// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

/*
 * This is a regression test for the issue described at:
 * https://github.com/joyent/node/issues/9113.
 *
 * This problem has been fixed by floating a patch on V8, this test makes
 * sure that the appropriate patch is floated even after future V8 upgrades.
 *
 * If the bug is reproduced, this test stalls and the tests suite makes it
 * time out eventually (currently after one minute). Otherwise it exits after
 * the for loop completes its execution.
 */
var spawn = require('child_process').spawn;
var args = ['--harmony',
            '--use-strict',
            '-e',
            'for (let i = 0; i < 3; ++i) { if (i == 1) { continue; } }'];
var child = spawn(process.execPath, args);
