# cidr-regex
Regular expression for matching CIDR (Classless Inter-Domain Routing)

## Install

```sh
$ npm install --save cidr-regex
```

## Usage

```js
import cidr from 'cidr-regex' // default regex is cidr v4
import { cidrv4, cidrv6 } from 'cidr-regex'
// OR
var cidrv4 = require('cidr-regex').cidrv4
var cidrv6 = require('cidr-regex').cidrv6

// is a CIDR v4
cidr.test('18.101.25.153/24') // true

// is not a CIDR v4
cidrv4.test('999.999.999.999/12') // false

// is a CIDR v6
cidrv6.test('fe80:0000:0000:0000:0204:61ff:fe9d:f156') // true

// is not a CIDR v6
cidrv6.test('fe80:0000:0000:0000:0204:61ff:fe9d:f156/a') // false
```

## API

### cidr

A regex for matching CIDR IPv4

### cidrv4

A regex for matching CIDR IPv4

### cidrv6

A regex for matching CIDR IPv6

## License

MIT © [Felipe Apostol](https://github.com/flipjs)
