/* Generated by re2c 1.0.3 */
#line 1 "src/wast-lexer.cc"
/*
 * Copyright 2016 WebAssembly Community Group participants
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "src/wast-lexer.h"

#include <cassert>
#include <cstdio>

#include "config.h"

#include "src/error-handler.h"
#include "src/lexer-source.h"
#include "src/wast-parser.h"

#define YYMAXFILL 29


#define INITIAL_LEXER_BUFFER_SIZE (64 * 1024)

#define ERROR(...) parser->Error(GetLocation(), __VA_ARGS__)

#define BEGIN(c) cond = (c)
#define FILL(n)              \
  do {                       \
    if (Failed(Fill((n)))) { \
      RETURN(Eof);           \
    }                        \
  } while (0)

#define MAYBE_MALFORMED_UTF8(desc)                \
  if (!(eof_ && limit_ - cursor_ <= YYMAXFILL)) { \
    ERROR("malformed utf-8%s", desc);             \
  }                                               \
  continue

#define yytext (next_pos_)
#define yyleng (cursor_ - next_pos_)

/* p must be a pointer somewhere in the lexer buffer */
#define FILE_OFFSET(p) ((p) - (buffer_) + buffer_file_offset_)
#define COLUMN(p) (FILE_OFFSET(p) - line_file_offset_ + 1)

#define COMMENT_NESTING (comment_nesting_)
#define NEWLINE                               \
  do {                                        \
    line_++;                                  \
    line_file_offset_ = FILE_OFFSET(cursor_); \
  } while (0)

#define RETURN(token) return Token(GetLocation(), TokenType::token);

#define RETURN_LITERAL(token, literal)          \
  return Token(GetLocation(), TokenType::token, \
               MakeLiteral(LiteralType::literal))

#define RETURN_TYPE(token, type) \
  return Token(GetLocation(), TokenType::token, Type::type)

#define RETURN_OPCODE0(token) \
  return Token(GetLocation(), TokenType::token, Opcode::token)

#define RETURN_OPCODE(token, opcode) \
  return Token(GetLocation(), TokenType::token, Opcode::opcode)

#define RETURN_TEXT(token) \
  return Token(GetLocation(), TokenType::token, GetText())

#define RETURN_TEXT_AT(token, at) \
  return Token(GetLocation(), TokenType::token, GetText(at))

namespace wabt {

WastLexer::WastLexer(std::unique_ptr<LexerSource> source, string_view filename)
    : source_(std::move(source)),
      line_finder_(source_->Clone()),
      filename_(filename),
      line_(1),
      comment_nesting_(0),
      buffer_file_offset_(0),
      line_file_offset_(0),
      eof_(false),
      buffer_(nullptr),
      buffer_size_(0),
      marker_(nullptr),
      next_pos_(nullptr),
      cursor_(nullptr),
      limit_(nullptr) {}

WastLexer::~WastLexer() {
  delete[] buffer_;
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateFileLexer(string_view filename) {
  auto source = MakeUnique<LexerSourceFile>(filename);
  if (!source->IsOpen()) {
    return std::unique_ptr<WastLexer>();
  }
  return MakeUnique<WastLexer>(std::move(source), filename);
}

// static
std::unique_ptr<WastLexer> WastLexer::CreateBufferLexer(string_view filename,
                                                        const void* data,
                                                        size_t size) {
  return MakeUnique<WastLexer>(MakeUnique<LexerSourceBuffer>(data, size),
                               filename);
}

Location WastLexer::GetLocation() {
  return Location(filename_, line_, COLUMN(next_pos_), COLUMN(cursor_));
}

Literal WastLexer::MakeLiteral(LiteralType type) {
  return Literal(type, GetText());
}

std::string WastLexer::GetText(size_t offset) {
  return std::string(yytext + offset, yyleng - offset);
}

Result WastLexer::Fill(size_t need) {
  if (eof_) {
    return Result::Error;
  }
  size_t free = next_pos_ - buffer_;
  assert(static_cast<size_t>(cursor_ - buffer_) >= free);
  // Our buffer is too small, need to realloc.
  if (free < need) {
    char* old_buffer = buffer_;
    size_t old_buffer_size = buffer_size_;
    size_t new_buffer_size =
        old_buffer_size ? old_buffer_size * 2 : INITIAL_LEXER_BUFFER_SIZE;
    // Make sure there is enough space for the bytes requested (need) and an
    // additional YYMAXFILL bytes which is needed for the re2c lexer
    // implementation when the eof is reached.
    while ((new_buffer_size - old_buffer_size) + free < need + YYMAXFILL)
      new_buffer_size *= 2;

    char* new_buffer = new char[new_buffer_size];
    if (limit_ > next_pos_) {
      memmove(new_buffer, next_pos_, limit_ - next_pos_);
    }
    buffer_ = new_buffer;
    buffer_size_ = new_buffer_size;
    next_pos_ = new_buffer + (next_pos_ - old_buffer) - free;
    marker_ = new_buffer + (marker_ - old_buffer) - free;
    cursor_ = new_buffer + (cursor_ - old_buffer) - free;
    limit_ = new_buffer + (limit_ - old_buffer) - free;
    buffer_file_offset_ += free;
    free += new_buffer_size - old_buffer_size;
    delete[] old_buffer;
  } else {
    // Shift everything down to make more room in the buffer.
    if (limit_ > next_pos_) {
      memmove(buffer_, next_pos_, limit_ - next_pos_);
    }
    next_pos_ -= free;
    marker_ -= free;
    cursor_ -= free;
    limit_ -= free;
    buffer_file_offset_ += free;
  }
  // Read the new data into the buffer.
  limit_ += source_->Fill(limit_, free);

  // If at the end of file, need to fill YYMAXFILL more characters with "fake
  // characters", that are not a lexeme nor a lexeme suffix. see
  // http://re2c.org/examples/example_03.html.
  if (limit_ < buffer_ + buffer_size_ - YYMAXFILL) {
    eof_ = true;
    // Fill with 0xff, since that is an invalid utf-8 byte.
    memset(limit_, 0xff, YYMAXFILL);
    limit_ += YYMAXFILL;
  }
  return Result::Ok;
}

Token WastLexer::GetToken(WastParser* parser) {
  #line 196 "src/prebuilt/wast-lexer-gen.cc"
enum YYCONDTYPE {
	YYCOND_i,
	YYCOND_BAD_TEXT,
	YYCOND_LINE_COMMENT,
	YYCOND_BLOCK_COMMENT,
};
#line 192 "src/wast-lexer.cc"

  YYCONDTYPE cond = YYCOND_i;  // i is the initial state.

  for (;;) {
    next_pos_ = cursor_;
    
#line 210 "src/prebuilt/wast-lexer-gen.cc"
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	if (cond < 2) {
		if (cond < 1) {
			goto YYCOND_i;
		} else {
			goto YYCOND_BAD_TEXT;
		}
	} else {
		if (cond < 3) {
			goto YYCOND_LINE_COMMENT;
		} else {
			goto YYCOND_BLOCK_COMMENT;
		}
	}
/* *********************************** */
YYCOND_i:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   4,   0,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36, 104,   0, 104, 104, 104, 104, 104, 
			 32,  32, 104, 104,  40, 104, 104, 104, 
			248, 248, 248, 248, 248, 248, 248, 248, 
			248, 248, 104,  32, 104, 104, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40,  72,  40, 104, 104, 
			104, 232, 232, 232, 232, 232, 232, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104, 104, 104, 104, 104, 104, 
			104, 104, 104,  40, 104,  40, 104,  32, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 29) FILL(29);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
		if (yych <= 'e') {
			if (yych <= '+') {
				if (yych <= '#') {
					if (yych <= 0x1F) {
						if (yych <= 0x08) goto yy3;
						if (yych <= '\n') goto yy8;
					} else {
						if (yych == '"') goto yy13;
						goto yy10;
					}
				} else {
					if (yych <= '(') {
						if (yych <= '$') goto yy15;
						if (yych <= '\'') goto yy10;
						goto yy16;
					} else {
						if (yych <= ')') goto yy18;
						if (yych <= '*') goto yy10;
						goto yy20;
					}
				}
			} else {
				if (yych <= ':') {
					if (yych <= '/') {
						if (yych == '-') goto yy20;
						goto yy10;
					} else {
						if (yych <= '0') goto yy21;
						if (yych <= '9') goto yy23;
						goto yy10;
					}
				} else {
					if (yych <= 'a') {
						if (yych <= ';') goto yy25;
						if (yych <= '`') goto yy10;
						goto yy26;
					} else {
						if (yych <= 'b') goto yy27;
						if (yych <= 'c') goto yy28;
						if (yych <= 'd') goto yy29;
						goto yy30;
					}
				}
			}
		} else {
			if (yych <= 's') {
				if (yych <= 'l') {
					if (yych <= 'h') {
						if (yych <= 'f') goto yy31;
						if (yych <= 'g') goto yy32;
						goto yy10;
					} else {
						if (yych <= 'i') goto yy33;
						if (yych <= 'k') goto yy10;
						goto yy34;
					}
				} else {
					if (yych <= 'o') {
						if (yych <= 'm') goto yy35;
						if (yych <= 'n') goto yy36;
						goto yy37;
					} else {
						if (yych <= 'p') goto yy38;
						if (yych <= 'q') goto yy39;
						if (yych <= 'r') goto yy40;
						goto yy41;
					}
				}
			} else {
				if (yych <= 0xC1) {
					if (yych <= 'v') {
						if (yych <= 't') goto yy42;
						if (yych <= 'u') goto yy43;
						goto yy44;
					} else {
						if (yych <= '~') goto yy10;
						if (yych >= 0x80) goto yy45;
					}
				} else {
					if (yych <= 0xEF) {
						if (yych <= 0xDF) goto yy47;
						if (yych <= 0xE0) goto yy48;
						goto yy49;
					} else {
						if (yych <= 0xF0) goto yy50;
						if (yych <= 0xF3) goto yy51;
						if (yych <= 0xF4) goto yy52;
						goto yy45;
					}
				}
			}
		}
yy3:
		++cursor_;
yy4:
#line 714 "src/wast-lexer.cc"
		{ ERROR("unexpected char"); continue; }
#line 366 "src/prebuilt/wast-lexer-gen.cc"
yy5:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
#line 712 "src/wast-lexer.cc"
		{ continue; }
#line 376 "src/prebuilt/wast-lexer-gen.cc"
yy8:
		++cursor_;
#line 711 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 381 "src/prebuilt/wast-lexer-gen.cc"
yy10:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy11:
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
yy12:
#line 713 "src/wast-lexer.cc"
		{ RETURN_TEXT(Reserved); }
#line 393 "src/prebuilt/wast-lexer-gen.cc"
yy13:
		yyaccept = 0;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x1F) goto yy14;
		if (yych <= 0x7F) goto yy54;
		if (yych <= 0xC1) goto yy14;
		if (yych <= 0xF4) goto yy54;
yy14:
		BEGIN(YYCOND_BAD_TEXT);
#line 245 "src/wast-lexer.cc"
		{ continue; }
#line 405 "src/prebuilt/wast-lexer-gen.cc"
yy15:
		yych = *++cursor_;
		if (yych <= '\'') {
			if (yych == '!') goto yy66;
			if (yych <= '"') goto yy12;
			goto yy66;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy12;
				goto yy66;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy66;
				goto yy12;
			}
		}
yy16:
		yych = *++cursor_;
		if (yych == ';') goto yy68;
#line 236 "src/wast-lexer.cc"
		{ RETURN(Lpar); }
#line 427 "src/prebuilt/wast-lexer-gen.cc"
yy18:
		++cursor_;
#line 237 "src/wast-lexer.cc"
		{ RETURN(Rpar); }
#line 432 "src/prebuilt/wast-lexer-gen.cc"
yy20:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych <= '/') goto yy11;
			if (yych <= '0') goto yy70;
			if (yych <= '9') goto yy72;
			goto yy11;
		} else {
			if (yych <= 'i') goto yy74;
			if (yych == 'n') goto yy75;
			goto yy11;
		}
yy21:
		yych = *++cursor_;
		if (yych == 'x') goto yy80;
		goto yy24;
yy22:
#line 238 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Nat, Int); }
#line 452 "src/prebuilt/wast-lexer-gen.cc"
yy23:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
yy24:
		if (yybm[0+yych] & 16) {
			goto yy23;
		}
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy22;
				goto yy10;
			} else {
				if (yych <= ')') goto yy22;
				if (yych == '.') goto yy76;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy22;
				if (yych == 'E') goto yy78;
				goto yy10;
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy79;
					goto yy10;
				} else {
					if (yych <= 'e') goto yy78;
					if (yych <= '~') goto yy10;
					goto yy22;
				}
			}
		}
yy25:
		yych = *++cursor_;
		if (yych == ';') goto yy81;
		goto yy4;
yy26:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy83;
			if (yych <= 'm') goto yy11;
			goto yy84;
		} else {
			if (yych <= 'r') goto yy11;
			if (yych <= 's') goto yy85;
			if (yych <= 't') goto yy86;
			goto yy11;
		}
yy27:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'i') goto yy87;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy88;
			if (yych == 'r') goto yy89;
			goto yy11;
		}
yy28:
		yych = *++cursor_;
		if (yych == 'a') goto yy91;
		if (yych == 'u') goto yy92;
		goto yy11;
yy29:
		yych = *++cursor_;
		if (yych == 'a') goto yy93;
		if (yych == 'r') goto yy94;
		goto yy11;
yy30:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'l') goto yy95;
			goto yy11;
		} else {
			if (yych <= 'n') goto yy96;
			if (yych == 'x') goto yy97;
			goto yy11;
		}
yy31:
		yych = *++cursor_;
		if (yych <= '5') {
			if (yych == '3') goto yy98;
			goto yy11;
		} else {
			if (yych <= '6') goto yy99;
			if (yych == 'u') goto yy100;
			goto yy11;
		}
yy32:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'e') goto yy101;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy102;
			if (yych == 'r') goto yy103;
			goto yy11;
		}
yy33:
		yych = *++cursor_;
		if (yych <= '7') {
			if (yych <= '2') {
				if (yych == '1') goto yy104;
				goto yy11;
			} else {
				if (yych <= '3') goto yy105;
				if (yych == '6') goto yy106;
				goto yy11;
			}
		} else {
			if (yych <= 'f') {
				if (yych <= '8') goto yy107;
				if (yych <= 'e') goto yy11;
				goto yy108;
			} else {
				if (yych <= 'l') goto yy11;
				if (yych <= 'm') goto yy110;
				if (yych <= 'n') goto yy111;
				goto yy11;
			}
		}
yy34:
		yych = *++cursor_;
		if (yych == 'o') goto yy112;
		goto yy11;
yy35:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy113;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy114;
			if (yych == 'u') goto yy115;
			goto yy11;
		}
yy36:
		yych = *++cursor_;
		if (yych == 'a') goto yy116;
		if (yych == 'o') goto yy117;
		goto yy11;
yy37:
		yych = *++cursor_;
		if (yych == 'f') goto yy118;
		goto yy11;
yy38:
		yych = *++cursor_;
		if (yych == 'a') goto yy119;
		goto yy11;
yy39:
		yych = *++cursor_;
		if (yych == 'u') goto yy120;
		goto yy11;
yy40:
		yych = *++cursor_;
		if (yych == 'e') goto yy121;
		goto yy11;
yy41:
		yych = *++cursor_;
		if (yych <= 'g') {
			if (yych == 'e') goto yy122;
			goto yy11;
		} else {
			if (yych <= 'h') goto yy123;
			if (yych == 't') goto yy124;
			goto yy11;
		}
yy42:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy125;
		case 'e':	goto yy126;
		case 'h':	goto yy127;
		case 'r':	goto yy128;
		case 'y':	goto yy129;
		default:	goto yy11;
		}
yy43:
		yych = *++cursor_;
		if (yych == 'n') goto yy130;
		goto yy11;
yy44:
		yych = *++cursor_;
		if (yych == '1') goto yy131;
		if (yych == '8') goto yy132;
		goto yy11;
yy45:
		++cursor_;
yy46:
#line 715 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 645 "src/prebuilt/wast-lexer-gen.cc"
yy47:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy46;
		if (yych <= 0xBF) goto yy3;
		goto yy46;
yy48:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy46;
		if (yych <= 0xBF) goto yy133;
		goto yy46;
yy49:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy46;
		if (yych <= 0xBF) goto yy133;
		goto yy46;
yy50:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy46;
		if (yych <= 0xBF) goto yy134;
		goto yy46;
yy51:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy46;
		if (yych <= 0xBF) goto yy134;
		goto yy46;
yy52:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy46;
		if (yych <= 0x8F) goto yy134;
		goto yy46;
yy53:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy54:
		if (yybm[0+yych] & 32) {
			goto yy53;
		}
		if (yych <= 0xDF) {
			if (yych <= '"') {
				if (yych >= ' ') goto yy56;
			} else {
				if (yych <= '\\') goto yy58;
				if (yych >= 0xC2) goto yy59;
			}
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xE0) goto yy60;
				if (yych <= 0xEF) goto yy61;
				goto yy62;
			} else {
				if (yych <= 0xF3) goto yy63;
				if (yych <= 0xF4) goto yy64;
			}
		}
yy55:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy14;
		} else {
			goto yy46;
		}
yy56:
		++cursor_;
#line 244 "src/wast-lexer.cc"
		{ RETURN_TEXT(Text); }
#line 717 "src/prebuilt/wast-lexer-gen.cc"
yy58:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '[') {
			if (yych <= '\'') {
				if (yych == '"') goto yy53;
				if (yych <= '&') goto yy55;
				goto yy53;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy55;
					goto yy135;
				} else {
					if (yych <= '@') goto yy55;
					if (yych <= 'F') goto yy135;
					goto yy55;
				}
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') {
					if (yych <= '\\') goto yy53;
					goto yy55;
				} else {
					if (yych <= 'f') goto yy135;
					if (yych <= 'm') goto yy55;
					goto yy53;
				}
			} else {
				if (yych <= 'r') {
					if (yych <= 'q') goto yy55;
					goto yy53;
				} else {
					if (yych == 't') goto yy53;
					goto yy55;
				}
			}
		}
yy59:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0xBF) goto yy53;
		goto yy55;
yy60:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy55;
		if (yych <= 0xBF) goto yy59;
		goto yy55;
yy61:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0xBF) goto yy59;
		goto yy55;
yy62:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy55;
		if (yych <= 0xBF) goto yy61;
		goto yy55;
yy63:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0xBF) goto yy61;
		goto yy55;
yy64:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0x8F) goto yy61;
		goto yy55;
yy65:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy66:
		if (yybm[0+yych] & 64) {
			goto yy65;
		}
		if (yych <= ')') goto yy67;
		if (yych <= ',') goto yy10;
		if (yych <= ';') goto yy67;
		if (yych <= '}') goto yy10;
yy67:
#line 696 "src/wast-lexer.cc"
		{ RETURN_TEXT(Var); }
#line 814 "src/prebuilt/wast-lexer-gen.cc"
yy68:
		++cursor_;
		BEGIN(YYCOND_BLOCK_COMMENT);
#line 702 "src/wast-lexer.cc"
		{ COMMENT_NESTING = 1; continue; }
#line 820 "src/prebuilt/wast-lexer-gen.cc"
yy70:
		yych = *++cursor_;
		if (yych == 'x') goto yy137;
		goto yy73;
yy71:
#line 239 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Int, Int); }
#line 828 "src/prebuilt/wast-lexer-gen.cc"
yy72:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
yy73:
		if (yych <= '9') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy71;
				goto yy10;
			} else {
				if (yych <= '-') {
					if (yych <= ')') goto yy71;
					goto yy10;
				} else {
					if (yych <= '.') goto yy76;
					if (yych <= '/') goto yy10;
					goto yy72;
				}
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') {
					if (yych <= ':') goto yy10;
					goto yy71;
				} else {
					if (yych == 'E') goto yy78;
					goto yy10;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy136;
					goto yy10;
				} else {
					if (yych <= 'e') goto yy78;
					if (yych <= '~') goto yy10;
					goto yy71;
				}
			}
		}
yy74:
		yych = *++cursor_;
		if (yych == 'n') goto yy138;
		goto yy11;
yy75:
		yych = *++cursor_;
		if (yych == 'a') goto yy116;
		goto yy11;
yy76:
		yych = *++cursor_;
		if (yych == '_') goto yy10;
		goto yy140;
yy77:
#line 240 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Float); }
#line 884 "src/prebuilt/wast-lexer-gen.cc"
yy78:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy141;
			goto yy11;
		} else {
			if (yych <= '-') goto yy141;
			if (yych <= '/') goto yy11;
			if (yych <= '9') goto yy142;
			goto yy11;
		}
yy79:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 16) {
			goto yy23;
		}
		if (yych <= '\'') {
			if (yych == '!') goto yy10;
			if (yych <= '"') goto yy12;
			goto yy10;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy12;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy80:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy144;
		}
		if (yych <= '\'') {
			if (yych == '!') goto yy10;
			if (yych <= '"') goto yy12;
			goto yy10;
		} else {
			if (yych <= ':') {
				if (yych <= ')') goto yy12;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy81:
		++cursor_;
		BEGIN(YYCOND_LINE_COMMENT);
#line 699 "src/wast-lexer.cc"
		{ continue; }
#line 943 "src/prebuilt/wast-lexer-gen.cc"
yy83:
		yych = *++cursor_;
		if (yych == 'i') goto yy146;
		goto yy11;
yy84:
		yych = *++cursor_;
		if (yych == 'y') goto yy147;
		goto yy11;
yy85:
		yych = *++cursor_;
		if (yych == 's') goto yy148;
		goto yy11;
yy86:
		yych = *++cursor_;
		if (yych == 'o') goto yy149;
		goto yy11;
yy87:
		yych = *++cursor_;
		if (yych == 'n') goto yy150;
		goto yy11;
yy88:
		yych = *++cursor_;
		if (yych == 'o') goto yy151;
		goto yy11;
yy89:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy90;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy152;
				if (yych <= '~') goto yy10;
			}
		}
yy90:
#line 270 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Br); }
#line 988 "src/prebuilt/wast-lexer-gen.cc"
yy91:
		yych = *++cursor_;
		if (yych == 'l') goto yy153;
		if (yych == 't') goto yy154;
		goto yy11;
yy92:
		yych = *++cursor_;
		if (yych == 'r') goto yy155;
		goto yy11;
yy93:
		yych = *++cursor_;
		if (yych == 't') goto yy156;
		goto yy11;
yy94:
		yych = *++cursor_;
		if (yych == 'o') goto yy157;
		goto yy11;
yy95:
		yych = *++cursor_;
		if (yych == 'e') goto yy158;
		if (yych == 's') goto yy159;
		goto yy11;
yy96:
		yych = *++cursor_;
		if (yych == 'd') goto yy160;
		goto yy11;
yy97:
		yych = *++cursor_;
		if (yych == 'c') goto yy162;
		if (yych == 'p') goto yy163;
		goto yy11;
yy98:
		yych = *++cursor_;
		if (yych == '2') goto yy164;
		goto yy11;
yy99:
		yych = *++cursor_;
		if (yych == '4') goto yy166;
		goto yy11;
yy100:
		yych = *++cursor_;
		if (yych == 'n') goto yy168;
		goto yy11;
yy101:
		yych = *++cursor_;
		if (yych == 't') goto yy169;
		goto yy11;
yy102:
		yych = *++cursor_;
		if (yych == 'o') goto yy171;
		goto yy11;
yy103:
		yych = *++cursor_;
		if (yych == 'o') goto yy172;
		goto yy11;
yy104:
		yych = *++cursor_;
		if (yych == '6') goto yy173;
		goto yy11;
yy105:
		yych = *++cursor_;
		if (yych == '2') goto yy174;
		goto yy11;
yy106:
		yych = *++cursor_;
		if (yych == '4') goto yy176;
		goto yy11;
yy107:
		yych = *++cursor_;
		if (yych == 'x') goto yy178;
		goto yy11;
yy108:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy109;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy179;
				if (yych <= '~') goto yy10;
			}
		}
yy109:
#line 266 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(If); }
#line 1080 "src/prebuilt/wast-lexer-gen.cc"
yy110:
		yych = *++cursor_;
		if (yych == 'p') goto yy180;
		goto yy11;
yy111:
		yych = *++cursor_;
		if (yych == 'f') goto yy181;
		if (yych == 'v') goto yy183;
		goto yy11;
yy112:
		yych = *++cursor_;
		if (yych == 'c') goto yy184;
		if (yych == 'o') goto yy185;
		goto yy11;
yy113:
		yych = *++cursor_;
		if (yych == 'm') goto yy186;
		goto yy11;
yy114:
		yych = *++cursor_;
		if (yych == 'd') goto yy187;
		goto yy11;
yy115:
		yych = *++cursor_;
		if (yych == 't') goto yy188;
		goto yy11;
yy116:
		yych = *++cursor_;
		if (yych == 'n') goto yy190;
		goto yy11;
yy117:
		yych = *++cursor_;
		if (yych == 'p') goto yy192;
		goto yy11;
yy118:
		yych = *++cursor_;
		if (yych == 'f') goto yy194;
		goto yy11;
yy119:
		yych = *++cursor_;
		if (yych == 'r') goto yy195;
		goto yy11;
yy120:
		yych = *++cursor_;
		if (yych == 'o') goto yy196;
		goto yy11;
yy121:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'g') goto yy197;
			goto yy11;
		} else {
			if (yych <= 's') goto yy198;
			if (yych <= 't') goto yy199;
			goto yy11;
		}
yy122:
		yych = *++cursor_;
		if (yych == 'l') goto yy200;
		if (yych == 't') goto yy201;
		goto yy11;
yy123:
		yych = *++cursor_;
		if (yych == 'a') goto yy202;
		goto yy11;
yy124:
		yych = *++cursor_;
		if (yych == 'a') goto yy203;
		goto yy11;
yy125:
		yych = *++cursor_;
		if (yych == 'b') goto yy204;
		goto yy11;
yy126:
		yych = *++cursor_;
		if (yych == 'e') goto yy205;
		goto yy11;
yy127:
		yych = *++cursor_;
		if (yych == 'e') goto yy206;
		if (yych == 'r') goto yy207;
		goto yy11;
yy128:
		yych = *++cursor_;
		if (yych == 'y') goto yy208;
		goto yy11;
yy129:
		yych = *++cursor_;
		if (yych == 'p') goto yy210;
		goto yy11;
yy130:
		yych = *++cursor_;
		if (yych == 'r') goto yy211;
		goto yy11;
yy131:
		yych = *++cursor_;
		if (yych == '2') goto yy212;
		goto yy11;
yy132:
		yych = *++cursor_;
		if (yych == 'x') goto yy213;
		goto yy11;
yy133:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0xBF) goto yy3;
		goto yy55;
yy134:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy55;
		if (yych <= 0xBF) goto yy133;
		goto yy55;
yy135:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '@') {
			if (yych <= '/') goto yy55;
			if (yych <= '9') goto yy53;
			goto yy55;
		} else {
			if (yych <= 'F') goto yy53;
			if (yych <= '`') goto yy55;
			if (yych <= 'f') goto yy53;
			goto yy55;
		}
yy136:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy72;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy137:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy12;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy12;
				if (yych <= '/') goto yy10;
				goto yy214;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy12;
				if (yych <= '@') goto yy10;
				goto yy214;
			} else {
				if (yych <= '`') goto yy10;
				if (yych <= 'f') goto yy214;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy138:
		yych = *++cursor_;
		if (yych == 'f') goto yy181;
		goto yy11;
yy139:
		++cursor_;
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
yy140:
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy77;
				goto yy10;
			} else {
				if (yych <= ')') goto yy77;
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy139;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy77;
				if (yych == 'E') goto yy78;
				goto yy10;
			} else {
				if (yych <= 'd') {
					if (yych <= '_') goto yy216;
					goto yy10;
				} else {
					if (yych <= 'e') goto yy78;
					if (yych <= '~') goto yy10;
					goto yy77;
				}
			}
		}
yy141:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych >= ':') goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy142:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy77;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy77;
				goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy142;
				if (yych <= ':') goto yy10;
				goto yy77;
			} else {
				if (yych == '_') goto yy141;
				if (yych <= '~') goto yy10;
				goto yy77;
			}
		}
yy144:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy144;
		}
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy22;
				goto yy10;
			} else {
				if (yych <= ')') goto yy22;
				if (yych == '.') goto yy217;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy22;
				if (yych == 'P') goto yy219;
				goto yy10;
			} else {
				if (yych <= 'o') {
					if (yych <= '_') goto yy80;
					goto yy10;
				} else {
					if (yych <= 'p') goto yy219;
					if (yych <= '~') goto yy10;
					goto yy22;
				}
			}
		}
yy146:
		yych = *++cursor_;
		if (yych == 'g') goto yy220;
		goto yy11;
yy147:
		yych = *++cursor_;
		if (yych == 'f') goto yy221;
		goto yy11;
yy148:
		yych = *++cursor_;
		if (yych == 'e') goto yy222;
		goto yy11;
yy149:
		yych = *++cursor_;
		if (yych == 'm') goto yy223;
		goto yy11;
yy150:
		yych = *++cursor_;
		if (yych == 'a') goto yy224;
		goto yy11;
yy151:
		yych = *++cursor_;
		if (yych == 'c') goto yy225;
		goto yy11;
yy152:
		yych = *++cursor_;
		if (yych == 'i') goto yy226;
		if (yych == 't') goto yy227;
		goto yy11;
yy153:
		yych = *++cursor_;
		if (yych == 'l') goto yy228;
		goto yy11;
yy154:
		yych = *++cursor_;
		if (yych == 'c') goto yy230;
		goto yy11;
yy155:
		yych = *++cursor_;
		if (yych == 'r') goto yy231;
		goto yy11;
yy156:
		yych = *++cursor_;
		if (yych == 'a') goto yy232;
		goto yy11;
yy157:
		yych = *++cursor_;
		if (yych == 'p') goto yy234;
		goto yy11;
yy158:
		yych = *++cursor_;
		if (yych == 'm') goto yy236;
		goto yy11;
yy159:
		yych = *++cursor_;
		if (yych == 'e') goto yy238;
		goto yy11;
yy160:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 276 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(End); }
#line 1437 "src/prebuilt/wast-lexer-gen.cc"
yy162:
		yych = *++cursor_;
		if (yych == 'e') goto yy240;
		goto yy11;
yy163:
		yych = *++cursor_;
		if (yych == 'o') goto yy241;
		goto yy11;
yy164:
		yych = *++cursor_;
		if (yych <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy242;
				if (yych <= ':') goto yy10;
			} else {
				if (yych == 'x') goto yy243;
				if (yych <= '~') goto yy10;
			}
		}
#line 259 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, F32); }
#line 1466 "src/prebuilt/wast-lexer-gen.cc"
yy166:
		yych = *++cursor_;
		if (yych <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy244;
				if (yych <= ':') goto yy10;
			} else {
				if (yych == 'x') goto yy245;
				if (yych <= '~') goto yy10;
			}
		}
#line 260 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, F64); }
#line 1487 "src/prebuilt/wast-lexer-gen.cc"
yy168:
		yych = *++cursor_;
		if (yych == 'c') goto yy246;
		goto yy11;
yy169:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy170;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy248;
				if (yych <= '~') goto yy10;
			}
		}
yy170:
#line 682 "src/wast-lexer.cc"
		{ RETURN(Get); }
#line 1512 "src/prebuilt/wast-lexer-gen.cc"
yy171:
		yych = *++cursor_;
		if (yych == 'b') goto yy249;
		goto yy11;
yy172:
		yych = *++cursor_;
		if (yych == 'w') goto yy250;
		goto yy11;
yy173:
		yych = *++cursor_;
		if (yych == 'x') goto yy251;
		goto yy11;
yy174:
		yych = *++cursor_;
		if (yych <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy252;
				if (yych <= ':') goto yy10;
			} else {
				if (yych == 'x') goto yy253;
				if (yych <= '~') goto yy10;
			}
		}
#line 257 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, I32); }
#line 1545 "src/prebuilt/wast-lexer-gen.cc"
yy176:
		yych = *++cursor_;
		if (yych <= '-') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '.') goto yy254;
				if (yych <= ':') goto yy10;
			} else {
				if (yych == 'x') goto yy255;
				if (yych <= '~') goto yy10;
			}
		}
#line 258 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, I64); }
#line 1566 "src/prebuilt/wast-lexer-gen.cc"
yy178:
		yych = *++cursor_;
		if (yych == '1') goto yy256;
		goto yy11;
yy179:
		yych = *++cursor_;
		if (yych == 'e') goto yy257;
		goto yy11;
yy180:
		yych = *++cursor_;
		if (yych == 'o') goto yy258;
		goto yy11;
yy181:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 242 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Infinity); }
#line 1586 "src/prebuilt/wast-lexer-gen.cc"
yy183:
		yych = *++cursor_;
		if (yych == 'o') goto yy259;
		goto yy11;
yy184:
		yych = *++cursor_;
		if (yych == 'a') goto yy260;
		goto yy11;
yy185:
		yych = *++cursor_;
		if (yych == 'p') goto yy261;
		goto yy11;
yy186:
		yych = *++cursor_;
		if (yych == 'o') goto yy263;
		goto yy11;
yy187:
		yych = *++cursor_;
		if (yych == 'u') goto yy264;
		goto yy11;
yy188:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 263 "src/wast-lexer.cc"
		{ RETURN(Mut); }
#line 1614 "src/prebuilt/wast-lexer-gen.cc"
yy190:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy191;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '9') goto yy10;
				goto yy265;
			} else {
				if (yych <= ';') goto yy191;
				if (yych <= '~') goto yy10;
			}
		}
yy191:
#line 243 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Nan); }
#line 1636 "src/prebuilt/wast-lexer-gen.cc"
yy192:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 264 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Nop); }
#line 1644 "src/prebuilt/wast-lexer-gen.cc"
yy194:
		yych = *++cursor_;
		if (yych == 's') goto yy266;
		goto yy11;
yy195:
		yych = *++cursor_;
		if (yych == 'a') goto yy267;
		goto yy11;
yy196:
		yych = *++cursor_;
		if (yych == 't') goto yy268;
		goto yy11;
yy197:
		yych = *++cursor_;
		if (yych == 'i') goto yy269;
		goto yy11;
yy198:
		yych = *++cursor_;
		if (yych == 'u') goto yy270;
		goto yy11;
yy199:
		yych = *++cursor_;
		if (yych == 'h') goto yy271;
		if (yych == 'u') goto yy272;
		goto yy11;
yy200:
		yych = *++cursor_;
		if (yych == 'e') goto yy273;
		goto yy11;
yy201:
		yych = *++cursor_;
		if (yych == '_') goto yy274;
		goto yy11;
yy202:
		yych = *++cursor_;
		if (yych == 'r') goto yy275;
		goto yy11;
yy203:
		yych = *++cursor_;
		if (yych == 'r') goto yy276;
		goto yy11;
yy204:
		yych = *++cursor_;
		if (yych == 'l') goto yy277;
		goto yy11;
yy205:
		yych = *++cursor_;
		if (yych == '_') goto yy278;
		goto yy11;
yy206:
		yych = *++cursor_;
		if (yych == 'n') goto yy279;
		goto yy11;
yy207:
		yych = *++cursor_;
		if (yych == 'o') goto yy281;
		goto yy11;
yy208:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 691 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Try); }
#line 1709 "src/prebuilt/wast-lexer-gen.cc"
yy210:
		yych = *++cursor_;
		if (yych == 'e') goto yy282;
		goto yy11;
yy211:
		yych = *++cursor_;
		if (yych == 'e') goto yy284;
		goto yy11;
yy212:
		yych = *++cursor_;
		if (yych == '8') goto yy285;
		goto yy11;
yy213:
		yych = *++cursor_;
		if (yych == '1') goto yy287;
		goto yy11;
yy214:
		++cursor_;
		if ((limit_ - cursor_) < 3) FILL(3);
		yych = *cursor_;
		if (yych <= ';') {
			if (yych <= ')') {
				if (yych <= '!') {
					if (yych <= ' ') goto yy71;
					goto yy10;
				} else {
					if (yych <= '"') goto yy71;
					if (yych <= '\'') goto yy10;
					goto yy71;
				}
			} else {
				if (yych <= '/') {
					if (yych == '.') goto yy217;
					goto yy10;
				} else {
					if (yych <= '9') goto yy214;
					if (yych <= ':') goto yy10;
					goto yy71;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'O') {
					if (yych <= '@') goto yy10;
					if (yych <= 'F') goto yy214;
					goto yy10;
				} else {
					if (yych <= 'P') goto yy219;
					if (yych <= '^') goto yy10;
					goto yy137;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= '`') goto yy10;
					if (yych <= 'f') goto yy214;
					goto yy10;
				} else {
					if (yych <= 'p') goto yy219;
					if (yych <= '~') goto yy10;
					goto yy71;
				}
			}
		}
yy216:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy139;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy217:
		yych = *++cursor_;
		if (yych == '_') goto yy10;
		goto yy289;
yy218:
#line 241 "src/wast-lexer.cc"
		{ RETURN_LITERAL(Float, Hexfloat); }
#line 1804 "src/prebuilt/wast-lexer-gen.cc"
yy219:
		yych = *++cursor_;
		if (yych <= ',') {
			if (yych == '+') goto yy290;
			goto yy11;
		} else {
			if (yych <= '-') goto yy290;
			if (yych <= '/') goto yy11;
			if (yych <= '9') goto yy291;
			goto yy11;
		}
yy220:
		yych = *++cursor_;
		if (yych == 'n') goto yy293;
		goto yy11;
yy221:
		yych = *++cursor_;
		if (yych == 'u') goto yy294;
		goto yy11;
yy222:
		yych = *++cursor_;
		if (yych == 'r') goto yy295;
		goto yy11;
yy223:
		yych = *++cursor_;
		if (yych == 'i') goto yy296;
		goto yy11;
yy224:
		yych = *++cursor_;
		if (yych == 'r') goto yy297;
		goto yy11;
yy225:
		yych = *++cursor_;
		if (yych == 'k') goto yy298;
		goto yy11;
yy226:
		yych = *++cursor_;
		if (yych == 'f') goto yy300;
		goto yy11;
yy227:
		yych = *++cursor_;
		if (yych == 'a') goto yy302;
		goto yy11;
yy228:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy229;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy303;
				if (yych <= '~') goto yy10;
			}
		}
yy229:
#line 273 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Call); }
#line 1868 "src/prebuilt/wast-lexer-gen.cc"
yy230:
		yych = *++cursor_;
		if (yych == 'h') goto yy304;
		goto yy11;
yy231:
		yych = *++cursor_;
		if (yych == 'e') goto yy306;
		goto yy11;
yy232:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 675 "src/wast-lexer.cc"
		{ RETURN(Data); }
#line 1884 "src/prebuilt/wast-lexer-gen.cc"
yy234:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 275 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Drop); }
#line 1892 "src/prebuilt/wast-lexer-gen.cc"
yy236:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 674 "src/wast-lexer.cc"
		{ RETURN(Elem); }
#line 1900 "src/prebuilt/wast-lexer-gen.cc"
yy238:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 268 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Else); }
#line 1908 "src/prebuilt/wast-lexer-gen.cc"
yy240:
		yych = *++cursor_;
		if (yych == 'p') goto yy307;
		goto yy11;
yy241:
		yych = *++cursor_;
		if (yych == 'r') goto yy308;
		goto yy11;
yy242:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy309;
		case 'c':	goto yy310;
		case 'd':	goto yy311;
		case 'e':	goto yy312;
		case 'f':	goto yy313;
		case 'g':	goto yy314;
		case 'l':	goto yy315;
		case 'm':	goto yy316;
		case 'n':	goto yy317;
		case 'r':	goto yy318;
		case 's':	goto yy319;
		case 't':	goto yy320;
		default:	goto yy11;
		}
yy243:
		yych = *++cursor_;
		if (yych == '4') goto yy321;
		goto yy11;
yy244:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy322;
		case 'c':	goto yy323;
		case 'd':	goto yy324;
		case 'e':	goto yy325;
		case 'f':	goto yy326;
		case 'g':	goto yy327;
		case 'l':	goto yy328;
		case 'm':	goto yy329;
		case 'n':	goto yy330;
		case 'p':	goto yy331;
		case 'r':	goto yy332;
		case 's':	goto yy333;
		case 't':	goto yy334;
		default:	goto yy11;
		}
yy245:
		yych = *++cursor_;
		if (yych == '2') goto yy335;
		goto yy11;
yy246:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 663 "src/wast-lexer.cc"
		{ RETURN(Func); }
#line 1967 "src/prebuilt/wast-lexer-gen.cc"
yy248:
		yych = *++cursor_;
		if (yych == 'g') goto yy336;
		if (yych == 'l') goto yy337;
		goto yy11;
yy249:
		yych = *++cursor_;
		if (yych == 'a') goto yy338;
		goto yy11;
yy250:
		yych = *++cursor_;
		if (yych == '_') goto yy339;
		goto yy11;
yy251:
		yych = *++cursor_;
		if (yych == '8') goto yy340;
		goto yy11;
yy252:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy341;
		case 'c':	goto yy342;
		case 'd':	goto yy343;
		case 'e':	goto yy344;
		case 'g':	goto yy345;
		case 'l':	goto yy346;
		case 'm':	goto yy347;
		case 'n':	goto yy348;
		case 'o':	goto yy349;
		case 'p':	goto yy350;
		case 'r':	goto yy351;
		case 's':	goto yy352;
		case 't':	goto yy353;
		case 'w':	goto yy354;
		case 'x':	goto yy355;
		default:	goto yy11;
		}
yy253:
		yych = *++cursor_;
		if (yych == '4') goto yy356;
		goto yy11;
yy254:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy357;
		case 'c':	goto yy358;
		case 'd':	goto yy359;
		case 'e':	goto yy360;
		case 'g':	goto yy361;
		case 'l':	goto yy362;
		case 'm':	goto yy363;
		case 'n':	goto yy364;
		case 'o':	goto yy365;
		case 'p':	goto yy366;
		case 'r':	goto yy367;
		case 's':	goto yy368;
		case 't':	goto yy369;
		case 'x':	goto yy370;
		default:	goto yy11;
		}
yy255:
		yych = *++cursor_;
		if (yych == '2') goto yy371;
		goto yy11;
yy256:
		yych = *++cursor_;
		if (yych == '6') goto yy372;
		goto yy11;
yy257:
		yych = *++cursor_;
		if (yych == 'x') goto yy373;
		goto yy11;
yy258:
		yych = *++cursor_;
		if (yych == 'r') goto yy374;
		goto yy11;
yy259:
		yych = *++cursor_;
		if (yych == 'k') goto yy375;
		goto yy11;
yy260:
		yych = *++cursor_;
		if (yych == 'l') goto yy376;
		goto yy11;
yy261:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 269 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Loop); }
#line 2059 "src/prebuilt/wast-lexer-gen.cc"
yy263:
		yych = *++cursor_;
		if (yych == 'r') goto yy378;
		goto yy11;
yy264:
		yych = *++cursor_;
		if (yych == 'l') goto yy379;
		goto yy11;
yy265:
		yych = *++cursor_;
		if (yych == '0') goto yy380;
		goto yy11;
yy266:
		yych = *++cursor_;
		if (yych == 'e') goto yy381;
		goto yy11;
yy267:
		yych = *++cursor_;
		if (yych == 'm') goto yy382;
		goto yy11;
yy268:
		yych = *++cursor_;
		if (yych == 'e') goto yy384;
		goto yy11;
yy269:
		yych = *++cursor_;
		if (yych == 's') goto yy386;
		goto yy11;
yy270:
		yych = *++cursor_;
		if (yych == 'l') goto yy387;
		goto yy11;
yy271:
		yych = *++cursor_;
		if (yych == 'r') goto yy388;
		goto yy11;
yy272:
		yych = *++cursor_;
		if (yych == 'r') goto yy389;
		goto yy11;
yy273:
		yych = *++cursor_;
		if (yych == 'c') goto yy390;
		goto yy11;
yy274:
		yych = *++cursor_;
		if (yych == 'g') goto yy391;
		if (yych == 'l') goto yy392;
		goto yy11;
yy275:
		yych = *++cursor_;
		if (yych == 'e') goto yy393;
		goto yy11;
yy276:
		yych = *++cursor_;
		if (yych == 't') goto yy394;
		goto yy11;
yy277:
		yych = *++cursor_;
		if (yych == 'e') goto yy396;
		goto yy11;
yy278:
		yych = *++cursor_;
		if (yych == 'l') goto yy398;
		goto yy11;
yy279:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 267 "src/wast-lexer.cc"
		{ RETURN(Then); }
#line 2132 "src/prebuilt/wast-lexer-gen.cc"
yy281:
		yych = *++cursor_;
		if (yych == 'w') goto yy399;
		goto yy11;
yy282:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 662 "src/wast-lexer.cc"
		{ RETURN(Type); }
#line 2144 "src/prebuilt/wast-lexer-gen.cc"
yy284:
		yych = *++cursor_;
		if (yych == 'a') goto yy401;
		goto yy11;
yy285:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy286;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy402;
				goto yy10;
			} else {
				if (yych <= ';') goto yy286;
				if (yych <= '~') goto yy10;
			}
		}
yy286:
#line 261 "src/wast-lexer.cc"
		{ RETURN_TYPE(ValueType, V128); }
#line 2170 "src/prebuilt/wast-lexer-gen.cc"
yy287:
		yych = *++cursor_;
		if (yych == '6') goto yy403;
		goto yy11;
yy288:
		++cursor_;
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
yy289:
		if (yych <= '@') {
			if (yych <= ')') {
				if (yych <= '!') {
					if (yych <= ' ') goto yy218;
					goto yy10;
				} else {
					if (yych <= '"') goto yy218;
					if (yych <= '\'') goto yy10;
					goto yy218;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy10;
					goto yy288;
				} else {
					if (yych == ';') goto yy218;
					goto yy10;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'O') {
					if (yych <= 'F') goto yy288;
					goto yy10;
				} else {
					if (yych <= 'P') goto yy219;
					if (yych <= '^') goto yy10;
					goto yy404;
				}
			} else {
				if (yych <= 'o') {
					if (yych <= '`') goto yy10;
					if (yych <= 'f') goto yy288;
					goto yy10;
				} else {
					if (yych <= 'p') goto yy219;
					if (yych <= '~') goto yy10;
					goto yy218;
				}
			}
		}
yy290:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych >= ':') goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy291:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy218;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy218;
				goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy291;
				if (yych <= ':') goto yy10;
				goto yy218;
			} else {
				if (yych == '_') goto yy290;
				if (yych <= '~') goto yy10;
				goto yy218;
			}
		}
yy293:
		yych = *++cursor_;
		if (yych == '=') goto yy405;
		goto yy11;
yy294:
		yych = *++cursor_;
		if (yych == 'n') goto yy406;
		goto yy11;
yy295:
		yych = *++cursor_;
		if (yych == 't') goto yy407;
		goto yy11;
yy296:
		yych = *++cursor_;
		if (yych == 'c') goto yy408;
		goto yy11;
yy297:
		yych = *++cursor_;
		if (yych == 'y') goto yy409;
		goto yy11;
yy298:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 265 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Block); }
#line 2295 "src/prebuilt/wast-lexer-gen.cc"
yy300:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 271 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(BrIf); }
#line 2303 "src/prebuilt/wast-lexer-gen.cc"
yy302:
		yych = *++cursor_;
		if (yych == 'b') goto yy411;
		goto yy11;
yy303:
		yych = *++cursor_;
		if (yych == 'i') goto yy412;
		goto yy11;
yy304:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 692 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Catch); }
#line 2319 "src/prebuilt/wast-lexer-gen.cc"
yy306:
		yych = *++cursor_;
		if (yych == 'n') goto yy413;
		goto yy11;
yy307:
		yych = *++cursor_;
		if (yych == 't') goto yy414;
		goto yy11;
yy308:
		yych = *++cursor_;
		if (yych == 't') goto yy416;
		goto yy11;
yy309:
		yych = *++cursor_;
		if (yych == 'b') goto yy418;
		if (yych == 'd') goto yy419;
		goto yy11;
yy310:
		yych = *++cursor_;
		if (yych == 'e') goto yy420;
		if (yych == 'o') goto yy421;
		goto yy11;
yy311:
		yych = *++cursor_;
		if (yych == 'e') goto yy422;
		if (yych == 'i') goto yy423;
		goto yy11;
yy312:
		yych = *++cursor_;
		if (yych == 'q') goto yy424;
		goto yy11;
yy313:
		yych = *++cursor_;
		if (yych == 'l') goto yy426;
		goto yy11;
yy314:
		yych = *++cursor_;
		if (yych == 'e') goto yy427;
		if (yych == 't') goto yy429;
		goto yy11;
yy315:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy431;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy433;
			if (yych == 't') goto yy434;
			goto yy11;
		}
yy316:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy436;
			goto yy11;
		} else {
			if (yych <= 'i') goto yy437;
			if (yych == 'u') goto yy438;
			goto yy11;
		}
yy317:
		yych = *++cursor_;
		if (yych == 'e') goto yy439;
		goto yy11;
yy318:
		yych = *++cursor_;
		if (yych == 'e') goto yy441;
		goto yy11;
yy319:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy442;
			goto yy11;
		} else {
			if (yych <= 't') goto yy443;
			if (yych <= 'u') goto yy444;
			goto yy11;
		}
yy320:
		yych = *++cursor_;
		if (yych == 'r') goto yy445;
		goto yy11;
yy321:
		yych = *++cursor_;
		if (yych == '.') goto yy446;
		goto yy11;
yy322:
		yych = *++cursor_;
		if (yych == 'b') goto yy447;
		if (yych == 'd') goto yy448;
		goto yy11;
yy323:
		yych = *++cursor_;
		if (yych == 'e') goto yy449;
		if (yych == 'o') goto yy450;
		goto yy11;
yy324:
		yych = *++cursor_;
		if (yych == 'i') goto yy451;
		goto yy11;
yy325:
		yych = *++cursor_;
		if (yych == 'q') goto yy452;
		goto yy11;
yy326:
		yych = *++cursor_;
		if (yych == 'l') goto yy454;
		goto yy11;
yy327:
		yych = *++cursor_;
		if (yych == 'e') goto yy455;
		if (yych == 't') goto yy457;
		goto yy11;
yy328:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy459;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy461;
			if (yych == 't') goto yy462;
			goto yy11;
		}
yy329:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy464;
			goto yy11;
		} else {
			if (yych <= 'i') goto yy465;
			if (yych == 'u') goto yy466;
			goto yy11;
		}
yy330:
		yych = *++cursor_;
		if (yych == 'e') goto yy467;
		goto yy11;
yy331:
		yych = *++cursor_;
		if (yych == 'r') goto yy469;
		goto yy11;
yy332:
		yych = *++cursor_;
		if (yych == 'e') goto yy470;
		goto yy11;
yy333:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'q') goto yy471;
			goto yy11;
		} else {
			if (yych <= 't') goto yy472;
			if (yych <= 'u') goto yy473;
			goto yy11;
		}
yy334:
		yych = *++cursor_;
		if (yych == 'r') goto yy474;
		goto yy11;
yy335:
		yych = *++cursor_;
		if (yych == '.') goto yy475;
		goto yy11;
yy336:
		yych = *++cursor_;
		if (yych == 'l') goto yy476;
		goto yy11;
yy337:
		yych = *++cursor_;
		if (yych == 'o') goto yy477;
		goto yy11;
yy338:
		yych = *++cursor_;
		if (yych == 'l') goto yy478;
		goto yy11;
yy339:
		yych = *++cursor_;
		if (yych == 'm') goto yy480;
		goto yy11;
yy340:
		yych = *++cursor_;
		if (yych == '.') goto yy481;
		goto yy11;
yy341:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'd') goto yy482;
			goto yy11;
		} else {
			if (yych <= 'n') goto yy483;
			if (yych == 't') goto yy484;
			goto yy11;
		}
yy342:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy485;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy486;
			if (yych == 't') goto yy487;
			goto yy11;
		}
yy343:
		yych = *++cursor_;
		if (yych == 'i') goto yy488;
		goto yy11;
yy344:
		yych = *++cursor_;
		if (yych == 'q') goto yy489;
		if (yych == 'x') goto yy491;
		goto yy11;
yy345:
		yych = *++cursor_;
		if (yych == 'e') goto yy492;
		if (yych == 't') goto yy493;
		goto yy11;
yy346:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy494;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy495;
			if (yych == 't') goto yy496;
			goto yy11;
		}
yy347:
		yych = *++cursor_;
		if (yych == 'u') goto yy497;
		goto yy11;
yy348:
		yych = *++cursor_;
		if (yych == 'e') goto yy498;
		goto yy11;
yy349:
		yych = *++cursor_;
		if (yych == 'r') goto yy500;
		goto yy11;
yy350:
		yych = *++cursor_;
		if (yych == 'o') goto yy502;
		goto yy11;
yy351:
		yych = *++cursor_;
		if (yych == 'e') goto yy503;
		if (yych == 'o') goto yy504;
		goto yy11;
yy352:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy505;
			goto yy11;
		} else {
			if (yych <= 't') goto yy506;
			if (yych <= 'u') goto yy507;
			goto yy11;
		}
yy353:
		yych = *++cursor_;
		if (yych == 'r') goto yy508;
		goto yy11;
yy354:
		yych = *++cursor_;
		if (yych == 'r') goto yy509;
		goto yy11;
yy355:
		yych = *++cursor_;
		if (yych == 'o') goto yy510;
		goto yy11;
yy356:
		yych = *++cursor_;
		if (yych == '.') goto yy511;
		goto yy11;
yy357:
		yych = *++cursor_;
		if (yych <= 'm') {
			if (yych == 'd') goto yy512;
			goto yy11;
		} else {
			if (yych <= 'n') goto yy513;
			if (yych == 't') goto yy514;
			goto yy11;
		}
yy358:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'l') goto yy515;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy516;
			if (yych == 't') goto yy517;
			goto yy11;
		}
yy359:
		yych = *++cursor_;
		if (yych == 'i') goto yy518;
		goto yy11;
yy360:
		yych = *++cursor_;
		if (yych == 'q') goto yy519;
		if (yych == 'x') goto yy521;
		goto yy11;
yy361:
		yych = *++cursor_;
		if (yych == 'e') goto yy522;
		if (yych == 't') goto yy523;
		goto yy11;
yy362:
		yych = *++cursor_;
		if (yych <= 'n') {
			if (yych == 'e') goto yy524;
			goto yy11;
		} else {
			if (yych <= 'o') goto yy525;
			if (yych == 't') goto yy526;
			goto yy11;
		}
yy363:
		yych = *++cursor_;
		if (yych == 'u') goto yy527;
		goto yy11;
yy364:
		yych = *++cursor_;
		if (yych == 'e') goto yy528;
		goto yy11;
yy365:
		yych = *++cursor_;
		if (yych == 'r') goto yy530;
		goto yy11;
yy366:
		yych = *++cursor_;
		if (yych == 'o') goto yy532;
		goto yy11;
yy367:
		yych = *++cursor_;
		if (yych == 'e') goto yy533;
		if (yych == 'o') goto yy534;
		goto yy11;
yy368:
		yych = *++cursor_;
		if (yych <= 's') {
			if (yych == 'h') goto yy535;
			goto yy11;
		} else {
			if (yych <= 't') goto yy536;
			if (yych <= 'u') goto yy537;
			goto yy11;
		}
yy369:
		yych = *++cursor_;
		if (yych == 'r') goto yy538;
		goto yy11;
yy370:
		yych = *++cursor_;
		if (yych == 'o') goto yy539;
		goto yy11;
yy371:
		yych = *++cursor_;
		if (yych == '.') goto yy540;
		goto yy11;
yy372:
		yych = *++cursor_;
		if (yych == '.') goto yy541;
		goto yy11;
yy373:
		yych = *++cursor_;
		if (yych == 'c') goto yy542;
		goto yy11;
yy374:
		yych = *++cursor_;
		if (yych == 't') goto yy543;
		goto yy11;
yy375:
		yych = *++cursor_;
		if (yych == 'e') goto yy545;
		goto yy11;
yy376:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 666 "src/wast-lexer.cc"
		{ RETURN(Local); }
#line 2704 "src/prebuilt/wast-lexer-gen.cc"
yy378:
		yych = *++cursor_;
		if (yych == 'y') goto yy547;
		goto yy11;
yy379:
		yych = *++cursor_;
		if (yych == 'e') goto yy549;
		goto yy11;
yy380:
		yych = *++cursor_;
		if (yych == 'x') goto yy551;
		goto yy11;
yy381:
		yych = *++cursor_;
		if (yych == 't') goto yy552;
		goto yy11;
yy382:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 664 "src/wast-lexer.cc"
		{ RETURN(Param); }
#line 2728 "src/prebuilt/wast-lexer-gen.cc"
yy384:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 670 "src/wast-lexer.cc"
		{ RETURN(Quote); }
#line 2736 "src/prebuilt/wast-lexer-gen.cc"
yy386:
		yych = *++cursor_;
		if (yych == 't') goto yy554;
		goto yy11;
yy387:
		yych = *++cursor_;
		if (yych == 't') goto yy555;
		goto yy11;
yy388:
		yych = *++cursor_;
		if (yych == 'o') goto yy557;
		goto yy11;
yy389:
		yych = *++cursor_;
		if (yych == 'n') goto yy558;
		goto yy11;
yy390:
		yych = *++cursor_;
		if (yych == 't') goto yy560;
		goto yy11;
yy391:
		yych = *++cursor_;
		if (yych == 'l') goto yy562;
		goto yy11;
yy392:
		yych = *++cursor_;
		if (yych == 'o') goto yy563;
		goto yy11;
yy393:
		yych = *++cursor_;
		if (yych == 'd') goto yy564;
		goto yy11;
yy394:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 673 "src/wast-lexer.cc"
		{ RETURN(Start); }
#line 2776 "src/prebuilt/wast-lexer-gen.cc"
yy396:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 671 "src/wast-lexer.cc"
		{ RETURN(Table); }
#line 2784 "src/prebuilt/wast-lexer-gen.cc"
yy398:
		yych = *++cursor_;
		if (yych == 'o') goto yy566;
		goto yy11;
yy399:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 693 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Throw); }
#line 2796 "src/prebuilt/wast-lexer-gen.cc"
yy401:
		yych = *++cursor_;
		if (yych == 'c') goto yy567;
		goto yy11;
yy402:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy568;
		case 'b':	goto yy569;
		case 'c':	goto yy570;
		case 'l':	goto yy571;
		case 'n':	goto yy572;
		case 'o':	goto yy573;
		case 's':	goto yy574;
		case 'x':	goto yy575;
		default:	goto yy11;
		}
yy403:
		yych = *++cursor_;
		if (yych == '.') goto yy576;
		goto yy11;
yy404:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy12;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy12;
				if (yych <= '/') goto yy10;
				goto yy288;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy12;
				if (yych <= '@') goto yy10;
				goto yy288;
			} else {
				if (yych <= '`') goto yy10;
				if (yych <= 'f') goto yy288;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy405:
		yych = *++cursor_;
		if (yych <= '/') goto yy11;
		if (yych <= '0') goto yy577;
		if (yych <= '9') goto yy579;
		goto yy11;
yy406:
		yych = *++cursor_;
		if (yych == 'c') goto yy581;
		goto yy11;
yy407:
		yych = *++cursor_;
		if (yych == '_') goto yy583;
		goto yy11;
yy408:
		yych = *++cursor_;
		if (yych == '.') goto yy584;
		goto yy11;
yy409:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 669 "src/wast-lexer.cc"
		{ RETURN(Bin); }
#line 2869 "src/prebuilt/wast-lexer-gen.cc"
yy411:
		yych = *++cursor_;
		if (yych == 'l') goto yy585;
		goto yy11;
yy412:
		yych = *++cursor_;
		if (yych == 'n') goto yy586;
		goto yy11;
yy413:
		yych = *++cursor_;
		if (yych == 't') goto yy587;
		goto yy11;
yy414:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 679 "src/wast-lexer.cc"
		{ RETURN(Except); }
#line 2889 "src/prebuilt/wast-lexer-gen.cc"
yy416:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 678 "src/wast-lexer.cc"
		{ RETURN(Export); }
#line 2897 "src/prebuilt/wast-lexer-gen.cc"
yy418:
		yych = *++cursor_;
		if (yych == 's') goto yy588;
		goto yy11;
yy419:
		yych = *++cursor_;
		if (yych == 'd') goto yy590;
		goto yy11;
yy420:
		yych = *++cursor_;
		if (yych == 'i') goto yy592;
		goto yy11;
yy421:
		yych = *++cursor_;
		if (yych == 'n') goto yy593;
		if (yych == 'p') goto yy594;
		goto yy11;
yy422:
		yych = *++cursor_;
		if (yych == 'm') goto yy595;
		goto yy11;
yy423:
		yych = *++cursor_;
		if (yych == 'v') goto yy596;
		goto yy11;
yy424:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 403 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Eq); }
#line 2930 "src/prebuilt/wast-lexer-gen.cc"
yy426:
		yych = *++cursor_;
		if (yych == 'o') goto yy598;
		goto yy11;
yy427:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 413 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Ge); }
#line 2942 "src/prebuilt/wast-lexer-gen.cc"
yy429:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 411 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Gt); }
#line 2950 "src/prebuilt/wast-lexer-gen.cc"
yy431:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 409 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Le); }
#line 2958 "src/prebuilt/wast-lexer-gen.cc"
yy433:
		yych = *++cursor_;
		if (yych == 'a') goto yy599;
		goto yy11;
yy434:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 407 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Lt); }
#line 2970 "src/prebuilt/wast-lexer-gen.cc"
yy436:
		yych = *++cursor_;
		if (yych == 'x') goto yy600;
		goto yy11;
yy437:
		yych = *++cursor_;
		if (yych == 'n') goto yy602;
		goto yy11;
yy438:
		yych = *++cursor_;
		if (yych == 'l') goto yy604;
		goto yy11;
yy439:
		yych = *++cursor_;
		if (yych <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy440;
				if (yych <= '`') goto yy10;
				goto yy606;
			} else {
				if (yych == 'g') goto yy607;
				if (yych <= '~') goto yy10;
			}
		}
yy440:
#line 405 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32Ne); }
#line 3005 "src/prebuilt/wast-lexer-gen.cc"
yy441:
		yych = *++cursor_;
		if (yych == 'i') goto yy609;
		goto yy11;
yy442:
		yych = *++cursor_;
		if (yych == 'r') goto yy610;
		goto yy11;
yy443:
		yych = *++cursor_;
		if (yych == 'o') goto yy611;
		goto yy11;
yy444:
		yych = *++cursor_;
		if (yych == 'b') goto yy612;
		goto yy11;
yy445:
		yych = *++cursor_;
		if (yych == 'u') goto yy614;
		goto yy11;
yy446:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy615;
		case 'c':	goto yy616;
		case 'd':	goto yy617;
		case 'e':	goto yy618;
		case 'g':	goto yy619;
		case 'l':	goto yy620;
		case 'm':	goto yy621;
		case 'n':	goto yy622;
		case 'r':	goto yy623;
		case 's':	goto yy624;
		default:	goto yy11;
		}
yy447:
		yych = *++cursor_;
		if (yych == 's') goto yy625;
		goto yy11;
yy448:
		yych = *++cursor_;
		if (yych == 'd') goto yy627;
		goto yy11;
yy449:
		yych = *++cursor_;
		if (yych == 'i') goto yy629;
		goto yy11;
yy450:
		yych = *++cursor_;
		if (yych == 'n') goto yy630;
		if (yych == 'p') goto yy631;
		goto yy11;
yy451:
		yych = *++cursor_;
		if (yych == 'v') goto yy632;
		goto yy11;
yy452:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 404 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Eq); }
#line 3069 "src/prebuilt/wast-lexer-gen.cc"
yy454:
		yych = *++cursor_;
		if (yych == 'o') goto yy634;
		goto yy11;
yy455:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 414 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Ge); }
#line 3081 "src/prebuilt/wast-lexer-gen.cc"
yy457:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 412 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Gt); }
#line 3089 "src/prebuilt/wast-lexer-gen.cc"
yy459:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 410 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Le); }
#line 3097 "src/prebuilt/wast-lexer-gen.cc"
yy461:
		yych = *++cursor_;
		if (yych == 'a') goto yy635;
		goto yy11;
yy462:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 408 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Lt); }
#line 3109 "src/prebuilt/wast-lexer-gen.cc"
yy464:
		yych = *++cursor_;
		if (yych == 'x') goto yy636;
		goto yy11;
yy465:
		yych = *++cursor_;
		if (yych == 'n') goto yy638;
		goto yy11;
yy466:
		yych = *++cursor_;
		if (yych == 'l') goto yy640;
		goto yy11;
yy467:
		yych = *++cursor_;
		if (yych <= ':') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= 'a') {
				if (yych <= ';') goto yy468;
				if (yych <= '`') goto yy10;
				goto yy642;
			} else {
				if (yych == 'g') goto yy643;
				if (yych <= '~') goto yy10;
			}
		}
yy468:
#line 406 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64Ne); }
#line 3144 "src/prebuilt/wast-lexer-gen.cc"
yy469:
		yych = *++cursor_;
		if (yych == 'o') goto yy645;
		goto yy11;
yy470:
		yych = *++cursor_;
		if (yych == 'i') goto yy646;
		goto yy11;
yy471:
		yych = *++cursor_;
		if (yych == 'r') goto yy647;
		goto yy11;
yy472:
		yych = *++cursor_;
		if (yych == 'o') goto yy648;
		goto yy11;
yy473:
		yych = *++cursor_;
		if (yych == 'b') goto yy649;
		goto yy11;
yy474:
		yych = *++cursor_;
		if (yych == 'u') goto yy651;
		goto yy11;
yy475:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy652;
		case 'c':	goto yy653;
		case 'd':	goto yy654;
		case 'e':	goto yy655;
		case 'g':	goto yy656;
		case 'l':	goto yy657;
		case 'm':	goto yy658;
		case 'n':	goto yy659;
		case 'r':	goto yy660;
		case 's':	goto yy661;
		default:	goto yy11;
		}
yy476:
		yych = *++cursor_;
		if (yych == 'o') goto yy662;
		goto yy11;
yy477:
		yych = *++cursor_;
		if (yych == 'c') goto yy663;
		goto yy11;
yy478:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 667 "src/wast-lexer.cc"
		{ RETURN(Global); }
#line 3199 "src/prebuilt/wast-lexer-gen.cc"
yy480:
		yych = *++cursor_;
		if (yych == 'e') goto yy664;
		goto yy11;
yy481:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy665;
		case 'e':	goto yy666;
		case 'g':	goto yy667;
		case 'l':	goto yy668;
		case 'm':	goto yy669;
		case 'n':	goto yy670;
		case 'r':	goto yy671;
		case 's':	goto yy672;
		default:	goto yy11;
		}
yy482:
		yych = *++cursor_;
		if (yych == 'd') goto yy673;
		goto yy11;
yy483:
		yych = *++cursor_;
		if (yych == 'd') goto yy675;
		goto yy11;
yy484:
		yych = *++cursor_;
		if (yych == 'o') goto yy677;
		goto yy11;
yy485:
		yych = *++cursor_;
		if (yych == 'z') goto yy678;
		goto yy11;
yy486:
		yych = *++cursor_;
		if (yych == 'n') goto yy680;
		goto yy11;
yy487:
		yych = *++cursor_;
		if (yych == 'z') goto yy681;
		goto yy11;
yy488:
		yych = *++cursor_;
		if (yych == 'v') goto yy683;
		goto yy11;
yy489:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy490;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'z') goto yy684;
				if (yych <= '~') goto yy10;
			}
		}
yy490:
#line 383 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32Eq); }
#line 3265 "src/prebuilt/wast-lexer-gen.cc"
yy491:
		yych = *++cursor_;
		if (yych == 't') goto yy686;
		goto yy11;
yy492:
		yych = *++cursor_;
		if (yych == '_') goto yy687;
		goto yy11;
yy493:
		yych = *++cursor_;
		if (yych == '_') goto yy688;
		goto yy11;
yy494:
		yych = *++cursor_;
		if (yych == '_') goto yy689;
		goto yy11;
yy495:
		yych = *++cursor_;
		if (yych == 'a') goto yy690;
		goto yy11;
yy496:
		yych = *++cursor_;
		if (yych == '_') goto yy691;
		goto yy11;
yy497:
		yych = *++cursor_;
		if (yych == 'l') goto yy692;
		goto yy11;
yy498:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 385 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32Ne); }
#line 3301 "src/prebuilt/wast-lexer-gen.cc"
yy500:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 355 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Or); }
#line 3309 "src/prebuilt/wast-lexer-gen.cc"
yy502:
		yych = *++cursor_;
		if (yych == 'p') goto yy694;
		goto yy11;
yy503:
		yych = *++cursor_;
		if (yych == 'i') goto yy695;
		if (yych == 'm') goto yy696;
		goto yy11;
yy504:
		yych = *++cursor_;
		if (yych == 't') goto yy697;
		goto yy11;
yy505:
		yych = *++cursor_;
		if (yych == 'l') goto yy698;
		if (yych == 'r') goto yy700;
		goto yy11;
yy506:
		yych = *++cursor_;
		if (yych == 'o') goto yy701;
		goto yy11;
yy507:
		yych = *++cursor_;
		if (yych == 'b') goto yy702;
		goto yy11;
yy508:
		yych = *++cursor_;
		if (yych == 'u') goto yy704;
		goto yy11;
yy509:
		yych = *++cursor_;
		if (yych == 'a') goto yy705;
		goto yy11;
yy510:
		yych = *++cursor_;
		if (yych == 'r') goto yy706;
		goto yy11;
yy511:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy708;
		case 'e':	goto yy709;
		case 'g':	goto yy710;
		case 'l':	goto yy711;
		case 'm':	goto yy712;
		case 'n':	goto yy713;
		case 'r':	goto yy714;
		case 's':	goto yy715;
		case 't':	goto yy716;
		default:	goto yy11;
		}
yy512:
		yych = *++cursor_;
		if (yych == 'd') goto yy717;
		goto yy11;
yy513:
		yych = *++cursor_;
		if (yych == 'd') goto yy719;
		goto yy11;
yy514:
		yych = *++cursor_;
		if (yych == 'o') goto yy721;
		goto yy11;
yy515:
		yych = *++cursor_;
		if (yych == 'z') goto yy722;
		goto yy11;
yy516:
		yych = *++cursor_;
		if (yych == 'n') goto yy724;
		goto yy11;
yy517:
		yych = *++cursor_;
		if (yych == 'z') goto yy725;
		goto yy11;
yy518:
		yych = *++cursor_;
		if (yych == 'v') goto yy727;
		goto yy11;
yy519:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy520;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'y') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'z') goto yy728;
				if (yych <= '~') goto yy10;
			}
		}
yy520:
#line 384 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64Eq); }
#line 3410 "src/prebuilt/wast-lexer-gen.cc"
yy521:
		yych = *++cursor_;
		if (yych == 't') goto yy730;
		goto yy11;
yy522:
		yych = *++cursor_;
		if (yych == '_') goto yy731;
		goto yy11;
yy523:
		yych = *++cursor_;
		if (yych == '_') goto yy732;
		goto yy11;
yy524:
		yych = *++cursor_;
		if (yych == '_') goto yy733;
		goto yy11;
yy525:
		yych = *++cursor_;
		if (yych == 'a') goto yy734;
		goto yy11;
yy526:
		yych = *++cursor_;
		if (yych == '_') goto yy735;
		goto yy11;
yy527:
		yych = *++cursor_;
		if (yych == 'l') goto yy736;
		goto yy11;
yy528:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 386 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64Ne); }
#line 3446 "src/prebuilt/wast-lexer-gen.cc"
yy530:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 356 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Or); }
#line 3454 "src/prebuilt/wast-lexer-gen.cc"
yy532:
		yych = *++cursor_;
		if (yych == 'p') goto yy738;
		goto yy11;
yy533:
		yych = *++cursor_;
		if (yych == 'i') goto yy739;
		if (yych == 'm') goto yy740;
		goto yy11;
yy534:
		yych = *++cursor_;
		if (yych == 't') goto yy741;
		goto yy11;
yy535:
		yych = *++cursor_;
		if (yych == 'l') goto yy742;
		if (yych == 'r') goto yy744;
		goto yy11;
yy536:
		yych = *++cursor_;
		if (yych == 'o') goto yy745;
		goto yy11;
yy537:
		yych = *++cursor_;
		if (yych == 'b') goto yy746;
		goto yy11;
yy538:
		yych = *++cursor_;
		if (yych == 'u') goto yy748;
		goto yy11;
yy539:
		yych = *++cursor_;
		if (yych == 'r') goto yy749;
		goto yy11;
yy540:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy751;
		case 'e':	goto yy752;
		case 'n':	goto yy753;
		case 'r':	goto yy754;
		case 's':	goto yy755;
		case 't':	goto yy756;
		default:	goto yy11;
		}
yy541:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy757;
		case 'e':	goto yy758;
		case 'g':	goto yy759;
		case 'l':	goto yy760;
		case 'm':	goto yy761;
		case 'n':	goto yy762;
		case 'r':	goto yy763;
		case 's':	goto yy764;
		default:	goto yy11;
		}
yy542:
		yych = *++cursor_;
		if (yych == 'e') goto yy765;
		goto yy11;
yy543:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 677 "src/wast-lexer.cc"
		{ RETURN(Import); }
#line 3524 "src/prebuilt/wast-lexer-gen.cc"
yy545:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 681 "src/wast-lexer.cc"
		{ RETURN(Invoke); }
#line 3532 "src/prebuilt/wast-lexer-gen.cc"
yy547:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy548;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= ':') {
				if (yych == '.') goto yy766;
				goto yy10;
			} else {
				if (yych <= ';') goto yy548;
				if (yych <= '~') goto yy10;
			}
		}
yy548:
#line 672 "src/wast-lexer.cc"
		{ RETURN(Memory); }
#line 3554 "src/prebuilt/wast-lexer-gen.cc"
yy549:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 668 "src/wast-lexer.cc"
		{ RETURN(Module); }
#line 3562 "src/prebuilt/wast-lexer-gen.cc"
yy551:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy12;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy12;
				if (yych <= '/') goto yy10;
				goto yy767;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy12;
				if (yych <= '@') goto yy10;
				goto yy767;
			} else {
				if (yych <= '`') goto yy10;
				if (yych <= 'f') goto yy767;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy552:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy553;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '<') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '=') goto yy769;
				if (yych <= '~') goto yy10;
			}
		}
yy553:
#line 676 "src/wast-lexer.cc"
		{ RETURN(Offset); }
#line 3609 "src/prebuilt/wast-lexer-gen.cc"
yy554:
		yych = *++cursor_;
		if (yych == 'e') goto yy770;
		goto yy11;
yy555:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 665 "src/wast-lexer.cc"
		{ RETURN(Result); }
#line 3621 "src/prebuilt/wast-lexer-gen.cc"
yy557:
		yych = *++cursor_;
		if (yych == 'w') goto yy771;
		goto yy11;
yy558:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 277 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Return); }
#line 3633 "src/prebuilt/wast-lexer-gen.cc"
yy560:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 448 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Select); }
#line 3641 "src/prebuilt/wast-lexer-gen.cc"
yy562:
		yych = *++cursor_;
		if (yych == 'o') goto yy773;
		goto yy11;
yy563:
		yych = *++cursor_;
		if (yych == 'c') goto yy774;
		goto yy11;
yy564:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 697 "src/wast-lexer.cc"
		{ RETURN(Shared); }
#line 3657 "src/prebuilt/wast-lexer-gen.cc"
yy566:
		yych = *++cursor_;
		if (yych == 'c') goto yy775;
		goto yy11;
yy567:
		yych = *++cursor_;
		if (yych == 'h') goto yy776;
		goto yy11;
yy568:
		yych = *++cursor_;
		if (yych == 'n') goto yy777;
		goto yy11;
yy569:
		yych = *++cursor_;
		if (yych == 'i') goto yy778;
		goto yy11;
yy570:
		yych = *++cursor_;
		if (yych == 'o') goto yy779;
		goto yy11;
yy571:
		yych = *++cursor_;
		if (yych == 'o') goto yy780;
		goto yy11;
yy572:
		yych = *++cursor_;
		if (yych == 'o') goto yy781;
		goto yy11;
yy573:
		yych = *++cursor_;
		if (yych == 'r') goto yy782;
		goto yy11;
yy574:
		yych = *++cursor_;
		if (yych == 't') goto yy784;
		goto yy11;
yy575:
		yych = *++cursor_;
		if (yych == 'o') goto yy785;
		goto yy11;
yy576:
		yych = *++cursor_;
		if (yych == 's') goto yy786;
		goto yy11;
yy577:
		yych = *++cursor_;
		if (yych == 'x') goto yy788;
		goto yy580;
yy578:
#line 307 "src/wast-lexer.cc"
		{ RETURN_TEXT_AT(AlignEqNat, 6); }
#line 3709 "src/prebuilt/wast-lexer-gen.cc"
yy579:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy580:
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy578;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy578;
				goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy579;
				if (yych <= ':') goto yy10;
				goto yy578;
			} else {
				if (yych == '_') goto yy787;
				if (yych <= '~') goto yy10;
				goto yy578;
			}
		}
yy581:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 262 "src/wast-lexer.cc"
		{ RETURN(Anyfunc); }
#line 3742 "src/prebuilt/wast-lexer-gen.cc"
yy583:
		yych = *++cursor_;
		switch (yych) {
		case 'e':	goto yy789;
		case 'i':	goto yy790;
		case 'm':	goto yy791;
		case 'r':	goto yy792;
		case 't':	goto yy793;
		case 'u':	goto yy794;
		default:	goto yy11;
		}
yy584:
		yych = *++cursor_;
		if (yych == 'w') goto yy795;
		goto yy11;
yy585:
		yych = *++cursor_;
		if (yych == 'e') goto yy796;
		goto yy11;
yy586:
		yych = *++cursor_;
		if (yych == 'd') goto yy798;
		goto yy11;
yy587:
		yych = *++cursor_;
		if (yych == '_') goto yy799;
		goto yy11;
yy588:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 322 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Abs); }
#line 3777 "src/prebuilt/wast-lexer-gen.cc"
yy590:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 369 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Add); }
#line 3785 "src/prebuilt/wast-lexer-gen.cc"
yy592:
		yych = *++cursor_;
		if (yych == 'l') goto yy800;
		goto yy11;
yy593:
		yych = *++cursor_;
		if (yych == 's') goto yy802;
		if (yych == 'v') goto yy803;
		goto yy11;
yy594:
		yych = *++cursor_;
		if (yych == 'y') goto yy804;
		goto yy11;
yy595:
		yych = *++cursor_;
		if (yych == 'o') goto yy805;
		goto yy11;
yy596:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 375 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Div); }
#line 3810 "src/prebuilt/wast-lexer-gen.cc"
yy598:
		yych = *++cursor_;
		if (yych == 'o') goto yy806;
		goto yy11;
yy599:
		yych = *++cursor_;
		if (yych == 'd') goto yy807;
		goto yy11;
yy600:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 379 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Max); }
#line 3826 "src/prebuilt/wast-lexer-gen.cc"
yy602:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 377 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Min); }
#line 3834 "src/prebuilt/wast-lexer-gen.cc"
yy604:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 373 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Mul); }
#line 3842 "src/prebuilt/wast-lexer-gen.cc"
yy606:
		yych = *++cursor_;
		if (yych == 'r') goto yy809;
		goto yy11;
yy607:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 320 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Neg); }
#line 3854 "src/prebuilt/wast-lexer-gen.cc"
yy609:
		yych = *++cursor_;
		if (yych == 'n') goto yy810;
		goto yy11;
yy610:
		yych = *++cursor_;
		if (yych == 't') goto yy811;
		goto yy11;
yy611:
		yych = *++cursor_;
		if (yych == 'r') goto yy813;
		goto yy11;
yy612:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 371 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Sub); }
#line 3874 "src/prebuilt/wast-lexer-gen.cc"
yy614:
		yych = *++cursor_;
		if (yych == 'n') goto yy814;
		goto yy11;
yy615:
		yych = *++cursor_;
		if (yych == 'b') goto yy815;
		if (yych == 'd') goto yy816;
		goto yy11;
yy616:
		yych = *++cursor_;
		if (yych == 'o') goto yy817;
		goto yy11;
yy617:
		yych = *++cursor_;
		if (yych == 'i') goto yy818;
		goto yy11;
yy618:
		yych = *++cursor_;
		if (yych == 'q') goto yy819;
		if (yych == 'x') goto yy821;
		goto yy11;
yy619:
		yych = *++cursor_;
		if (yych == 'e') goto yy822;
		if (yych == 't') goto yy824;
		goto yy11;
yy620:
		yych = *++cursor_;
		if (yych == 'e') goto yy826;
		if (yych == 't') goto yy828;
		goto yy11;
yy621:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy830;
			goto yy11;
		} else {
			if (yych <= 'i') goto yy831;
			if (yych == 'u') goto yy832;
			goto yy11;
		}
yy622:
		yych = *++cursor_;
		if (yych == 'e') goto yy833;
		goto yy11;
yy623:
		yych = *++cursor_;
		if (yych == 'e') goto yy835;
		goto yy11;
yy624:
		yych = *++cursor_;
		if (yych <= 'q') {
			if (yych <= 'o') goto yy11;
			if (yych <= 'p') goto yy836;
			goto yy837;
		} else {
			if (yych == 'u') goto yy838;
			goto yy11;
		}
yy625:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 323 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Abs); }
#line 3942 "src/prebuilt/wast-lexer-gen.cc"
yy627:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 370 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Add); }
#line 3950 "src/prebuilt/wast-lexer-gen.cc"
yy629:
		yych = *++cursor_;
		if (yych == 'l') goto yy839;
		goto yy11;
yy630:
		yych = *++cursor_;
		if (yych == 's') goto yy841;
		if (yych == 'v') goto yy842;
		goto yy11;
yy631:
		yych = *++cursor_;
		if (yych == 'y') goto yy843;
		goto yy11;
yy632:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 376 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Div); }
#line 3971 "src/prebuilt/wast-lexer-gen.cc"
yy634:
		yych = *++cursor_;
		if (yych == 'o') goto yy844;
		goto yy11;
yy635:
		yych = *++cursor_;
		if (yych == 'd') goto yy845;
		goto yy11;
yy636:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 380 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Max); }
#line 3987 "src/prebuilt/wast-lexer-gen.cc"
yy638:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 378 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Min); }
#line 3995 "src/prebuilt/wast-lexer-gen.cc"
yy640:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 374 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Mul); }
#line 4003 "src/prebuilt/wast-lexer-gen.cc"
yy642:
		yych = *++cursor_;
		if (yych == 'r') goto yy847;
		goto yy11;
yy643:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 321 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Neg); }
#line 4015 "src/prebuilt/wast-lexer-gen.cc"
yy645:
		yych = *++cursor_;
		if (yych == 'm') goto yy848;
		goto yy11;
yy646:
		yych = *++cursor_;
		if (yych == 'n') goto yy849;
		goto yy11;
yy647:
		yych = *++cursor_;
		if (yych == 't') goto yy850;
		goto yy11;
yy648:
		yych = *++cursor_;
		if (yych == 'r') goto yy852;
		goto yy11;
yy649:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 372 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Sub); }
#line 4039 "src/prebuilt/wast-lexer-gen.cc"
yy651:
		yych = *++cursor_;
		if (yych == 'n') goto yy853;
		goto yy11;
yy652:
		yych = *++cursor_;
		if (yych == 'b') goto yy854;
		if (yych == 'd') goto yy855;
		goto yy11;
yy653:
		yych = *++cursor_;
		if (yych == 'o') goto yy856;
		goto yy11;
yy654:
		yych = *++cursor_;
		if (yych == 'i') goto yy857;
		goto yy11;
yy655:
		yych = *++cursor_;
		if (yych == 'q') goto yy858;
		if (yych == 'x') goto yy860;
		goto yy11;
yy656:
		yych = *++cursor_;
		if (yych == 'e') goto yy861;
		if (yych == 't') goto yy863;
		goto yy11;
yy657:
		yych = *++cursor_;
		if (yych == 'e') goto yy865;
		if (yych == 't') goto yy867;
		goto yy11;
yy658:
		yych = *++cursor_;
		if (yych <= 'h') {
			if (yych == 'a') goto yy869;
			goto yy11;
		} else {
			if (yych <= 'i') goto yy870;
			if (yych == 'u') goto yy871;
			goto yy11;
		}
yy659:
		yych = *++cursor_;
		if (yych == 'e') goto yy872;
		goto yy11;
yy660:
		yych = *++cursor_;
		if (yych == 'e') goto yy874;
		goto yy11;
yy661:
		yych = *++cursor_;
		if (yych <= 'q') {
			if (yych <= 'o') goto yy11;
			if (yych <= 'p') goto yy875;
			goto yy876;
		} else {
			if (yych == 'u') goto yy877;
			goto yy11;
		}
yy662:
		yych = *++cursor_;
		if (yych == 'b') goto yy878;
		goto yy11;
yy663:
		yych = *++cursor_;
		if (yych == 'a') goto yy879;
		goto yy11;
yy664:
		yych = *++cursor_;
		if (yych == 'm') goto yy880;
		goto yy11;
yy665:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy881;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy882;
			if (yych == 'n') goto yy883;
			goto yy11;
		}
yy666:
		yych = *++cursor_;
		if (yych == 'q') goto yy884;
		if (yych == 'x') goto yy886;
		goto yy11;
yy667:
		yych = *++cursor_;
		if (yych == 'e') goto yy887;
		if (yych == 't') goto yy888;
		goto yy11;
yy668:
		yych = *++cursor_;
		if (yych == 'e') goto yy889;
		if (yych == 't') goto yy890;
		goto yy11;
yy669:
		yych = *++cursor_;
		if (yych == 'u') goto yy891;
		goto yy11;
yy670:
		yych = *++cursor_;
		if (yych == 'e') goto yy892;
		goto yy11;
yy671:
		yych = *++cursor_;
		if (yych == 'e') goto yy894;
		goto yy11;
yy672:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy895;
			goto yy11;
		} else {
			if (yych <= 'p') goto yy896;
			if (yych == 'u') goto yy897;
			goto yy11;
		}
yy673:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 339 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Add); }
#line 4166 "src/prebuilt/wast-lexer-gen.cc"
yy675:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 353 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32And); }
#line 4174 "src/prebuilt/wast-lexer-gen.cc"
yy677:
		yych = *++cursor_;
		if (yych == 'm') goto yy898;
		goto yy11;
yy678:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 314 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Clz); }
#line 4186 "src/prebuilt/wast-lexer-gen.cc"
yy680:
		yych = *++cursor_;
		if (yych == 's') goto yy899;
		goto yy11;
yy681:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 316 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Ctz); }
#line 4198 "src/prebuilt/wast-lexer-gen.cc"
yy683:
		yych = *++cursor_;
		if (yych == '_') goto yy900;
		goto yy11;
yy684:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 312 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32Eqz); }
#line 4210 "src/prebuilt/wast-lexer-gen.cc"
yy686:
		yych = *++cursor_;
		if (yych == 'e') goto yy901;
		goto yy11;
yy687:
		yych = *++cursor_;
		if (yych == 's') goto yy902;
		if (yych == 'u') goto yy904;
		goto yy11;
yy688:
		yych = *++cursor_;
		if (yych == 's') goto yy906;
		if (yych == 'u') goto yy908;
		goto yy11;
yy689:
		yych = *++cursor_;
		if (yych == 's') goto yy910;
		if (yych == 'u') goto yy912;
		goto yy11;
yy690:
		yych = *++cursor_;
		if (yych == 'd') goto yy914;
		goto yy11;
yy691:
		yych = *++cursor_;
		if (yych == 's') goto yy916;
		if (yych == 'u') goto yy918;
		goto yy11;
yy692:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 343 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Mul); }
#line 4246 "src/prebuilt/wast-lexer-gen.cc"
yy694:
		yych = *++cursor_;
		if (yych == 'c') goto yy920;
		goto yy11;
yy695:
		yych = *++cursor_;
		if (yych == 'n') goto yy921;
		goto yy11;
yy696:
		yych = *++cursor_;
		if (yych == '_') goto yy922;
		goto yy11;
yy697:
		yych = *++cursor_;
		if (yych == 'l') goto yy923;
		if (yych == 'r') goto yy925;
		goto yy11;
yy698:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 359 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Shl); }
#line 4271 "src/prebuilt/wast-lexer-gen.cc"
yy700:
		yych = *++cursor_;
		if (yych == '_') goto yy927;
		goto yy11;
yy701:
		yych = *++cursor_;
		if (yych == 'r') goto yy928;
		goto yy11;
yy702:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 341 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Sub); }
#line 4287 "src/prebuilt/wast-lexer-gen.cc"
yy704:
		yych = *++cursor_;
		if (yych == 'n') goto yy929;
		goto yy11;
yy705:
		yych = *++cursor_;
		if (yych == 'p') goto yy930;
		goto yy11;
yy706:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 357 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Xor); }
#line 4303 "src/prebuilt/wast-lexer-gen.cc"
yy708:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy931;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy932;
			if (yych == 'n') goto yy933;
			goto yy11;
		}
yy709:
		yych = *++cursor_;
		if (yych == 'q') goto yy934;
		if (yych == 'x') goto yy936;
		goto yy11;
yy710:
		yych = *++cursor_;
		if (yych == 'e') goto yy937;
		if (yych == 't') goto yy938;
		goto yy11;
yy711:
		yych = *++cursor_;
		if (yych == 'e') goto yy939;
		if (yych == 't') goto yy940;
		goto yy11;
yy712:
		yych = *++cursor_;
		if (yych == 'u') goto yy941;
		goto yy11;
yy713:
		yych = *++cursor_;
		if (yych == 'e') goto yy942;
		goto yy11;
yy714:
		yych = *++cursor_;
		if (yych == 'e') goto yy944;
		goto yy11;
yy715:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy945;
			goto yy11;
		} else {
			if (yych <= 'p') goto yy946;
			if (yych == 'u') goto yy947;
			goto yy11;
		}
yy716:
		yych = *++cursor_;
		if (yych == 'r') goto yy948;
		goto yy11;
yy717:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 340 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Add); }
#line 4362 "src/prebuilt/wast-lexer-gen.cc"
yy719:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 354 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64And); }
#line 4370 "src/prebuilt/wast-lexer-gen.cc"
yy721:
		yych = *++cursor_;
		if (yych == 'm') goto yy949;
		goto yy11;
yy722:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 315 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Clz); }
#line 4382 "src/prebuilt/wast-lexer-gen.cc"
yy724:
		yych = *++cursor_;
		if (yych == 's') goto yy950;
		goto yy11;
yy725:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 317 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Ctz); }
#line 4394 "src/prebuilt/wast-lexer-gen.cc"
yy727:
		yych = *++cursor_;
		if (yych == '_') goto yy951;
		goto yy11;
yy728:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 313 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64Eqz); }
#line 4406 "src/prebuilt/wast-lexer-gen.cc"
yy730:
		yych = *++cursor_;
		if (yych == 'e') goto yy952;
		goto yy11;
yy731:
		yych = *++cursor_;
		if (yych == 's') goto yy953;
		if (yych == 'u') goto yy955;
		goto yy11;
yy732:
		yych = *++cursor_;
		if (yych == 's') goto yy957;
		if (yych == 'u') goto yy959;
		goto yy11;
yy733:
		yych = *++cursor_;
		if (yych == 's') goto yy961;
		if (yych == 'u') goto yy963;
		goto yy11;
yy734:
		yych = *++cursor_;
		if (yych == 'd') goto yy965;
		goto yy11;
yy735:
		yych = *++cursor_;
		if (yych == 's') goto yy967;
		if (yych == 'u') goto yy969;
		goto yy11;
yy736:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 344 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Mul); }
#line 4442 "src/prebuilt/wast-lexer-gen.cc"
yy738:
		yych = *++cursor_;
		if (yych == 'c') goto yy971;
		goto yy11;
yy739:
		yych = *++cursor_;
		if (yych == 'n') goto yy972;
		goto yy11;
yy740:
		yych = *++cursor_;
		if (yych == '_') goto yy973;
		goto yy11;
yy741:
		yych = *++cursor_;
		if (yych == 'l') goto yy974;
		if (yych == 'r') goto yy976;
		goto yy11;
yy742:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 360 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Shl); }
#line 4467 "src/prebuilt/wast-lexer-gen.cc"
yy744:
		yych = *++cursor_;
		if (yych == '_') goto yy978;
		goto yy11;
yy745:
		yych = *++cursor_;
		if (yych == 'r') goto yy979;
		goto yy11;
yy746:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 342 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Sub); }
#line 4483 "src/prebuilt/wast-lexer-gen.cc"
yy748:
		yych = *++cursor_;
		if (yych == 'n') goto yy980;
		goto yy11;
yy749:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 358 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Xor); }
#line 4495 "src/prebuilt/wast-lexer-gen.cc"
yy751:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy981;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy982;
			if (yych == 'n') goto yy983;
			goto yy11;
		}
yy752:
		yych = *++cursor_;
		if (yych == 'x') goto yy984;
		goto yy11;
yy753:
		yych = *++cursor_;
		if (yych == 'e') goto yy985;
		goto yy11;
yy754:
		yych = *++cursor_;
		if (yych == 'e') goto yy986;
		goto yy11;
yy755:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy987;
			goto yy11;
		} else {
			if (yych <= 'p') goto yy988;
			if (yych == 'u') goto yy989;
			goto yy11;
		}
yy756:
		yych = *++cursor_;
		if (yych == 'r') goto yy990;
		goto yy11;
yy757:
		yych = *++cursor_;
		if (yych <= 'k') {
			if (yych == 'd') goto yy991;
			goto yy11;
		} else {
			if (yych <= 'l') goto yy992;
			if (yych == 'n') goto yy993;
			goto yy11;
		}
yy758:
		yych = *++cursor_;
		if (yych == 'q') goto yy994;
		if (yych == 'x') goto yy996;
		goto yy11;
yy759:
		yych = *++cursor_;
		if (yych == 'e') goto yy997;
		if (yych == 't') goto yy998;
		goto yy11;
yy760:
		yych = *++cursor_;
		if (yych == 'e') goto yy999;
		if (yych == 't') goto yy1000;
		goto yy11;
yy761:
		yych = *++cursor_;
		if (yych == 'u') goto yy1001;
		goto yy11;
yy762:
		yych = *++cursor_;
		if (yych == 'e') goto yy1002;
		goto yy11;
yy763:
		yych = *++cursor_;
		if (yych == 'e') goto yy1004;
		goto yy11;
yy764:
		yych = *++cursor_;
		if (yych <= 'o') {
			if (yych == 'h') goto yy1005;
			goto yy11;
		} else {
			if (yych <= 'p') goto yy1006;
			if (yych == 'u') goto yy1007;
			goto yy11;
		}
yy765:
		yych = *++cursor_;
		if (yych == 'p') goto yy1008;
		goto yy11;
yy766:
		yych = *++cursor_;
		if (yych == 'g') goto yy1009;
		if (yych == 's') goto yy1010;
		goto yy11;
yy767:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy191;
				goto yy10;
			} else {
				if (yych <= ')') goto yy191;
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy767;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy191;
				if (yych <= '@') goto yy10;
				if (yych <= 'F') goto yy767;
				goto yy10;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy551;
					goto yy10;
				} else {
					if (yych <= 'f') goto yy767;
					if (yych <= '~') goto yy10;
					goto yy191;
				}
			}
		}
yy769:
		yych = *++cursor_;
		if (yych <= '/') goto yy11;
		if (yych <= '0') goto yy1011;
		if (yych <= '9') goto yy1013;
		goto yy11;
yy770:
		yych = *++cursor_;
		if (yych == 'r') goto yy1015;
		goto yy11;
yy771:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 694 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Rethrow); }
#line 4637 "src/prebuilt/wast-lexer-gen.cc"
yy773:
		yych = *++cursor_;
		if (yych == 'b') goto yy1017;
		goto yy11;
yy774:
		yych = *++cursor_;
		if (yych == 'a') goto yy1018;
		goto yy11;
yy775:
		yych = *++cursor_;
		if (yych == 'a') goto yy1019;
		goto yy11;
yy776:
		yych = *++cursor_;
		if (yych == 'a') goto yy1020;
		goto yy11;
yy777:
		yych = *++cursor_;
		if (yych == 'd') goto yy1021;
		goto yy11;
yy778:
		yych = *++cursor_;
		if (yych == 't') goto yy1023;
		goto yy11;
yy779:
		yych = *++cursor_;
		if (yych == 'n') goto yy1024;
		goto yy11;
yy780:
		yych = *++cursor_;
		if (yych == 'a') goto yy1025;
		goto yy11;
yy781:
		yych = *++cursor_;
		if (yych == 't') goto yy1026;
		goto yy11;
yy782:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 581 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128Or); }
#line 4681 "src/prebuilt/wast-lexer-gen.cc"
yy784:
		yych = *++cursor_;
		if (yych == 'o') goto yy1028;
		goto yy11;
yy785:
		yych = *++cursor_;
		if (yych == 'r') goto yy1029;
		goto yy11;
yy786:
		yych = *++cursor_;
		if (yych == 'h') goto yy1031;
		goto yy11;
yy787:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy579;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy788:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy12;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy12;
				if (yych <= '/') goto yy10;
				goto yy1032;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy12;
				if (yych <= '@') goto yy10;
				goto yy1032;
			} else {
				if (yych <= '`') goto yy10;
				if (yych <= 'f') goto yy1032;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy789:
		yych = *++cursor_;
		if (yych == 'x') goto yy1034;
		goto yy11;
yy790:
		yych = *++cursor_;
		if (yych == 'n') goto yy1035;
		goto yy11;
yy791:
		yych = *++cursor_;
		if (yych == 'a') goto yy1036;
		goto yy11;
yy792:
		yych = *++cursor_;
		if (yych == 'e') goto yy1037;
		goto yy11;
yy793:
		yych = *++cursor_;
		if (yych == 'r') goto yy1038;
		goto yy11;
yy794:
		yych = *++cursor_;
		if (yych == 'n') goto yy1039;
		goto yy11;
yy795:
		yych = *++cursor_;
		if (yych == 'a') goto yy1040;
		goto yy11;
yy796:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 272 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(BrTable); }
#line 4779 "src/prebuilt/wast-lexer-gen.cc"
yy798:
		yych = *++cursor_;
		if (yych == 'i') goto yy1041;
		goto yy11;
yy799:
		yych = *++cursor_;
		if (yych == 'm') goto yy1042;
		goto yy11;
yy800:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 326 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Ceil); }
#line 4795 "src/prebuilt/wast-lexer-gen.cc"
yy802:
		yych = *++cursor_;
		if (yych == 't') goto yy1043;
		goto yy11;
yy803:
		yych = *++cursor_;
		if (yych == 'e') goto yy1045;
		goto yy11;
yy804:
		yych = *++cursor_;
		if (yych == 's') goto yy1046;
		goto yy11;
yy805:
		yych = *++cursor_;
		if (yych == 't') goto yy1047;
		goto yy11;
yy806:
		yych = *++cursor_;
		if (yych == 'r') goto yy1048;
		goto yy11;
yy807:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 285 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, F32Load); }
#line 4823 "src/prebuilt/wast-lexer-gen.cc"
yy809:
		yych = *++cursor_;
		if (yych == 'e') goto yy1050;
		goto yy11;
yy810:
		yych = *++cursor_;
		if (yych == 't') goto yy1051;
		goto yy11;
yy811:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 324 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Sqrt); }
#line 4839 "src/prebuilt/wast-lexer-gen.cc"
yy813:
		yych = *++cursor_;
		if (yych == 'e') goto yy1052;
		goto yy11;
yy814:
		yych = *++cursor_;
		if (yych == 'c') goto yy1054;
		goto yy11;
yy815:
		yych = *++cursor_;
		if (yych == 's') goto yy1056;
		goto yy11;
yy816:
		yych = *++cursor_;
		if (yych == 'd') goto yy1058;
		goto yy11;
yy817:
		yych = *++cursor_;
		if (yych == 'n') goto yy1060;
		goto yy11;
yy818:
		yych = *++cursor_;
		if (yych == 'v') goto yy1061;
		goto yy11;
yy819:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 596 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Eq); }
#line 4871 "src/prebuilt/wast-lexer-gen.cc"
yy821:
		yych = *++cursor_;
		if (yych == 't') goto yy1063;
		goto yy11;
yy822:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 633 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Ge); }
#line 4883 "src/prebuilt/wast-lexer-gen.cc"
yy824:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 625 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Gt); }
#line 4891 "src/prebuilt/wast-lexer-gen.cc"
yy826:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 617 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Le); }
#line 4899 "src/prebuilt/wast-lexer-gen.cc"
yy828:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 609 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Lt); }
#line 4907 "src/prebuilt/wast-lexer-gen.cc"
yy830:
		yych = *++cursor_;
		if (yych == 'x') goto yy1064;
		goto yy11;
yy831:
		yych = *++cursor_;
		if (yych == 'n') goto yy1066;
		goto yy11;
yy832:
		yych = *++cursor_;
		if (yych == 'l') goto yy1068;
		goto yy11;
yy833:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy834;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'g') goto yy1070;
				if (yych <= '~') goto yy10;
			}
		}
yy834:
#line 601 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F32X4Ne); }
#line 4940 "src/prebuilt/wast-lexer-gen.cc"
yy835:
		yych = *++cursor_;
		if (yych == 'p') goto yy1072;
		goto yy11;
yy836:
		yych = *++cursor_;
		if (yych == 'l') goto yy1073;
		goto yy11;
yy837:
		yych = *++cursor_;
		if (yych == 'r') goto yy1074;
		goto yy11;
yy838:
		yych = *++cursor_;
		if (yych == 'b') goto yy1075;
		goto yy11;
yy839:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 327 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Ceil); }
#line 4964 "src/prebuilt/wast-lexer-gen.cc"
yy841:
		yych = *++cursor_;
		if (yych == 't') goto yy1077;
		goto yy11;
yy842:
		yych = *++cursor_;
		if (yych == 'e') goto yy1079;
		goto yy11;
yy843:
		yych = *++cursor_;
		if (yych == 's') goto yy1080;
		goto yy11;
yy844:
		yych = *++cursor_;
		if (yych == 'r') goto yy1081;
		goto yy11;
yy845:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 286 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, F64Load); }
#line 4988 "src/prebuilt/wast-lexer-gen.cc"
yy847:
		yych = *++cursor_;
		if (yych == 'e') goto yy1083;
		goto yy11;
yy848:
		yych = *++cursor_;
		if (yych == 'o') goto yy1084;
		goto yy11;
yy849:
		yych = *++cursor_;
		if (yych == 't') goto yy1085;
		goto yy11;
yy850:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 325 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Sqrt); }
#line 5008 "src/prebuilt/wast-lexer-gen.cc"
yy852:
		yych = *++cursor_;
		if (yych == 'e') goto yy1086;
		goto yy11;
yy853:
		yych = *++cursor_;
		if (yych == 'c') goto yy1088;
		goto yy11;
yy854:
		yych = *++cursor_;
		if (yych == 's') goto yy1090;
		goto yy11;
yy855:
		yych = *++cursor_;
		if (yych == 'd') goto yy1092;
		goto yy11;
yy856:
		yych = *++cursor_;
		if (yych == 'n') goto yy1094;
		goto yy11;
yy857:
		yych = *++cursor_;
		if (yych == 'v') goto yy1095;
		goto yy11;
yy858:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 597 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Eq); }
#line 5040 "src/prebuilt/wast-lexer-gen.cc"
yy860:
		yych = *++cursor_;
		if (yych == 't') goto yy1097;
		goto yy11;
yy861:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 634 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Ge); }
#line 5052 "src/prebuilt/wast-lexer-gen.cc"
yy863:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 626 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Gt); }
#line 5060 "src/prebuilt/wast-lexer-gen.cc"
yy865:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 618 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Le); }
#line 5068 "src/prebuilt/wast-lexer-gen.cc"
yy867:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 610 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Lt); }
#line 5076 "src/prebuilt/wast-lexer-gen.cc"
yy869:
		yych = *++cursor_;
		if (yych == 'x') goto yy1098;
		goto yy11;
yy870:
		yych = *++cursor_;
		if (yych == 'n') goto yy1100;
		goto yy11;
yy871:
		yych = *++cursor_;
		if (yych == 'l') goto yy1102;
		goto yy11;
yy872:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy873;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'g') goto yy1104;
				if (yych <= '~') goto yy10;
			}
		}
yy873:
#line 602 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, F64X2Ne); }
#line 5109 "src/prebuilt/wast-lexer-gen.cc"
yy874:
		yych = *++cursor_;
		if (yych == 'p') goto yy1106;
		goto yy11;
yy875:
		yych = *++cursor_;
		if (yych == 'l') goto yy1107;
		goto yy11;
yy876:
		yych = *++cursor_;
		if (yych == 'r') goto yy1108;
		goto yy11;
yy877:
		yych = *++cursor_;
		if (yych == 'b') goto yy1109;
		goto yy11;
yy878:
		yych = *++cursor_;
		if (yych == 'a') goto yy1111;
		goto yy11;
yy879:
		yych = *++cursor_;
		if (yych == 'l') goto yy1112;
		goto yy11;
yy880:
		yych = *++cursor_;
		if (yych == 'o') goto yy1114;
		goto yy11;
yy881:
		yych = *++cursor_;
		if (yych == 'd') goto yy1115;
		goto yy11;
yy882:
		yych = *++cursor_;
		if (yych == 'l') goto yy1117;
		goto yy11;
yy883:
		yych = *++cursor_;
		if (yych == 'y') goto yy1118;
		goto yy11;
yy884:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 594 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8Eq); }
#line 5157 "src/prebuilt/wast-lexer-gen.cc"
yy886:
		yych = *++cursor_;
		if (yych == 't') goto yy1119;
		goto yy11;
yy887:
		yych = *++cursor_;
		if (yych == '_') goto yy1120;
		goto yy11;
yy888:
		yych = *++cursor_;
		if (yych == '_') goto yy1121;
		goto yy11;
yy889:
		yych = *++cursor_;
		if (yych == '_') goto yy1122;
		goto yy11;
yy890:
		yych = *++cursor_;
		if (yych == '_') goto yy1123;
		goto yy11;
yy891:
		yych = *++cursor_;
		if (yych == 'l') goto yy1124;
		goto yy11;
yy892:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy893;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'g') goto yy1126;
				if (yych <= '~') goto yy10;
			}
		}
yy893:
#line 599 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8Ne); }
#line 5202 "src/prebuilt/wast-lexer-gen.cc"
yy894:
		yych = *++cursor_;
		if (yych == 'p') goto yy1128;
		goto yy11;
yy895:
		yych = *++cursor_;
		if (yych == 'l') goto yy1129;
		if (yych == 'r') goto yy1131;
		goto yy11;
yy896:
		yych = *++cursor_;
		if (yych == 'l') goto yy1132;
		goto yy11;
yy897:
		yych = *++cursor_;
		if (yych == 'b') goto yy1133;
		goto yy11;
yy898:
		yych = *++cursor_;
		if (yych == 'i') goto yy1135;
		goto yy11;
yy899:
		yych = *++cursor_;
		if (yych == 't') goto yy1136;
		goto yy11;
yy900:
		yych = *++cursor_;
		if (yych == 's') goto yy1138;
		if (yych == 'u') goto yy1140;
		goto yy11;
yy901:
		yych = *++cursor_;
		if (yych == 'n') goto yy1142;
		goto yy11;
yy902:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 399 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GeS); }
#line 5244 "src/prebuilt/wast-lexer-gen.cc"
yy904:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 401 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GeU); }
#line 5252 "src/prebuilt/wast-lexer-gen.cc"
yy906:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 395 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GtS); }
#line 5260 "src/prebuilt/wast-lexer-gen.cc"
yy908:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 397 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32GtU); }
#line 5268 "src/prebuilt/wast-lexer-gen.cc"
yy910:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 391 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LeS); }
#line 5276 "src/prebuilt/wast-lexer-gen.cc"
yy912:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 393 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LeU); }
#line 5284 "src/prebuilt/wast-lexer-gen.cc"
yy914:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1143;
				if (yych <= '7') goto yy10;
				goto yy1144;
			} else {
				if (yych == ';') goto yy915;
				if (yych <= '~') goto yy10;
			}
		}
yy915:
#line 283 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load); }
#line 5307 "src/prebuilt/wast-lexer-gen.cc"
yy916:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 387 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LtS); }
#line 5315 "src/prebuilt/wast-lexer-gen.cc"
yy918:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 389 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32LtU); }
#line 5323 "src/prebuilt/wast-lexer-gen.cc"
yy920:
		yych = *++cursor_;
		if (yych == 'n') goto yy1145;
		goto yy11;
yy921:
		yych = *++cursor_;
		if (yych == 't') goto yy1146;
		goto yy11;
yy922:
		yych = *++cursor_;
		if (yych == 's') goto yy1147;
		if (yych == 'u') goto yy1149;
		goto yy11;
yy923:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 365 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Rotl); }
#line 5344 "src/prebuilt/wast-lexer-gen.cc"
yy925:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 367 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32Rotr); }
#line 5352 "src/prebuilt/wast-lexer-gen.cc"
yy927:
		yych = *++cursor_;
		if (yych == 's') goto yy1151;
		if (yych == 'u') goto yy1153;
		goto yy11;
yy928:
		yych = *++cursor_;
		if (yych == 'e') goto yy1155;
		goto yy11;
yy929:
		yych = *++cursor_;
		if (yych == 'c') goto yy1157;
		goto yy11;
yy930:
		yych = *++cursor_;
		if (yych == '/') goto yy1158;
		goto yy11;
yy931:
		yych = *++cursor_;
		if (yych == 'd') goto yy1159;
		goto yy11;
yy932:
		yych = *++cursor_;
		if (yych == 'l') goto yy1161;
		goto yy11;
yy933:
		yych = *++cursor_;
		if (yych == 'y') goto yy1162;
		goto yy11;
yy934:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 595 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4Eq); }
#line 5389 "src/prebuilt/wast-lexer-gen.cc"
yy936:
		yych = *++cursor_;
		if (yych == 't') goto yy1163;
		goto yy11;
yy937:
		yych = *++cursor_;
		if (yych == '_') goto yy1164;
		goto yy11;
yy938:
		yych = *++cursor_;
		if (yych == '_') goto yy1165;
		goto yy11;
yy939:
		yych = *++cursor_;
		if (yych == '_') goto yy1166;
		goto yy11;
yy940:
		yych = *++cursor_;
		if (yych == '_') goto yy1167;
		goto yy11;
yy941:
		yych = *++cursor_;
		if (yych == 'l') goto yy1168;
		goto yy11;
yy942:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy943;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'g') goto yy1170;
				if (yych <= '~') goto yy10;
			}
		}
yy943:
#line 600 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4Ne); }
#line 5434 "src/prebuilt/wast-lexer-gen.cc"
yy944:
		yych = *++cursor_;
		if (yych == 'p') goto yy1172;
		goto yy11;
yy945:
		yych = *++cursor_;
		if (yych == 'l') goto yy1173;
		if (yych == 'r') goto yy1175;
		goto yy11;
yy946:
		yych = *++cursor_;
		if (yych == 'l') goto yy1176;
		goto yy11;
yy947:
		yych = *++cursor_;
		if (yych == 'b') goto yy1177;
		goto yy11;
yy948:
		yych = *++cursor_;
		if (yych == 'u') goto yy1179;
		goto yy11;
yy949:
		yych = *++cursor_;
		if (yych == 'i') goto yy1180;
		goto yy11;
yy950:
		yych = *++cursor_;
		if (yych == 't') goto yy1181;
		goto yy11;
yy951:
		yych = *++cursor_;
		if (yych == 's') goto yy1183;
		if (yych == 'u') goto yy1185;
		goto yy11;
yy952:
		yych = *++cursor_;
		if (yych == 'n') goto yy1187;
		goto yy11;
yy953:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 400 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GeS); }
#line 5480 "src/prebuilt/wast-lexer-gen.cc"
yy955:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 402 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GeU); }
#line 5488 "src/prebuilt/wast-lexer-gen.cc"
yy957:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 396 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GtS); }
#line 5496 "src/prebuilt/wast-lexer-gen.cc"
yy959:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 398 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64GtU); }
#line 5504 "src/prebuilt/wast-lexer-gen.cc"
yy961:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 392 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LeS); }
#line 5512 "src/prebuilt/wast-lexer-gen.cc"
yy963:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 394 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LeU); }
#line 5520 "src/prebuilt/wast-lexer-gen.cc"
yy965:
		yych = *++cursor_;
		if (yych <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy966;
				if (yych <= '0') goto yy10;
				goto yy1188;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy1189;
				if (yych <= '7') goto yy10;
				goto yy1190;
			} else {
				if (yych == ';') goto yy966;
				if (yych <= '~') goto yy10;
			}
		}
yy966:
#line 284 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load); }
#line 5545 "src/prebuilt/wast-lexer-gen.cc"
yy967:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 388 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LtS); }
#line 5553 "src/prebuilt/wast-lexer-gen.cc"
yy969:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 390 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I64LtU); }
#line 5561 "src/prebuilt/wast-lexer-gen.cc"
yy971:
		yych = *++cursor_;
		if (yych == 'n') goto yy1191;
		goto yy11;
yy972:
		yych = *++cursor_;
		if (yych == 't') goto yy1192;
		goto yy11;
yy973:
		yych = *++cursor_;
		if (yych == 's') goto yy1193;
		if (yych == 'u') goto yy1195;
		goto yy11;
yy974:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 366 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Rotl); }
#line 5582 "src/prebuilt/wast-lexer-gen.cc"
yy976:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 368 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64Rotr); }
#line 5590 "src/prebuilt/wast-lexer-gen.cc"
yy978:
		yych = *++cursor_;
		if (yych == 's') goto yy1197;
		if (yych == 'u') goto yy1199;
		goto yy11;
yy979:
		yych = *++cursor_;
		if (yych == 'e') goto yy1201;
		goto yy11;
yy980:
		yych = *++cursor_;
		if (yych == 'c') goto yy1203;
		goto yy11;
yy981:
		yych = *++cursor_;
		if (yych == 'd') goto yy1204;
		goto yy11;
yy982:
		yych = *++cursor_;
		if (yych == 'l') goto yy1206;
		goto yy11;
yy983:
		yych = *++cursor_;
		if (yych == 'y') goto yy1207;
		goto yy11;
yy984:
		yych = *++cursor_;
		if (yych == 't') goto yy1208;
		goto yy11;
yy985:
		yych = *++cursor_;
		if (yych == 'g') goto yy1209;
		goto yy11;
yy986:
		yych = *++cursor_;
		if (yych == 'p') goto yy1211;
		goto yy11;
yy987:
		yych = *++cursor_;
		if (yych == 'l') goto yy1212;
		if (yych == 'r') goto yy1214;
		goto yy11;
yy988:
		yych = *++cursor_;
		if (yych == 'l') goto yy1215;
		goto yy11;
yy989:
		yych = *++cursor_;
		if (yych == 'b') goto yy1216;
		goto yy11;
yy990:
		yych = *++cursor_;
		if (yych == 'u') goto yy1218;
		goto yy11;
yy991:
		yych = *++cursor_;
		if (yych == 'd') goto yy1219;
		goto yy11;
yy992:
		yych = *++cursor_;
		if (yych == 'l') goto yy1221;
		goto yy11;
yy993:
		yych = *++cursor_;
		if (yych == 'y') goto yy1222;
		goto yy11;
yy994:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 593 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16Eq); }
#line 5664 "src/prebuilt/wast-lexer-gen.cc"
yy996:
		yych = *++cursor_;
		if (yych == 't') goto yy1223;
		goto yy11;
yy997:
		yych = *++cursor_;
		if (yych == '_') goto yy1224;
		goto yy11;
yy998:
		yych = *++cursor_;
		if (yych == '_') goto yy1225;
		goto yy11;
yy999:
		yych = *++cursor_;
		if (yych == '_') goto yy1226;
		goto yy11;
yy1000:
		yych = *++cursor_;
		if (yych == '_') goto yy1227;
		goto yy11;
yy1001:
		yych = *++cursor_;
		if (yych == 'l') goto yy1228;
		goto yy11;
yy1002:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1003;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= 'f') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= 'g') goto yy1230;
				if (yych <= '~') goto yy10;
			}
		}
yy1003:
#line 598 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16Ne); }
#line 5709 "src/prebuilt/wast-lexer-gen.cc"
yy1004:
		yych = *++cursor_;
		if (yych == 'p') goto yy1232;
		goto yy11;
yy1005:
		yych = *++cursor_;
		if (yych == 'l') goto yy1233;
		if (yych == 'r') goto yy1235;
		goto yy11;
yy1006:
		yych = *++cursor_;
		if (yych == 'l') goto yy1236;
		goto yy11;
yy1007:
		yych = *++cursor_;
		if (yych == 'b') goto yy1237;
		goto yy11;
yy1008:
		yych = *++cursor_;
		if (yych == 't') goto yy1239;
		goto yy11;
yy1009:
		yych = *++cursor_;
		if (yych == 'r') goto yy1241;
		goto yy11;
yy1010:
		yych = *++cursor_;
		if (yych == 'i') goto yy1242;
		goto yy11;
yy1011:
		yych = *++cursor_;
		if (yych == 'x') goto yy1244;
		goto yy1014;
yy1012:
#line 306 "src/wast-lexer.cc"
		{ RETURN_TEXT_AT(OffsetEqNat, 7); }
#line 5746 "src/prebuilt/wast-lexer-gen.cc"
yy1013:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
yy1014:
		if (yych <= '/') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy1012;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy1012;
				goto yy10;
			}
		} else {
			if (yych <= ';') {
				if (yych <= '9') goto yy1013;
				if (yych <= ':') goto yy10;
				goto yy1012;
			} else {
				if (yych == '_') goto yy1243;
				if (yych <= '~') goto yy10;
				goto yy1012;
			}
		}
yy1015:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 680 "src/wast-lexer.cc"
		{ RETURN(Register); }
#line 5779 "src/prebuilt/wast-lexer-gen.cc"
yy1017:
		yych = *++cursor_;
		if (yych == 'a') goto yy1245;
		goto yy11;
yy1018:
		yych = *++cursor_;
		if (yych == 'l') goto yy1246;
		goto yy11;
yy1019:
		yych = *++cursor_;
		if (yych == 'l') goto yy1248;
		goto yy11;
yy1020:
		yych = *++cursor_;
		if (yych == 'b') goto yy1250;
		goto yy11;
yy1021:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 580 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128And); }
#line 5803 "src/prebuilt/wast-lexer-gen.cc"
yy1023:
		yych = *++cursor_;
		if (yych == 's') goto yy1251;
		goto yy11;
yy1024:
		yych = *++cursor_;
		if (yych == 's') goto yy1252;
		goto yy11;
yy1025:
		yych = *++cursor_;
		if (yych == 'd') goto yy1253;
		goto yy11;
yy1026:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 583 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, V128Not); }
#line 5823 "src/prebuilt/wast-lexer-gen.cc"
yy1028:
		yych = *++cursor_;
		if (yych == 'r') goto yy1255;
		goto yy11;
yy1029:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 582 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, V128Xor); }
#line 5835 "src/prebuilt/wast-lexer-gen.cc"
yy1031:
		yych = *++cursor_;
		if (yych == 'u') goto yy1256;
		goto yy11;
yy1032:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy578;
				goto yy10;
			} else {
				if (yych <= ')') goto yy578;
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy1032;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy578;
				if (yych <= '@') goto yy10;
				if (yych <= 'F') goto yy1032;
				goto yy10;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy788;
					goto yy10;
				} else {
					if (yych <= 'f') goto yy1032;
					if (yych <= '~') goto yy10;
					goto yy578;
				}
			}
		}
yy1034:
		yych = *++cursor_;
		if (yych == 'h') goto yy1257;
		goto yy11;
yy1035:
		yych = *++cursor_;
		if (yych == 'v') goto yy1258;
		goto yy11;
yy1036:
		yych = *++cursor_;
		if (yych == 'l') goto yy1259;
		goto yy11;
yy1037:
		yych = *++cursor_;
		if (yych == 't') goto yy1260;
		goto yy11;
yy1038:
		yych = *++cursor_;
		if (yych == 'a') goto yy1261;
		goto yy11;
yy1039:
		yych = *++cursor_;
		if (yych == 'l') goto yy1262;
		goto yy11;
yy1040:
		yych = *++cursor_;
		if (yych == 'k') goto yy1263;
		goto yy11;
yy1041:
		yych = *++cursor_;
		if (yych == 'r') goto yy1264;
		goto yy11;
yy1042:
		yych = *++cursor_;
		if (yych == 'e') goto yy1265;
		goto yy11;
yy1043:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 310 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, F32Const); }
#line 5915 "src/prebuilt/wast-lexer-gen.cc"
yy1045:
		yych = *++cursor_;
		if (yych == 'r') goto yy1266;
		goto yy11;
yy1046:
		yych = *++cursor_;
		if (yych == 'i') goto yy1267;
		goto yy11;
yy1047:
		yych = *++cursor_;
		if (yych == 'e') goto yy1268;
		goto yy11;
yy1048:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 328 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Floor); }
#line 5935 "src/prebuilt/wast-lexer-gen.cc"
yy1050:
		yych = *++cursor_;
		if (yych == 's') goto yy1269;
		goto yy11;
yy1051:
		yych = *++cursor_;
		if (yych == 'e') goto yy1270;
		goto yy11;
yy1052:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 289 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, F32Store); }
#line 5951 "src/prebuilt/wast-lexer-gen.cc"
yy1054:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 330 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Trunc); }
#line 5959 "src/prebuilt/wast-lexer-gen.cc"
yy1056:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 637 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Abs); }
#line 5967 "src/prebuilt/wast-lexer-gen.cc"
yy1058:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 643 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Add); }
#line 5975 "src/prebuilt/wast-lexer-gen.cc"
yy1060:
		yych = *++cursor_;
		if (yych == 'v') goto yy1271;
		goto yy11;
yy1061:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 647 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Div); }
#line 5987 "src/prebuilt/wast-lexer-gen.cc"
yy1063:
		yych = *++cursor_;
		if (yych == 'r') goto yy1272;
		goto yy11;
yy1064:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 641 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Max); }
#line 5999 "src/prebuilt/wast-lexer-gen.cc"
yy1066:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 639 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Min); }
#line 6007 "src/prebuilt/wast-lexer-gen.cc"
yy1068:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 649 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Mul); }
#line 6015 "src/prebuilt/wast-lexer-gen.cc"
yy1070:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 635 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Neg); }
#line 6023 "src/prebuilt/wast-lexer-gen.cc"
yy1072:
		yych = *++cursor_;
		if (yych == 'l') goto yy1273;
		goto yy11;
yy1073:
		yych = *++cursor_;
		if (yych == 'a') goto yy1274;
		goto yy11;
yy1074:
		yych = *++cursor_;
		if (yych == 't') goto yy1275;
		goto yy11;
yy1075:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 645 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32X4Sub); }
#line 6043 "src/prebuilt/wast-lexer-gen.cc"
yy1077:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 311 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, F64Const); }
#line 6051 "src/prebuilt/wast-lexer-gen.cc"
yy1079:
		yych = *++cursor_;
		if (yych == 'r') goto yy1277;
		goto yy11;
yy1080:
		yych = *++cursor_;
		if (yych == 'i') goto yy1278;
		goto yy11;
yy1081:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 329 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Floor); }
#line 6067 "src/prebuilt/wast-lexer-gen.cc"
yy1083:
		yych = *++cursor_;
		if (yych == 's') goto yy1279;
		goto yy11;
yy1084:
		yych = *++cursor_;
		if (yych == 't') goto yy1280;
		goto yy11;
yy1085:
		yych = *++cursor_;
		if (yych == 'e') goto yy1281;
		goto yy11;
yy1086:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 290 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, F64Store); }
#line 6087 "src/prebuilt/wast-lexer-gen.cc"
yy1088:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 331 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Trunc); }
#line 6095 "src/prebuilt/wast-lexer-gen.cc"
yy1090:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 638 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Abs); }
#line 6103 "src/prebuilt/wast-lexer-gen.cc"
yy1092:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 644 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Add); }
#line 6111 "src/prebuilt/wast-lexer-gen.cc"
yy1094:
		yych = *++cursor_;
		if (yych == 'v') goto yy1282;
		goto yy11;
yy1095:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 648 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Div); }
#line 6123 "src/prebuilt/wast-lexer-gen.cc"
yy1097:
		yych = *++cursor_;
		if (yych == 'r') goto yy1283;
		goto yy11;
yy1098:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 642 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Max); }
#line 6135 "src/prebuilt/wast-lexer-gen.cc"
yy1100:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 640 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Min); }
#line 6143 "src/prebuilt/wast-lexer-gen.cc"
yy1102:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 650 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Mul); }
#line 6151 "src/prebuilt/wast-lexer-gen.cc"
yy1104:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 636 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Neg); }
#line 6159 "src/prebuilt/wast-lexer-gen.cc"
yy1106:
		yych = *++cursor_;
		if (yych == 'l') goto yy1284;
		goto yy11;
yy1107:
		yych = *++cursor_;
		if (yych == 'a') goto yy1285;
		goto yy11;
yy1108:
		yych = *++cursor_;
		if (yych == 't') goto yy1286;
		goto yy11;
yy1109:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 646 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64X2Sub); }
#line 6179 "src/prebuilt/wast-lexer-gen.cc"
yy1111:
		yych = *++cursor_;
		if (yych == 'l') goto yy1288;
		goto yy11;
yy1112:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 278 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GetLocal); }
#line 6191 "src/prebuilt/wast-lexer-gen.cc"
yy1114:
		yych = *++cursor_;
		if (yych == 'r') goto yy1290;
		goto yy11;
yy1115:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1116;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy1291;
				if (yych <= '~') goto yy10;
			}
		}
yy1116:
#line 546 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Add); }
#line 6216 "src/prebuilt/wast-lexer-gen.cc"
yy1117:
		yych = *++cursor_;
		if (yych == '_') goto yy1292;
		goto yy11;
yy1118:
		yych = *++cursor_;
		if (yych == '_') goto yy1293;
		goto yy11;
yy1119:
		yych = *++cursor_;
		if (yych == 'r') goto yy1294;
		goto yy11;
yy1120:
		yych = *++cursor_;
		if (yych == 's') goto yy1295;
		if (yych == 'u') goto yy1297;
		goto yy11;
yy1121:
		yych = *++cursor_;
		if (yych == 's') goto yy1299;
		if (yych == 'u') goto yy1301;
		goto yy11;
yy1122:
		yych = *++cursor_;
		if (yych == 's') goto yy1303;
		if (yych == 'u') goto yy1305;
		goto yy11;
yy1123:
		yych = *++cursor_;
		if (yych == 's') goto yy1307;
		if (yych == 'u') goto yy1309;
		goto yy11;
yy1124:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 554 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Mul); }
#line 6256 "src/prebuilt/wast-lexer-gen.cc"
yy1126:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 557 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I16X8Neg); }
#line 6264 "src/prebuilt/wast-lexer-gen.cc"
yy1128:
		yych = *++cursor_;
		if (yych == 'l') goto yy1311;
		goto yy11;
yy1129:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 569 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Shl); }
#line 6276 "src/prebuilt/wast-lexer-gen.cc"
yy1131:
		yych = *++cursor_;
		if (yych == '_') goto yy1312;
		goto yy11;
yy1132:
		yych = *++cursor_;
		if (yych == 'a') goto yy1313;
		goto yy11;
yy1133:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1134;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy1314;
				if (yych <= '~') goto yy10;
			}
		}
yy1134:
#line 550 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8Sub); }
#line 6305 "src/prebuilt/wast-lexer-gen.cc"
yy1135:
		yych = *++cursor_;
		if (yych == 'c') goto yy1315;
		goto yy11;
yy1136:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 308 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, I32Const); }
#line 6317 "src/prebuilt/wast-lexer-gen.cc"
yy1138:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 345 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32DivS); }
#line 6325 "src/prebuilt/wast-lexer-gen.cc"
yy1140:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 347 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32DivU); }
#line 6333 "src/prebuilt/wast-lexer-gen.cc"
yy1142:
		yych = *++cursor_;
		if (yych == 'd') goto yy1316;
		goto yy11;
yy1143:
		yych = *++cursor_;
		if (yych == '6') goto yy1317;
		goto yy11;
yy1144:
		yych = *++cursor_;
		if (yych == '_') goto yy1318;
		goto yy11;
yy1145:
		yych = *++cursor_;
		if (yych == 't') goto yy1319;
		goto yy11;
yy1146:
		yych = *++cursor_;
		if (yych == 'e') goto yy1321;
		goto yy11;
yy1147:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 349 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32RemS); }
#line 6361 "src/prebuilt/wast-lexer-gen.cc"
yy1149:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 351 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32RemU); }
#line 6369 "src/prebuilt/wast-lexer-gen.cc"
yy1151:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 361 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32ShrS); }
#line 6377 "src/prebuilt/wast-lexer-gen.cc"
yy1153:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 363 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32ShrU); }
#line 6385 "src/prebuilt/wast-lexer-gen.cc"
yy1155:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1322;
				if (yych <= '7') goto yy10;
				goto yy1323;
			} else {
				if (yych == ';') goto yy1156;
				if (yych <= '~') goto yy10;
			}
		}
yy1156:
#line 287 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store); }
#line 6408 "src/prebuilt/wast-lexer-gen.cc"
yy1157:
		yych = *++cursor_;
		if (yych == '_') goto yy1325;
		goto yy11;
yy1158:
		yych = *++cursor_;
		if (yych == 'i') goto yy1326;
		goto yy11;
yy1159:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 547 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Add); }
#line 6424 "src/prebuilt/wast-lexer-gen.cc"
yy1161:
		yych = *++cursor_;
		if (yych == '_') goto yy1327;
		goto yy11;
yy1162:
		yych = *++cursor_;
		if (yych == '_') goto yy1328;
		goto yy11;
yy1163:
		yych = *++cursor_;
		if (yych == 'r') goto yy1329;
		goto yy11;
yy1164:
		yych = *++cursor_;
		if (yych == 's') goto yy1330;
		if (yych == 'u') goto yy1332;
		goto yy11;
yy1165:
		yych = *++cursor_;
		if (yych == 's') goto yy1334;
		if (yych == 'u') goto yy1336;
		goto yy11;
yy1166:
		yych = *++cursor_;
		if (yych == 's') goto yy1338;
		if (yych == 'u') goto yy1340;
		goto yy11;
yy1167:
		yych = *++cursor_;
		if (yych == 's') goto yy1342;
		if (yych == 'u') goto yy1344;
		goto yy11;
yy1168:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 555 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Mul); }
#line 6464 "src/prebuilt/wast-lexer-gen.cc"
yy1170:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 558 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4Neg); }
#line 6472 "src/prebuilt/wast-lexer-gen.cc"
yy1172:
		yych = *++cursor_;
		if (yych == 'l') goto yy1346;
		goto yy11;
yy1173:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 570 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Shl); }
#line 6484 "src/prebuilt/wast-lexer-gen.cc"
yy1175:
		yych = *++cursor_;
		if (yych == '_') goto yy1347;
		goto yy11;
yy1176:
		yych = *++cursor_;
		if (yych == 'a') goto yy1348;
		goto yy11;
yy1177:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 551 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4Sub); }
#line 6500 "src/prebuilt/wast-lexer-gen.cc"
yy1179:
		yych = *++cursor_;
		if (yych == 'n') goto yy1349;
		goto yy11;
yy1180:
		yych = *++cursor_;
		if (yych == 'c') goto yy1350;
		goto yy11;
yy1181:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 309 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, I64Const); }
#line 6516 "src/prebuilt/wast-lexer-gen.cc"
yy1183:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 346 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64DivS); }
#line 6524 "src/prebuilt/wast-lexer-gen.cc"
yy1185:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 348 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64DivU); }
#line 6532 "src/prebuilt/wast-lexer-gen.cc"
yy1187:
		yych = *++cursor_;
		if (yych == 'd') goto yy1351;
		goto yy11;
yy1188:
		yych = *++cursor_;
		if (yych == '6') goto yy1352;
		goto yy11;
yy1189:
		yych = *++cursor_;
		if (yych == '2') goto yy1353;
		goto yy11;
yy1190:
		yych = *++cursor_;
		if (yych == '_') goto yy1354;
		goto yy11;
yy1191:
		yych = *++cursor_;
		if (yych == 't') goto yy1355;
		goto yy11;
yy1192:
		yych = *++cursor_;
		if (yych == 'e') goto yy1357;
		goto yy11;
yy1193:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 350 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64RemS); }
#line 6564 "src/prebuilt/wast-lexer-gen.cc"
yy1195:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 352 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64RemU); }
#line 6572 "src/prebuilt/wast-lexer-gen.cc"
yy1197:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 362 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64ShrS); }
#line 6580 "src/prebuilt/wast-lexer-gen.cc"
yy1199:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 364 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64ShrU); }
#line 6588 "src/prebuilt/wast-lexer-gen.cc"
yy1201:
		yych = *++cursor_;
		if (yych <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy1202;
				if (yych <= '0') goto yy10;
				goto yy1358;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy1359;
				if (yych <= '7') goto yy10;
				goto yy1360;
			} else {
				if (yych == ';') goto yy1202;
				if (yych <= '~') goto yy10;
			}
		}
yy1202:
#line 288 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store); }
#line 6613 "src/prebuilt/wast-lexer-gen.cc"
yy1203:
		yych = *++cursor_;
		if (yych == '_') goto yy1362;
		goto yy11;
yy1204:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 548 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Add); }
#line 6625 "src/prebuilt/wast-lexer-gen.cc"
yy1206:
		yych = *++cursor_;
		if (yych == '_') goto yy1363;
		goto yy11;
yy1207:
		yych = *++cursor_;
		if (yych == '_') goto yy1364;
		goto yy11;
yy1208:
		yych = *++cursor_;
		if (yych == 'r') goto yy1365;
		goto yy11;
yy1209:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 559 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2Neg); }
#line 6645 "src/prebuilt/wast-lexer-gen.cc"
yy1211:
		yych = *++cursor_;
		if (yych == 'l') goto yy1366;
		goto yy11;
yy1212:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 571 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Shl); }
#line 6657 "src/prebuilt/wast-lexer-gen.cc"
yy1214:
		yych = *++cursor_;
		if (yych == '_') goto yy1367;
		goto yy11;
yy1215:
		yych = *++cursor_;
		if (yych == 'a') goto yy1368;
		goto yy11;
yy1216:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 552 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2Sub); }
#line 6673 "src/prebuilt/wast-lexer-gen.cc"
yy1218:
		yych = *++cursor_;
		if (yych == 'n') goto yy1369;
		goto yy11;
yy1219:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1220;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy1370;
				if (yych <= '~') goto yy10;
			}
		}
yy1220:
#line 545 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Add); }
#line 6698 "src/prebuilt/wast-lexer-gen.cc"
yy1221:
		yych = *++cursor_;
		if (yych == '_') goto yy1371;
		goto yy11;
yy1222:
		yych = *++cursor_;
		if (yych == '_') goto yy1372;
		goto yy11;
yy1223:
		yych = *++cursor_;
		if (yych == 'r') goto yy1373;
		goto yy11;
yy1224:
		yych = *++cursor_;
		if (yych == 's') goto yy1374;
		if (yych == 'u') goto yy1376;
		goto yy11;
yy1225:
		yych = *++cursor_;
		if (yych == 's') goto yy1378;
		if (yych == 'u') goto yy1380;
		goto yy11;
yy1226:
		yych = *++cursor_;
		if (yych == 's') goto yy1382;
		if (yych == 'u') goto yy1384;
		goto yy11;
yy1227:
		yych = *++cursor_;
		if (yych == 's') goto yy1386;
		if (yych == 'u') goto yy1388;
		goto yy11;
yy1228:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 553 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Mul); }
#line 6738 "src/prebuilt/wast-lexer-gen.cc"
yy1230:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 556 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I8X16Neg); }
#line 6746 "src/prebuilt/wast-lexer-gen.cc"
yy1232:
		yych = *++cursor_;
		if (yych == 'l') goto yy1390;
		goto yy11;
yy1233:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 568 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Shl); }
#line 6758 "src/prebuilt/wast-lexer-gen.cc"
yy1235:
		yych = *++cursor_;
		if (yych == '_') goto yy1391;
		goto yy11;
yy1236:
		yych = *++cursor_;
		if (yych == 'a') goto yy1392;
		goto yy11;
yy1237:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1238;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy1393;
				if (yych <= '~') goto yy10;
			}
		}
yy1238:
#line 549 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16Sub); }
#line 6787 "src/prebuilt/wast-lexer-gen.cc"
yy1239:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 695 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(IfExcept); }
#line 6795 "src/prebuilt/wast-lexer-gen.cc"
yy1241:
		yych = *++cursor_;
		if (yych == 'o') goto yy1394;
		goto yy11;
yy1242:
		yych = *++cursor_;
		if (yych == 'z') goto yy1395;
		goto yy11;
yy1243:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych <= ' ') goto yy12;
				goto yy10;
			} else {
				if (yych <= '"') goto yy12;
				if (yych <= '\'') goto yy10;
				goto yy12;
			}
		} else {
			if (yych <= ':') {
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy1013;
				goto yy10;
			} else {
				if (yych <= ';') goto yy12;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy1244:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= '9') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
				goto yy12;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy12;
				if (yych <= '/') goto yy10;
				goto yy1396;
			}
		} else {
			if (yych <= 'F') {
				if (yych == ';') goto yy12;
				if (yych <= '@') goto yy10;
				goto yy1396;
			} else {
				if (yych <= '`') goto yy10;
				if (yych <= 'f') goto yy1396;
				if (yych <= '~') goto yy10;
				goto yy12;
			}
		}
yy1245:
		yych = *++cursor_;
		if (yych == 'l') goto yy1398;
		goto yy11;
yy1246:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 279 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(SetLocal); }
#line 6865 "src/prebuilt/wast-lexer-gen.cc"
yy1248:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 280 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(TeeLocal); }
#line 6873 "src/prebuilt/wast-lexer-gen.cc"
yy1250:
		yych = *++cursor_;
		if (yych == 'l') goto yy1400;
		goto yy11;
yy1251:
		yych = *++cursor_;
		if (yych == 'e') goto yy1401;
		goto yy11;
yy1252:
		yych = *++cursor_;
		if (yych == 't') goto yy1402;
		goto yy11;
yy1253:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 522 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load,  V128Load); }
#line 6893 "src/prebuilt/wast-lexer-gen.cc"
yy1255:
		yych = *++cursor_;
		if (yych == 'e') goto yy1404;
		goto yy11;
yy1256:
		yych = *++cursor_;
		if (yych == 'f') goto yy1406;
		goto yy11;
yy1257:
		yych = *++cursor_;
		if (yych == 'a') goto yy1407;
		goto yy11;
yy1258:
		yych = *++cursor_;
		if (yych == 'a') goto yy1408;
		goto yy11;
yy1259:
		yych = *++cursor_;
		if (yych == 'f') goto yy1409;
		goto yy11;
yy1260:
		yych = *++cursor_;
		if (yych == 'u') goto yy1410;
		goto yy11;
yy1261:
		yych = *++cursor_;
		if (yych == 'p') goto yy1411;
		goto yy11;
yy1262:
		yych = *++cursor_;
		if (yych == 'i') goto yy1413;
		goto yy11;
yy1263:
		yych = *++cursor_;
		if (yych == 'e') goto yy1414;
		goto yy11;
yy1264:
		yych = *++cursor_;
		if (yych == 'e') goto yy1416;
		goto yy11;
yy1265:
		yych = *++cursor_;
		if (yych == 'm') goto yy1417;
		goto yy11;
yy1266:
		yych = *++cursor_;
		if (yych == 't') goto yy1418;
		goto yy11;
yy1267:
		yych = *++cursor_;
		if (yych == 'g') goto yy1419;
		goto yy11;
yy1268:
		yych = *++cursor_;
		if (yych == '/') goto yy1420;
		goto yy11;
yy1269:
		yych = *++cursor_;
		if (yych == 't') goto yy1421;
		goto yy11;
yy1270:
		yych = *++cursor_;
		if (yych == 'r') goto yy1423;
		goto yy11;
yy1271:
		yych = *++cursor_;
		if (yych == 'e') goto yy1424;
		goto yy11;
yy1272:
		yych = *++cursor_;
		if (yych == 'a') goto yy1425;
		goto yy11;
yy1273:
		yych = *++cursor_;
		if (yych == 'a') goto yy1426;
		goto yy11;
yy1274:
		yych = *++cursor_;
		if (yych == 't') goto yy1427;
		goto yy11;
yy1275:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 651 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Sqrt); }
#line 6981 "src/prebuilt/wast-lexer-gen.cc"
yy1277:
		yych = *++cursor_;
		if (yych == 't') goto yy1429;
		goto yy11;
yy1278:
		yych = *++cursor_;
		if (yych == 'g') goto yy1430;
		goto yy11;
yy1279:
		yych = *++cursor_;
		if (yych == 't') goto yy1431;
		goto yy11;
yy1280:
		yych = *++cursor_;
		if (yych == 'e') goto yy1433;
		goto yy11;
yy1281:
		yych = *++cursor_;
		if (yych == 'r') goto yy1434;
		goto yy11;
yy1282:
		yych = *++cursor_;
		if (yych == 'e') goto yy1435;
		goto yy11;
yy1283:
		yych = *++cursor_;
		if (yych == 'a') goto yy1436;
		goto yy11;
yy1284:
		yych = *++cursor_;
		if (yych == 'a') goto yy1437;
		goto yy11;
yy1285:
		yych = *++cursor_;
		if (yych == 't') goto yy1438;
		goto yy11;
yy1286:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 652 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Sqrt); }
#line 7025 "src/prebuilt/wast-lexer-gen.cc"
yy1288:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 281 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(GetGlobal); }
#line 7033 "src/prebuilt/wast-lexer-gen.cc"
yy1290:
		yych = *++cursor_;
		if (yych == 'y') goto yy1440;
		goto yy11;
yy1291:
		yych = *++cursor_;
		if (yych == 's') goto yy1442;
		goto yy11;
yy1292:
		yych = *++cursor_;
		if (yych == 't') goto yy1443;
		goto yy11;
yy1293:
		yych = *++cursor_;
		if (yych == 't') goto yy1444;
		goto yy11;
yy1294:
		yych = *++cursor_;
		if (yych == 'a') goto yy1445;
		goto yy11;
yy1295:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 629 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GeS); }
#line 7061 "src/prebuilt/wast-lexer-gen.cc"
yy1297:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 630 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GeU); }
#line 7069 "src/prebuilt/wast-lexer-gen.cc"
yy1299:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 621 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GtS); }
#line 7077 "src/prebuilt/wast-lexer-gen.cc"
yy1301:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 622 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8GtU); }
#line 7085 "src/prebuilt/wast-lexer-gen.cc"
yy1303:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 613 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LeS); }
#line 7093 "src/prebuilt/wast-lexer-gen.cc"
yy1305:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 614 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LeU); }
#line 7101 "src/prebuilt/wast-lexer-gen.cc"
yy1307:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 605 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LtS); }
#line 7109 "src/prebuilt/wast-lexer-gen.cc"
yy1309:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 606 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I16X8LtU); }
#line 7117 "src/prebuilt/wast-lexer-gen.cc"
yy1311:
		yych = *++cursor_;
		if (yych == 'a') goto yy1446;
		goto yy11;
yy1312:
		yych = *++cursor_;
		if (yych == 's') goto yy1447;
		if (yych == 'u') goto yy1449;
		goto yy11;
yy1313:
		yych = *++cursor_;
		if (yych == 't') goto yy1451;
		goto yy11;
yy1314:
		yych = *++cursor_;
		if (yych == 's') goto yy1453;
		goto yy11;
yy1315:
		yych = *++cursor_;
		if (yych == '.') goto yy1454;
		goto yy11;
yy1316:
		yych = *++cursor_;
		if (yych == '1') goto yy1455;
		if (yych == '8') goto yy1456;
		goto yy11;
yy1317:
		yych = *++cursor_;
		if (yych == '_') goto yy1457;
		goto yy11;
yy1318:
		yych = *++cursor_;
		if (yych == 's') goto yy1458;
		if (yych == 'u') goto yy1460;
		goto yy11;
yy1319:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 318 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Popcnt); }
#line 7160 "src/prebuilt/wast-lexer-gen.cc"
yy1321:
		yych = *++cursor_;
		if (yych == 'r') goto yy1462;
		goto yy11;
yy1322:
		yych = *++cursor_;
		if (yych == '6') goto yy1463;
		goto yy11;
yy1323:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 301 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store8); }
#line 7176 "src/prebuilt/wast-lexer-gen.cc"
yy1325:
		yych = *++cursor_;
		if (yych == 's') goto yy1465;
		if (yych == 'u') goto yy1466;
		goto yy11;
yy1326:
		yych = *++cursor_;
		if (yych == '6') goto yy1467;
		goto yy11;
yy1327:
		yych = *++cursor_;
		if (yych == 't') goto yy1468;
		goto yy11;
yy1328:
		yych = *++cursor_;
		if (yych == 't') goto yy1469;
		goto yy11;
yy1329:
		yych = *++cursor_;
		if (yych == 'a') goto yy1470;
		goto yy11;
yy1330:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 631 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GeS); }
#line 7205 "src/prebuilt/wast-lexer-gen.cc"
yy1332:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 632 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GeU); }
#line 7213 "src/prebuilt/wast-lexer-gen.cc"
yy1334:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 623 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GtS); }
#line 7221 "src/prebuilt/wast-lexer-gen.cc"
yy1336:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 624 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4GtU); }
#line 7229 "src/prebuilt/wast-lexer-gen.cc"
yy1338:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 615 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LeS); }
#line 7237 "src/prebuilt/wast-lexer-gen.cc"
yy1340:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 616 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LeU); }
#line 7245 "src/prebuilt/wast-lexer-gen.cc"
yy1342:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 607 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LtS); }
#line 7253 "src/prebuilt/wast-lexer-gen.cc"
yy1344:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 608 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I32X4LtU); }
#line 7261 "src/prebuilt/wast-lexer-gen.cc"
yy1346:
		yych = *++cursor_;
		if (yych == 'a') goto yy1471;
		goto yy11;
yy1347:
		yych = *++cursor_;
		if (yych == 's') goto yy1472;
		if (yych == 'u') goto yy1474;
		goto yy11;
yy1348:
		yych = *++cursor_;
		if (yych == 't') goto yy1476;
		goto yy11;
yy1349:
		yych = *++cursor_;
		if (yych == 'c') goto yy1478;
		goto yy11;
yy1350:
		yych = *++cursor_;
		if (yych == '.') goto yy1479;
		goto yy11;
yy1351:
		yych = *++cursor_;
		if (yych <= '3') {
			if (yych == '1') goto yy1480;
			if (yych <= '2') goto yy11;
			goto yy1481;
		} else {
			if (yych <= '8') {
				if (yych <= '7') goto yy11;
				goto yy1482;
			} else {
				if (yych == '_') goto yy1483;
				goto yy11;
			}
		}
yy1352:
		yych = *++cursor_;
		if (yych == '_') goto yy1484;
		goto yy11;
yy1353:
		yych = *++cursor_;
		if (yych == '_') goto yy1485;
		goto yy11;
yy1354:
		yych = *++cursor_;
		if (yych == 's') goto yy1486;
		if (yych == 'u') goto yy1488;
		goto yy11;
yy1355:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 319 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Popcnt); }
#line 7318 "src/prebuilt/wast-lexer-gen.cc"
yy1357:
		yych = *++cursor_;
		if (yych == 'r') goto yy1490;
		goto yy11;
yy1358:
		yych = *++cursor_;
		if (yych == '6') goto yy1491;
		goto yy11;
yy1359:
		yych = *++cursor_;
		if (yych == '2') goto yy1493;
		goto yy11;
yy1360:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 302 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store8); }
#line 7338 "src/prebuilt/wast-lexer-gen.cc"
yy1362:
		yych = *++cursor_;
		if (yych == 's') goto yy1495;
		if (yych == 'u') goto yy1496;
		goto yy11;
yy1363:
		yych = *++cursor_;
		if (yych == 't') goto yy1497;
		goto yy11;
yy1364:
		yych = *++cursor_;
		if (yych == 't') goto yy1498;
		goto yy11;
yy1365:
		yych = *++cursor_;
		if (yych == 'a') goto yy1499;
		goto yy11;
yy1366:
		yych = *++cursor_;
		if (yych == 'a') goto yy1500;
		goto yy11;
yy1367:
		yych = *++cursor_;
		if (yych == 's') goto yy1501;
		if (yych == 'u') goto yy1503;
		goto yy11;
yy1368:
		yych = *++cursor_;
		if (yych == 't') goto yy1505;
		goto yy11;
yy1369:
		yych = *++cursor_;
		if (yych == 'c') goto yy1507;
		goto yy11;
yy1370:
		yych = *++cursor_;
		if (yych == 's') goto yy1508;
		goto yy11;
yy1371:
		yych = *++cursor_;
		if (yych == 't') goto yy1509;
		goto yy11;
yy1372:
		yych = *++cursor_;
		if (yych == 't') goto yy1510;
		goto yy11;
yy1373:
		yych = *++cursor_;
		if (yych == 'a') goto yy1511;
		goto yy11;
yy1374:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 627 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GeS); }
#line 7396 "src/prebuilt/wast-lexer-gen.cc"
yy1376:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 628 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GeU); }
#line 7404 "src/prebuilt/wast-lexer-gen.cc"
yy1378:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 619 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GtS); }
#line 7412 "src/prebuilt/wast-lexer-gen.cc"
yy1380:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 620 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16GtU); }
#line 7420 "src/prebuilt/wast-lexer-gen.cc"
yy1382:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 611 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LeS); }
#line 7428 "src/prebuilt/wast-lexer-gen.cc"
yy1384:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 612 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LeU); }
#line 7436 "src/prebuilt/wast-lexer-gen.cc"
yy1386:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 603 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LtS); }
#line 7444 "src/prebuilt/wast-lexer-gen.cc"
yy1388:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 604 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Compare, I8X16LtU); }
#line 7452 "src/prebuilt/wast-lexer-gen.cc"
yy1390:
		yych = *++cursor_;
		if (yych == 'a') goto yy1512;
		goto yy11;
yy1391:
		yych = *++cursor_;
		if (yych == 's') goto yy1513;
		if (yych == 'u') goto yy1515;
		goto yy11;
yy1392:
		yych = *++cursor_;
		if (yych == 't') goto yy1517;
		goto yy11;
yy1393:
		yych = *++cursor_;
		if (yych == 's') goto yy1519;
		goto yy11;
yy1394:
		yych = *++cursor_;
		if (yych == 'w') goto yy1520;
		goto yy11;
yy1395:
		yych = *++cursor_;
		if (yych == 'e') goto yy1522;
		goto yy11;
yy1396:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= ':') {
			if (yych <= '\'') {
				if (yych == '!') goto yy10;
				if (yych <= '"') goto yy1012;
				goto yy10;
			} else {
				if (yych <= ')') goto yy1012;
				if (yych <= '/') goto yy10;
				if (yych <= '9') goto yy1396;
				goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych <= ';') goto yy1012;
				if (yych <= '@') goto yy10;
				if (yych <= 'F') goto yy1396;
				goto yy10;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy1244;
					goto yy10;
				} else {
					if (yych <= 'f') goto yy1396;
					if (yych <= '~') goto yy10;
					goto yy1012;
				}
			}
		}
yy1398:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 282 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(SetGlobal); }
#line 7517 "src/prebuilt/wast-lexer-gen.cc"
yy1400:
		yych = *++cursor_;
		if (yych == 'e') goto yy1524;
		goto yy11;
yy1401:
		yych = *++cursor_;
		if (yych == 'l') goto yy1526;
		goto yy11;
yy1402:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 521 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Const, V128Const); }
#line 7533 "src/prebuilt/wast-lexer-gen.cc"
yy1404:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 523 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, V128Store); }
#line 7541 "src/prebuilt/wast-lexer-gen.cc"
yy1406:
		yych = *++cursor_;
		if (yych == 'f') goto yy1527;
		goto yy11;
yy1407:
		yych = *++cursor_;
		if (yych == 'u') goto yy1528;
		goto yy11;
yy1408:
		yych = *++cursor_;
		if (yych == 'l') goto yy1529;
		goto yy11;
yy1409:
		yych = *++cursor_;
		if (yych == 'o') goto yy1530;
		goto yy11;
yy1410:
		yych = *++cursor_;
		if (yych == 'r') goto yy1531;
		goto yy11;
yy1411:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 689 "src/wast-lexer.cc"
		{ RETURN(AssertTrap); }
#line 7569 "src/prebuilt/wast-lexer-gen.cc"
yy1413:
		yych = *++cursor_;
		if (yych == 'n') goto yy1532;
		goto yy11;
yy1414:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 457 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(AtomicWake); }
#line 7581 "src/prebuilt/wast-lexer-gen.cc"
yy1416:
		yych = *++cursor_;
		if (yych == 'c') goto yy1533;
		goto yy11;
yy1417:
		yych = *++cursor_;
		if (yych == 'o') goto yy1534;
		goto yy11;
yy1418:
		yych = *++cursor_;
		if (yych == '_') goto yy1535;
		goto yy11;
yy1419:
		yych = *++cursor_;
		if (yych == 'n') goto yy1536;
		goto yy11;
yy1420:
		yych = *++cursor_;
		if (yych == 'f') goto yy1538;
		goto yy11;
yy1421:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 332 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32Nearest); }
#line 7609 "src/prebuilt/wast-lexer-gen.cc"
yy1423:
		yych = *++cursor_;
		if (yych == 'p') goto yy1539;
		goto yy11;
yy1424:
		yych = *++cursor_;
		if (yych == 'r') goto yy1540;
		goto yy11;
yy1425:
		yych = *++cursor_;
		if (yych == 'c') goto yy1541;
		goto yy11;
yy1426:
		yych = *++cursor_;
		if (yych == 'c') goto yy1542;
		goto yy11;
yy1427:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 528 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4Splat); }
#line 7633 "src/prebuilt/wast-lexer-gen.cc"
yy1429:
		yych = *++cursor_;
		if (yych == '_') goto yy1543;
		goto yy11;
yy1430:
		yych = *++cursor_;
		if (yych == 'n') goto yy1544;
		goto yy11;
yy1431:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 333 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64Nearest); }
#line 7649 "src/prebuilt/wast-lexer-gen.cc"
yy1433:
		yych = *++cursor_;
		if (yych == '/') goto yy1546;
		goto yy11;
yy1434:
		yych = *++cursor_;
		if (yych == 'p') goto yy1547;
		goto yy11;
yy1435:
		yych = *++cursor_;
		if (yych == 'r') goto yy1548;
		goto yy11;
yy1436:
		yych = *++cursor_;
		if (yych == 'c') goto yy1549;
		goto yy11;
yy1437:
		yych = *++cursor_;
		if (yych == 'c') goto yy1550;
		goto yy11;
yy1438:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 529 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2Splat); }
#line 7677 "src/prebuilt/wast-lexer-gen.cc"
yy1440:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 453 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryGrow); }
#line 7685 "src/prebuilt/wast-lexer-gen.cc"
yy1442:
		yych = *++cursor_;
		if (yych == 'a') goto yy1551;
		goto yy11;
yy1443:
		yych = *++cursor_;
		if (yych == 'r') goto yy1552;
		goto yy11;
yy1444:
		yych = *++cursor_;
		if (yych == 'r') goto yy1553;
		goto yy11;
yy1445:
		yych = *++cursor_;
		if (yych == 'c') goto yy1554;
		goto yy11;
yy1446:
		yych = *++cursor_;
		if (yych == 'c') goto yy1555;
		goto yy11;
yy1447:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 574 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8ShrS); }
#line 7713 "src/prebuilt/wast-lexer-gen.cc"
yy1449:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 575 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8ShrU); }
#line 7721 "src/prebuilt/wast-lexer-gen.cc"
yy1451:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 525 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I16X8Splat); }
#line 7729 "src/prebuilt/wast-lexer-gen.cc"
yy1453:
		yych = *++cursor_;
		if (yych == 'a') goto yy1556;
		goto yy11;
yy1454:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'l') goto yy1557;
			if (yych <= 'q') goto yy11;
			goto yy1558;
		} else {
			if (yych <= 's') goto yy1559;
			if (yych == 'w') goto yy1560;
			goto yy11;
		}
yy1455:
		yych = *++cursor_;
		if (yych == '6') goto yy1561;
		goto yy11;
yy1456:
		yych = *++cursor_;
		if (yych == '_') goto yy1562;
		goto yy11;
yy1457:
		yych = *++cursor_;
		if (yych == 's') goto yy1563;
		if (yych == 'u') goto yy1565;
		goto yy11;
yy1458:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 291 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load8S); }
#line 7765 "src/prebuilt/wast-lexer-gen.cc"
yy1460:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 293 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load8U); }
#line 7773 "src/prebuilt/wast-lexer-gen.cc"
yy1462:
		yych = *++cursor_;
		if (yych == 'p') goto yy1567;
		goto yy11;
yy1463:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 303 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I32Store16); }
#line 7785 "src/prebuilt/wast-lexer-gen.cc"
yy1465:
		yych = *++cursor_;
		if (yych == '/') goto yy1568;
		if (yych == ':') goto yy1569;
		goto yy11;
yy1466:
		yych = *++cursor_;
		if (yych == '/') goto yy1570;
		if (yych == ':') goto yy1571;
		goto yy11;
yy1467:
		yych = *++cursor_;
		if (yych == '4') goto yy1572;
		goto yy11;
yy1468:
		yych = *++cursor_;
		if (yych == 'r') goto yy1574;
		goto yy11;
yy1469:
		yych = *++cursor_;
		if (yych == 'r') goto yy1575;
		goto yy11;
yy1470:
		yych = *++cursor_;
		if (yych == 'c') goto yy1576;
		goto yy11;
yy1471:
		yych = *++cursor_;
		if (yych == 'c') goto yy1577;
		goto yy11;
yy1472:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 576 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4ShrS); }
#line 7823 "src/prebuilt/wast-lexer-gen.cc"
yy1474:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 577 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I32X4ShrU); }
#line 7831 "src/prebuilt/wast-lexer-gen.cc"
yy1476:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 526 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4Splat); }
#line 7839 "src/prebuilt/wast-lexer-gen.cc"
yy1478:
		yych = *++cursor_;
		if (yych == '_') goto yy1578;
		goto yy11;
yy1479:
		yych = *++cursor_;
		if (yych <= 'r') {
			if (yych == 'l') goto yy1579;
			if (yych <= 'q') goto yy11;
			goto yy1580;
		} else {
			if (yych <= 's') goto yy1581;
			if (yych == 'w') goto yy1582;
			goto yy11;
		}
yy1480:
		yych = *++cursor_;
		if (yych == '6') goto yy1583;
		goto yy11;
yy1481:
		yych = *++cursor_;
		if (yych == '2') goto yy1584;
		goto yy11;
yy1482:
		yych = *++cursor_;
		if (yych == '_') goto yy1585;
		goto yy11;
yy1483:
		yych = *++cursor_;
		if (yych == 's') goto yy1586;
		if (yych == 'u') goto yy1587;
		goto yy11;
yy1484:
		yych = *++cursor_;
		if (yych == 's') goto yy1588;
		if (yych == 'u') goto yy1590;
		goto yy11;
yy1485:
		yych = *++cursor_;
		if (yych == 's') goto yy1592;
		if (yych == 'u') goto yy1594;
		goto yy11;
yy1486:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 292 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load8S); }
#line 7889 "src/prebuilt/wast-lexer-gen.cc"
yy1488:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 294 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load8U); }
#line 7897 "src/prebuilt/wast-lexer-gen.cc"
yy1490:
		yych = *++cursor_;
		if (yych == 'p') goto yy1596;
		goto yy11;
yy1491:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 304 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store16); }
#line 7909 "src/prebuilt/wast-lexer-gen.cc"
yy1493:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 305 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Store, I64Store32); }
#line 7917 "src/prebuilt/wast-lexer-gen.cc"
yy1495:
		yych = *++cursor_;
		if (yych == '/') goto yy1597;
		if (yych == ':') goto yy1598;
		goto yy11;
yy1496:
		yych = *++cursor_;
		if (yych == '/') goto yy1599;
		if (yych == ':') goto yy1600;
		goto yy11;
yy1497:
		yych = *++cursor_;
		if (yych == 'r') goto yy1601;
		goto yy11;
yy1498:
		yych = *++cursor_;
		if (yych == 'r') goto yy1602;
		goto yy11;
yy1499:
		yych = *++cursor_;
		if (yych == 'c') goto yy1603;
		goto yy11;
yy1500:
		yych = *++cursor_;
		if (yych == 'c') goto yy1604;
		goto yy11;
yy1501:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 578 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2ShrS); }
#line 7951 "src/prebuilt/wast-lexer-gen.cc"
yy1503:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 579 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I64X2ShrU); }
#line 7959 "src/prebuilt/wast-lexer-gen.cc"
yy1505:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 527 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2Splat); }
#line 7967 "src/prebuilt/wast-lexer-gen.cc"
yy1507:
		yych = *++cursor_;
		if (yych == '_') goto yy1605;
		goto yy11;
yy1508:
		yych = *++cursor_;
		if (yych == 'a') goto yy1606;
		goto yy11;
yy1509:
		yych = *++cursor_;
		if (yych == 'r') goto yy1607;
		goto yy11;
yy1510:
		yych = *++cursor_;
		if (yych == 'r') goto yy1608;
		goto yy11;
yy1511:
		yych = *++cursor_;
		if (yych == 'c') goto yy1609;
		goto yy11;
yy1512:
		yych = *++cursor_;
		if (yych == 'c') goto yy1610;
		goto yy11;
yy1513:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 572 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16ShrS); }
#line 7999 "src/prebuilt/wast-lexer-gen.cc"
yy1515:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 573 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16ShrU); }
#line 8007 "src/prebuilt/wast-lexer-gen.cc"
yy1517:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 524 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I8X16Splat); }
#line 8015 "src/prebuilt/wast-lexer-gen.cc"
yy1519:
		yych = *++cursor_;
		if (yych == 'a') goto yy1611;
		goto yy11;
yy1520:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 451 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemoryGrow); }
#line 8027 "src/prebuilt/wast-lexer-gen.cc"
yy1522:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 450 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemorySize); }
#line 8035 "src/prebuilt/wast-lexer-gen.cc"
yy1524:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 449 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(Unreachable); }
#line 8043 "src/prebuilt/wast-lexer-gen.cc"
yy1526:
		yych = *++cursor_;
		if (yych == 'e') goto yy1612;
		goto yy11;
yy1527:
		yych = *++cursor_;
		if (yych == 'l') goto yy1613;
		goto yy11;
yy1528:
		yych = *++cursor_;
		if (yych == 's') goto yy1614;
		goto yy11;
yy1529:
		yych = *++cursor_;
		if (yych == 'i') goto yy1615;
		goto yy11;
yy1530:
		yych = *++cursor_;
		if (yych == 'r') goto yy1616;
		goto yy11;
yy1531:
		yych = *++cursor_;
		if (yych == 'n') goto yy1617;
		goto yy11;
yy1532:
		yych = *++cursor_;
		if (yych == 'k') goto yy1619;
		goto yy11;
yy1533:
		yych = *++cursor_;
		if (yych == 't') goto yy1620;
		goto yy11;
yy1534:
		yych = *++cursor_;
		if (yych == 'r') goto yy1622;
		goto yy11;
yy1535:
		yych = *++cursor_;
		if (yych == 's') goto yy1623;
		if (yych == 'u') goto yy1624;
		goto yy11;
yy1536:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 381 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F32Copysign); }
#line 8092 "src/prebuilt/wast-lexer-gen.cc"
yy1538:
		yych = *++cursor_;
		if (yych == '6') goto yy1625;
		goto yy11;
yy1539:
		yych = *++cursor_;
		if (yych == 'r') goto yy1626;
		goto yy11;
yy1540:
		yych = *++cursor_;
		if (yych == 't') goto yy1627;
		goto yy11;
yy1541:
		yych = *++cursor_;
		if (yych == 't') goto yy1628;
		goto yy11;
yy1542:
		yych = *++cursor_;
		if (yych == 'e') goto yy1629;
		goto yy11;
yy1543:
		yych = *++cursor_;
		if (yych == 's') goto yy1630;
		if (yych == 'u') goto yy1631;
		goto yy11;
yy1544:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 382 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, F64Copysign); }
#line 8125 "src/prebuilt/wast-lexer-gen.cc"
yy1546:
		yych = *++cursor_;
		if (yych == 'f') goto yy1632;
		goto yy11;
yy1547:
		yych = *++cursor_;
		if (yych == 'r') goto yy1633;
		goto yy11;
yy1548:
		yych = *++cursor_;
		if (yych == 't') goto yy1634;
		goto yy11;
yy1549:
		yych = *++cursor_;
		if (yych == 't') goto yy1635;
		goto yy11;
yy1550:
		yych = *++cursor_;
		if (yych == 'e') goto yy1636;
		goto yy11;
yy1551:
		yych = *++cursor_;
		if (yych == 't') goto yy1637;
		goto yy11;
yy1552:
		yych = *++cursor_;
		if (yych == 'u') goto yy1638;
		goto yy11;
yy1553:
		yych = *++cursor_;
		if (yych == 'u') goto yy1639;
		goto yy11;
yy1554:
		yych = *++cursor_;
		if (yych == 't') goto yy1640;
		goto yy11;
yy1555:
		yych = *++cursor_;
		if (yych == 'e') goto yy1641;
		goto yy11;
yy1556:
		yych = *++cursor_;
		if (yych == 't') goto yy1642;
		goto yy11;
yy1557:
		yych = *++cursor_;
		if (yych == 'o') goto yy1643;
		goto yy11;
yy1558:
		yych = *++cursor_;
		if (yych == 'm') goto yy1644;
		goto yy11;
yy1559:
		yych = *++cursor_;
		if (yych == 't') goto yy1645;
		goto yy11;
yy1560:
		yych = *++cursor_;
		if (yych == 'a') goto yy1646;
		goto yy11;
yy1561:
		yych = *++cursor_;
		if (yych == '_') goto yy1647;
		goto yy11;
yy1562:
		yych = *++cursor_;
		if (yych == 's') goto yy1648;
		goto yy11;
yy1563:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 295 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load16S); }
#line 8201 "src/prebuilt/wast-lexer-gen.cc"
yy1565:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 297 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I32Load16U); }
#line 8209 "src/prebuilt/wast-lexer-gen.cc"
yy1567:
		yych = *++cursor_;
		if (yych == 'r') goto yy1650;
		goto yy11;
yy1568:
		yych = *++cursor_;
		if (yych == 'f') goto yy1651;
		goto yy11;
yy1569:
		yych = *++cursor_;
		if (yych == 's') goto yy1652;
		goto yy11;
yy1570:
		yych = *++cursor_;
		if (yych == 'f') goto yy1653;
		goto yy11;
yy1571:
		yych = *++cursor_;
		if (yych == 's') goto yy1654;
		goto yy11;
yy1572:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 417 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32WrapI64); }
#line 8237 "src/prebuilt/wast-lexer-gen.cc"
yy1574:
		yych = *++cursor_;
		if (yych == 'u') goto yy1655;
		goto yy11;
yy1575:
		yych = *++cursor_;
		if (yych == 'u') goto yy1656;
		goto yy11;
yy1576:
		yych = *++cursor_;
		if (yych == 't') goto yy1657;
		goto yy11;
yy1577:
		yych = *++cursor_;
		if (yych == 'e') goto yy1658;
		goto yy11;
yy1578:
		yych = *++cursor_;
		if (yych == 's') goto yy1659;
		if (yych == 'u') goto yy1660;
		goto yy11;
yy1579:
		yych = *++cursor_;
		if (yych == 'o') goto yy1661;
		goto yy11;
yy1580:
		yych = *++cursor_;
		if (yych == 'm') goto yy1662;
		goto yy11;
yy1581:
		yych = *++cursor_;
		if (yych == 't') goto yy1663;
		goto yy11;
yy1582:
		yych = *++cursor_;
		if (yych == 'a') goto yy1664;
		goto yy11;
yy1583:
		yych = *++cursor_;
		if (yych == '_') goto yy1665;
		goto yy11;
yy1584:
		yych = *++cursor_;
		if (yych == '_') goto yy1666;
		goto yy11;
yy1585:
		yych = *++cursor_;
		if (yych == 's') goto yy1667;
		goto yy11;
yy1586:
		yych = *++cursor_;
		if (yych == '/') goto yy1669;
		goto yy11;
yy1587:
		yych = *++cursor_;
		if (yych == '/') goto yy1670;
		goto yy11;
yy1588:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 296 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load16S); }
#line 8302 "src/prebuilt/wast-lexer-gen.cc"
yy1590:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 298 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load16U); }
#line 8310 "src/prebuilt/wast-lexer-gen.cc"
yy1592:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 299 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load32S); }
#line 8318 "src/prebuilt/wast-lexer-gen.cc"
yy1594:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 300 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Load, I64Load32U); }
#line 8326 "src/prebuilt/wast-lexer-gen.cc"
yy1596:
		yych = *++cursor_;
		if (yych == 'r') goto yy1671;
		goto yy11;
yy1597:
		yych = *++cursor_;
		if (yych == 'f') goto yy1672;
		goto yy11;
yy1598:
		yych = *++cursor_;
		if (yych == 's') goto yy1673;
		goto yy11;
yy1599:
		yych = *++cursor_;
		if (yych == 'f') goto yy1674;
		goto yy11;
yy1600:
		yych = *++cursor_;
		if (yych == 's') goto yy1675;
		goto yy11;
yy1601:
		yych = *++cursor_;
		if (yych == 'u') goto yy1676;
		goto yy11;
yy1602:
		yych = *++cursor_;
		if (yych == 'u') goto yy1677;
		goto yy11;
yy1603:
		yych = *++cursor_;
		if (yych == 't') goto yy1678;
		goto yy11;
yy1604:
		yych = *++cursor_;
		if (yych == 'e') goto yy1679;
		goto yy11;
yy1605:
		yych = *++cursor_;
		if (yych == 's') goto yy1680;
		if (yych == 'u') goto yy1681;
		goto yy11;
yy1606:
		yych = *++cursor_;
		if (yych == 't') goto yy1682;
		goto yy11;
yy1607:
		yych = *++cursor_;
		if (yych == 'u') goto yy1683;
		goto yy11;
yy1608:
		yych = *++cursor_;
		if (yych == 'u') goto yy1684;
		goto yy11;
yy1609:
		yych = *++cursor_;
		if (yych == 't') goto yy1685;
		goto yy11;
yy1610:
		yych = *++cursor_;
		if (yych == 'e') goto yy1686;
		goto yy11;
yy1611:
		yych = *++cursor_;
		if (yych == 't') goto yy1687;
		goto yy11;
yy1612:
		yych = *++cursor_;
		if (yych == 'c') goto yy1688;
		goto yy11;
yy1613:
		yych = *++cursor_;
		if (yych == 'e') goto yy1689;
		goto yy11;
yy1614:
		yych = *++cursor_;
		if (yych == 't') goto yy1691;
		goto yy11;
yy1615:
		yych = *++cursor_;
		if (yych == 'd') goto yy1692;
		goto yy11;
yy1616:
		yych = *++cursor_;
		if (yych == 'm') goto yy1694;
		goto yy11;
yy1617:
		yych = *++cursor_;
		if (yych <= ')') {
			if (yych <= '!') {
				if (yych >= '!') goto yy10;
			} else {
				if (yych <= '"') goto yy1618;
				if (yych <= '\'') goto yy10;
			}
		} else {
			if (yych <= '^') {
				if (yych != ';') goto yy10;
			} else {
				if (yych <= '_') goto yy1695;
				if (yych <= '~') goto yy10;
			}
		}
yy1618:
#line 686 "src/wast-lexer.cc"
		{ RETURN(AssertReturn); }
#line 8432 "src/prebuilt/wast-lexer-gen.cc"
yy1619:
		yych = *++cursor_;
		if (yych == 'a') goto yy1696;
		goto yy11;
yy1620:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 274 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(CallIndirect); }
#line 8444 "src/prebuilt/wast-lexer-gen.cc"
yy1622:
		yych = *++cursor_;
		if (yych == 'y') goto yy1697;
		goto yy11;
yy1623:
		yych = *++cursor_;
		if (yych == '/') goto yy1699;
		goto yy11;
yy1624:
		yych = *++cursor_;
		if (yych == '/') goto yy1700;
		goto yy11;
yy1625:
		yych = *++cursor_;
		if (yych == '4') goto yy1701;
		goto yy11;
yy1626:
		yych = *++cursor_;
		if (yych == 'e') goto yy1703;
		goto yy11;
yy1627:
		yych = *++cursor_;
		if (yych == '_') goto yy1704;
		goto yy11;
yy1628:
		yych = *++cursor_;
		if (yych == '_') goto yy1705;
		goto yy11;
yy1629:
		yych = *++cursor_;
		if (yych == '_') goto yy1706;
		goto yy11;
yy1630:
		yych = *++cursor_;
		if (yych == '/') goto yy1707;
		goto yy11;
yy1631:
		yych = *++cursor_;
		if (yych == '/') goto yy1708;
		goto yy11;
yy1632:
		yych = *++cursor_;
		if (yych == '3') goto yy1709;
		goto yy11;
yy1633:
		yych = *++cursor_;
		if (yych == 'e') goto yy1710;
		goto yy11;
yy1634:
		yych = *++cursor_;
		if (yych == '_') goto yy1711;
		goto yy11;
yy1635:
		yych = *++cursor_;
		if (yych == '_') goto yy1712;
		goto yy11;
yy1636:
		yych = *++cursor_;
		if (yych == '_') goto yy1713;
		goto yy11;
yy1637:
		yych = *++cursor_;
		if (yych == 'u') goto yy1714;
		goto yy11;
yy1638:
		yych = *++cursor_;
		if (yych == 'e') goto yy1715;
		goto yy11;
yy1639:
		yych = *++cursor_;
		if (yych == 'e') goto yy1717;
		goto yy11;
yy1640:
		yych = *++cursor_;
		if (yych == '_') goto yy1719;
		goto yy11;
yy1641:
		yych = *++cursor_;
		if (yych == '_') goto yy1720;
		goto yy11;
yy1642:
		yych = *++cursor_;
		if (yych == 'u') goto yy1721;
		goto yy11;
yy1643:
		yych = *++cursor_;
		if (yych == 'a') goto yy1722;
		goto yy11;
yy1644:
		yych = *++cursor_;
		if (yych == 'w') goto yy1723;
		goto yy11;
yy1645:
		yych = *++cursor_;
		if (yych == 'o') goto yy1724;
		goto yy11;
yy1646:
		yych = *++cursor_;
		if (yych == 'i') goto yy1725;
		goto yy11;
yy1647:
		yych = *++cursor_;
		if (yych == 's') goto yy1726;
		goto yy11;
yy1648:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 334 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Extend8S); }
#line 8556 "src/prebuilt/wast-lexer-gen.cc"
yy1650:
		yych = *++cursor_;
		if (yych == 'e') goto yy1728;
		goto yy11;
yy1651:
		yych = *++cursor_;
		if (yych == '3') goto yy1729;
		if (yych == '6') goto yy1730;
		goto yy11;
yy1652:
		yych = *++cursor_;
		if (yych == 'a') goto yy1731;
		goto yy11;
yy1653:
		yych = *++cursor_;
		if (yych == '3') goto yy1732;
		if (yych == '6') goto yy1733;
		goto yy11;
yy1654:
		yych = *++cursor_;
		if (yych == 'a') goto yy1734;
		goto yy11;
yy1655:
		yych = *++cursor_;
		if (yych == 'e') goto yy1735;
		goto yy11;
yy1656:
		yych = *++cursor_;
		if (yych == 'e') goto yy1737;
		goto yy11;
yy1657:
		yych = *++cursor_;
		if (yych == '_') goto yy1739;
		goto yy11;
yy1658:
		yych = *++cursor_;
		if (yych == '_') goto yy1740;
		goto yy11;
yy1659:
		yych = *++cursor_;
		if (yych == '/') goto yy1741;
		goto yy11;
yy1660:
		yych = *++cursor_;
		if (yych == '/') goto yy1742;
		goto yy11;
yy1661:
		yych = *++cursor_;
		if (yych == 'a') goto yy1743;
		goto yy11;
yy1662:
		yych = *++cursor_;
		if (yych == 'w') goto yy1744;
		goto yy11;
yy1663:
		yych = *++cursor_;
		if (yych == 'o') goto yy1745;
		goto yy11;
yy1664:
		yych = *++cursor_;
		if (yych == 'i') goto yy1746;
		goto yy11;
yy1665:
		yych = *++cursor_;
		if (yych == 's') goto yy1747;
		goto yy11;
yy1666:
		yych = *++cursor_;
		if (yych == 's') goto yy1749;
		goto yy11;
yy1667:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 336 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend8S); }
#line 8634 "src/prebuilt/wast-lexer-gen.cc"
yy1669:
		yych = *++cursor_;
		if (yych == 'i') goto yy1751;
		goto yy11;
yy1670:
		yych = *++cursor_;
		if (yych == 'i') goto yy1752;
		goto yy11;
yy1671:
		yych = *++cursor_;
		if (yych == 'e') goto yy1753;
		goto yy11;
yy1672:
		yych = *++cursor_;
		if (yych == '3') goto yy1754;
		if (yych == '6') goto yy1755;
		goto yy11;
yy1673:
		yych = *++cursor_;
		if (yych == 'a') goto yy1756;
		goto yy11;
yy1674:
		yych = *++cursor_;
		if (yych == '3') goto yy1757;
		if (yych == '6') goto yy1758;
		goto yy11;
yy1675:
		yych = *++cursor_;
		if (yych == 'a') goto yy1759;
		goto yy11;
yy1676:
		yych = *++cursor_;
		if (yych == 'e') goto yy1760;
		goto yy11;
yy1677:
		yych = *++cursor_;
		if (yych == 'e') goto yy1762;
		goto yy11;
yy1678:
		yych = *++cursor_;
		if (yych == '_') goto yy1764;
		goto yy11;
yy1679:
		yych = *++cursor_;
		if (yych == '_') goto yy1765;
		goto yy11;
yy1680:
		yych = *++cursor_;
		if (yych == '/') goto yy1766;
		goto yy11;
yy1681:
		yych = *++cursor_;
		if (yych == '/') goto yy1767;
		goto yy11;
yy1682:
		yych = *++cursor_;
		if (yych == 'u') goto yy1768;
		goto yy11;
yy1683:
		yych = *++cursor_;
		if (yych == 'e') goto yy1769;
		goto yy11;
yy1684:
		yych = *++cursor_;
		if (yych == 'e') goto yy1771;
		goto yy11;
yy1685:
		yych = *++cursor_;
		if (yych == '_') goto yy1773;
		goto yy11;
yy1686:
		yych = *++cursor_;
		if (yych == '_') goto yy1774;
		goto yy11;
yy1687:
		yych = *++cursor_;
		if (yych == 'u') goto yy1775;
		goto yy11;
yy1688:
		yych = *++cursor_;
		if (yych == 't') goto yy1776;
		goto yy11;
yy1689:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 544 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdShuffleOp, V8X16Shuffle); }
#line 8724 "src/prebuilt/wast-lexer-gen.cc"
yy1691:
		yych = *++cursor_;
		if (yych == 'i') goto yy1778;
		goto yy11;
yy1692:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 684 "src/wast-lexer.cc"
		{ RETURN(AssertInvalid); }
#line 8736 "src/prebuilt/wast-lexer-gen.cc"
yy1694:
		yych = *++cursor_;
		if (yych == 'e') goto yy1779;
		goto yy11;
yy1695:
		yych = *++cursor_;
		if (yych == 'a') goto yy1780;
		if (yych == 'c') goto yy1781;
		goto yy11;
yy1696:
		yych = *++cursor_;
		if (yych == 'b') goto yy1782;
		goto yy11;
yy1697:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 452 "src/wast-lexer.cc"
		{ RETURN_OPCODE0(MemorySize); }
#line 8757 "src/prebuilt/wast-lexer-gen.cc"
yy1699:
		yych = *++cursor_;
		if (yych == 'i') goto yy1783;
		goto yy11;
yy1700:
		yych = *++cursor_;
		if (yych == 'i') goto yy1784;
		goto yy11;
yy1701:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 443 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32DemoteF64); }
#line 8773 "src/prebuilt/wast-lexer-gen.cc"
yy1703:
		yych = *++cursor_;
		if (yych == 't') goto yy1785;
		goto yy11;
yy1704:
		yych = *++cursor_;
		if (yych == 's') goto yy1786;
		if (yych == 'u') goto yy1787;
		goto yy11;
yy1705:
		yych = *++cursor_;
		if (yych == 'l') goto yy1788;
		goto yy11;
yy1706:
		yych = *++cursor_;
		if (yych == 'l') goto yy1789;
		goto yy11;
yy1707:
		yych = *++cursor_;
		if (yych == 'i') goto yy1790;
		goto yy11;
yy1708:
		yych = *++cursor_;
		if (yych == 'i') goto yy1791;
		goto yy11;
yy1709:
		yych = *++cursor_;
		if (yych == '2') goto yy1792;
		goto yy11;
yy1710:
		yych = *++cursor_;
		if (yych == 't') goto yy1794;
		goto yy11;
yy1711:
		yych = *++cursor_;
		if (yych == 's') goto yy1795;
		if (yych == 'u') goto yy1796;
		goto yy11;
yy1712:
		yych = *++cursor_;
		if (yych == 'l') goto yy1797;
		goto yy11;
yy1713:
		yych = *++cursor_;
		if (yych == 'l') goto yy1798;
		goto yy11;
yy1714:
		yych = *++cursor_;
		if (yych == 'r') goto yy1799;
		goto yy11;
yy1715:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 590 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I16X8AllTrue); }
#line 8831 "src/prebuilt/wast-lexer-gen.cc"
yy1717:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 586 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I16X8AnyTrue); }
#line 8839 "src/prebuilt/wast-lexer-gen.cc"
yy1719:
		yych = *++cursor_;
		if (yych == 'l') goto yy1800;
		goto yy11;
yy1720:
		yych = *++cursor_;
		if (yych == 'l') goto yy1801;
		goto yy11;
yy1721:
		yych = *++cursor_;
		if (yych == 'r') goto yy1802;
		goto yy11;
yy1722:
		yych = *++cursor_;
		if (yych == 'd') goto yy1803;
		goto yy11;
yy1723:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych == '.') goto yy1805;
			goto yy11;
		} else {
			if (yych <= '1') goto yy1806;
			if (yych == '8') goto yy1807;
			goto yy11;
		}
yy1724:
		yych = *++cursor_;
		if (yych == 'r') goto yy1808;
		goto yy11;
yy1725:
		yych = *++cursor_;
		if (yych == 't') goto yy1809;
		goto yy11;
yy1726:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 335 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32Extend16S); }
#line 8881 "src/prebuilt/wast-lexer-gen.cc"
yy1728:
		yych = *++cursor_;
		if (yych == 't') goto yy1811;
		goto yy11;
yy1729:
		yych = *++cursor_;
		if (yych == '2') goto yy1812;
		goto yy11;
yy1730:
		yych = *++cursor_;
		if (yych == '4') goto yy1814;
		goto yy11;
yy1731:
		yych = *++cursor_;
		if (yych == 't') goto yy1816;
		goto yy11;
yy1732:
		yych = *++cursor_;
		if (yych == '2') goto yy1817;
		goto yy11;
yy1733:
		yych = *++cursor_;
		if (yych == '4') goto yy1819;
		goto yy11;
yy1734:
		yych = *++cursor_;
		if (yych == 't') goto yy1821;
		goto yy11;
yy1735:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 591 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I32X4AllTrue); }
#line 8917 "src/prebuilt/wast-lexer-gen.cc"
yy1737:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 587 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I32X4AnyTrue); }
#line 8925 "src/prebuilt/wast-lexer-gen.cc"
yy1739:
		yych = *++cursor_;
		if (yych == 'l') goto yy1822;
		goto yy11;
yy1740:
		yych = *++cursor_;
		if (yych == 'l') goto yy1823;
		goto yy11;
yy1741:
		yych = *++cursor_;
		if (yych == 'f') goto yy1824;
		goto yy11;
yy1742:
		yych = *++cursor_;
		if (yych == 'f') goto yy1825;
		goto yy11;
yy1743:
		yych = *++cursor_;
		if (yych == 'd') goto yy1826;
		goto yy11;
yy1744:
		yych = *++cursor_;
		switch (yych) {
		case '.':	goto yy1828;
		case '1':	goto yy1829;
		case '3':	goto yy1830;
		case '8':	goto yy1831;
		default:	goto yy11;
		}
yy1745:
		yych = *++cursor_;
		if (yych == 'r') goto yy1832;
		goto yy11;
yy1746:
		yych = *++cursor_;
		if (yych == 't') goto yy1833;
		goto yy11;
yy1747:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 337 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend16S); }
#line 8970 "src/prebuilt/wast-lexer-gen.cc"
yy1749:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 338 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64Extend32S); }
#line 8978 "src/prebuilt/wast-lexer-gen.cc"
yy1751:
		yych = *++cursor_;
		if (yych == '3') goto yy1835;
		goto yy11;
yy1752:
		yych = *++cursor_;
		if (yych == '3') goto yy1836;
		goto yy11;
yy1753:
		yych = *++cursor_;
		if (yych == 't') goto yy1837;
		goto yy11;
yy1754:
		yych = *++cursor_;
		if (yych == '2') goto yy1838;
		goto yy11;
yy1755:
		yych = *++cursor_;
		if (yych == '4') goto yy1840;
		goto yy11;
yy1756:
		yych = *++cursor_;
		if (yych == 't') goto yy1842;
		goto yy11;
yy1757:
		yych = *++cursor_;
		if (yych == '2') goto yy1843;
		goto yy11;
yy1758:
		yych = *++cursor_;
		if (yych == '4') goto yy1845;
		goto yy11;
yy1759:
		yych = *++cursor_;
		if (yych == 't') goto yy1847;
		goto yy11;
yy1760:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 592 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I64X2AllTrue); }
#line 9022 "src/prebuilt/wast-lexer-gen.cc"
yy1762:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 588 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I64X2AnyTrue); }
#line 9030 "src/prebuilt/wast-lexer-gen.cc"
yy1764:
		yych = *++cursor_;
		if (yych == 'l') goto yy1848;
		goto yy11;
yy1765:
		yych = *++cursor_;
		if (yych == 'l') goto yy1849;
		goto yy11;
yy1766:
		yych = *++cursor_;
		if (yych == 'f') goto yy1850;
		goto yy11;
yy1767:
		yych = *++cursor_;
		if (yych == 'f') goto yy1851;
		goto yy11;
yy1768:
		yych = *++cursor_;
		if (yych == 'r') goto yy1852;
		goto yy11;
yy1769:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 589 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I8X16AllTrue); }
#line 9058 "src/prebuilt/wast-lexer-gen.cc"
yy1771:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 585 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary,  I8X16AnyTrue); }
#line 9066 "src/prebuilt/wast-lexer-gen.cc"
yy1773:
		yych = *++cursor_;
		if (yych == 'l') goto yy1853;
		goto yy11;
yy1774:
		yych = *++cursor_;
		if (yych == 'l') goto yy1854;
		goto yy11;
yy1775:
		yych = *++cursor_;
		if (yych == 'r') goto yy1855;
		goto yy11;
yy1776:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 584 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Ternary, V128BitSelect); }
#line 9086 "src/prebuilt/wast-lexer-gen.cc"
yy1778:
		yych = *++cursor_;
		if (yych == 'o') goto yy1856;
		goto yy11;
yy1779:
		yych = *++cursor_;
		if (yych == 'd') goto yy1857;
		goto yy11;
yy1780:
		yych = *++cursor_;
		if (yych == 'r') goto yy1859;
		goto yy11;
yy1781:
		yych = *++cursor_;
		if (yych == 'a') goto yy1860;
		goto yy11;
yy1782:
		yych = *++cursor_;
		if (yych == 'l') goto yy1861;
		goto yy11;
yy1783:
		yych = *++cursor_;
		if (yych == '3') goto yy1862;
		if (yych == '6') goto yy1863;
		goto yy11;
yy1784:
		yych = *++cursor_;
		if (yych == '3') goto yy1864;
		if (yych == '6') goto yy1865;
		goto yy11;
yy1785:
		yych = *++cursor_;
		if (yych == '/') goto yy1866;
		goto yy11;
yy1786:
		yych = *++cursor_;
		if (yych == '/') goto yy1867;
		goto yy11;
yy1787:
		yych = *++cursor_;
		if (yych == '/') goto yy1868;
		goto yy11;
yy1788:
		yych = *++cursor_;
		if (yych == 'a') goto yy1869;
		goto yy11;
yy1789:
		yych = *++cursor_;
		if (yych == 'a') goto yy1870;
		goto yy11;
yy1790:
		yych = *++cursor_;
		if (yych == '3') goto yy1871;
		if (yych == '6') goto yy1872;
		goto yy11;
yy1791:
		yych = *++cursor_;
		if (yych == '3') goto yy1873;
		if (yych == '6') goto yy1874;
		goto yy11;
yy1792:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 442 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64PromoteF32); }
#line 9154 "src/prebuilt/wast-lexer-gen.cc"
yy1794:
		yych = *++cursor_;
		if (yych == '/') goto yy1875;
		goto yy11;
yy1795:
		yych = *++cursor_;
		if (yych == '/') goto yy1876;
		goto yy11;
yy1796:
		yych = *++cursor_;
		if (yych == '/') goto yy1877;
		goto yy11;
yy1797:
		yych = *++cursor_;
		if (yych == 'a') goto yy1878;
		goto yy11;
yy1798:
		yych = *++cursor_;
		if (yych == 'a') goto yy1879;
		goto yy11;
yy1799:
		yych = *++cursor_;
		if (yych == 'a') goto yy1880;
		goto yy11;
yy1800:
		yych = *++cursor_;
		if (yych == 'a') goto yy1881;
		goto yy11;
yy1801:
		yych = *++cursor_;
		if (yych == 'a') goto yy1882;
		goto yy11;
yy1802:
		yych = *++cursor_;
		if (yych == 'a') goto yy1883;
		goto yy11;
yy1803:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1884;
				if (yych <= '7') goto yy10;
				goto yy1885;
			} else {
				if (yych == ';') goto yy1804;
				if (yych <= '~') goto yy10;
			}
		}
yy1804:
#line 458 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad); }
#line 9213 "src/prebuilt/wast-lexer-gen.cc"
yy1805:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy1886;
		case 'c':	goto yy1887;
		case 'o':	goto yy1888;
		case 's':	goto yy1889;
		case 'x':	goto yy1890;
		default:	goto yy11;
		}
yy1806:
		yych = *++cursor_;
		if (yych == '6') goto yy1891;
		goto yy11;
yy1807:
		yych = *++cursor_;
		if (yych == '_') goto yy1892;
		goto yy11;
yy1808:
		yych = *++cursor_;
		if (yych == 'e') goto yy1893;
		goto yy11;
yy1809:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 455 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicWait, I32AtomicWait); }
#line 9243 "src/prebuilt/wast-lexer-gen.cc"
yy1811:
		yych = *++cursor_;
		if (yych == '/') goto yy1895;
		goto yy11;
yy1812:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 418 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSF32); }
#line 9255 "src/prebuilt/wast-lexer-gen.cc"
yy1814:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 420 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSF64); }
#line 9263 "src/prebuilt/wast-lexer-gen.cc"
yy1816:
		yych = *++cursor_;
		if (yych == '/') goto yy1896;
		goto yy11;
yy1817:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 422 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncUF32); }
#line 9275 "src/prebuilt/wast-lexer-gen.cc"
yy1819:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 424 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncUF64); }
#line 9283 "src/prebuilt/wast-lexer-gen.cc"
yy1821:
		yych = *++cursor_;
		if (yych == '/') goto yy1897;
		goto yy11;
yy1822:
		yych = *++cursor_;
		if (yych == 'a') goto yy1898;
		goto yy11;
yy1823:
		yych = *++cursor_;
		if (yych == 'a') goto yy1899;
		goto yy11;
yy1824:
		yych = *++cursor_;
		if (yych == '3') goto yy1900;
		goto yy11;
yy1825:
		yych = *++cursor_;
		if (yych == '3') goto yy1901;
		goto yy11;
yy1826:
		yych = *++cursor_;
		if (yych <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy1827;
				if (yych <= '0') goto yy10;
				goto yy1902;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy1903;
				if (yych <= '7') goto yy10;
				goto yy1904;
			} else {
				if (yych == ';') goto yy1827;
				if (yych <= '~') goto yy10;
			}
		}
yy1827:
#line 459 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad); }
#line 9328 "src/prebuilt/wast-lexer-gen.cc"
yy1828:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy1905;
		case 'c':	goto yy1906;
		case 'o':	goto yy1907;
		case 's':	goto yy1908;
		case 'x':	goto yy1909;
		default:	goto yy11;
		}
yy1829:
		yych = *++cursor_;
		if (yych == '6') goto yy1910;
		goto yy11;
yy1830:
		yych = *++cursor_;
		if (yych == '2') goto yy1911;
		goto yy11;
yy1831:
		yych = *++cursor_;
		if (yych == '_') goto yy1912;
		goto yy11;
yy1832:
		yych = *++cursor_;
		if (yych == 'e') goto yy1913;
		goto yy11;
yy1833:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 456 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicWait, I64AtomicWait); }
#line 9362 "src/prebuilt/wast-lexer-gen.cc"
yy1835:
		yych = *++cursor_;
		if (yych == '2') goto yy1915;
		goto yy11;
yy1836:
		yych = *++cursor_;
		if (yych == '2') goto yy1917;
		goto yy11;
yy1837:
		yych = *++cursor_;
		if (yych == '/') goto yy1919;
		goto yy11;
yy1838:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 419 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSF32); }
#line 9382 "src/prebuilt/wast-lexer-gen.cc"
yy1840:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 421 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSF64); }
#line 9390 "src/prebuilt/wast-lexer-gen.cc"
yy1842:
		yych = *++cursor_;
		if (yych == '/') goto yy1920;
		goto yy11;
yy1843:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 423 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncUF32); }
#line 9402 "src/prebuilt/wast-lexer-gen.cc"
yy1845:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 425 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncUF64); }
#line 9410 "src/prebuilt/wast-lexer-gen.cc"
yy1847:
		yych = *++cursor_;
		if (yych == '/') goto yy1921;
		goto yy11;
yy1848:
		yych = *++cursor_;
		if (yych == 'a') goto yy1922;
		goto yy11;
yy1849:
		yych = *++cursor_;
		if (yych == 'a') goto yy1923;
		goto yy11;
yy1850:
		yych = *++cursor_;
		if (yych == '6') goto yy1924;
		goto yy11;
yy1851:
		yych = *++cursor_;
		if (yych == '6') goto yy1925;
		goto yy11;
yy1852:
		yych = *++cursor_;
		if (yych == 'a') goto yy1926;
		goto yy11;
yy1853:
		yych = *++cursor_;
		if (yych == 'a') goto yy1927;
		goto yy11;
yy1854:
		yych = *++cursor_;
		if (yych == 'a') goto yy1928;
		goto yy11;
yy1855:
		yych = *++cursor_;
		if (yych == 'a') goto yy1929;
		goto yy11;
yy1856:
		yych = *++cursor_;
		if (yych == 'n') goto yy1930;
		goto yy11;
yy1857:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 683 "src/wast-lexer.cc"
		{ RETURN(AssertMalformed); }
#line 9458 "src/prebuilt/wast-lexer-gen.cc"
yy1859:
		yych = *++cursor_;
		if (yych == 'i') goto yy1932;
		goto yy11;
yy1860:
		yych = *++cursor_;
		if (yych == 'n') goto yy1933;
		goto yy11;
yy1861:
		yych = *++cursor_;
		if (yych == 'e') goto yy1934;
		goto yy11;
yy1862:
		yych = *++cursor_;
		if (yych == '2') goto yy1936;
		goto yy11;
yy1863:
		yych = *++cursor_;
		if (yych == '4') goto yy1938;
		goto yy11;
yy1864:
		yych = *++cursor_;
		if (yych == '2') goto yy1940;
		goto yy11;
yy1865:
		yych = *++cursor_;
		if (yych == '4') goto yy1942;
		goto yy11;
yy1866:
		yych = *++cursor_;
		if (yych == 'i') goto yy1944;
		goto yy11;
yy1867:
		yych = *++cursor_;
		if (yych == 'i') goto yy1945;
		goto yy11;
yy1868:
		yych = *++cursor_;
		if (yych == 'i') goto yy1946;
		goto yy11;
yy1869:
		yych = *++cursor_;
		if (yych == 'n') goto yy1947;
		goto yy11;
yy1870:
		yych = *++cursor_;
		if (yych == 'n') goto yy1948;
		goto yy11;
yy1871:
		yych = *++cursor_;
		if (yych == '2') goto yy1949;
		goto yy11;
yy1872:
		yych = *++cursor_;
		if (yych == '4') goto yy1951;
		goto yy11;
yy1873:
		yych = *++cursor_;
		if (yych == '2') goto yy1953;
		goto yy11;
yy1874:
		yych = *++cursor_;
		if (yych == '4') goto yy1955;
		goto yy11;
yy1875:
		yych = *++cursor_;
		if (yych == 'i') goto yy1957;
		goto yy11;
yy1876:
		yych = *++cursor_;
		if (yych == 'i') goto yy1958;
		goto yy11;
yy1877:
		yych = *++cursor_;
		if (yych == 'i') goto yy1959;
		goto yy11;
yy1878:
		yych = *++cursor_;
		if (yych == 'n') goto yy1960;
		goto yy11;
yy1879:
		yych = *++cursor_;
		if (yych == 'n') goto yy1961;
		goto yy11;
yy1880:
		yych = *++cursor_;
		if (yych == 't') goto yy1962;
		goto yy11;
yy1881:
		yych = *++cursor_;
		if (yych == 'n') goto yy1963;
		goto yy11;
yy1882:
		yych = *++cursor_;
		if (yych == 'n') goto yy1964;
		goto yy11;
yy1883:
		yych = *++cursor_;
		if (yych == 't') goto yy1965;
		goto yy11;
yy1884:
		yych = *++cursor_;
		if (yych == '6') goto yy1966;
		goto yy11;
yy1885:
		yych = *++cursor_;
		if (yych == '_') goto yy1967;
		goto yy11;
yy1886:
		yych = *++cursor_;
		if (yych == 'd') goto yy1968;
		if (yych == 'n') goto yy1969;
		goto yy11;
yy1887:
		yych = *++cursor_;
		if (yych == 'm') goto yy1970;
		goto yy11;
yy1888:
		yych = *++cursor_;
		if (yych == 'r') goto yy1971;
		goto yy11;
yy1889:
		yych = *++cursor_;
		if (yych == 'u') goto yy1973;
		goto yy11;
yy1890:
		yych = *++cursor_;
		if (yych == 'c') goto yy1974;
		if (yych == 'o') goto yy1975;
		goto yy11;
yy1891:
		yych = *++cursor_;
		if (yych == '_') goto yy1976;
		goto yy11;
yy1892:
		yych = *++cursor_;
		if (yych == 'u') goto yy1977;
		goto yy11;
yy1893:
		yych = *++cursor_;
		if (yych <= '0') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych >= '*') goto yy10;
			}
		} else {
			if (yych <= '8') {
				if (yych <= '1') goto yy1978;
				if (yych <= '7') goto yy10;
				goto yy1979;
			} else {
				if (yych == ';') goto yy1894;
				if (yych <= '~') goto yy10;
			}
		}
yy1894:
#line 465 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore); }
#line 9619 "src/prebuilt/wast-lexer-gen.cc"
yy1895:
		yych = *++cursor_;
		if (yych == 'f') goto yy1981;
		goto yy11;
yy1896:
		yych = *++cursor_;
		if (yych == 'f') goto yy1982;
		goto yy11;
yy1897:
		yych = *++cursor_;
		if (yych == 'f') goto yy1983;
		goto yy11;
yy1898:
		yych = *++cursor_;
		if (yych == 'n') goto yy1984;
		goto yy11;
yy1899:
		yych = *++cursor_;
		if (yych == 'n') goto yy1985;
		goto yy11;
yy1900:
		yych = *++cursor_;
		if (yych == '2') goto yy1986;
		goto yy11;
yy1901:
		yych = *++cursor_;
		if (yych == '2') goto yy1987;
		goto yy11;
yy1902:
		yych = *++cursor_;
		if (yych == '6') goto yy1988;
		goto yy11;
yy1903:
		yych = *++cursor_;
		if (yych == '2') goto yy1989;
		goto yy11;
yy1904:
		yych = *++cursor_;
		if (yych == '_') goto yy1990;
		goto yy11;
yy1905:
		yych = *++cursor_;
		if (yych == 'd') goto yy1991;
		if (yych == 'n') goto yy1992;
		goto yy11;
yy1906:
		yych = *++cursor_;
		if (yych == 'm') goto yy1993;
		goto yy11;
yy1907:
		yych = *++cursor_;
		if (yych == 'r') goto yy1994;
		goto yy11;
yy1908:
		yych = *++cursor_;
		if (yych == 'u') goto yy1996;
		goto yy11;
yy1909:
		yych = *++cursor_;
		if (yych == 'c') goto yy1997;
		if (yych == 'o') goto yy1998;
		goto yy11;
yy1910:
		yych = *++cursor_;
		if (yych == '_') goto yy1999;
		goto yy11;
yy1911:
		yych = *++cursor_;
		if (yych == '_') goto yy2000;
		goto yy11;
yy1912:
		yych = *++cursor_;
		if (yych == 'u') goto yy2001;
		goto yy11;
yy1913:
		yych = *++cursor_;
		if (yych <= '1') {
			if (yych <= '"') {
				if (yych == '!') goto yy10;
			} else {
				if (yych <= '\'') goto yy10;
				if (yych <= ')') goto yy1914;
				if (yych <= '0') goto yy10;
				goto yy2002;
			}
		} else {
			if (yych <= '8') {
				if (yych == '3') goto yy2003;
				if (yych <= '7') goto yy10;
				goto yy2004;
			} else {
				if (yych == ';') goto yy1914;
				if (yych <= '~') goto yy10;
			}
		}
yy1914:
#line 466 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore); }
#line 9718 "src/prebuilt/wast-lexer-gen.cc"
yy1915:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 415 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendSI32); }
#line 9726 "src/prebuilt/wast-lexer-gen.cc"
yy1917:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 416 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ExtendUI32); }
#line 9734 "src/prebuilt/wast-lexer-gen.cc"
yy1919:
		yych = *++cursor_;
		if (yych == 'f') goto yy2006;
		goto yy11;
yy1920:
		yych = *++cursor_;
		if (yych == 'f') goto yy2007;
		goto yy11;
yy1921:
		yych = *++cursor_;
		if (yych == 'f') goto yy2008;
		goto yy11;
yy1922:
		yych = *++cursor_;
		if (yych == 'n') goto yy2009;
		goto yy11;
yy1923:
		yych = *++cursor_;
		if (yych == 'n') goto yy2010;
		goto yy11;
yy1924:
		yych = *++cursor_;
		if (yych == '4') goto yy2011;
		goto yy11;
yy1925:
		yych = *++cursor_;
		if (yych == '4') goto yy2012;
		goto yy11;
yy1926:
		yych = *++cursor_;
		if (yych == 't') goto yy2013;
		goto yy11;
yy1927:
		yych = *++cursor_;
		if (yych == 'n') goto yy2014;
		goto yy11;
yy1928:
		yych = *++cursor_;
		if (yych == 'n') goto yy2015;
		goto yy11;
yy1929:
		yych = *++cursor_;
		if (yych == 't') goto yy2016;
		goto yy11;
yy1930:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 690 "src/wast-lexer.cc"
		{ RETURN(AssertExhaustion); }
#line 9786 "src/prebuilt/wast-lexer-gen.cc"
yy1932:
		yych = *++cursor_;
		if (yych == 't') goto yy2017;
		goto yy11;
yy1933:
		yych = *++cursor_;
		if (yych == 'o') goto yy2018;
		goto yy11;
yy1934:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 685 "src/wast-lexer.cc"
		{ RETURN(AssertUnlinkable); }
#line 9802 "src/prebuilt/wast-lexer-gen.cc"
yy1936:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 434 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertSI32); }
#line 9810 "src/prebuilt/wast-lexer-gen.cc"
yy1938:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 436 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertSI64); }
#line 9818 "src/prebuilt/wast-lexer-gen.cc"
yy1940:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 438 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertUI32); }
#line 9826 "src/prebuilt/wast-lexer-gen.cc"
yy1942:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 440 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ConvertUI64); }
#line 9834 "src/prebuilt/wast-lexer-gen.cc"
yy1944:
		yych = *++cursor_;
		if (yych == '3') goto yy2019;
		goto yy11;
yy1945:
		yych = *++cursor_;
		if (yych == '3') goto yy2020;
		goto yy11;
yy1946:
		yych = *++cursor_;
		if (yych == '3') goto yy2021;
		goto yy11;
yy1947:
		yych = *++cursor_;
		if (yych == 'e') goto yy2022;
		goto yy11;
yy1948:
		yych = *++cursor_;
		if (yych == 'e') goto yy2024;
		goto yy11;
yy1949:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 435 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertSI32); }
#line 9862 "src/prebuilt/wast-lexer-gen.cc"
yy1951:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 437 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertSI64); }
#line 9870 "src/prebuilt/wast-lexer-gen.cc"
yy1953:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 439 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertUI32); }
#line 9878 "src/prebuilt/wast-lexer-gen.cc"
yy1955:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 441 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ConvertUI64); }
#line 9886 "src/prebuilt/wast-lexer-gen.cc"
yy1957:
		yych = *++cursor_;
		if (yych == '6') goto yy2026;
		goto yy11;
yy1958:
		yych = *++cursor_;
		if (yych == '6') goto yy2027;
		goto yy11;
yy1959:
		yych = *++cursor_;
		if (yych == '6') goto yy2028;
		goto yy11;
yy1960:
		yych = *++cursor_;
		if (yych == 'e') goto yy2029;
		goto yy11;
yy1961:
		yych = *++cursor_;
		if (yych == 'e') goto yy2031;
		goto yy11;
yy1962:
		yych = *++cursor_;
		if (yych == 'e') goto yy2033;
		goto yy11;
yy1963:
		yych = *++cursor_;
		if (yych == 'e') goto yy2034;
		goto yy11;
yy1964:
		yych = *++cursor_;
		if (yych == 'e') goto yy2035;
		goto yy11;
yy1965:
		yych = *++cursor_;
		if (yych == 'e') goto yy2037;
		goto yy11;
yy1966:
		yych = *++cursor_;
		if (yych == '_') goto yy2038;
		goto yy11;
yy1967:
		yych = *++cursor_;
		if (yych == 'u') goto yy2039;
		goto yy11;
yy1968:
		yych = *++cursor_;
		if (yych == 'd') goto yy2041;
		goto yy11;
yy1969:
		yych = *++cursor_;
		if (yych == 'd') goto yy2043;
		goto yy11;
yy1970:
		yych = *++cursor_;
		if (yych == 'p') goto yy2045;
		goto yy11;
yy1971:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 493 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwOr); }
#line 9950 "src/prebuilt/wast-lexer-gen.cc"
yy1973:
		yych = *++cursor_;
		if (yych == 'b') goto yy2046;
		goto yy11;
yy1974:
		yych = *++cursor_;
		if (yych == 'h') goto yy2048;
		goto yy11;
yy1975:
		yych = *++cursor_;
		if (yych == 'r') goto yy2049;
		goto yy11;
yy1976:
		yych = *++cursor_;
		if (yych == 'u') goto yy2051;
		goto yy11;
yy1977:
		yych = *++cursor_;
		if (yych == '.') goto yy2052;
		goto yy11;
yy1978:
		yych = *++cursor_;
		if (yych == '6') goto yy2053;
		goto yy11;
yy1979:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 467 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore8); }
#line 9982 "src/prebuilt/wast-lexer-gen.cc"
yy1981:
		yych = *++cursor_;
		if (yych == '3') goto yy2055;
		goto yy11;
yy1982:
		yych = *++cursor_;
		if (yych == '3') goto yy2056;
		if (yych == '6') goto yy2057;
		goto yy11;
yy1983:
		yych = *++cursor_;
		if (yych == '3') goto yy2058;
		if (yych == '6') goto yy2059;
		goto yy11;
yy1984:
		yych = *++cursor_;
		if (yych == 'e') goto yy2060;
		goto yy11;
yy1985:
		yych = *++cursor_;
		if (yych == 'e') goto yy2062;
		goto yy11;
yy1986:
		yych = *++cursor_;
		if (yych == 'x') goto yy2064;
		goto yy11;
yy1987:
		yych = *++cursor_;
		if (yych == 'x') goto yy2065;
		goto yy11;
yy1988:
		yych = *++cursor_;
		if (yych == '_') goto yy2066;
		goto yy11;
yy1989:
		yych = *++cursor_;
		if (yych == '_') goto yy2067;
		goto yy11;
yy1990:
		yych = *++cursor_;
		if (yych == 'u') goto yy2068;
		goto yy11;
yy1991:
		yych = *++cursor_;
		if (yych == 'd') goto yy2070;
		goto yy11;
yy1992:
		yych = *++cursor_;
		if (yych == 'd') goto yy2072;
		goto yy11;
yy1993:
		yych = *++cursor_;
		if (yych == 'p') goto yy2074;
		goto yy11;
yy1994:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 494 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwOr); }
#line 10044 "src/prebuilt/wast-lexer-gen.cc"
yy1996:
		yych = *++cursor_;
		if (yych == 'b') goto yy2075;
		goto yy11;
yy1997:
		yych = *++cursor_;
		if (yych == 'h') goto yy2077;
		goto yy11;
yy1998:
		yych = *++cursor_;
		if (yych == 'r') goto yy2078;
		goto yy11;
yy1999:
		yych = *++cursor_;
		if (yych == 'u') goto yy2080;
		goto yy11;
yy2000:
		yych = *++cursor_;
		if (yych == 'u') goto yy2081;
		goto yy11;
yy2001:
		yych = *++cursor_;
		if (yych == '.') goto yy2082;
		goto yy11;
yy2002:
		yych = *++cursor_;
		if (yych == '6') goto yy2083;
		goto yy11;
yy2003:
		yych = *++cursor_;
		if (yych == '2') goto yy2085;
		goto yy11;
yy2004:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 469 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore8); }
#line 10084 "src/prebuilt/wast-lexer-gen.cc"
yy2006:
		yych = *++cursor_;
		if (yych == '6') goto yy2087;
		goto yy11;
yy2007:
		yych = *++cursor_;
		if (yych == '3') goto yy2088;
		if (yych == '6') goto yy2089;
		goto yy11;
yy2008:
		yych = *++cursor_;
		if (yych == '3') goto yy2090;
		if (yych == '6') goto yy2091;
		goto yy11;
yy2009:
		yych = *++cursor_;
		if (yych == 'e') goto yy2092;
		goto yy11;
yy2010:
		yych = *++cursor_;
		if (yych == 'e') goto yy2094;
		goto yy11;
yy2011:
		yych = *++cursor_;
		if (yych == 'x') goto yy2096;
		goto yy11;
yy2012:
		yych = *++cursor_;
		if (yych == 'x') goto yy2097;
		goto yy11;
yy2013:
		yych = *++cursor_;
		if (yych == 'e') goto yy2098;
		goto yy11;
yy2014:
		yych = *++cursor_;
		if (yych == 'e') goto yy2099;
		goto yy11;
yy2015:
		yych = *++cursor_;
		if (yych == 'e') goto yy2100;
		goto yy11;
yy2016:
		yych = *++cursor_;
		if (yych == 'e') goto yy2102;
		goto yy11;
yy2017:
		yych = *++cursor_;
		if (yych == 'h') goto yy2103;
		goto yy11;
yy2018:
		yych = *++cursor_;
		if (yych == 'n') goto yy2104;
		goto yy11;
yy2019:
		yych = *++cursor_;
		if (yych == '2') goto yy2105;
		goto yy11;
yy2020:
		yych = *++cursor_;
		if (yych == '2') goto yy2107;
		goto yy11;
yy2021:
		yych = *++cursor_;
		if (yych == '2') goto yy2108;
		goto yy11;
yy2022:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 536 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F32X4ExtractLane); }
#line 10158 "src/prebuilt/wast-lexer-gen.cc"
yy2024:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 542 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F32X4ReplaceLane); }
#line 10166 "src/prebuilt/wast-lexer-gen.cc"
yy2026:
		yych = *++cursor_;
		if (yych == '4') goto yy2109;
		goto yy11;
yy2027:
		yych = *++cursor_;
		if (yych == '4') goto yy2111;
		goto yy11;
yy2028:
		yych = *++cursor_;
		if (yych == '4') goto yy2112;
		goto yy11;
yy2029:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 537 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F64X2ExtractLane); }
#line 10186 "src/prebuilt/wast-lexer-gen.cc"
yy2031:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 543 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, F64X2ReplaceLane); }
#line 10194 "src/prebuilt/wast-lexer-gen.cc"
yy2033:
		yych = *++cursor_;
		if (yych == '_') goto yy2113;
		goto yy11;
yy2034:
		yych = *++cursor_;
		if (yych == '_') goto yy2114;
		goto yy11;
yy2035:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 539 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ReplaceLane); }
#line 10210 "src/prebuilt/wast-lexer-gen.cc"
yy2037:
		yych = *++cursor_;
		if (yych == '_') goto yy2115;
		goto yy11;
yy2038:
		yych = *++cursor_;
		if (yych == 'u') goto yy2116;
		goto yy11;
yy2039:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 460 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad8U); }
#line 10226 "src/prebuilt/wast-lexer-gen.cc"
yy2041:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 472 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwAdd); }
#line 10234 "src/prebuilt/wast-lexer-gen.cc"
yy2043:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 486 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwAnd); }
#line 10242 "src/prebuilt/wast-lexer-gen.cc"
yy2045:
		yych = *++cursor_;
		if (yych == 'x') goto yy2118;
		goto yy11;
yy2046:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 479 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwSub); }
#line 10254 "src/prebuilt/wast-lexer-gen.cc"
yy2048:
		yych = *++cursor_;
		if (yych == 'g') goto yy2119;
		goto yy11;
yy2049:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 500 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwXor); }
#line 10266 "src/prebuilt/wast-lexer-gen.cc"
yy2051:
		yych = *++cursor_;
		if (yych == '.') goto yy2121;
		goto yy11;
yy2052:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2122;
		case 'c':	goto yy2123;
		case 'o':	goto yy2124;
		case 's':	goto yy2125;
		case 'x':	goto yy2126;
		default:	goto yy11;
		}
yy2053:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 468 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I32AtomicStore16); }
#line 10288 "src/prebuilt/wast-lexer-gen.cc"
yy2055:
		yych = *++cursor_;
		if (yych == '2') goto yy2127;
		goto yy11;
yy2056:
		yych = *++cursor_;
		if (yych == '2') goto yy2129;
		goto yy11;
yy2057:
		yych = *++cursor_;
		if (yych == '4') goto yy2131;
		goto yy11;
yy2058:
		yych = *++cursor_;
		if (yych == '2') goto yy2133;
		goto yy11;
yy2059:
		yych = *++cursor_;
		if (yych == '4') goto yy2135;
		goto yy11;
yy2060:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 534 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I32X4ExtractLane); }
#line 10316 "src/prebuilt/wast-lexer-gen.cc"
yy2062:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 540 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I32X4ReplaceLane); }
#line 10324 "src/prebuilt/wast-lexer-gen.cc"
yy2064:
		yych = *++cursor_;
		if (yych == '4') goto yy2137;
		goto yy11;
yy2065:
		yych = *++cursor_;
		if (yych == '4') goto yy2138;
		goto yy11;
yy2066:
		yych = *++cursor_;
		if (yych == 'u') goto yy2139;
		goto yy11;
yy2067:
		yych = *++cursor_;
		if (yych == 'u') goto yy2141;
		goto yy11;
yy2068:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 462 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad8U); }
#line 10348 "src/prebuilt/wast-lexer-gen.cc"
yy2070:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 473 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwAdd); }
#line 10356 "src/prebuilt/wast-lexer-gen.cc"
yy2072:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 487 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwAnd); }
#line 10364 "src/prebuilt/wast-lexer-gen.cc"
yy2074:
		yych = *++cursor_;
		if (yych == 'x') goto yy2143;
		goto yy11;
yy2075:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 480 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwSub); }
#line 10376 "src/prebuilt/wast-lexer-gen.cc"
yy2077:
		yych = *++cursor_;
		if (yych == 'g') goto yy2144;
		goto yy11;
yy2078:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 501 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwXor); }
#line 10388 "src/prebuilt/wast-lexer-gen.cc"
yy2080:
		yych = *++cursor_;
		if (yych == '.') goto yy2146;
		goto yy11;
yy2081:
		yych = *++cursor_;
		if (yych == '.') goto yy2147;
		goto yy11;
yy2082:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2148;
		case 'c':	goto yy2149;
		case 'o':	goto yy2150;
		case 's':	goto yy2151;
		case 'x':	goto yy2152;
		default:	goto yy11;
		}
yy2083:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 470 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore16); }
#line 10414 "src/prebuilt/wast-lexer-gen.cc"
yy2085:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 471 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicStore, I64AtomicStore32); }
#line 10422 "src/prebuilt/wast-lexer-gen.cc"
yy2087:
		yych = *++cursor_;
		if (yych == '4') goto yy2153;
		goto yy11;
yy2088:
		yych = *++cursor_;
		if (yych == '2') goto yy2155;
		goto yy11;
yy2089:
		yych = *++cursor_;
		if (yych == '4') goto yy2157;
		goto yy11;
yy2090:
		yych = *++cursor_;
		if (yych == '2') goto yy2159;
		goto yy11;
yy2091:
		yych = *++cursor_;
		if (yych == '4') goto yy2161;
		goto yy11;
yy2092:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 535 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I64X2ExtractLane); }
#line 10450 "src/prebuilt/wast-lexer-gen.cc"
yy2094:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 541 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I64X2ReplaceLane); }
#line 10458 "src/prebuilt/wast-lexer-gen.cc"
yy2096:
		yych = *++cursor_;
		if (yych == '2') goto yy2163;
		goto yy11;
yy2097:
		yych = *++cursor_;
		if (yych == '2') goto yy2164;
		goto yy11;
yy2098:
		yych = *++cursor_;
		if (yych == '_') goto yy2165;
		goto yy11;
yy2099:
		yych = *++cursor_;
		if (yych == '_') goto yy2166;
		goto yy11;
yy2100:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 538 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ReplaceLane); }
#line 10482 "src/prebuilt/wast-lexer-gen.cc"
yy2102:
		yych = *++cursor_;
		if (yych == '_') goto yy2167;
		goto yy11;
yy2103:
		yych = *++cursor_;
		if (yych == 'm') goto yy2168;
		goto yy11;
yy2104:
		yych = *++cursor_;
		if (yych == 'i') goto yy2169;
		goto yy11;
yy2105:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 444 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F32ReinterpretI32); }
#line 10502 "src/prebuilt/wast-lexer-gen.cc"
yy2107:
		yych = *++cursor_;
		if (yych == 'x') goto yy2170;
		goto yy11;
yy2108:
		yych = *++cursor_;
		if (yych == 'x') goto yy2171;
		goto yy11;
yy2109:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 446 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, F64ReinterpretI64); }
#line 10518 "src/prebuilt/wast-lexer-gen.cc"
yy2111:
		yych = *++cursor_;
		if (yych == 'x') goto yy2172;
		goto yy11;
yy2112:
		yych = *++cursor_;
		if (yych == 'x') goto yy2173;
		goto yy11;
yy2113:
		yych = *++cursor_;
		if (yych == 's') goto yy2174;
		if (yych == 'u') goto yy2176;
		goto yy11;
yy2114:
		yych = *++cursor_;
		if (yych == 's') goto yy2178;
		if (yych == 'u') goto yy2180;
		goto yy11;
yy2115:
		yych = *++cursor_;
		if (yych == 's') goto yy2182;
		if (yych == 'u') goto yy2184;
		goto yy11;
yy2116:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 461 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I32AtomicLoad16U); }
#line 10549 "src/prebuilt/wast-lexer-gen.cc"
yy2118:
		yych = *++cursor_;
		if (yych == 'c') goto yy2186;
		goto yy11;
yy2119:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 507 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmwXchg); }
#line 10561 "src/prebuilt/wast-lexer-gen.cc"
yy2121:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2187;
		case 'c':	goto yy2188;
		case 'o':	goto yy2189;
		case 's':	goto yy2190;
		case 'x':	goto yy2191;
		default:	goto yy11;
		}
yy2122:
		yych = *++cursor_;
		if (yych == 'd') goto yy2192;
		if (yych == 'n') goto yy2193;
		goto yy11;
yy2123:
		yych = *++cursor_;
		if (yych == 'm') goto yy2194;
		goto yy11;
yy2124:
		yych = *++cursor_;
		if (yych == 'r') goto yy2195;
		goto yy11;
yy2125:
		yych = *++cursor_;
		if (yych == 'u') goto yy2197;
		goto yy11;
yy2126:
		yych = *++cursor_;
		if (yych == 'c') goto yy2198;
		if (yych == 'o') goto yy2199;
		goto yy11;
yy2127:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 445 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32ReinterpretF32); }
#line 10601 "src/prebuilt/wast-lexer-gen.cc"
yy2129:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 426 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSSatF32); }
#line 10609 "src/prebuilt/wast-lexer-gen.cc"
yy2131:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 428 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncSSatF64); }
#line 10617 "src/prebuilt/wast-lexer-gen.cc"
yy2133:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 430 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncUSatF32); }
#line 10625 "src/prebuilt/wast-lexer-gen.cc"
yy2135:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 432 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I32TruncUSatF64); }
#line 10633 "src/prebuilt/wast-lexer-gen.cc"
yy2137:
		yych = *++cursor_;
		if (yych == ':') goto yy2200;
		goto yy11;
yy2138:
		yych = *++cursor_;
		if (yych == ':') goto yy2201;
		goto yy11;
yy2139:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 463 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad16U); }
#line 10649 "src/prebuilt/wast-lexer-gen.cc"
yy2141:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 464 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicLoad, I64AtomicLoad32U); }
#line 10657 "src/prebuilt/wast-lexer-gen.cc"
yy2143:
		yych = *++cursor_;
		if (yych == 'c') goto yy2202;
		goto yy11;
yy2144:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 508 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmwXchg); }
#line 10669 "src/prebuilt/wast-lexer-gen.cc"
yy2146:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2203;
		case 'c':	goto yy2204;
		case 'o':	goto yy2205;
		case 's':	goto yy2206;
		case 'x':	goto yy2207;
		default:	goto yy11;
		}
yy2147:
		yych = *++cursor_;
		switch (yych) {
		case 'a':	goto yy2208;
		case 'c':	goto yy2209;
		case 'o':	goto yy2210;
		case 's':	goto yy2211;
		case 'x':	goto yy2212;
		default:	goto yy11;
		}
yy2148:
		yych = *++cursor_;
		if (yych == 'd') goto yy2213;
		if (yych == 'n') goto yy2214;
		goto yy11;
yy2149:
		yych = *++cursor_;
		if (yych == 'm') goto yy2215;
		goto yy11;
yy2150:
		yych = *++cursor_;
		if (yych == 'r') goto yy2216;
		goto yy11;
yy2151:
		yych = *++cursor_;
		if (yych == 'u') goto yy2218;
		goto yy11;
yy2152:
		yych = *++cursor_;
		if (yych == 'c') goto yy2219;
		if (yych == 'o') goto yy2220;
		goto yy11;
yy2153:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 447 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64ReinterpretF64); }
#line 10719 "src/prebuilt/wast-lexer-gen.cc"
yy2155:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 427 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSSatF32); }
#line 10727 "src/prebuilt/wast-lexer-gen.cc"
yy2157:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 429 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncSSatF64); }
#line 10735 "src/prebuilt/wast-lexer-gen.cc"
yy2159:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 431 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncUSatF32); }
#line 10743 "src/prebuilt/wast-lexer-gen.cc"
yy2161:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 433 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Convert, I64TruncUSatF64); }
#line 10751 "src/prebuilt/wast-lexer-gen.cc"
yy2163:
		yych = *++cursor_;
		if (yych == ':') goto yy2221;
		goto yy11;
yy2164:
		yych = *++cursor_;
		if (yych == ':') goto yy2222;
		goto yy11;
yy2165:
		yych = *++cursor_;
		if (yych == 's') goto yy2223;
		if (yych == 'u') goto yy2225;
		goto yy11;
yy2166:
		yych = *++cursor_;
		if (yych == 's') goto yy2227;
		if (yych == 'u') goto yy2229;
		goto yy11;
yy2167:
		yych = *++cursor_;
		if (yych == 's') goto yy2231;
		if (yych == 'u') goto yy2233;
		goto yy11;
yy2168:
		yych = *++cursor_;
		if (yych == 'e') goto yy2235;
		goto yy11;
yy2169:
		yych = *++cursor_;
		if (yych == 'c') goto yy2236;
		goto yy11;
yy2170:
		yych = *++cursor_;
		if (yych == '4') goto yy2237;
		goto yy11;
yy2171:
		yych = *++cursor_;
		if (yych == '4') goto yy2239;
		goto yy11;
yy2172:
		yych = *++cursor_;
		if (yych == '2') goto yy2241;
		goto yy11;
yy2173:
		yych = *++cursor_;
		if (yych == '2') goto yy2243;
		goto yy11;
yy2174:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 562 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8AddSaturateS); }
#line 10806 "src/prebuilt/wast-lexer-gen.cc"
yy2176:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 563 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8AddSaturateU); }
#line 10814 "src/prebuilt/wast-lexer-gen.cc"
yy2178:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 532 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ExtractLaneS); }
#line 10822 "src/prebuilt/wast-lexer-gen.cc"
yy2180:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 533 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I16X8ExtractLaneU); }
#line 10830 "src/prebuilt/wast-lexer-gen.cc"
yy2182:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 566 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8SubSaturateS); }
#line 10838 "src/prebuilt/wast-lexer-gen.cc"
yy2184:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 567 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I16X8SubSaturateU); }
#line 10846 "src/prebuilt/wast-lexer-gen.cc"
yy2186:
		yych = *++cursor_;
		if (yych == 'h') goto yy2245;
		goto yy11;
yy2187:
		yych = *++cursor_;
		if (yych == 'd') goto yy2246;
		if (yych == 'n') goto yy2247;
		goto yy11;
yy2188:
		yych = *++cursor_;
		if (yych == 'm') goto yy2248;
		goto yy11;
yy2189:
		yych = *++cursor_;
		if (yych == 'r') goto yy2249;
		goto yy11;
yy2190:
		yych = *++cursor_;
		if (yych == 'u') goto yy2251;
		goto yy11;
yy2191:
		yych = *++cursor_;
		if (yych == 'c') goto yy2252;
		if (yych == 'o') goto yy2253;
		goto yy11;
yy2192:
		yych = *++cursor_;
		if (yych == 'd') goto yy2254;
		goto yy11;
yy2193:
		yych = *++cursor_;
		if (yych == 'd') goto yy2256;
		goto yy11;
yy2194:
		yych = *++cursor_;
		if (yych == 'p') goto yy2258;
		goto yy11;
yy2195:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 495 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8UOr); }
#line 10892 "src/prebuilt/wast-lexer-gen.cc"
yy2197:
		yych = *++cursor_;
		if (yych == 'b') goto yy2259;
		goto yy11;
yy2198:
		yych = *++cursor_;
		if (yych == 'h') goto yy2261;
		goto yy11;
yy2199:
		yych = *++cursor_;
		if (yych == 'r') goto yy2262;
		goto yy11;
yy2200:
		yych = *++cursor_;
		if (yych == 's') goto yy2264;
		goto yy11;
yy2201:
		yych = *++cursor_;
		if (yych == 's') goto yy2265;
		goto yy11;
yy2202:
		yych = *++cursor_;
		if (yych == 'h') goto yy2266;
		goto yy11;
yy2203:
		yych = *++cursor_;
		if (yych == 'd') goto yy2267;
		if (yych == 'n') goto yy2268;
		goto yy11;
yy2204:
		yych = *++cursor_;
		if (yych == 'm') goto yy2269;
		goto yy11;
yy2205:
		yych = *++cursor_;
		if (yych == 'r') goto yy2270;
		goto yy11;
yy2206:
		yych = *++cursor_;
		if (yych == 'u') goto yy2272;
		goto yy11;
yy2207:
		yych = *++cursor_;
		if (yych == 'c') goto yy2273;
		if (yych == 'o') goto yy2274;
		goto yy11;
yy2208:
		yych = *++cursor_;
		if (yych == 'd') goto yy2275;
		if (yych == 'n') goto yy2276;
		goto yy11;
yy2209:
		yych = *++cursor_;
		if (yych == 'm') goto yy2277;
		goto yy11;
yy2210:
		yych = *++cursor_;
		if (yych == 'r') goto yy2278;
		goto yy11;
yy2211:
		yych = *++cursor_;
		if (yych == 'u') goto yy2280;
		goto yy11;
yy2212:
		yych = *++cursor_;
		if (yych == 'c') goto yy2281;
		if (yych == 'o') goto yy2282;
		goto yy11;
yy2213:
		yych = *++cursor_;
		if (yych == 'd') goto yy2283;
		goto yy11;
yy2214:
		yych = *++cursor_;
		if (yych == 'd') goto yy2285;
		goto yy11;
yy2215:
		yych = *++cursor_;
		if (yych == 'p') goto yy2287;
		goto yy11;
yy2216:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 497 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8UOr); }
#line 10980 "src/prebuilt/wast-lexer-gen.cc"
yy2218:
		yych = *++cursor_;
		if (yych == 'b') goto yy2288;
		goto yy11;
yy2219:
		yych = *++cursor_;
		if (yych == 'h') goto yy2290;
		goto yy11;
yy2220:
		yych = *++cursor_;
		if (yych == 'r') goto yy2291;
		goto yy11;
yy2221:
		yych = *++cursor_;
		if (yych == 's') goto yy2293;
		goto yy11;
yy2222:
		yych = *++cursor_;
		if (yych == 's') goto yy2294;
		goto yy11;
yy2223:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 560 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16AddSaturateS); }
#line 11008 "src/prebuilt/wast-lexer-gen.cc"
yy2225:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 561 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16AddSaturateU); }
#line 11016 "src/prebuilt/wast-lexer-gen.cc"
yy2227:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 530 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ExtractLaneS); }
#line 11024 "src/prebuilt/wast-lexer-gen.cc"
yy2229:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 531 "src/wast-lexer.cc"
		{ RETURN_OPCODE(SimdLaneOp, I8X16ExtractLaneU); }
#line 11032 "src/prebuilt/wast-lexer-gen.cc"
yy2231:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 564 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16SubSaturateS); }
#line 11040 "src/prebuilt/wast-lexer-gen.cc"
yy2233:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 565 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Binary, I8X16SubSaturateU); }
#line 11048 "src/prebuilt/wast-lexer-gen.cc"
yy2235:
		yych = *++cursor_;
		if (yych == 't') goto yy2295;
		goto yy11;
yy2236:
		yych = *++cursor_;
		if (yych == 'a') goto yy2296;
		goto yy11;
yy2237:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 653 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4ConvertSI32X4); }
#line 11064 "src/prebuilt/wast-lexer-gen.cc"
yy2239:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 654 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F32X4ConvertUI32X4); }
#line 11072 "src/prebuilt/wast-lexer-gen.cc"
yy2241:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 655 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2ConvertSI64X2); }
#line 11080 "src/prebuilt/wast-lexer-gen.cc"
yy2243:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 656 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, F64X2ConvertUI64X2); }
#line 11088 "src/prebuilt/wast-lexer-gen.cc"
yy2245:
		yych = *++cursor_;
		if (yych == 'g') goto yy2297;
		goto yy11;
yy2246:
		yych = *++cursor_;
		if (yych == 'd') goto yy2299;
		goto yy11;
yy2247:
		yych = *++cursor_;
		if (yych == 'd') goto yy2301;
		goto yy11;
yy2248:
		yych = *++cursor_;
		if (yych == 'p') goto yy2303;
		goto yy11;
yy2249:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 496 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16UOr); }
#line 11112 "src/prebuilt/wast-lexer-gen.cc"
yy2251:
		yych = *++cursor_;
		if (yych == 'b') goto yy2304;
		goto yy11;
yy2252:
		yych = *++cursor_;
		if (yych == 'h') goto yy2306;
		goto yy11;
yy2253:
		yych = *++cursor_;
		if (yych == 'r') goto yy2307;
		goto yy11;
yy2254:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 474 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8UAdd); }
#line 11132 "src/prebuilt/wast-lexer-gen.cc"
yy2256:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 488 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8UAnd); }
#line 11140 "src/prebuilt/wast-lexer-gen.cc"
yy2258:
		yych = *++cursor_;
		if (yych == 'x') goto yy2309;
		goto yy11;
yy2259:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 481 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8USub); }
#line 11152 "src/prebuilt/wast-lexer-gen.cc"
yy2261:
		yych = *++cursor_;
		if (yych == 'g') goto yy2310;
		goto yy11;
yy2262:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 502 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8UXor); }
#line 11164 "src/prebuilt/wast-lexer-gen.cc"
yy2264:
		yych = *++cursor_;
		if (yych == 'a') goto yy2312;
		goto yy11;
yy2265:
		yych = *++cursor_;
		if (yych == 'a') goto yy2313;
		goto yy11;
yy2266:
		yych = *++cursor_;
		if (yych == 'g') goto yy2314;
		goto yy11;
yy2267:
		yych = *++cursor_;
		if (yych == 'd') goto yy2316;
		goto yy11;
yy2268:
		yych = *++cursor_;
		if (yych == 'd') goto yy2318;
		goto yy11;
yy2269:
		yych = *++cursor_;
		if (yych == 'p') goto yy2320;
		goto yy11;
yy2270:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 498 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16UOr); }
#line 11196 "src/prebuilt/wast-lexer-gen.cc"
yy2272:
		yych = *++cursor_;
		if (yych == 'b') goto yy2321;
		goto yy11;
yy2273:
		yych = *++cursor_;
		if (yych == 'h') goto yy2323;
		goto yy11;
yy2274:
		yych = *++cursor_;
		if (yych == 'r') goto yy2324;
		goto yy11;
yy2275:
		yych = *++cursor_;
		if (yych == 'd') goto yy2326;
		goto yy11;
yy2276:
		yych = *++cursor_;
		if (yych == 'd') goto yy2328;
		goto yy11;
yy2277:
		yych = *++cursor_;
		if (yych == 'p') goto yy2330;
		goto yy11;
yy2278:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 499 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32UOr); }
#line 11228 "src/prebuilt/wast-lexer-gen.cc"
yy2280:
		yych = *++cursor_;
		if (yych == 'b') goto yy2331;
		goto yy11;
yy2281:
		yych = *++cursor_;
		if (yych == 'h') goto yy2333;
		goto yy11;
yy2282:
		yych = *++cursor_;
		if (yych == 'r') goto yy2334;
		goto yy11;
yy2283:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 476 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8UAdd); }
#line 11248 "src/prebuilt/wast-lexer-gen.cc"
yy2285:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 490 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8UAnd); }
#line 11256 "src/prebuilt/wast-lexer-gen.cc"
yy2287:
		yych = *++cursor_;
		if (yych == 'x') goto yy2336;
		goto yy11;
yy2288:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 483 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8USub); }
#line 11268 "src/prebuilt/wast-lexer-gen.cc"
yy2290:
		yych = *++cursor_;
		if (yych == 'g') goto yy2337;
		goto yy11;
yy2291:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 504 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8UXor); }
#line 11280 "src/prebuilt/wast-lexer-gen.cc"
yy2293:
		yych = *++cursor_;
		if (yych == 'a') goto yy2339;
		goto yy11;
yy2294:
		yych = *++cursor_;
		if (yych == 'a') goto yy2340;
		goto yy11;
yy2295:
		yych = *++cursor_;
		if (yych == 'i') goto yy2341;
		goto yy11;
yy2296:
		yych = *++cursor_;
		if (yych == 'l') goto yy2342;
		goto yy11;
yy2297:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 514 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmwCmpxchg); }
#line 11304 "src/prebuilt/wast-lexer-gen.cc"
yy2299:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 475 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16UAdd); }
#line 11312 "src/prebuilt/wast-lexer-gen.cc"
yy2301:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 489 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16UAnd); }
#line 11320 "src/prebuilt/wast-lexer-gen.cc"
yy2303:
		yych = *++cursor_;
		if (yych == 'x') goto yy2343;
		goto yy11;
yy2304:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 482 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16USub); }
#line 11332 "src/prebuilt/wast-lexer-gen.cc"
yy2306:
		yych = *++cursor_;
		if (yych == 'g') goto yy2344;
		goto yy11;
yy2307:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 503 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16UXor); }
#line 11344 "src/prebuilt/wast-lexer-gen.cc"
yy2309:
		yych = *++cursor_;
		if (yych == 'c') goto yy2346;
		goto yy11;
yy2310:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 509 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw8UXchg); }
#line 11356 "src/prebuilt/wast-lexer-gen.cc"
yy2312:
		yych = *++cursor_;
		if (yych == 't') goto yy2347;
		goto yy11;
yy2313:
		yych = *++cursor_;
		if (yych == 't') goto yy2349;
		goto yy11;
yy2314:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 515 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmwCmpxchg); }
#line 11372 "src/prebuilt/wast-lexer-gen.cc"
yy2316:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 477 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16UAdd); }
#line 11380 "src/prebuilt/wast-lexer-gen.cc"
yy2318:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 491 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16UAnd); }
#line 11388 "src/prebuilt/wast-lexer-gen.cc"
yy2320:
		yych = *++cursor_;
		if (yych == 'x') goto yy2351;
		goto yy11;
yy2321:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 484 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16USub); }
#line 11400 "src/prebuilt/wast-lexer-gen.cc"
yy2323:
		yych = *++cursor_;
		if (yych == 'g') goto yy2352;
		goto yy11;
yy2324:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 505 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16UXor); }
#line 11412 "src/prebuilt/wast-lexer-gen.cc"
yy2326:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 478 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32UAdd); }
#line 11420 "src/prebuilt/wast-lexer-gen.cc"
yy2328:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 492 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32UAnd); }
#line 11428 "src/prebuilt/wast-lexer-gen.cc"
yy2330:
		yych = *++cursor_;
		if (yych == 'x') goto yy2354;
		goto yy11;
yy2331:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 485 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32USub); }
#line 11440 "src/prebuilt/wast-lexer-gen.cc"
yy2333:
		yych = *++cursor_;
		if (yych == 'g') goto yy2355;
		goto yy11;
yy2334:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 506 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32UXor); }
#line 11452 "src/prebuilt/wast-lexer-gen.cc"
yy2336:
		yych = *++cursor_;
		if (yych == 'c') goto yy2357;
		goto yy11;
yy2337:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 511 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw8UXchg); }
#line 11464 "src/prebuilt/wast-lexer-gen.cc"
yy2339:
		yych = *++cursor_;
		if (yych == 't') goto yy2358;
		goto yy11;
yy2340:
		yych = *++cursor_;
		if (yych == 't') goto yy2360;
		goto yy11;
yy2341:
		yych = *++cursor_;
		if (yych == 'c') goto yy2362;
		goto yy11;
yy2342:
		yych = *++cursor_;
		if (yych == '_') goto yy2363;
		goto yy11;
yy2343:
		yych = *++cursor_;
		if (yych == 'c') goto yy2364;
		goto yy11;
yy2344:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 510 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I32AtomicRmw16UXchg); }
#line 11492 "src/prebuilt/wast-lexer-gen.cc"
yy2346:
		yych = *++cursor_;
		if (yych == 'h') goto yy2365;
		goto yy11;
yy2347:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 657 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4TruncSF32X4Sat); }
#line 11504 "src/prebuilt/wast-lexer-gen.cc"
yy2349:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 658 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I32X4TruncUF32X4Sat); }
#line 11512 "src/prebuilt/wast-lexer-gen.cc"
yy2351:
		yych = *++cursor_;
		if (yych == 'c') goto yy2366;
		goto yy11;
yy2352:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 512 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw16UXchg); }
#line 11524 "src/prebuilt/wast-lexer-gen.cc"
yy2354:
		yych = *++cursor_;
		if (yych == 'c') goto yy2367;
		goto yy11;
yy2355:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 513 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmw, I64AtomicRmw32UXchg); }
#line 11536 "src/prebuilt/wast-lexer-gen.cc"
yy2357:
		yych = *++cursor_;
		if (yych == 'h') goto yy2368;
		goto yy11;
yy2358:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 659 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2TruncSF64X2Sat); }
#line 11548 "src/prebuilt/wast-lexer-gen.cc"
yy2360:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 660 "src/wast-lexer.cc"
		{ RETURN_OPCODE(Unary, I64X2TruncUF64X2Sat); }
#line 11556 "src/prebuilt/wast-lexer-gen.cc"
yy2362:
		yych = *++cursor_;
		if (yych == '_') goto yy2369;
		goto yy11;
yy2363:
		yych = *++cursor_;
		if (yych == 'n') goto yy2370;
		goto yy11;
yy2364:
		yych = *++cursor_;
		if (yych == 'h') goto yy2371;
		goto yy11;
yy2365:
		yych = *++cursor_;
		if (yych == 'g') goto yy2372;
		goto yy11;
yy2366:
		yych = *++cursor_;
		if (yych == 'h') goto yy2374;
		goto yy11;
yy2367:
		yych = *++cursor_;
		if (yych == 'h') goto yy2375;
		goto yy11;
yy2368:
		yych = *++cursor_;
		if (yych == 'g') goto yy2376;
		goto yy11;
yy2369:
		yych = *++cursor_;
		if (yych == 'n') goto yy2378;
		goto yy11;
yy2370:
		yych = *++cursor_;
		if (yych == 'a') goto yy2379;
		goto yy11;
yy2371:
		yych = *++cursor_;
		if (yych == 'g') goto yy2380;
		goto yy11;
yy2372:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 516 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmw8UCmpxchg); }
#line 11604 "src/prebuilt/wast-lexer-gen.cc"
yy2374:
		yych = *++cursor_;
		if (yych == 'g') goto yy2382;
		goto yy11;
yy2375:
		yych = *++cursor_;
		if (yych == 'g') goto yy2384;
		goto yy11;
yy2376:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 518 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw8UCmpxchg); }
#line 11620 "src/prebuilt/wast-lexer-gen.cc"
yy2378:
		yych = *++cursor_;
		if (yych == 'a') goto yy2386;
		goto yy11;
yy2379:
		yych = *++cursor_;
		if (yych == 'n') goto yy2387;
		goto yy11;
yy2380:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 517 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I32AtomicRmw16UCmpxchg); }
#line 11636 "src/prebuilt/wast-lexer-gen.cc"
yy2382:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 519 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw16UCmpxchg); }
#line 11644 "src/prebuilt/wast-lexer-gen.cc"
yy2384:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 520 "src/wast-lexer.cc"
		{ RETURN_OPCODE(AtomicRmwCmpxchg, I64AtomicRmw32UCmpxchg); }
#line 11652 "src/prebuilt/wast-lexer-gen.cc"
yy2386:
		yych = *++cursor_;
		if (yych == 'n') goto yy2389;
		goto yy11;
yy2387:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 687 "src/wast-lexer.cc"
		{ RETURN(AssertReturnCanonicalNan); }
#line 11664 "src/prebuilt/wast-lexer-gen.cc"
yy2389:
		yych = *++cursor_;
		if (yybm[0+yych] & 8) {
			goto yy10;
		}
#line 688 "src/wast-lexer.cc"
		{ RETURN(AssertReturnArithmeticNan); }
#line 11672 "src/prebuilt/wast-lexer-gen.cc"
	}
/* *********************************** */
YYCOND_BAD_TEXT:
	if ((limit_ - cursor_) < 5) FILL(5);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '!') {
			if (yych == '\n') goto yy2395;
			if (yych >= ' ') goto yy2397;
		} else {
			if (yych <= '"') goto yy2399;
			if (yych == '\\') goto yy2401;
			goto yy2397;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy2402;
			if (yych <= 0xDF) goto yy2404;
			if (yych <= 0xE0) goto yy2405;
			goto yy2406;
		} else {
			if (yych <= 0xF0) goto yy2407;
			if (yych <= 0xF3) goto yy2408;
			if (yych <= 0xF4) goto yy2409;
			goto yy2402;
		}
	}
	++cursor_;
yy2394:
#line 254 "src/wast-lexer.cc"
	{ ERROR("illegal character in string");
                                  continue; }
#line 11705 "src/prebuilt/wast-lexer-gen.cc"
yy2395:
	++cursor_;
	BEGIN(YYCOND_i);
#line 247 "src/wast-lexer.cc"
	{ ERROR("newline in string");
                                  NEWLINE;
                                  continue; }
#line 11713 "src/prebuilt/wast-lexer-gen.cc"
yy2397:
	++cursor_;
#line 246 "src/wast-lexer.cc"
	{ continue; }
#line 11718 "src/prebuilt/wast-lexer-gen.cc"
yy2399:
	++cursor_;
	BEGIN(YYCOND_i);
#line 253 "src/wast-lexer.cc"
	{ RETURN_TEXT(Text); }
#line 11724 "src/prebuilt/wast-lexer-gen.cc"
yy2401:
	yyaccept = 0;
	yych = *(marker_ = ++cursor_);
	if (yych <= 'f') {
		if (yych <= '/') {
			if (yych <= '!') {
				if (yych == '\n') goto yy2394;
				goto yy2410;
			} else {
				if (yych <= '"') goto yy2397;
				if (yych == '\'') goto yy2397;
				goto yy2410;
			}
		} else {
			if (yych <= 'F') {
				if (yych <= '9') goto yy2412;
				if (yych <= '@') goto yy2410;
				goto yy2412;
			} else {
				if (yych == '\\') goto yy2397;
				if (yych <= '`') goto yy2410;
				goto yy2412;
			}
		}
	} else {
		if (yych <= 0x7F) {
			if (yych <= 'q') {
				if (yych == 'n') goto yy2397;
				goto yy2410;
			} else {
				if (yych == 's') goto yy2410;
				if (yych <= 't') goto yy2397;
				goto yy2410;
			}
		} else {
			if (yych <= 0xEF) {
				if (yych <= 0xC1) goto yy2394;
				if (yych <= 0xDF) goto yy2413;
				if (yych <= 0xE0) goto yy2415;
				goto yy2416;
			} else {
				if (yych <= 0xF0) goto yy2417;
				if (yych <= 0xF3) goto yy2418;
				if (yych <= 0xF4) goto yy2419;
				goto yy2394;
			}
		}
	}
yy2402:
	++cursor_;
yy2403:
#line 256 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in string"); }
#line 11778 "src/prebuilt/wast-lexer-gen.cc"
yy2404:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2403;
	if (yych <= 0xBF) goto yy2397;
	goto yy2403;
yy2405:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy2403;
	if (yych <= 0xBF) goto yy2420;
	goto yy2403;
yy2406:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2403;
	if (yych <= 0xBF) goto yy2420;
	goto yy2403;
yy2407:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy2403;
	if (yych <= 0xBF) goto yy2421;
	goto yy2403;
yy2408:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2403;
	if (yych <= 0xBF) goto yy2421;
	goto yy2403;
yy2409:
	yyaccept = 1;
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2403;
	if (yych <= 0x8F) goto yy2421;
	goto yy2403;
yy2410:
	++cursor_;
yy2411:
#line 250 "src/wast-lexer.cc"
	{ ERROR("bad escape \"%.*s\"",
                                        static_cast<int>(yyleng), yytext);
                                  continue; }
#line 11821 "src/prebuilt/wast-lexer-gen.cc"
yy2412:
	yych = *++cursor_;
	if (yych <= '@') {
		if (yych <= '/') goto yy2411;
		if (yych <= '9') goto yy2397;
		goto yy2411;
	} else {
		if (yych <= 'F') goto yy2397;
		if (yych <= '`') goto yy2411;
		if (yych <= 'f') goto yy2397;
		goto yy2411;
	}
yy2413:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0xBF) goto yy2410;
yy2414:
	cursor_ = marker_;
	if (yyaccept == 0) {
		goto yy2394;
	} else {
		goto yy2403;
	}
yy2415:
	yych = *++cursor_;
	if (yych <= 0x9F) goto yy2414;
	if (yych <= 0xBF) goto yy2413;
	goto yy2414;
yy2416:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0xBF) goto yy2413;
	goto yy2414;
yy2417:
	yych = *++cursor_;
	if (yych <= 0x8F) goto yy2414;
	if (yych <= 0xBF) goto yy2416;
	goto yy2414;
yy2418:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0xBF) goto yy2416;
	goto yy2414;
yy2419:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0x8F) goto yy2416;
	goto yy2414;
yy2420:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0xBF) goto yy2397;
	goto yy2414;
yy2421:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2414;
	if (yych <= 0xBF) goto yy2420;
	goto yy2414;
/* *********************************** */
YYCOND_LINE_COMMENT:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		if ((limit_ - cursor_) < 2) FILL(2);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy2424;
		}
		if (yych <= 0xE0) {
			if (yych <= '\n') goto yy2427;
			if (yych <= 0xC1) goto yy2429;
			if (yych <= 0xDF) goto yy2431;
			goto yy2432;
		} else {
			if (yych <= 0xF0) {
				if (yych <= 0xEF) goto yy2433;
				goto yy2434;
			} else {
				if (yych <= 0xF3) goto yy2435;
				if (yych <= 0xF4) goto yy2436;
				goto yy2429;
			}
		}
yy2424:
		yyaccept = 0;
		marker_ = ++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yybm[0+yych] & 128) {
			goto yy2424;
		}
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy2426;
			if (yych <= 0xDF) goto yy2437;
			if (yych <= 0xE0) goto yy2439;
			goto yy2440;
		} else {
			if (yych <= 0xF0) goto yy2441;
			if (yych <= 0xF3) goto yy2442;
			if (yych <= 0xF4) goto yy2443;
		}
yy2426:
#line 701 "src/wast-lexer.cc"
		{ continue; }
#line 11958 "src/prebuilt/wast-lexer-gen.cc"
yy2427:
		++cursor_;
		BEGIN(YYCOND_i);
#line 700 "src/wast-lexer.cc"
		{ NEWLINE; continue; }
#line 11964 "src/prebuilt/wast-lexer-gen.cc"
yy2429:
		++cursor_;
yy2430:
#line 715 "src/wast-lexer.cc"
		{ MAYBE_MALFORMED_UTF8(""); }
#line 11970 "src/prebuilt/wast-lexer-gen.cc"
yy2431:
		yych = *++cursor_;
		if (yych <= 0x7F) goto yy2430;
		if (yych <= 0xBF) goto yy2424;
		goto yy2430;
yy2432:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x9F) goto yy2430;
		if (yych <= 0xBF) goto yy2437;
		goto yy2430;
yy2433:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy2430;
		if (yych <= 0xBF) goto yy2437;
		goto yy2430;
yy2434:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x8F) goto yy2430;
		if (yych <= 0xBF) goto yy2440;
		goto yy2430;
yy2435:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy2430;
		if (yych <= 0xBF) goto yy2440;
		goto yy2430;
yy2436:
		yyaccept = 1;
		yych = *(marker_ = ++cursor_);
		if (yych <= 0x7F) goto yy2430;
		if (yych <= 0x8F) goto yy2440;
		goto yy2430;
yy2437:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy2438;
		if (yych <= 0xBF) goto yy2424;
yy2438:
		cursor_ = marker_;
		if (yyaccept == 0) {
			goto yy2426;
		} else {
			goto yy2430;
		}
yy2439:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x9F) goto yy2438;
		if (yych <= 0xBF) goto yy2437;
		goto yy2438;
yy2440:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy2438;
		if (yych <= 0xBF) goto yy2437;
		goto yy2438;
yy2441:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x8F) goto yy2438;
		if (yych <= 0xBF) goto yy2440;
		goto yy2438;
yy2442:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy2438;
		if (yych <= 0xBF) goto yy2440;
		goto yy2438;
yy2443:
		++cursor_;
		if (limit_ <= cursor_) FILL(1);
		yych = *cursor_;
		if (yych <= 0x7F) goto yy2438;
		if (yych <= 0x8F) goto yy2440;
		goto yy2438;
	}
/* *********************************** */
YYCOND_BLOCK_COMMENT:
	if ((limit_ - cursor_) < 4) FILL(4);
	yych = *cursor_;
	if (yych <= 0x7F) {
		if (yych <= '\'') {
			if (yych == '\n') goto yy2448;
		} else {
			if (yych <= '(') goto yy2450;
			if (yych == ';') goto yy2451;
		}
	} else {
		if (yych <= 0xEF) {
			if (yych <= 0xC1) goto yy2452;
			if (yych <= 0xDF) goto yy2454;
			if (yych <= 0xE0) goto yy2455;
			goto yy2456;
		} else {
			if (yych <= 0xF0) goto yy2457;
			if (yych <= 0xF3) goto yy2458;
			if (yych <= 0xF4) goto yy2459;
			goto yy2452;
		}
	}
yy2446:
	++cursor_;
yy2447:
#line 709 "src/wast-lexer.cc"
	{ continue; }
#line 12084 "src/prebuilt/wast-lexer-gen.cc"
yy2448:
	++cursor_;
#line 708 "src/wast-lexer.cc"
	{ NEWLINE; continue; }
#line 12089 "src/prebuilt/wast-lexer-gen.cc"
yy2450:
	yych = *++cursor_;
	if (yych == ';') goto yy2460;
	goto yy2447;
yy2451:
	yych = *++cursor_;
	if (yych == ')') goto yy2462;
	goto yy2447;
yy2452:
	++cursor_;
yy2453:
#line 710 "src/wast-lexer.cc"
	{ MAYBE_MALFORMED_UTF8(" in block comment"); }
#line 12103 "src/prebuilt/wast-lexer-gen.cc"
yy2454:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2453;
	if (yych <= 0xBF) goto yy2446;
	goto yy2453;
yy2455:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x9F) goto yy2453;
	if (yych <= 0xBF) goto yy2464;
	goto yy2453;
yy2456:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2453;
	if (yych <= 0xBF) goto yy2464;
	goto yy2453;
yy2457:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x8F) goto yy2453;
	if (yych <= 0xBF) goto yy2466;
	goto yy2453;
yy2458:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2453;
	if (yych <= 0xBF) goto yy2466;
	goto yy2453;
yy2459:
	yych = *(marker_ = ++cursor_);
	if (yych <= 0x7F) goto yy2453;
	if (yych <= 0x8F) goto yy2466;
	goto yy2453;
yy2460:
	++cursor_;
#line 703 "src/wast-lexer.cc"
	{ COMMENT_NESTING++; continue; }
#line 12138 "src/prebuilt/wast-lexer-gen.cc"
yy2462:
	++cursor_;
#line 704 "src/wast-lexer.cc"
	{ if (--COMMENT_NESTING == 0) {
                                    BEGIN(YYCOND_i);
                                  }
                                  continue; }
#line 12146 "src/prebuilt/wast-lexer-gen.cc"
yy2464:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2465;
	if (yych <= 0xBF) goto yy2446;
yy2465:
	cursor_ = marker_;
	goto yy2453;
yy2466:
	yych = *++cursor_;
	if (yych <= 0x7F) goto yy2465;
	if (yych <= 0xBF) goto yy2464;
	goto yy2465;
}
#line 716 "src/wast-lexer.cc"

  }
}

}  // namespace wabt
