# Node.js 16 ChangeLog

<!--lint disable prohibited-strings-->
<!--lint disable maximum-line-length-->
<!--lint disable no-literal-urls-->

<table>
<tr>
<th>Current</th>
</tr>
<tr>
<td>
<a href="#16.9.0">16.9.0</a><br/>
<a href="#16.8.0">16.8.0</a><br/>
<a href="#16.7.0">16.7.0</a><br/>
<a href="#16.6.2">16.6.2</a><br/>
<a href="#16.6.1">16.6.1</a><br/>
<a href="#16.6.0">16.6.0</a><br/>
<a href="#16.5.0">16.5.0</a><br/>
<a href="#16.4.2">16.4.2</a><br/>
<a href="#16.4.1">16.4.1</a><br/>
<a href="#16.4.0">16.4.0</a><br/>
<a href="#16.3.0">16.3.0</a><br/>
<a href="#16.2.0">16.2.0</a><br/>
<a href="#16.1.0">16.1.0</a><br/>
<a href="#16.0.0">16.0.0</a><br/>
</td>
</tr>
</table>

* Other Versions
  * [15.x](CHANGELOG_V15.md)
  * [14.x](CHANGELOG_V14.md)
  * [13.x](CHANGELOG_V13.md)
  * [12.x](CHANGELOG_V12.md)
  * [11.x](CHANGELOG_V11.md)
  * [10.x](CHANGELOG_V10.md)
  * [9.x](CHANGELOG_V9.md)
  * [8.x](CHANGELOG_V8.md)
  * [7.x](CHANGELOG_V7.md)
  * [6.x](CHANGELOG_V6.md)
  * [5.x](CHANGELOG_V5.md)
  * [4.x](CHANGELOG_V4.md)
  * [0.12.x](CHANGELOG_V012.md)
  * [0.10.x](CHANGELOG_V010.md)
  * [io.js](CHANGELOG_IOJS.md)
  * [Archive](CHANGELOG_ARCHIVE.md)

<a id="16.9.0"></a>
## 2021-09-07, Version 16.9.0 (Current), @targos

### Notable Changes

#### Corepack

Node.js now includes Corepack, a script that acts as a bridge between Node.js projects and the package managers they are intended to be used with during development.
In practical terms, **Corepack will let you use Yarn and pnpm without having to install them** - just like what currently happens with npm, which is shipped in Node.js by default.
Please head over to the [Corepack documentation page](https://nodejs.org/dist/latest-v16.x/docs/api/corepack.html) for more information on how to use it.

Contributed by Maël Nison - [#39608](https://github.com/nodejs/node/pull/39608)

#### V8 9.3

V8 is updated to version [9.3](https://v8.dev/blog/v8-release-93), which includes performance improvements and new JavaScript features.

#### [`Object.hasOwn`](https://v8.dev/features/object-has-own)

`Object.hasOwn` is a static alias for `Object.prototype.hasOwnProperty.call`:

```js
Object.hasOwn({ value: 42 }, 'value'); // Returns `true`.
```

#### [Error cause](https://v8.dev/features/error-cause)

Errors can now be optionally constructed with a `cause` option, pointing to another error.
This adds a `cause` property on the new error:

```js
const error1 = new Error('Error one');
const error2 = new Error('Error two', { cause: error1 });
// error2.cause === error1
```

Contributed by Michaël Zasso - [#39947](https://github.com/nodejs/node/pull/39947)

#### Other Notable Changes

* [[`34c627e4bc`](https://github.com/nodejs/node/commit/34c627e4bc)] - **(SEMVER-MINOR)** **crypto**: add RSA-PSS params to asymmetricKeyDetails (Tobias Nießen) [#39851](https://github.com/nodejs/node/pull/39851)
* [[`20da0a5379`](https://github.com/nodejs/node/commit/20da0a5379)] - **(SEMVER-MINOR)** **module**: support pattern trailers (Guy Bedford) [#39635](https://github.com/nodejs/node/pull/39635)
* [[`cb44781371`](https://github.com/nodejs/node/commit/cb44781371)] - **(SEMVER-MINOR)** **stream**: add stream.compose (Robert Nagy) [#39029](https://github.com/nodejs/node/pull/39029)

### Commits

* [[`2343c394fb`](https://github.com/nodejs/node/commit/2343c394fb)] - **async_hooks**: use resource stack for AsyncLocalStorage run (Stephen Belanger) [#39890](https://github.com/nodejs/node/pull/39890)
* [[`00951827cd`](https://github.com/nodejs/node/commit/00951827cd)] - ***Revert*** "**build**: add windows-2022 to GitHub test matrix" (Michaël Zasso) [#39982](https://github.com/nodejs/node/pull/39982)
* [[`e7834535b3`](https://github.com/nodejs/node/commit/e7834535b3)] - **build**: add windows-2022 to GitHub test matrix (Michaël Zasso) [#39857](https://github.com/nodejs/node/pull/39857)
* [[`c49b0c0dd4`](https://github.com/nodejs/node/commit/c49b0c0dd4)] - **build**: add support for Visual Studio 2022 (Michaël Zasso) [#39857](https://github.com/nodejs/node/pull/39857)
* [[`afdb665e57`](https://github.com/nodejs/node/commit/afdb665e57)] - **build**: fix find-inactive-collaborators workflow token (Rich Trott) [#39909](https://github.com/nodejs/node/pull/39909)
* [[`0ff88f362f`](https://github.com/nodejs/node/commit/0ff88f362f)] - **build**: update token used for pull requests (Rich Trott) [#39907](https://github.com/nodejs/node/pull/39907)
* [[`beca890330`](https://github.com/nodejs/node/commit/beca890330)] - **build**: adapt v8\_pch.h to V8 9.3 (Michaël Zasso) [#39469](https://github.com/nodejs/node/pull/39469)
* [[`2170346aa3`](https://github.com/nodejs/node/commit/2170346aa3)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#39947](https://github.com/nodejs/node/pull/39947)
* [[`d33ab968ab`](https://github.com/nodejs/node/commit/d33ab968ab)] - **cluster**: fix comment regarding child\_process file (Yash Ladha) [#39308](https://github.com/nodejs/node/pull/39308)
* [[`585199497f`](https://github.com/nodejs/node/commit/585199497f)] - **crypto**: fix regression in RSA-PSS keygen (Tobias Nießen) [#39937](https://github.com/nodejs/node/pull/39937)
* [[`34c627e4bc`](https://github.com/nodejs/node/commit/34c627e4bc)] - **(SEMVER-MINOR)** **crypto**: add RSA-PSS params to asymmetricKeyDetails (Tobias Nießen) [#39851](https://github.com/nodejs/node/pull/39851)
* [[`1dd91582da`](https://github.com/nodejs/node/commit/1dd91582da)] - **crypto**: fix rsa-pss one-shot sign/verify error handling (Filip Skokan) [#39830](https://github.com/nodejs/node/pull/39830)
* [[`20cf47004e`](https://github.com/nodejs/node/commit/20cf47004e)] - **crypto**: fix JWK RSA-PSS SubtleCrypto.exportKey (Filip Skokan) [#39828](https://github.com/nodejs/node/pull/39828)
* [[`e25dc8e470`](https://github.com/nodejs/node/commit/e25dc8e470)] - **deps**: upgrade npm to 7.21.1 (npm team) [#39904](https://github.com/nodejs/node/pull/39904)
* [[`9270684837`](https://github.com/nodejs/node/commit/9270684837)] - **deps**: update archs files for OpenSSL-1.1.1l+quic (Richard Lau) [#39867](https://github.com/nodejs/node/pull/39867)
* [[`4b5bbec6cc`](https://github.com/nodejs/node/commit/4b5bbec6cc)] - **deps**: upgrade openssl sources to OpenSSL\_1\_1\_1l+quic (Richard Lau) [#39867](https://github.com/nodejs/node/pull/39867)
* [[`71659fd4ba`](https://github.com/nodejs/node/commit/71659fd4ba)] - **(SEMVER-MINOR)** **deps**: add corepack (Maël Nison) [#39608](https://github.com/nodejs/node/pull/39608)
* [[`7470db0dfb`](https://github.com/nodejs/node/commit/7470db0dfb)] - **deps**: restore minimum ICU version to 68 (Michaël Zasso) [#39470](https://github.com/nodejs/node/pull/39470)
* [[`92d83d18d2`](https://github.com/nodejs/node/commit/92d83d18d2)] - **deps**: make V8 9.3 abi-compatible with 9.0 (Michaël Zasso) [#39947](https://github.com/nodejs/node/pull/39947)
* [[`0140face81`](https://github.com/nodejs/node/commit/0140face81)] - **deps**: V8: cherry-pick 00bb1a77c03e (Darshan Sen) [#39829](https://github.com/nodejs/node/pull/39829)
* [[`3e1053e755`](https://github.com/nodejs/node/commit/3e1053e755)] - **deps**: V8: cherry-pick 81814ed44574 (Stephen Belanger) [#39719](https://github.com/nodejs/node/pull/39719)
* [[`d9d0104878`](https://github.com/nodejs/node/commit/d9d0104878)] - **deps**: silence irrelevant V8 warning (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`cd9b03ea40`](https://github.com/nodejs/node/commit/cd9b03ea40)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`b83cab712f`](https://github.com/nodejs/node/commit/b83cab712f)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`068824d754`](https://github.com/nodejs/node/commit/068824d754)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`54f4f1af50`](https://github.com/nodejs/node/commit/54f4f1af50)] - **deps**: V8: forward declaration of `Rtl*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`10ba1cb8b2`](https://github.com/nodejs/node/commit/10ba1cb8b2)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`3ce6f72124`](https://github.com/nodejs/node/commit/3ce6f72124)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`f43c292520`](https://github.com/nodejs/node/commit/f43c292520)] - **(SEMVER-MINOR)** **deps**: update V8 to 9.3.345.16 (Michaël Zasso) [#39947](https://github.com/nodejs/node/pull/39947)
* [[`9e782eb758`](https://github.com/nodejs/node/commit/9e782eb758)] - **doc**: remove {C,Dec}ompressionStream documentation (Luigi Pinca) [#39899](https://github.com/nodejs/node/pull/39899)
* [[`7857e9cc77`](https://github.com/nodejs/node/commit/7857e9cc77)] - **doc**: add descriptions about when `options.mode` is ignored (Ray) [#39881](https://github.com/nodejs/node/pull/39881)
* [[`d43b555047`](https://github.com/nodejs/node/commit/d43b555047)] - **doc**: remove danbev from TSC member list (Daniel Bevenius) [#39978](https://github.com/nodejs/node/pull/39978)
* [[`fc01dd916e`](https://github.com/nodejs/node/commit/fc01dd916e)] - **doc**: add missing changes to generateKeyPair(Sync) (Tobias Nießen) [#39963](https://github.com/nodejs/node/pull/39963)
* [[`953f2e9f88`](https://github.com/nodejs/node/commit/953f2e9f88)] - **doc**: add nodejs/tweet issue creation to sec. doc (Daniel Bevenius) [#39940](https://github.com/nodejs/node/pull/39940)
* [[`29c4b07716`](https://github.com/nodejs/node/commit/29c4b07716)] - **doc**: update WASI example to use import.meta.url (Guy Bedford) [#39925](https://github.com/nodejs/node/pull/39925)
* [[`9eb4a70c14`](https://github.com/nodejs/node/commit/9eb4a70c14)] - **doc**: move reference to OpenSSL flags SSL\_OP\_\* (Tobias Nießen) [#39935](https://github.com/nodejs/node/pull/39935)
* [[`8ea4befc82`](https://github.com/nodejs/node/commit/8ea4befc82)] - **doc**: add docs for duplex.allowHalfOpen property (Tim Perry) [#39126](https://github.com/nodejs/node/pull/39126)
* [[`bc2b73ec9b`](https://github.com/nodejs/node/commit/bc2b73ec9b)] - **doc**: add FrankQiu to a triager (FrankQiu) [#39922](https://github.com/nodejs/node/pull/39922)
* [[`8b68f8ec38`](https://github.com/nodejs/node/commit/8b68f8ec38)] - **doc**: add VoltrexMaster to triagers (voltrexmaster) [#39920](https://github.com/nodejs/node/pull/39920)
* [[`3a8f77ac0d`](https://github.com/nodejs/node/commit/3a8f77ac0d)] - **doc**: document JavaScript tool for benchmark comparison (Michaël Zasso) [#39835](https://github.com/nodejs/node/pull/39835)
* [[`4ac703ca8e`](https://github.com/nodejs/node/commit/4ac703ca8e)] - **doc**: add Mesteery to triagers (Mestery) [#39887](https://github.com/nodejs/node/pull/39887)
* [[`d059a5186b`](https://github.com/nodejs/node/commit/d059a5186b)] - **doc**: update maintaining openssl guide (Richard Lau) [#39878](https://github.com/nodejs/node/pull/39878)
* [[`486150580c`](https://github.com/nodejs/node/commit/486150580c)] - **doc**: move ERR\_WORKER\_UNSPPORTED\_EXTENSION to legacy (Qingyu Deng) [#39788](https://github.com/nodejs/node/pull/39788)
* [[`a4b8c13798`](https://github.com/nodejs/node/commit/a4b8c13798)] - **events**: protect property defs against prototype polution (James M Snell) [#39773](https://github.com/nodejs/node/pull/39773)
* [[`cfbe9065ae`](https://github.com/nodejs/node/commit/cfbe9065ae)] - **events**: add brand checks for detached accessors (James M Snell) [#39773](https://github.com/nodejs/node/pull/39773)
* [[`112af69194`](https://github.com/nodejs/node/commit/112af69194)] - **fs**: add docs and tests for `AsyncIterable` support in `fh.writeFile` (Antoine du Hamel) [#39836](https://github.com/nodejs/node/pull/39836)
* [[`402071bc45`](https://github.com/nodejs/node/commit/402071bc45)] - **meta**: remove duplicate AUTHORS entry for NigelKibodeaux (Rich Trott) [#39967](https://github.com/nodejs/node/pull/39967)
* [[`3588f07603`](https://github.com/nodejs/node/commit/3588f07603)] - **meta**: add mailmap entry for Ethan-Arrowood (Rich Trott) [#39930](https://github.com/nodejs/node/pull/39930)
* [[`259e0cf4d7`](https://github.com/nodejs/node/commit/259e0cf4d7)] - **meta**: add mailmap entry for branisha (Rich Trott) [#39889](https://github.com/nodejs/node/pull/39889)
* [[`bc236a6714`](https://github.com/nodejs/node/commit/bc236a6714)] - **meta**: update .mailmap to remove duplicate AUTHORS entry for addaleax (Rich Trott) [#39880](https://github.com/nodejs/node/pull/39880)
* [[`20da0a5379`](https://github.com/nodejs/node/commit/20da0a5379)] - **(SEMVER-MINOR)** **module**: support pattern trailers (Guy Bedford) [#39635](https://github.com/nodejs/node/pull/39635)
* [[`879dc4658e`](https://github.com/nodejs/node/commit/879dc4658e)] - **src**: remove usage of AllocatedBuffer from src/node\_buffer.cc (Darshan Sen) [#39941](https://github.com/nodejs/node/pull/39941)
* [[`79ce096470`](https://github.com/nodejs/node/commit/79ce096470)] - **src**: remove extra semicolons outside fns (Shelley Vohr) [#39800](https://github.com/nodejs/node/pull/39800)
* [[`cb44781371`](https://github.com/nodejs/node/commit/cb44781371)] - **(SEMVER-MINOR)** **stream**: add stream.compose (Robert Nagy) [#39029](https://github.com/nodejs/node/pull/39029)
* [[`ca9b781d20`](https://github.com/nodejs/node/commit/ca9b781d20)] - **test**: use `assert.match` instead of `regexp.test` (Michaël Zasso) [#39928](https://github.com/nodejs/node/pull/39928)
* [[`007e2855af`](https://github.com/nodejs/node/commit/007e2855af)] - **test**: use error code mapping in place of raw errno (Darshan Sen) [#38675](https://github.com/nodejs/node/pull/38675)
* [[`00529b0ef2`](https://github.com/nodejs/node/commit/00529b0ef2)] - **test**: add test to verify other extension can be loaded by worker (Qingyu Deng) [#39788](https://github.com/nodejs/node/pull/39788)
* [[`4e7212c88c`](https://github.com/nodejs/node/commit/4e7212c88c)] - **test**: update error message keywords (leeight) [#39826](https://github.com/nodejs/node/pull/39826)
* [[`549d717722`](https://github.com/nodejs/node/commit/549d717722)] - **test**: adapt test-fs-read to V8 9.3 (Michaël Zasso) [#39469](https://github.com/nodejs/node/pull/39469)
* [[`644b25e068`](https://github.com/nodejs/node/commit/644b25e068)] - **test**: adapt test-util-inspect to V8 9.3 (Michaël Zasso) [#39469](https://github.com/nodejs/node/pull/39469)
* [[`105bff9ea5`](https://github.com/nodejs/node/commit/105bff9ea5)] - **test**: adapt test-v8-flags to V8 9.3 (Michaël Zasso) [#39469](https://github.com/nodejs/node/pull/39469)
* [[`d92bd9a982`](https://github.com/nodejs/node/commit/d92bd9a982)] - **tools**: add support for import assertions in linter (Antoine du Hamel) [#39924](https://github.com/nodejs/node/pull/39924)
* [[`9763561e30`](https://github.com/nodejs/node/commit/9763561e30)] - **tools**: update gyp-next to v0.10.0 (Michaël Zasso) [#39857](https://github.com/nodejs/node/pull/39857)
* [[`9f105c73fc`](https://github.com/nodejs/node/commit/9f105c73fc)] - **tools**: update V8 gypfiles for 9.3 (Michaël Zasso) [#39469](https://github.com/nodejs/node/pull/39469)
* [[`16271d2f50`](https://github.com/nodejs/node/commit/16271d2f50)] - **worker**: remove file extension check (Qingyu Deng) [#39788](https://github.com/nodejs/node/pull/39788)
* [[`3b1ce93e03`](https://github.com/nodejs/node/commit/3b1ce93e03)] - **worker**: add brand checks for detached MessageEvent accessors (James M Snell) [#39773](https://github.com/nodejs/node/pull/39773)

<a id="16.8.0"></a>
## 2021-08-25, Version 16.8.0 (Current), @targos

### Notable Changes

* [[`2e90b10f35`](https://github.com/nodejs/node/commit/2e90b10f35)] - **doc**: deprecate type coercion for `dns.lookup` options (Antoine du Hamel) [#38906](https://github.com/nodejs/node/pull/38906)
* [[`a6d50a18a0`](https://github.com/nodejs/node/commit/a6d50a18a0)] - **(SEMVER-MINOR)** **stream**: add `stream.Duplex.from` utility (Robert Nagy) [#39519](https://github.com/nodejs/node/pull/39519)
* [[`af7047a815`](https://github.com/nodejs/node/commit/af7047a815)] - **(SEMVER-MINOR)** **stream**: add `isDisturbed` helper (Robert Nagy) [#39628](https://github.com/nodejs/node/pull/39628)
* [[`66400374de`](https://github.com/nodejs/node/commit/66400374de)] - **(SEMVER-MINOR)** **util**: expose `toUSVString` (Robert Nagy) [#39814](https://github.com/nodejs/node/pull/39814)

### Commits

* [[`90bf247a55`](https://github.com/nodejs/node/commit/90bf247a55)] - **build**: fix update authors commit (Mestery) [#39858](https://github.com/nodejs/node/pull/39858)
* [[`c968372e37`](https://github.com/nodejs/node/commit/c968372e37)] - **build**: add authors.yml (Tierney Cyren) [#35831](https://github.com/nodejs/node/pull/35831)
* [[`3f284cf65c`](https://github.com/nodejs/node/commit/3f284cf65c)] - **build**: add option to hide console window (Cheng Zhao) [#39712](https://github.com/nodejs/node/pull/39712)
* [[`a01e3ab41d`](https://github.com/nodejs/node/commit/a01e3ab41d)] - **deps**: V8: cherry-pick 00bb1a77c03e (Darshan Sen) [#39829](https://github.com/nodejs/node/pull/39829)
* [[`cce95c4c5b`](https://github.com/nodejs/node/commit/cce95c4c5b)] - **deps**: upgrade npm to 7.21.0 (Myles Borins) [#39813](https://github.com/nodejs/node/pull/39813)
* [[`254810a22e`](https://github.com/nodejs/node/commit/254810a22e)] - **doc**: add duplicate CVE check in sec. release doc (Daniel Bevenius) [#39845](https://github.com/nodejs/node/pull/39845)
* [[`8c50d16712`](https://github.com/nodejs/node/commit/8c50d16712)] - **doc**: improve description of the triagers team (Michaël Zasso) [#39833](https://github.com/nodejs/node/pull/39833)
* [[`c02165d992`](https://github.com/nodejs/node/commit/c02165d992)] - **doc**: update instructions for cc (Michael Dawson) [#39674](https://github.com/nodejs/node/pull/39674)
* [[`208305fd8f`](https://github.com/nodejs/node/commit/208305fd8f)] - **doc**: move util.toUSVString() outside of deprecated group (Luigi Pinca) [#39840](https://github.com/nodejs/node/pull/39840)
* [[`2e90b10f35`](https://github.com/nodejs/node/commit/2e90b10f35)] - **doc**: deprecate type coercion for `dns.lookup` options (Antoine du Hamel) [#38906](https://github.com/nodejs/node/pull/38906)
* [[`8460a3216c`](https://github.com/nodejs/node/commit/8460a3216c)] - **doc**: deprecate using non-boolean values in the `verbatim` option (Antoine du Hamel) [#38906](https://github.com/nodejs/node/pull/38906)
* [[`3041d57201`](https://github.com/nodejs/node/commit/3041d57201)] - **doc**: fix malformed changelog entries (Rich Trott) [#39791](https://github.com/nodejs/node/pull/39791)
* [[`2b02f747c3`](https://github.com/nodejs/node/commit/2b02f747c3)] - **doc**: fix lint errors in packages.md (Rich Trott) [#39792](https://github.com/nodejs/node/pull/39792)
* [[`a387600d8f`](https://github.com/nodejs/node/commit/a387600d8f)] - **doc**: add example of self-reference in scoped packages (Jesús Leganés-Combarro 'piranna) [#37630](https://github.com/nodejs/node/pull/37630)
* [[`7a25bf3a6d`](https://github.com/nodejs/node/commit/7a25bf3a6d)] - **doc**: add himadriganguly as a triager (Himadri Ganguly) [#39757](https://github.com/nodejs/node/pull/39757)
* [[`d1900f43ce`](https://github.com/nodejs/node/commit/d1900f43ce)] - **fs**: combine require() and destructure (Colin Ihrig) [#39806](https://github.com/nodejs/node/pull/39806)
* [[`158d4464d2`](https://github.com/nodejs/node/commit/158d4464d2)] - **meta**: add gyp as owner of gyp files and tools/gyp (Mary Marchini) [#34847](https://github.com/nodejs/node/pull/34847)
* [[`8fa38500f2`](https://github.com/nodejs/node/commit/8fa38500f2)] - **policy**: canonicalize before resolving specifiers (Bradley Farias) [#37863](https://github.com/nodejs/node/pull/37863)
* [[`a7a217be13`](https://github.com/nodejs/node/commit/a7a217be13)] - **repl**: fix tla function hoisting (Don Jayamanne) [#39745](https://github.com/nodejs/node/pull/39745)
* [[`3a8399ee61`](https://github.com/nodejs/node/commit/3a8399ee61)] - **src**: return Maybe\<bool\> from InitializeContextRuntime() (Darshan Sen) [#39695](https://github.com/nodejs/node/pull/39695)
* [[`a704c9dfce`](https://github.com/nodejs/node/commit/a704c9dfce)] - **(SEMVER-MINOR)** **src**: call overload ctor from the original ctor (Darshan Sen) [#39768](https://github.com/nodejs/node/pull/39768)
* [[`0918ea0683`](https://github.com/nodejs/node/commit/0918ea0683)] - **(SEMVER-MINOR)** **src**: add a constructor overload for CallbackScope (Darshan Sen) [#39768](https://github.com/nodejs/node/pull/39768)
* [[`a6d50a18a0`](https://github.com/nodejs/node/commit/a6d50a18a0)] - **(SEMVER-MINOR)** **stream**: duplexify (Robert Nagy) [#39519](https://github.com/nodejs/node/pull/39519)
* [[`af7047a815`](https://github.com/nodejs/node/commit/af7047a815)] - **(SEMVER-MINOR)** **stream**: add isDisturbed helper (Robert Nagy) [#39628](https://github.com/nodejs/node/pull/39628)
* [[`f98311a7c8`](https://github.com/nodejs/node/commit/f98311a7c8)] - **tools**: update workflow to open a pull request (Rich Trott) [#39825](https://github.com/nodejs/node/pull/39825)
* [[`d33f897509`](https://github.com/nodejs/node/commit/d33f897509)] - **tools**: use find-inactive-collaborators to modify README.md (Rich Trott) [#39825](https://github.com/nodejs/node/pull/39825)
* [[`d82ee96861`](https://github.com/nodejs/node/commit/d82ee96861)] - **tools**: update gyp-next to v0.9.5 (Jiawen Geng) [#39818](https://github.com/nodejs/node/pull/39818)
* [[`79079ea01b`](https://github.com/nodejs/node/commit/79079ea01b)] - **tools**: fix markdown linting (Rich Trott) [#39832](https://github.com/nodejs/node/pull/39832)
* [[`01093b07cc`](https://github.com/nodejs/node/commit/01093b07cc)] - **tools**: update markdown linter dependencies and move to ESM (Antoine du Hamel) [#39801](https://github.com/nodejs/node/pull/39801)
* [[`9dc0c91392`](https://github.com/nodejs/node/commit/9dc0c91392)] - **tools**: update rollup to latest version in markdown linter (Rich Trott) [#39797](https://github.com/nodejs/node/pull/39797)
* [[`c34e2534ab`](https://github.com/nodejs/node/commit/c34e2534ab)] - **tools**: update markdown lint dependencies (Rich Trott) [#39770](https://github.com/nodejs/node/pull/39770)
* [[`66400374de`](https://github.com/nodejs/node/commit/66400374de)] - **(SEMVER-MINOR)** **util**: expose toUSVString (Robert Nagy) [#39814](https://github.com/nodejs/node/pull/39814)

<a id="16.7.0"></a>
## 2021-08-17, Version 16.7.0 (Current), @danielleadams

### Notable Changes

* **fs**:
  * experimental: add recursive cp method (Benjamin Coe) [#39372](https://github.com/nodejs/node/pull/39372)

### Commits

* [[`a80c989306`](https://github.com/nodejs/node/commit/a80c989306)] - **async_hooks**: merge resource\_symbol with owner\_symbol (Darshan Sen) [#38468](https://github.com/nodejs/node/pull/38468)
* [[`69a2a6b6c3`](https://github.com/nodejs/node/commit/69a2a6b6c3)] - **bootstrap**: call \_undestroy() inside \_destroy for stdout and stderr (Matteo Collina) [#39685](https://github.com/nodejs/node/pull/39685)
* [[`5bc31ea0aa`](https://github.com/nodejs/node/commit/5bc31ea0aa)] - **buffer**: add endings option, remove Node.js specific encoding option (James M Snell) [#39708](https://github.com/nodejs/node/pull/39708)
* [[`091a579275`](https://github.com/nodejs/node/commit/091a579275)] - **(SEMVER-MINOR)** **buffer**: add Blob.prototype.stream method and other cleanups (James M Snell) [#39693](https://github.com/nodejs/node/pull/39693)
* [[`097d898e58`](https://github.com/nodejs/node/commit/097d898e58)] - **build**: run coverage for inspector protocol changes (Richard Lau) [#39725](https://github.com/nodejs/node/pull/39725)
* [[`cf028df0ed`](https://github.com/nodejs/node/commit/cf028df0ed)] - **build**: fix V8 build with pointer compression (Michaël Zasso) [#39664](https://github.com/nodejs/node/pull/39664)
* [[`9d38400de1`](https://github.com/nodejs/node/commit/9d38400de1)] - **build**: exclude markdown files from some GitHub Actions (Rich Trott) [#39565](https://github.com/nodejs/node/pull/39565)
* [[`eeb804a7b7`](https://github.com/nodejs/node/commit/eeb804a7b7)] - **build**: use lts shorthand in GitHub Actions (Rich Trott) [#39538](https://github.com/nodejs/node/pull/39538)
* [[`93a904d0ba`](https://github.com/nodejs/node/commit/93a904d0ba)] - **(SEMVER-MINOR)** **crypto**: implement webcrypto.randomUUID (Michaël Zasso) [#39648](https://github.com/nodejs/node/pull/39648)
* [[`3321b65a5a`](https://github.com/nodejs/node/commit/3321b65a5a)] - **debugger**: prevent simultaneous heap snapshots (Rich Trott) [#39638](https://github.com/nodejs/node/pull/39638)
* [[`6c375e18b6`](https://github.com/nodejs/node/commit/6c375e18b6)] - **debugger**: remove undefined parameter (Rich Trott) [#39570](https://github.com/nodejs/node/pull/39570)
* [[`103bf20988`](https://github.com/nodejs/node/commit/103bf20988)] - **deps**: V8: cherry-pick 81814ed44574 (Stephen Belanger) [#39719](https://github.com/nodejs/node/pull/39719)
* [[`cf5e5b5711`](https://github.com/nodejs/node/commit/cf5e5b5711)] - **deps**: upgrade to libuv 1.42.0 (Luigi Pinca) [#39525](https://github.com/nodejs/node/pull/39525)
* [[`5f92d2fe6d`](https://github.com/nodejs/node/commit/5f92d2fe6d)] - **dgram**: use simplified validator (Voltrex) [#39753](https://github.com/nodejs/node/pull/39753)
* [[`c7e918b06a`](https://github.com/nodejs/node/commit/c7e918b06a)] - **(SEMVER-MINOR)** **dns**: add "tries" option to Resolve options (Luan Devecchi) [#39610](https://github.com/nodejs/node/pull/39610)
* [[`5d66646b71`](https://github.com/nodejs/node/commit/5d66646b71)] - **doc**: correct cjs code to match mjs code (Raz Luvaton) [#39509](https://github.com/nodejs/node/pull/39509)
* [[`f18bb2a0f1`](https://github.com/nodejs/node/commit/f18bb2a0f1)] - **doc**: fix typo in hmac.paramNames default (Justin) [#39766](https://github.com/nodejs/node/pull/39766)
* [[`338a166e83`](https://github.com/nodejs/node/commit/338a166e83)] - **doc**: fix `fs.rmdir` `recursive` option deprecation history (Antoine du Hamel) [#39728](https://github.com/nodejs/node/pull/39728)
* [[`bfb1dc0a2c`](https://github.com/nodejs/node/commit/bfb1dc0a2c)] - **doc**: fixed variable names in queueMicrotask example (ashish maurya) [#39634](https://github.com/nodejs/node/pull/39634)
* [[`08b31f12f8`](https://github.com/nodejs/node/commit/08b31f12f8)] - **doc**: change "Version 4 UUID" to "version 4 UUID" (Tobias Nießen) [#39682](https://github.com/nodejs/node/pull/39682)
* [[`f5200f9785`](https://github.com/nodejs/node/commit/f5200f9785)] - **doc**: update debugger.md description and examples (Rich Trott) [#39661](https://github.com/nodejs/node/pull/39661)
* [[`4700f1e529`](https://github.com/nodejs/node/commit/4700f1e529)] - **doc**: fix color contrast issue in light mode (Rich Trott) [#39660](https://github.com/nodejs/node/pull/39660)
* [[`88c83a4698`](https://github.com/nodejs/node/commit/88c83a4698)] - **(SEMVER-MINOR)** **doc**: add missing change to resolver ctor (Luan Devecchi) [#39610](https://github.com/nodejs/node/pull/39610)
* [[`760cafa5ed`](https://github.com/nodejs/node/commit/760cafa5ed)] - **doc**: fix typo in `url.md` (Howie Zhao) [#39666](https://github.com/nodejs/node/pull/39666)
* [[`9ab5503693`](https://github.com/nodejs/node/commit/9ab5503693)] - **doc**: add point to ask H1 reporter about credit (Daniel Bevenius) [#39585](https://github.com/nodejs/node/pull/39585)
* [[`7514405456`](https://github.com/nodejs/node/commit/7514405456)] - **doc**: update min mac ver + move mac arm64 to tier 1 (Ash Cripps) [#39586](https://github.com/nodejs/node/pull/39586)
* [[`d7c8c6dcee`](https://github.com/nodejs/node/commit/d7c8c6dcee)] - **doc**: add missing `introduced_in` metadata (Richard Lau) [#39575](https://github.com/nodejs/node/pull/39575)
* [[`8072517097`](https://github.com/nodejs/node/commit/8072517097)] - **doc**: add code examples to `Writable.destroy()` and `Writable.destroyed` (Juan José Arboleda) [#39491](https://github.com/nodejs/node/pull/39491)
* [[`55f47cc2d0`](https://github.com/nodejs/node/commit/55f47cc2d0)] - **doc**: add `String.prototype.at` and `%TypedArray%.prototype.at` (Jordan Harband) [#39583](https://github.com/nodejs/node/pull/39583)
* [[`0c0412e2c4`](https://github.com/nodejs/node/commit/0c0412e2c4)] - **doc**: move `NODE_MODULE_VERSION` in release guide (Richard Lau) [#39544](https://github.com/nodejs/node/pull/39544)
* [[`5df74f9b21`](https://github.com/nodejs/node/commit/5df74f9b21)] - **doc**: remove outdated ARM information from release guide (Richard Lau) [#39544](https://github.com/nodejs/node/pull/39544)
* [[`8eccb11ea0`](https://github.com/nodejs/node/commit/8eccb11ea0)] - **doc**: fence command examples in release guide (Richard Lau) [#39544](https://github.com/nodejs/node/pull/39544)
* [[`0bd97e1f2d`](https://github.com/nodejs/node/commit/0bd97e1f2d)] - **doc**: update backport labels in release guide (Richard Lau) [#39544](https://github.com/nodejs/node/pull/39544)
* [[`2129ad6a0a`](https://github.com/nodejs/node/commit/2129ad6a0a)] - **doc**: add code example to `fs.truncate` method (Juan José Arboleda) [#39454](https://github.com/nodejs/node/pull/39454)
* [[`3ff5e153ef`](https://github.com/nodejs/node/commit/3ff5e153ef)] - **doc**: add code example to `http.createServer` method (Juan José Arboleda) [#39455](https://github.com/nodejs/node/pull/39455)
* [[`7d0c869cfa`](https://github.com/nodejs/node/commit/7d0c869cfa)] - **doc**: add PerformanceObserver `buffered` document (legendecas) [#39514](https://github.com/nodejs/node/pull/39514)
* [[`0dc167a03f`](https://github.com/nodejs/node/commit/0dc167a03f)] - **(SEMVER-MINOR)** **fs**: add recursive cp method (Benjamin Coe) [#39372](https://github.com/nodejs/node/pull/39372)
* [[`54dd3df943`](https://github.com/nodejs/node/commit/54dd3df943)] - **http**: decodes url.username and url.password for authorization header (Lew Gordon) [#39310](https://github.com/nodejs/node/pull/39310)
* [[`81e62f67bf`](https://github.com/nodejs/node/commit/81e62f67bf)] - **inspector**: update inspector\_protocol to 89c4adf (Rich Trott) [#39650](https://github.com/nodejs/node/pull/39650)
* [[`793fee4915`](https://github.com/nodejs/node/commit/793fee4915)] - **inspector**: update inspector\_protocol to 8ec18cf (Rich Trott) [#39614](https://github.com/nodejs/node/pull/39614)
* [[`5afdc1f4c0`](https://github.com/nodejs/node/commit/5afdc1f4c0)] - **lib**: simplify validators (Voltrex) [#39753](https://github.com/nodejs/node/pull/39753)
* [[`ca3cb96d25`](https://github.com/nodejs/node/commit/ca3cb96d25)] - **lib**: cleanup validation (Voltrex) [#39652](https://github.com/nodejs/node/pull/39652)
* [[`cc08d3062f`](https://github.com/nodejs/node/commit/cc08d3062f)] - **lib**: cleanup instance validation (Voltrex) [#39656](https://github.com/nodejs/node/pull/39656)
* [[`2751cdf6f9`](https://github.com/nodejs/node/commit/2751cdf6f9)] - **lib**: use helper for readability (Voltrex) [#39649](https://github.com/nodejs/node/pull/39649)
* [[`c68415cba2`](https://github.com/nodejs/node/commit/c68415cba2)] - **lib**: use validators (Voltrex) [#39663](https://github.com/nodejs/node/pull/39663)
* [[`be2d60dd1d`](https://github.com/nodejs/node/commit/be2d60dd1d)] - **lib**: use validator (Voltrex) [#39547](https://github.com/nodejs/node/pull/39547)
* [[`486d51ac0c`](https://github.com/nodejs/node/commit/486d51ac0c)] - **lib**: use `validateObject` (Voltrex) [#39605](https://github.com/nodejs/node/pull/39605)
* [[`058e882a2a`](https://github.com/nodejs/node/commit/058e882a2a)] - **lib**: use ERR\_ILLEGAL\_CONSTRUCTOR (Mestery) [#39556](https://github.com/nodejs/node/pull/39556)
* [[`07cadc4432`](https://github.com/nodejs/node/commit/07cadc4432)] - **meta**: consolidate AUTHORS entries for ooHmartY (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`6c788b8030`](https://github.com/nodejs/node/commit/6c788b8030)] - **meta**: consolidate AUTHORS entries for homosaur (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`07351edebe`](https://github.com/nodejs/node/commit/07351edebe)] - **meta**: consolidate AUTHORS entries for Ayase-252 (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`5fe282769b`](https://github.com/nodejs/node/commit/5fe282769b)] - **meta**: consolidate AUTHORS entries for robin-drexler (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`fc2a626357`](https://github.com/nodejs/node/commit/fc2a626357)] - **meta**: consolidate AUTHORS entries for samshull (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`67cfc66a47`](https://github.com/nodejs/node/commit/67cfc66a47)] - **meta**: update AUTHORS (Rich Trott) [#39705](https://github.com/nodejs/node/pull/39705)
* [[`91008fbdeb`](https://github.com/nodejs/node/commit/91008fbdeb)] - **meta**: consolidate email addresses for MarshallOfSound (Rich Trott) [#39651](https://github.com/nodejs/node/pull/39651)
* [[`a76b63536a`](https://github.com/nodejs/node/commit/a76b63536a)] - **meta**: consolidate email addresses for tadjik1 (Rich Trott) [#39651](https://github.com/nodejs/node/pull/39651)
* [[`aaab2095db`](https://github.com/nodejs/node/commit/aaab2095db)] - **meta**: consolidate email addresses for szmarczak (Rich Trott) [#39651](https://github.com/nodejs/node/pull/39651)
* [[`f413a9d83c`](https://github.com/nodejs/node/commit/f413a9d83c)] - **meta**: update AUTHORS (Rich Trott) [#39636](https://github.com/nodejs/node/pull/39636)
* [[`7a91d4bfe9`](https://github.com/nodejs/node/commit/7a91d4bfe9)] - **meta**: simplify mailmap (Rich Trott) [#39612](https://github.com/nodejs/node/pull/39612)
* [[`4ec5d2de5d`](https://github.com/nodejs/node/commit/4ec5d2de5d)] - **meta**: consolidate emails for tadhgcreedon (Rich Trott) [#39611](https://github.com/nodejs/node/pull/39611)
* [[`bb88c38eac`](https://github.com/nodejs/node/commit/bb88c38eac)] - **meta**: consolidate emails for timcosta (Rich Trott) [#39611](https://github.com/nodejs/node/pull/39611)
* [[`0920a8cf6f`](https://github.com/nodejs/node/commit/0920a8cf6f)] - **meta**: consolidate emails for timruffles (Rich Trott) [#39611](https://github.com/nodejs/node/pull/39611)
* [[`1474a9d4b1`](https://github.com/nodejs/node/commit/1474a9d4b1)] - **meta**: update AUTHORS (Rich Trott) [#39629](https://github.com/nodejs/node/pull/39629)
* [[`c59e3ec685`](https://github.com/nodejs/node/commit/c59e3ec685)] - **meta**: add mailmap entry for ryzokuken (Rich Trott) [#39596](https://github.com/nodejs/node/pull/39596)
* [[`34f4bb8277`](https://github.com/nodejs/node/commit/34f4bb8277)] - **meta**: add mailmap entry for uttampawar (Rich Trott) [#39596](https://github.com/nodejs/node/pull/39596)
* [[`fd213edda2`](https://github.com/nodejs/node/commit/fd213edda2)] - **meta**: add mailmap entry for dmabupt (Rich Trott) [#39596](https://github.com/nodejs/node/pull/39596)
* [[`6b664e224b`](https://github.com/nodejs/node/commit/6b664e224b)] - **meta**: align README/.mailmap/AUTHORS email entries (Rich Trott) [#39505](https://github.com/nodejs/node/pull/39505)
* [[`96d8ecbd66`](https://github.com/nodejs/node/commit/96d8ecbd66)] - **meta**: add mailmap entry for garygsc (Rich Trott) [#39588](https://github.com/nodejs/node/pull/39588)
* [[`16d85f3f48`](https://github.com/nodejs/node/commit/16d85f3f48)] - **meta**: add mailmap entry for ttzztztz (Rich Trott) [#39588](https://github.com/nodejs/node/pull/39588)
* [[`60ab111fdb`](https://github.com/nodejs/node/commit/60ab111fdb)] - **meta**: update AUTHORS (Rich Trott) [#39587](https://github.com/nodejs/node/pull/39587)
* [[`b43f87d729`](https://github.com/nodejs/node/commit/b43f87d729)] - **meta**: update .mailmap to remove duplication in AUTHORS (Rich Trott) [#39561](https://github.com/nodejs/node/pull/39561)
* [[`6f4a2aa5a4`](https://github.com/nodejs/node/commit/6f4a2aa5a4)] - **meta**: add .mailmap entries to remove AUTHORS duplicates (Rich Trott) [#39560](https://github.com/nodejs/node/pull/39560)
* [[`86d144c500`](https://github.com/nodejs/node/commit/86d144c500)] - **meta**: add .mailmap entry to remove duplication in AUTHORS (Rich Trott) [#39559](https://github.com/nodejs/node/pull/39559)
* [[`110c088f02`](https://github.com/nodejs/node/commit/110c088f02)] - **meta**: update collaborator email in AUTHORS/.mailmap (Rich Trott) [#39521](https://github.com/nodejs/node/pull/39521)
* [[`72af147bb5`](https://github.com/nodejs/node/commit/72af147bb5)] - **meta**: update collaborator email in README (Rich Trott) [#39521](https://github.com/nodejs/node/pull/39521)
* [[`23bc4cfb21`](https://github.com/nodejs/node/commit/23bc4cfb21)] - **meta**: update collaborator email in AUTHORS/.mailmap (Rich Trott) [#39521](https://github.com/nodejs/node/pull/39521)
* [[`e4289728c7`](https://github.com/nodejs/node/commit/e4289728c7)] - **meta**: move gdams to emeritus (Rich Trott) [#39539](https://github.com/nodejs/node/pull/39539)
* [[`4df59bc727`](https://github.com/nodejs/node/commit/4df59bc727)] - **module**: add some typings to `internal/modules/esm/resolve` (Antoine du Hamel) [#39504](https://github.com/nodejs/node/pull/39504)
* [[`b5858589d0`](https://github.com/nodejs/node/commit/b5858589d0)] - **node-api**: handle pending exception in cb wrapper (Michael Dawson) [#39476](https://github.com/nodejs/node/pull/39476)
* [[`016b7ba616`](https://github.com/nodejs/node/commit/016b7ba616)] - **perf_hooks**: fix PerformanceObserver gc crash (James M Snell) [#39550](https://github.com/nodejs/node/pull/39550)
* [[`b37575b67c`](https://github.com/nodejs/node/commit/b37575b67c)] - **perf_hooks**: fix performance timeline wpt failures (legendecas) [#39532](https://github.com/nodejs/node/pull/39532)
* [[`64c02eb3cc`](https://github.com/nodejs/node/commit/64c02eb3cc)] - **(SEMVER-MINOR)** **perf_hooks**: web performance timeline compliance (legendecas) [#39297](https://github.com/nodejs/node/pull/39297)
* [[`7ff21397d6`](https://github.com/nodejs/node/commit/7ff21397d6)] - **policy**: fix integrity when DEFAULT\_ENCODING is set (Tobias Nießen) [#39750](https://github.com/nodejs/node/pull/39750)
* [[`03be967cad`](https://github.com/nodejs/node/commit/03be967cad)] - **src**: fix TextDecoder final flush size calculation (James M Snell) [#39737](https://github.com/nodejs/node/pull/39737)
* [[`9046e78943`](https://github.com/nodejs/node/commit/9046e78943)] - **src**: fix crash in AfterGetAddrInfo (Anna Henningsen) [#39735](https://github.com/nodejs/node/pull/39735)
* [[`2a00ef5ede`](https://github.com/nodejs/node/commit/2a00ef5ede)] - **(SEMVER-MINOR)** **src**: fix align in cares\_wrap.h (Luan) [#39610](https://github.com/nodejs/node/pull/39610)
* [[`60a2b31c68`](https://github.com/nodejs/node/commit/60a2b31c68)] - **src**: add cosmetic space character to `async_wrap.h` file (Juan José Arboleda) [#39459](https://github.com/nodejs/node/pull/39459)
* [[`cd9b0bf68c`](https://github.com/nodejs/node/commit/cd9b0bf68c)] - **stream**: ensure text() stream consumer flushes correctly (James M Snell) [#39737](https://github.com/nodejs/node/pull/39737)
* [[`f57a0e4d8b`](https://github.com/nodejs/node/commit/f57a0e4d8b)] - **(SEMVER-MINOR)** **stream**: utility consumers for web and node.js streams (James M Snell) [#39594](https://github.com/nodejs/node/pull/39594)
* [[`975edf5330`](https://github.com/nodejs/node/commit/975edf5330)] - **stream**: clean `endWritableNT` (Mestery) [#39645](https://github.com/nodejs/node/pull/39645)
* [[`9e38fc6757`](https://github.com/nodejs/node/commit/9e38fc6757)] - **(SEMVER-MINOR)** **stream**: add readableDidRead if has been read from (Robert Nagy) [#39589](https://github.com/nodejs/node/pull/39589)
* [[`a5ded4a85a`](https://github.com/nodejs/node/commit/a5ded4a85a)] - **test**: use simplfied validator (voltrexmaster) [#39753](https://github.com/nodejs/node/pull/39753)
* [[`53cf53c95a`](https://github.com/nodejs/node/commit/53cf53c95a)] - **(SEMVER-MINOR)** **test**: enable blob.prototype.stream tests (James M Snell) [#39693](https://github.com/nodejs/node/pull/39693)
* [[`7e9884598f`](https://github.com/nodejs/node/commit/7e9884598f)] - **test**: update WPT abort tests (Michaël Zasso) [#39697](https://github.com/nodejs/node/pull/39697)
* [[`94381fbdf5`](https://github.com/nodejs/node/commit/94381fbdf5)] - **test**: update WPT common and resources (Michaël Zasso) [#39697](https://github.com/nodejs/node/pull/39697)
* [[`34a041a846`](https://github.com/nodejs/node/commit/34a041a846)] - **test**: fix test-debugger-heap-profiler for workers (Richard Lau) [#39687](https://github.com/nodejs/node/pull/39687)
* [[`9f5acfa90e`](https://github.com/nodejs/node/commit/9f5acfa90e)] - **test**: increase memory for coverage action (Benjamin Coe) [#39690](https://github.com/nodejs/node/pull/39690)
* [[`0be15cedc4`](https://github.com/nodejs/node/commit/0be15cedc4)] - **test**: use template to concatenate string (Himadri Ganguly) [#39621](https://github.com/nodejs/node/pull/39621)
* [[`952a5282e2`](https://github.com/nodejs/node/commit/952a5282e2)] - **(SEMVER-MINOR)** **test**: pull Web Platform Tests for WebCryptoAPI (Michaël Zasso) [#39648](https://github.com/nodejs/node/pull/39648)
* [[`3622fb1e03`](https://github.com/nodejs/node/commit/3622fb1e03)] - **test**: deflake test-http2-buffersize (Luigi Pinca) [#39591](https://github.com/nodejs/node/pull/39591)
* [[`1962c7c7b3`](https://github.com/nodejs/node/commit/1962c7c7b3)] - **test**: convert anonymous function to arrow function (Himadri Ganguly) [#39604](https://github.com/nodejs/node/pull/39604)
* [[`635e1a0274`](https://github.com/nodejs/node/commit/635e1a0274)] - **test**: add test-debugger-breakpoint-exists (Rich Trott) [#39570](https://github.com/nodejs/node/pull/39570)
* [[`cff2aea5df`](https://github.com/nodejs/node/commit/cff2aea5df)] - **test**: add known issues test for debugger heap snapshot race (Rich Trott) [#39557](https://github.com/nodejs/node/pull/39557)
* [[`5e1011238a`](https://github.com/nodejs/node/commit/5e1011238a)] - **tools**: bump remark-preset-lint-node to 3.0.0 (Rich Trott) [#39755](https://github.com/nodejs/node/pull/39755)
* [[`eb741253fd`](https://github.com/nodejs/node/commit/eb741253fd)] - **tools**: update path-parse in markdown linter package-lock file (Rich Trott) [#39729](https://github.com/nodejs/node/pull/39729)
* [[`52a172f983`](https://github.com/nodejs/node/commit/52a172f983)] - **tools**: fix more build warnings in inspector\_protocol (Richard Lau) [#39725](https://github.com/nodejs/node/pull/39725)
* [[`77f9c1fa98`](https://github.com/nodejs/node/commit/77f9c1fa98)] - **tools**: cherry-pick ffb34b6d5dbf0 (Darshan Sen) [#39725](https://github.com/nodejs/node/pull/39725)
* [[`b9510d21c9`](https://github.com/nodejs/node/commit/b9510d21c9)] - **tools**: update inspector\_protocol to e8ba1a7 (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`8d509d8773`](https://github.com/nodejs/node/commit/8d509d8773)] - **tools**: update inspector\_protocol to 39ca567 (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`ee7142fa37`](https://github.com/nodejs/node/commit/ee7142fa37)] - **tools**: update inspector\_protocol to 97d3146 (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`c6323d847d`](https://github.com/nodejs/node/commit/c6323d847d)] - ***Revert*** "**tools**: fix compiler warning in inspector\_protocol" (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`6e19c166e4`](https://github.com/nodejs/node/commit/6e19c166e4)] - **tools**: update inspector\_protocol to a53e96d31a2755eb16ca37 (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`61c53f39d2`](https://github.com/nodejs/node/commit/61c53f39d2)] - **tools**: update inspector\_protocol to fe0467fd105a (Rich Trott) [#39694](https://github.com/nodejs/node/pull/39694)
* [[`b1b6f20353`](https://github.com/nodejs/node/commit/b1b6f20353)] - **tools**: improve error detection in find-inactive-collaborators (Rich Trott) [#39617](https://github.com/nodejs/node/pull/39617)
* [[`d1360fcf48`](https://github.com/nodejs/node/commit/d1360fcf48)] - **tools**: update ESLint to 7.32.0 (Luigi Pinca) [#39602](https://github.com/nodejs/node/pull/39602)
* [[`af1c782cad`](https://github.com/nodejs/node/commit/af1c782cad)] - **tools**: update ESLint to 7.31.0 (Colin Ihrig) [#39424](https://github.com/nodejs/node/pull/39424)
* [[`37dda19461`](https://github.com/nodejs/node/commit/37dda19461)] - **(SEMVER-MINOR)** **url,buffer**: implement URL.createObjectURL (James M Snell) [#39693](https://github.com/nodejs/node/pull/39693)
* [[`dcab88ad38`](https://github.com/nodejs/node/commit/dcab88ad38)] - **worker**: add brand checks for detached properties/methods (James M Snell) [#39763](https://github.com/nodejs/node/pull/39763)

<a id="16.6.2"></a>
## 2021-08-11, Version 16.6.2 (Current), @BethGriggs

This is a security release.

### Notable Changes

* **CVE-2021-3672/CVE-2021-22931**: Improper handling of untypical characters in domain names (High)
  * Node.js was vulnerable to Remote Code Execution, XSS, application crashes due to missing input validation of hostnames returned by Domain Name Servers in the Node.js DNS library which can lead to the output of wrong hostnames (leading to Domain Hijacking) and injection vulnerabilities in applications using the library. You can read more about it at https://nvd.nist.gov/vuln/detail/CVE-2021-22931.
* **CVE-2021-22930**: Use after free on close http2 on stream canceling (High)
  * Node.js was vulnerable to a use after free attack where an attacker might be able to exploit memory corruption to change process behavior. This release includes a follow-up fix for CVE-2021-22930 as the issue was not completely resolved by the previous fix. You can read more about it at https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-22930.
* **CVE-2021-22939**: Incomplete validation of rejectUnauthorized parameter (Low)
  * If the Node.js HTTPS API was used incorrectly and "undefined" was in passed for the "rejectUnauthorized" parameter, no error was returned and connections to servers with an expired certificate would have been accepted. You can read more about it at https://nvd.nist.gov/vuln/detail/CVE-2021-22939.

### Commits

* [[`054537cdc2`](https://github.com/nodejs/node/commit/054537cdc2)] - **deps**: update c-ares to 1.17.2 (Beth Griggs) [#39724](https://github.com/nodejs/node/pull/39724)
* [[`ac544905b6`](https://github.com/nodejs/node/commit/ac544905b6)] - **deps**: reflect c-ares source tree (Beth Griggs) [#39653](https://github.com/nodejs/node/pull/39653)
* [[`a914b23cbc`](https://github.com/nodejs/node/commit/a914b23cbc)] - **deps**: apply missed updates from c-ares 1.17.1 (Beth Griggs) [#39653](https://github.com/nodejs/node/pull/39653)
* [[`31d5773654`](https://github.com/nodejs/node/commit/31d5773654)] - **http2**: add tests for cancel event while client is paused reading (Akshay K) [#39622](https://github.com/nodejs/node/pull/39622)
* [[`a3c33d4ce7`](https://github.com/nodejs/node/commit/a3c33d4ce7)] - **http2**: update handling of rst\_stream with error code NGHTTP2\_CANCEL (Akshay K) [#39622](https://github.com/nodejs/node/pull/39622)
* [[`6c7fff6f1d`](https://github.com/nodejs/node/commit/6c7fff6f1d)] - **tls**: validate "rejectUnauthorized: undefined" (Matteo Collina) [nodejs-private/node-private#276](https://github.com/nodejs-private/node-private/pull/276)

<a id="16.6.1"></a>
## 2021-08-03, Version 16.6.1 (Current), @targos

### Notable Changes

* Updated npm to 7.20.3 (npm team) [#39579](https://github.com/nodejs/node/pull/39579)
* Reverted an ABI-breaking change from V8 9.2 that could impact some native modules (Michaël Zasso) [#39624](https://github.com/nodejs/node/pull/39624)
* Fixed a bug in error handling known to affect at least Webpack and Jest (Guy Bedford) [#39593](https://github.com/nodejs/node/pull/39593)

### Commits

* [[`6c769ccedf`](https://github.com/nodejs/node/commit/6c769ccedf)] - **build**: override python executable path on configure (legendecas) [#39465](https://github.com/nodejs/node/pull/39465)
* [[`cbf6a01c17`](https://github.com/nodejs/node/commit/cbf6a01c17)] - **crypto**: fix `generateKeyPair` with encoding 'jwk' (himself65) [#39319](https://github.com/nodejs/node/pull/39319)
* [[`3091295609`](https://github.com/nodejs/node/commit/3091295609)] - **deps**: revert ABI-breaking change from V8 9.2 (Michaël Zasso) [#39624](https://github.com/nodejs/node/pull/39624)
* [[`06d7b8e8c8`](https://github.com/nodejs/node/commit/06d7b8e8c8)] - **deps**: upgrade npm to 7.20.3 (npm team) [#39579](https://github.com/nodejs/node/pull/39579)
* [[`7b612fadc2`](https://github.com/nodejs/node/commit/7b612fadc2)] - **doc**: fix crypto.hkdf callback derivedKey type (Filip Skokan) [#39453](https://github.com/nodejs/node/pull/39453)
* [[`7a731efd97`](https://github.com/nodejs/node/commit/7a731efd97)] - **doc,lib,test**: rename HKDF 'key' argument (Tobias Nießen) [#39474](https://github.com/nodejs/node/pull/39474)
* [[`93bbaa0ce9`](https://github.com/nodejs/node/commit/93bbaa0ce9)] - **module**: fix ERR\_REQUIRE\_ESM error for null frames (Guy Bedford) [#39593](https://github.com/nodejs/node/pull/39593)
* [[`e13162de09`](https://github.com/nodejs/node/commit/e13162de09)] - **module**: refine `enrichCJSError` (Antoine du Hamel) [#39507](https://github.com/nodejs/node/pull/39507)
* [[`815fbec6f1`](https://github.com/nodejs/node/commit/815fbec6f1)] - **repl**: do not include legacy getter/setter methods in completion (Anna Henningsen) [#39576](https://github.com/nodejs/node/pull/39576)
* [[`0405c8d3f0`](https://github.com/nodejs/node/commit/0405c8d3f0)] - **zlib**: avoid converting `Uint8Array` instances to `Buffer` (Antoine du Hamel) [#39492](https://github.com/nodejs/node/pull/39492)

<a id="16.6.0"></a>
## 2021-07-29, Version 16.6.0 (Current), @BethGriggs

This is a security release.

### Notable Changes

#### Say hello to V8 9.2

The V8 engine is updated to version 9.2.230.21.

It notably introduces the new [`Array.prototype.at`](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/at) method (also on [Typed Arrays](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/TypedArray/at) and [strings](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/at)):

```js
const array = [1, 2, 3];

console.log(array.at(-1));
// Prints: 3
```

Contributed by Michaël Zasso - [#39470](https://github.com/nodejs/node/pull/39470)

#### Other notable changes

* **CVE-2021-22930**: Use after free on close http2 on stream canceling (High) - [#39423](https://github.com/nodejs/node/pull/39423)
  * Node.js is vulnerable to a use after free attack where an attacker might be able to exploit the memory corruption, to change process behavior. You can read more about it in https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-22930
* [[`f93d2ac587`](https://github.com/nodejs/node/commit/f93d2ac587)] - **inspector**: mark as stable (Gireesh Punathil) [#37748](https://github.com/nodejs/node/pull/37748)
* [[`89b4770d5c`](https://github.com/nodejs/node/commit/89b4770d5c)] - **punycode**: add pending deprecation (Antoine du Hamel) [#38444](https://github.com/nodejs/node/pull/38444)
* [[`b67214fe31`](https://github.com/nodejs/node/commit/b67214fe31)] - **(SEMVER-MINOR)** **repl**: enable --experimental-repl-await /w opt-out (hemanth.hm) [#34733](https://github.com/nodejs/node/pull/34733)

### Commits

* [[`b5248d4000`](https://github.com/nodejs/node/commit/b5248d4000)] - **async_hooks**: emit promise trace events from JS (Stephen Belanger) [#39135](https://github.com/nodejs/node/pull/39135)
* [[`e18778d409`](https://github.com/nodejs/node/commit/e18778d409)] - **async_hooks**: eliminate native PromiseHook (Stephen Belanger) [#39135](https://github.com/nodejs/node/pull/39135)
* [[`90b9bb1a7d`](https://github.com/nodejs/node/commit/90b9bb1a7d)] - **build**: use Node.js 14 in commit-lint.yml (Rich Trott) [#39506](https://github.com/nodejs/node/pull/39506)
* [[`5182e26f14`](https://github.com/nodejs/node/commit/5182e26f14)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#39470](https://github.com/nodejs/node/pull/39470)
* [[`e1910ef290`](https://github.com/nodejs/node/commit/e1910ef290)] - **build**: fix `host_arch_cc()` for AIX/IBM i (Richard Lau) [#39481](https://github.com/nodejs/node/pull/39481)
* [[`ce2011b7a1`](https://github.com/nodejs/node/commit/ce2011b7a1)] - **build**: update coverage Makefile target comments (Richard Lau) [#39365](https://github.com/nodejs/node/pull/39365)
* [[`6b055f17b6`](https://github.com/nodejs/node/commit/6b055f17b6)] - **build**: run workflows when a PR is ready for review (Michaël Zasso) [#39405](https://github.com/nodejs/node/pull/39405)
* [[`25f45d5018`](https://github.com/nodejs/node/commit/25f45d5018)] - **build**: update to setup-node@v2 (Rich Trott) [#39366](https://github.com/nodejs/node/pull/39366)
* [[`a7472576d7`](https://github.com/nodejs/node/commit/a7472576d7)] - **build**: add `library_files` to gyp variables (himself65) [#39293](https://github.com/nodejs/node/pull/39293)
* [[`d16d36f1c2`](https://github.com/nodejs/node/commit/d16d36f1c2)] - **crypto**: support Big(U)Int64Array in getRandomValues (Michaël Zasso) [#39443](https://github.com/nodejs/node/pull/39443)
* [[`95db54482a`](https://github.com/nodejs/node/commit/95db54482a)] - **debugger**: validate sec-websocket-accept response header (Chris Opperwall) [#39357](https://github.com/nodejs/node/pull/39357)
* [[`3751b92fa2`](https://github.com/nodejs/node/commit/3751b92fa2)] - **debugger**: rename internal module (Rich Trott) [#39378](https://github.com/nodejs/node/pull/39378)
* [[`0e5eb8b17d`](https://github.com/nodejs/node/commit/0e5eb8b17d)] - **deps**: restore minimum ICU version to 68 (Michaël Zasso) [#39470](https://github.com/nodejs/node/pull/39470)
* [[`e8da1f25fb`](https://github.com/nodejs/node/commit/e8da1f25fb)] - **(SEMVER-MINOR)** **deps**: make V8 9.2 abi-compatible with 9.0 (Michaël Zasso) [#39470](https://github.com/nodejs/node/pull/39470)
* [[`a93e6ef777`](https://github.com/nodejs/node/commit/a93e6ef777)] - **deps**: V8: backport 5c76da8ddcf8 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`d612544199`](https://github.com/nodejs/node/commit/d612544199)] - **deps**: V8: cherry-pick 359d44df4cdd (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`c6ec2b4817`](https://github.com/nodejs/node/commit/c6ec2b4817)] - **deps**: V8: cherry-pick 3805a698f7b6 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`e6b84dfe84`](https://github.com/nodejs/node/commit/e6b84dfe84)] - **deps**: V8: cherry-pick 56fe020eec0c (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`2393fae427`](https://github.com/nodejs/node/commit/2393fae427)] - **deps**: V8: cherry-pick 2b77ca200c56 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`c8e7d80475`](https://github.com/nodejs/node/commit/c8e7d80475)] - **deps**: V8: cherry-pick 53784bdb8f01 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`65062b3e0d`](https://github.com/nodejs/node/commit/65062b3e0d)] - **deps**: V8: cherry-pick 7ff6609a5385 (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`c3efc70df7`](https://github.com/nodejs/node/commit/c3efc70df7)] - **deps**: V8: cherry-pick a5cea1bfc38c (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`201da87bc1`](https://github.com/nodejs/node/commit/201da87bc1)] - **deps**: V8: cherry-pick 986299250e6d (Richard Lau) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`794ad2e016`](https://github.com/nodejs/node/commit/794ad2e016)] - **deps**: V8: backport 71e8f8bb3c26 (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`53cc6c8000`](https://github.com/nodejs/node/commit/53cc6c8000)] - **deps**: V8: cherry-pick 3d24b3ab8af0 (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`7f7cb8bfe1`](https://github.com/nodejs/node/commit/7f7cb8bfe1)] - **deps**: silence irrelevant V8 warning (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`16cbd8c8b6`](https://github.com/nodejs/node/commit/16cbd8c8b6)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`98150e2bc6`](https://github.com/nodejs/node/commit/98150e2bc6)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`3f3e167fea`](https://github.com/nodejs/node/commit/3f3e167fea)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`785b8990de`](https://github.com/nodejs/node/commit/785b8990de)] - **deps**: V8: forward declaration of `Rtl*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`38cb655f04`](https://github.com/nodejs/node/commit/38cb655f04)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`9082ecef66`](https://github.com/nodejs/node/commit/9082ecef66)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`6114198717`](https://github.com/nodejs/node/commit/6114198717)] - **(SEMVER-MINOR)** **deps**: update V8 to 9.2.230.21 (Michaël Zasso) [#39470](https://github.com/nodejs/node/pull/39470)
* [[`89796d0c7f`](https://github.com/nodejs/node/commit/89796d0c7f)] - **deps**: bump HdrHistogram\_C to 0.11.2 (Matteo Collina) [#39462](https://github.com/nodejs/node/pull/39462)
* [[`9dd232c42b`](https://github.com/nodejs/node/commit/9dd232c42b)] - **deps**: update to cjs-module-lexer@1.2.2 (Guy Bedford) [#39402](https://github.com/nodejs/node/pull/39402)
* [[`626eb07fda`](https://github.com/nodejs/node/commit/626eb07fda)] - **deps**: extract gtest source files to deps/googletest (legendecas) [#39386](https://github.com/nodejs/node/pull/39386)
* [[`487c45ffd9`](https://github.com/nodejs/node/commit/487c45ffd9)] - **doc**: move lball@redhat.com to emeritus (Lance Ball) [#39501](https://github.com/nodejs/node/pull/39501)
* [[`5f84f47e13`](https://github.com/nodejs/node/commit/5f84f47e13)] - **doc**: update AUTHORS (Rich Trott) [#39488](https://github.com/nodejs/node/pull/39488)
* [[`1d27ae1514`](https://github.com/nodejs/node/commit/1d27ae1514)] - **doc**: update strategic initiative champion (Rich Trott) [#39487](https://github.com/nodejs/node/pull/39487)
* [[`e552b1a791`](https://github.com/nodejs/node/commit/e552b1a791)] - **doc**: improve node.js+fips instructions (Benjamin Mayr) [#39390](https://github.com/nodejs/node/pull/39390)
* [[`aa1dfb3111`](https://github.com/nodejs/node/commit/aa1dfb3111)] - **doc**: simplify unnecessarily specific .mailmap entries (Rich Trott) [#39430](https://github.com/nodejs/node/pull/39430)
* [[`ae69656c61`](https://github.com/nodejs/node/commit/ae69656c61)] - **doc**: update checkbox label in backporting guide (Darshan Sen) [#39420](https://github.com/nodejs/node/pull/39420)
* [[`4fd8db687d`](https://github.com/nodejs/node/commit/4fd8db687d)] - **doc**: remove \_Addenda\_ from headers (Rich Trott) [#39427](https://github.com/nodejs/node/pull/39427)
* [[`cefd2fb1e4`](https://github.com/nodejs/node/commit/cefd2fb1e4)] - **doc**: simplify .mailmap file (Rich Trott) [#39418](https://github.com/nodejs/node/pull/39418)
* [[`ade2eed9a6`](https://github.com/nodejs/node/commit/ade2eed9a6)] - **doc**: fix broken internal link in http.md (Rich Trott) [#39425](https://github.com/nodejs/node/pull/39425)
* [[`5fdfcc069f`](https://github.com/nodejs/node/commit/5fdfcc069f)] - **doc**: remove outdated step in onboarding exercise (Rich Trott) [#39410](https://github.com/nodejs/node/pull/39410)
* [[`94706c7012`](https://github.com/nodejs/node/commit/94706c7012)] - **doc**: revise strategic initiatives text (Rich Trott) [#39417](https://github.com/nodejs/node/pull/39417)
* [[`9932e3589c`](https://github.com/nodejs/node/commit/9932e3589c)] - **doc**: remove typo (extra ' character) (Nikita Rykov) [#39414](https://github.com/nodejs/node/pull/39414)
* [[`2b92b4ea2d`](https://github.com/nodejs/node/commit/2b92b4ea2d)] - **doc**: update mailmap and AUTHORS (Rich Trott) [#39393](https://github.com/nodejs/node/pull/39393)
* [[`6d6396594b`](https://github.com/nodejs/node/commit/6d6396594b)] - **doc**: use a details tag for completed initiatves (Rich Trott) [#39416](https://github.com/nodejs/node/pull/39416)
* [[`ac43e3331c`](https://github.com/nodejs/node/commit/ac43e3331c)] - **doc**: update commit-queue.md to indicate GitHub Actions are checked (Rich Trott) [#39411](https://github.com/nodejs/node/pull/39411)
* [[`75130c94d1`](https://github.com/nodejs/node/commit/75130c94d1)] - **doc**: use \_pull request\_ instead of \_PR\_ in onboarding doc (Rich Trott) [#39409](https://github.com/nodejs/node/pull/39409)
* [[`20bb3f6df0`](https://github.com/nodejs/node/commit/20bb3f6df0)] - **doc**: add strategic initiatives from TSC repo (Rich Trott) [#39394](https://github.com/nodejs/node/pull/39394)
* [[`6979313abb`](https://github.com/nodejs/node/commit/6979313abb)] - **doc**: standardize on \_pull request\_ (Rich Trott) [#39384](https://github.com/nodejs/node/pull/39384)
* [[`20124cc275`](https://github.com/nodejs/node/commit/20124cc275)] - **doc**: make minor edits to pull request text (Rich Trott) [#39383](https://github.com/nodejs/node/pull/39383)
* [[`11482f02cf`](https://github.com/nodejs/node/commit/11482f02cf)] - **doc**: add docker-node and build-wg issue contents (Daniel Bevenius) [#39215](https://github.com/nodejs/node/pull/39215)
* [[`c535956b6e`](https://github.com/nodejs/node/commit/c535956b6e)] - **doc**: add instructions for core vuln files (Daniel Bevenius) [#39220](https://github.com/nodejs/node/pull/39220)
* [[`353a8bb27b`](https://github.com/nodejs/node/commit/353a8bb27b)] - **doc**: standardize on not capitalizing \_collaborator\_ (Rich Trott) [#39379](https://github.com/nodejs/node/pull/39379)
* [[`9b15e5c155`](https://github.com/nodejs/node/commit/9b15e5c155)] - **doc**: update mailmap and deduplicate AUTHORS entry (Rich Trott) [#39391](https://github.com/nodejs/node/pull/39391)
* [[`e44ccd9aad`](https://github.com/nodejs/node/commit/e44ccd9aad)] - **doc**: update AUTHORS (Rich Trott) [#39367](https://github.com/nodejs/node/pull/39367)
* [[`39e6536a87`](https://github.com/nodejs/node/commit/39e6536a87)] - **doc**: move jdalton to emeritus (Rich Trott) [#39380](https://github.com/nodejs/node/pull/39380)
* [[`bbff5a9e47`](https://github.com/nodejs/node/commit/bbff5a9e47)] - **doc**: edit guide on pull requests (Rich Trott) [#39359](https://github.com/nodejs/node/pull/39359)
* [[`902ef9aca0`](https://github.com/nodejs/node/commit/902ef9aca0)] - **doc,meta**: update email addresses for misterdjules (Rich Trott) [#39433](https://github.com/nodejs/node/pull/39433)
* [[`cc7b61721c`](https://github.com/nodejs/node/commit/cc7b61721c)] - **doc,tools**: remove `checkLinks.mjs` (Antoine du Hamel) [#39206](https://github.com/nodejs/node/pull/39206)
* [[`e2fd015cda`](https://github.com/nodejs/node/commit/e2fd015cda)] - **domain**: do not add domain to promise from other context (Stephen Belanger) [#39135](https://github.com/nodejs/node/pull/39135)
* [[`93eff3f5a6`](https://github.com/nodejs/node/commit/93eff3f5a6)] - **esm**: refine ERR\_REQUIRE\_ESM errors (Guy Bedford) [#39175](https://github.com/nodejs/node/pull/39175)
* [[`1fb0954202`](https://github.com/nodejs/node/commit/1fb0954202)] - **events**: allow an event to be dispatched multiple times (Luigi Pinca) [#39395](https://github.com/nodejs/node/pull/39395)
* [[`6f2989c346`](https://github.com/nodejs/node/commit/6f2989c346)] - **events**: allow the options argument to be null (Luigi Pinca) [#39486](https://github.com/nodejs/node/pull/39486)
* [[`72ad6d3f27`](https://github.com/nodejs/node/commit/72ad6d3f27)] - **fs**: check closing\_ in FileHandle::Close (James M Snell) [#39472](https://github.com/nodejs/node/pull/39472)
* [[`8b58e574ba`](https://github.com/nodejs/node/commit/8b58e574ba)] - **fs**: fix FileHandle::ClosePromise to return persisted Promise (James M Snell) [#39331](https://github.com/nodejs/node/pull/39331)
* [[`9d950a0956`](https://github.com/nodejs/node/commit/9d950a0956)] - **http2**: on receiving rst\_stream with cancel code add it to pending list (Akshay K) [#39423](https://github.com/nodejs/node/pull/39423)
* [[`19e9accf91`](https://github.com/nodejs/node/commit/19e9accf91)] - **inspector**: mark as stable (Gireesh Punathil) [#37748](https://github.com/nodejs/node/pull/37748)
* [[`e4331cd43d`](https://github.com/nodejs/node/commit/e4331cd43d)] - **lib**: comment explaining special-case handling of promises (Stephen Belanger) [#39135](https://github.com/nodejs/node/pull/39135)
* [[`0a47f5fc54`](https://github.com/nodejs/node/commit/0a47f5fc54)] - **meta**: update collaborator email in README (Rich Trott) [#39510](https://github.com/nodejs/node/pull/39510)
* [[`65020110e8`](https://github.com/nodejs/node/commit/65020110e8)] - **meta**: remove unneeded .mailmap entry (Rich Trott) [#39512](https://github.com/nodejs/node/pull/39512)
* [[`864ef11be8`](https://github.com/nodejs/node/commit/864ef11be8)] - **meta**: update email address for collaborator (Rich Trott) [#39511](https://github.com/nodejs/node/pull/39511)
* [[`d3f58cb650`](https://github.com/nodejs/node/commit/d3f58cb650)] - **meta**: align collaborator name in .mailmap/AUTHORS with README (Rich Trott) [#39489](https://github.com/nodejs/node/pull/39489)
* [[`5f9b2187a1`](https://github.com/nodejs/node/commit/5f9b2187a1)] - **meta**: align email address in README/.mailmap/AUTHORS (Rich Trott) [#39503](https://github.com/nodejs/node/pull/39503)
* [[`9fbe3f6b49`](https://github.com/nodejs/node/commit/9fbe3f6b49)] - **meta**: revise .mailmap for README consistency (Rich Trott) [#39457](https://github.com/nodejs/node/pull/39457)
* [[`f6fbb38924`](https://github.com/nodejs/node/commit/f6fbb38924)] - **meta**: alphabetize .mailmap file (Rich Trott) [#39434](https://github.com/nodejs/node/pull/39434)
* [[`dc9c6aa428`](https://github.com/nodejs/node/commit/dc9c6aa428)] - **meta**: align collaborator email in .mailmap/AUTHORS with README (Rich Trott) [#39478](https://github.com/nodejs/node/pull/39478)
* [[`febeb0df16`](https://github.com/nodejs/node/commit/febeb0df16)] - **meta**: update AUTHORS (Rich Trott) [#39461](https://github.com/nodejs/node/pull/39461)
* [[`d059ed9242`](https://github.com/nodejs/node/commit/d059ed9242)] - **meta**: add .mailmap entry for new email for existing contributor (Rich Trott) [#39431](https://github.com/nodejs/node/pull/39431)
* [[`cdf7251370`](https://github.com/nodejs/node/commit/cdf7251370)] - **process**: add api to enable source-maps programmatically (legendecas) [#39085](https://github.com/nodejs/node/pull/39085)
* [[`eccc9a6578`](https://github.com/nodejs/node/commit/eccc9a6578)] - **punycode**: add pending deprecation (Antoine du Hamel) [#38444](https://github.com/nodejs/node/pull/38444)
* [[`a082a705b3`](https://github.com/nodejs/node/commit/a082a705b3)] - **(SEMVER-MINOR)** **repl**: enable --experimental-repl-await /w opt-out (hemanth.hm) [#34733](https://github.com/nodejs/node/pull/34733)
* [[`b230ac12d9`](https://github.com/nodejs/node/commit/b230ac12d9)] - **src**: stop using deprecated v8::ApiObject (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`929205e6b9`](https://github.com/nodejs/node/commit/929205e6b9)] - **src**: use non-deprecated Symbol::Description (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`42ff6d952a`](https://github.com/nodejs/node/commit/42ff6d952a)] - **src**: print native module id on native module not found (legendecas) [#39460](https://github.com/nodejs/node/pull/39460)
* [[`f0287e52aa`](https://github.com/nodejs/node/commit/f0287e52aa)] - **src**: close HandleWraps instead of deleting them in OnGCCollect() (Anna Henningsen) [#39441](https://github.com/nodejs/node/pull/39441)
* [[`2cf52f8db1`](https://github.com/nodejs/node/commit/2cf52f8db1)] - **src**: set SSL\_OP\_ALLOW\_CLIENT\_RENEGOTIATION (Daniel Bevenius) [#38753](https://github.com/nodejs/node/pull/38753)
* [[`fc138376aa`](https://github.com/nodejs/node/commit/fc138376aa)] - **src**: remove unused guards around node-api reference (legendecas) [#38334](https://github.com/nodejs/node/pull/38334)
* [[`26ada4971c`](https://github.com/nodejs/node/commit/26ada4971c)] - **stream**: import internal/util/types instead (James M Snell) [#39331](https://github.com/nodejs/node/pull/39331)
* [[`e91053a465`](https://github.com/nodejs/node/commit/e91053a465)] - **stream**: implement TextEncoderStream and TextDecoderStream (James M Snell) [#39347](https://github.com/nodejs/node/pull/39347)
* [[`efe74746f0`](https://github.com/nodejs/node/commit/efe74746f0)] - **stream**: fixup property definition to avoid prototype polution (James M Snell) [#39371](https://github.com/nodejs/node/pull/39371)
* [[`4709da0372`](https://github.com/nodejs/node/commit/4709da0372)] - **test**: ensure microtask queues are not automatically drained (Jochen Eisinger) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`86ca9a8a80`](https://github.com/nodejs/node/commit/86ca9a8a80)] - **test**: remove test-debug-args (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`bbcd651cfd`](https://github.com/nodejs/node/commit/bbcd651cfd)] - **test**: update trace events test expectations (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`039f64f249`](https://github.com/nodejs/node/commit/039f64f249)] - **test**: fix WASI link test (Richard Lau) [#39485](https://github.com/nodejs/node/pull/39485)
* [[`b1d38ddc8a`](https://github.com/nodejs/node/commit/b1d38ddc8a)] - **test**: update OpenSSL3 error messages for beta-1 (Daniel Bevenius) [#39437](https://github.com/nodejs/node/pull/39437)
* [[`db4f802fba`](https://github.com/nodejs/node/commit/db4f802fba)] - ***Revert*** "**test**: skip tests for openssl-3.0.0-alpha15" (Daniel Bevenius) [#39437](https://github.com/nodejs/node/pull/39437)
* [[`a30d021b94`](https://github.com/nodejs/node/commit/a30d021b94)] - **test**: add test for WebSocket secret verification in debugger (Rich Trott) [#39357](https://github.com/nodejs/node/pull/39357)
* [[`04355afd24`](https://github.com/nodejs/node/commit/04355afd24)] - **test**: add NumberFormat resolvedOptions test (Richard Lau) [#39401](https://github.com/nodejs/node/pull/39401)
* [[`d0fb02c26a`](https://github.com/nodejs/node/commit/d0fb02c26a)] - **test**: put common lint exceptions into config file (Rich Trott) [#39358](https://github.com/nodejs/node/pull/39358)
* [[`259d091366`](https://github.com/nodejs/node/commit/259d091366)] - **test**: mark test-domain-error-types flaky (James M Snell) [#39369](https://github.com/nodejs/node/pull/39369)
* [[`5517769472`](https://github.com/nodejs/node/commit/5517769472)] - **tools**: fetch googletest dependency for V8 CI (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`5fe74aa403`](https://github.com/nodejs/node/commit/5fe74aa403)] - **tools**: update V8 gypfiles for 9.2 (Michaël Zasso) [#38990](https://github.com/nodejs/node/pull/38990)
* [[`e58cf4e44c`](https://github.com/nodejs/node/commit/e58cf4e44c)] - **tools**: flag README/mailmap mismatches in find-inactive-collaborators (Rich Trott) [#39477](https://github.com/nodejs/node/pull/39477)
* [[`0a46e66253`](https://github.com/nodejs/node/commit/0a46e66253)] - **tools**: use mailmap for find-inactive-collaborators (Rich Trott) [#39432](https://github.com/nodejs/node/pull/39432)
* [[`7570f998df`](https://github.com/nodejs/node/commit/7570f998df)] - **tools**: email matchin is case insensitive for .mailmap (Rich Trott) [#39430](https://github.com/nodejs/node/pull/39430)
* [[`5c11a0279d`](https://github.com/nodejs/node/commit/5c11a0279d)] - **tools**: make internal link checker more robust (Rich Trott) [#39429](https://github.com/nodejs/node/pull/39429)
* [[`4c32aa02db`](https://github.com/nodejs/node/commit/4c32aa02db)] - **tools**: added remark-frontmatter (Ben Halverson) [#38717](https://github.com/nodejs/node/pull/38717)
* [[`c6a7c3d00d`](https://github.com/nodejs/node/commit/c6a7c3d00d)] - **tools**: fix broken link hash (Rich Trott) [#39426](https://github.com/nodejs/node/pull/39426)
* [[`0f1d51578e`](https://github.com/nodejs/node/commit/0f1d51578e)] - **tools**: change commit fetch limiting in find-inactive-collaborators (Rich Trott) [#39362](https://github.com/nodejs/node/pull/39362)
* [[`e5d64473e8`](https://github.com/nodejs/node/commit/e5d64473e8)] - **tools**: use Node.js 16.x for GitHub workflow (Rich Trott) [#39362](https://github.com/nodejs/node/pull/39362)
* [[`68fd6d5282`](https://github.com/nodejs/node/commit/68fd6d5282)] - **url**: prevent pathname setter from erasing path of path-only URLs (Darshan Sen) [#39060](https://github.com/nodejs/node/pull/39060)

<a id="16.5.0"></a>
## 2021-07-14, Version 16.5.0 (Current), @targos

### Notable Changes

#### Experimental Web Streams API

Node.js now exposes an experimental implementation of the
[Web Streams API](https://developer.mozilla.org/en-US/docs/Web/API/Streams_API).

While it is experimental, the API is not exposed on the global object and is only
accessible using the new `stream/web` core module:

```mjs
import { ReadableStream, WritableStream } from 'stream/web';
// Or from 'node:stream/web'
```

Importing the module will emit a single experimental warning per process.

The raw API is implemented and we are now working on its integration with
various existing core APIs.

Contributed by James M Snell - [#39062](https://github.com/nodejs/node/pull/39062)

#### Other notable changes

* [[`83f3b959f9`](https://github.com/nodejs/node/commit/83f3b959f9)] - **(SEMVER-MINOR)** **fs**: allow empty string for temp directory prefix (Voltrex) [#39028](https://github.com/nodejs/node/pull/39028)
* [[`c04fd2bb97`](https://github.com/nodejs/node/commit/c04fd2bb97)] - **deps**: upgrade npm to 7.19.1 (npm team) [#39225](https://github.com/nodejs/node/pull/39225)

### Commits

* [[`aafa08d7b9`](https://github.com/nodejs/node/commit/aafa08d7b9)] - **bootstrap**: load perf\_hooks eagerly during bootstrap (Joyee Cheung) [#38971](https://github.com/nodejs/node/pull/38971)
* [[`6e46eb186c`](https://github.com/nodejs/node/commit/6e46eb186c)] - **bootstrap**: support perf hooks in snapshot (Joyee Cheung) [#38971](https://github.com/nodejs/node/pull/38971)
* [[`10681828ac`](https://github.com/nodejs/node/commit/10681828ac)] - **build**: update gcovr for gcc 8 compatibility (Richard Lau) [#39326](https://github.com/nodejs/node/pull/39326)
* [[`8381132f76`](https://github.com/nodejs/node/commit/8381132f76)] - **build**: add riscv into host\_arch\_cc (Lu Yahan) [#39004](https://github.com/nodejs/node/pull/39004)
* [[`a7ba21864d`](https://github.com/nodejs/node/commit/a7ba21864d)] - **build**: restore libplatform headers in distribution (Jeroen Ooms) [#39288](https://github.com/nodejs/node/pull/39288)
* [[`41161eabf2`](https://github.com/nodejs/node/commit/41161eabf2)] - **build**: remove unused comment in Makefile (LitoMore) [#39171](https://github.com/nodejs/node/pull/39171)
* [[`f6a1092471`](https://github.com/nodejs/node/commit/f6a1092471)] - **build**: allow to build riscv64 using Makefile (Makoto Kato) [#39048](https://github.com/nodejs/node/pull/39048)
* [[`a7cd40ed8d`](https://github.com/nodejs/node/commit/a7cd40ed8d)] - **build**: uvwasi honours node\_shared\_libuv (Jérémy Lal) [#39260](https://github.com/nodejs/node/pull/39260)
* [[`3ed04994b7`](https://github.com/nodejs/node/commit/3ed04994b7)] - **build**: shorten path used in tarball build workflow (Richard Lau) [#39192](https://github.com/nodejs/node/pull/39192)
* [[`65b56b3774`](https://github.com/nodejs/node/commit/65b56b3774)] - **build**: fix building with external builtins (Momtchil Momtchev) [#39091](https://github.com/nodejs/node/pull/39091)
* [[`412b1012d2`](https://github.com/nodejs/node/commit/412b1012d2)] - **build**: pass directory instead of list of files to js2c.py (Joyee Cheung) [#39069](https://github.com/nodejs/node/pull/39069)
* [[`171ca6bb3c`](https://github.com/nodejs/node/commit/171ca6bb3c)] - **build**: don't pass `--mode` argument to V8 test-runner (Richard Lau) [#39055](https://github.com/nodejs/node/pull/39055)
* [[`cf8536ea3f`](https://github.com/nodejs/node/commit/cf8536ea3f)] - **build**: fix commit linter on unrebased PRs (Mary Marchini) [#39121](https://github.com/nodejs/node/pull/39121)
* [[`cf0533b8b2`](https://github.com/nodejs/node/commit/cf0533b8b2)] - **build**: use Actions to validate commit message (Mary Marchini) [#32417](https://github.com/nodejs/node/pull/32417)
* [[`4202274851`](https://github.com/nodejs/node/commit/4202274851)] - **crypto**: move OPENSSL\_IS\_BORINGSSL guard (Shelley Vohr) [#39136](https://github.com/nodejs/node/pull/39136)
* [[`89f5a73ba5`](https://github.com/nodejs/node/commit/89f5a73ba5)] - **crypto**: use compatible ecdh function (Shelley Vohr) [#39054](https://github.com/nodejs/node/pull/39054)
* [[`30e878b603`](https://github.com/nodejs/node/commit/30e878b603)] - **crypto**: add OPENSSL\_IS\_BORINGSSL guard (Shelley Vohr) [#39138](https://github.com/nodejs/node/pull/39138)
* [[`630266cba2`](https://github.com/nodejs/node/commit/630266cba2)] - **debugger**: indicate server is ending (Rich Trott) [#39334](https://github.com/nodejs/node/pull/39334)
* [[`48d9680f84`](https://github.com/nodejs/node/commit/48d9680f84)] - **debugger**: remove final lint exceptions in inspect\_repl.js (Rich Trott) [#39078](https://github.com/nodejs/node/pull/39078)
* [[`4507714f9d`](https://github.com/nodejs/node/commit/4507714f9d)] - **deps**: V8: backport 5c76da8ddcf8 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`0e64bd0dd6`](https://github.com/nodejs/node/commit/0e64bd0dd6)] - **deps**: V8: cherry-pick 359d44df4cdd (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`142ce6838b`](https://github.com/nodejs/node/commit/142ce6838b)] - **deps**: V8: cherry-pick 3805a698f7b6 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`2657c305cb`](https://github.com/nodejs/node/commit/2657c305cb)] - **deps**: V8: cherry-pick 56fe020eec0c (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`5c5a93e533`](https://github.com/nodejs/node/commit/5c5a93e533)] - **deps**: V8: cherry-pick 2b77ca200c56 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`cf49ebb052`](https://github.com/nodejs/node/commit/cf49ebb052)] - **deps**: V8: cherry-pick 53784bdb8f01 (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`3d351b29c1`](https://github.com/nodejs/node/commit/3d351b29c1)] - **deps**: V8: cherry-pick cb4faa902e9f (Michaël Zasso) [#39337](https://github.com/nodejs/node/pull/39337)
* [[`165130a3e0`](https://github.com/nodejs/node/commit/165130a3e0)] - **deps**: patch V8 to 9.1.269.38 (Michaël Zasso) [#39196](https://github.com/nodejs/node/pull/39196)
* [[`c04fd2bb97`](https://github.com/nodejs/node/commit/c04fd2bb97)] - **deps**: upgrade npm to 7.19.1 (npm team) [#39225](https://github.com/nodejs/node/pull/39225)
* [[`bf4c50f9d9`](https://github.com/nodejs/node/commit/bf4c50f9d9)] - **deps**: upgrade npm to 7.19.0 (npm team) [#39148](https://github.com/nodejs/node/pull/39148)
* [[`8630b39376`](https://github.com/nodejs/node/commit/8630b39376)] - **deps**: update Acorn to v8.4.1 (Michaël Zasso) [#39166](https://github.com/nodejs/node/pull/39166)
* [[`38ae4077c7`](https://github.com/nodejs/node/commit/38ae4077c7)] - **doc**: fix typos in Web Streams API documentation (Tobias Nießen) [#39351](https://github.com/nodejs/node/pull/39351)
* [[`fb6616ecbb`](https://github.com/nodejs/node/commit/fb6616ecbb)] - **doc**: add text about moving long commit lists out of PR description (Danielle Adams) [#39186](https://github.com/nodejs/node/pull/39186)
* [[`29c9cc8f03`](https://github.com/nodejs/node/commit/29c9cc8f03)] - **doc**: do not use & for "and" in text (Rich Trott) [#39345](https://github.com/nodejs/node/pull/39345)
* [[`0b3b2695bc`](https://github.com/nodejs/node/commit/0b3b2695bc)] - **doc**: do not use tilde for "about" or "approximately" (Rich Trott) [#39344](https://github.com/nodejs/node/pull/39344)
* [[`64a185e595`](https://github.com/nodejs/node/commit/64a185e595)] - **doc**: use consistent abbreviation formatting (Rich Trott) [#39343](https://github.com/nodejs/node/pull/39343)
* [[`2573bf5116`](https://github.com/nodejs/node/commit/2573bf5116)] - **doc**: update AUTHORS (Rich Trott) [#39277](https://github.com/nodejs/node/pull/39277)
* [[`63b6084724`](https://github.com/nodejs/node/commit/63b6084724)] - **doc**: put information about the past in details tags (Rich Trott) [#39321](https://github.com/nodejs/node/pull/39321)
* [[`e26635085a`](https://github.com/nodejs/node/commit/e26635085a)] - **doc**: replace outdated `util.promisify` timer examples with references (foxxyz) [#39164](https://github.com/nodejs/node/pull/39164)
* [[`d101a85e36`](https://github.com/nodejs/node/commit/d101a85e36)] - **doc**: move AndreasMadsen to emeritus (Rich Trott) [#39315](https://github.com/nodejs/node/pull/39315)
* [[`2d552a32d6`](https://github.com/nodejs/node/commit/2d552a32d6)] - **doc**: move ofrobots to collaborator emeritus (Rich Trott) [#39307](https://github.com/nodejs/node/pull/39307)
* [[`131d676f64`](https://github.com/nodejs/node/commit/131d676f64)] - **doc**: simplify CRAN mirror text in benchmark guide (Rich Trott) [#39287](https://github.com/nodejs/node/pull/39287)
* [[`c92b80e631`](https://github.com/nodejs/node/commit/c92b80e631)] - **doc**: use "repository" instead of "repo" in onboarding.md (Rich Trott) [#39286](https://github.com/nodejs/node/pull/39286)
* [[`81df9b1e92`](https://github.com/nodejs/node/commit/81df9b1e92)] - **doc**: update collaborator email address (Rich Trott) [#39263](https://github.com/nodejs/node/pull/39263)
* [[`b8860f35c9`](https://github.com/nodejs/node/commit/b8860f35c9)] - **doc**: remove GitHub mark (Rich Trott) [#39251](https://github.com/nodejs/node/pull/39251)
* [[`f06ebf1775`](https://github.com/nodejs/node/commit/f06ebf1775)] - **doc**: remove emailing the TSC from offboarding doc (Rich Trott) [#39280](https://github.com/nodejs/node/pull/39280)
* [[`175a6569f4`](https://github.com/nodejs/node/commit/175a6569f4)] - **doc**: add annotation to writeFile `data` as `Object` (Jacob) [#39167](https://github.com/nodejs/node/pull/39167)
* [[`4d53c63c22`](https://github.com/nodejs/node/commit/4d53c63c22)] - **doc**: fix boldface punctuation for full sentences (Rich Trott) [#39278](https://github.com/nodejs/node/pull/39278)
* [[`146f733f43`](https://github.com/nodejs/node/commit/146f733f43)] - **doc**: fix constants usage in fs.access example (Cyrille Bourgois) [#39289](https://github.com/nodejs/node/pull/39289)
* [[`eacee0ab17`](https://github.com/nodejs/node/commit/eacee0ab17)] - **doc**: use "repository" in guides versus repo (Michael Dawson) [#39198](https://github.com/nodejs/node/pull/39198)
* [[`04bcfcfff1`](https://github.com/nodejs/node/commit/04bcfcfff1)] - **doc**: update Node-api version matrix (Michael Dawson) [#39197](https://github.com/nodejs/node/pull/39197)
* [[`4dd6ab389a`](https://github.com/nodejs/node/commit/4dd6ab389a)] - **doc**: remove onboarding-extras (Rich Trott) [#39252](https://github.com/nodejs/node/pull/39252)
* [[`a01dacfdcd`](https://github.com/nodejs/node/commit/a01dacfdcd)] - **doc**: move Sam Ruby to emeritus (Rich Trott) [#39264](https://github.com/nodejs/node/pull/39264)
* [[`2bb3713b74`](https://github.com/nodejs/node/commit/2bb3713b74)] - **doc**: update AUTHORS file (Rich Trott) [#39250](https://github.com/nodejs/node/pull/39250)
* [[`2227c1368f`](https://github.com/nodejs/node/commit/2227c1368f)] - **doc**: fix color contrast for anchor marks in dark mode (Rich Trott) [#39168](https://github.com/nodejs/node/pull/39168)
* [[`f8cdaad9d4`](https://github.com/nodejs/node/commit/f8cdaad9d4)] - **doc**: rename datatypes to data types (FrankEntriken) [#39209](https://github.com/nodejs/node/pull/39209)
* [[`250024eaec`](https://github.com/nodejs/node/commit/250024eaec)] - **doc**: normalize CSS variable names and indentation (Rich Trott) [#39199](https://github.com/nodejs/node/pull/39199)
* [[`db74a35348`](https://github.com/nodejs/node/commit/db74a35348)] - **doc**: remove unnecessary module format comments (Rich Trott) [#39219](https://github.com/nodejs/node/pull/39219)
* [[`24a1f7ec84`](https://github.com/nodejs/node/commit/24a1f7ec84)] - **doc**: use more consistent formatting for deprecations (Rich Trott) [#39218](https://github.com/nodejs/node/pull/39218)
* [[`24c0d7d872`](https://github.com/nodejs/node/commit/24c0d7d872)] - **doc**: update AUTHORS (Rich Trott) [#39217](https://github.com/nodejs/node/pull/39217)
* [[`3e5ed72b0a`](https://github.com/nodejs/node/commit/3e5ed72b0a)] - **doc**: use "pull request" instead of "PR" in packages.md (Rich Trott) [#39213](https://github.com/nodejs/node/pull/39213)
* [[`ddc24b2105`](https://github.com/nodejs/node/commit/ddc24b2105)] - **doc**: move v8.stopCoverage() to expected location in doc (Rich Trott) [#39212](https://github.com/nodejs/node/pull/39212)
* [[`68c334c8c9`](https://github.com/nodejs/node/commit/68c334c8c9)] - **doc**: move vm.measureMemory() to expected location in doc (Rich Trott) [#39211](https://github.com/nodejs/node/pull/39211)
* [[`81d52d7c79`](https://github.com/nodejs/node/commit/81d52d7c79)] - **doc**: fix CHANGELOG.md formatting (Richard Lau) [#39223](https://github.com/nodejs/node/pull/39223)
* [[`9c3a5fd53e`](https://github.com/nodejs/node/commit/9c3a5fd53e)] - **doc**: add cc oss-security@lists.openwall.com (Daniel Bevenius) [#39191](https://github.com/nodejs/node/pull/39191)
* [[`07ba2875ae`](https://github.com/nodejs/node/commit/07ba2875ae)] - **doc**: remove instructions for unsupported Node.js versions (Rich Trott) [#39185](https://github.com/nodejs/node/pull/39185)
* [[`482851f647`](https://github.com/nodejs/node/commit/482851f647)] - **doc**: remove obsolete cc recommendations (Rich Trott) [#39181](https://github.com/nodejs/node/pull/39181)
* [[`8311b29083`](https://github.com/nodejs/node/commit/8311b29083)] - **doc**: use "repository" in maintaining-V8 doc (Rich Trott) [#39179](https://github.com/nodejs/node/pull/39179)
* [[`952580e1bf`](https://github.com/nodejs/node/commit/952580e1bf)] - **doc**: fix broken link in errors.md (Rich Trott) [#39200](https://github.com/nodejs/node/pull/39200)
* [[`af1e1dba36`](https://github.com/nodejs/node/commit/af1e1dba36)] - **doc**: correct JavaScript primitive value names in n-api.md (legendecas) [#39129](https://github.com/nodejs/node/pull/39129)
* [[`00728d1301`](https://github.com/nodejs/node/commit/00728d1301)] - **doc**: apply logical ordering to CSS variables (Rich Trott) [#39169](https://github.com/nodejs/node/pull/39169)
* [[`aec2744e14`](https://github.com/nodejs/node/commit/aec2744e14)] - **doc**: remove file name from self-reference links (Antoine du Hamel) [#39165](https://github.com/nodejs/node/pull/39165)
* [[`74bb915178`](https://github.com/nodejs/node/commit/74bb915178)] - **doc**: use repository instead of repo (Rich Trott) [#39157](https://github.com/nodejs/node/pull/39157)
* [[`a669a191a1`](https://github.com/nodejs/node/commit/a669a191a1)] - **doc**: use ASCII order for md refs (Antoine du Hamel) [#39170](https://github.com/nodejs/node/pull/39170)
* [[`21e8720155`](https://github.com/nodejs/node/commit/21e8720155)] - **doc**: fix `EventTarget.dispatchEvent` docs (Rohan Sharma) [#39127](https://github.com/nodejs/node/pull/39127)
* [[`90ec7660bc`](https://github.com/nodejs/node/commit/90ec7660bc)] - **doc**: update AUTHORS file (Rich Trott) [#39082](https://github.com/nodejs/node/pull/39082)
* [[`81cebec5cc`](https://github.com/nodejs/node/commit/81cebec5cc)] - **doc**: esm examples /w imports for process, Buffer (Guy Bedford) [#39043](https://github.com/nodejs/node/pull/39043)
* [[`c1588887a6`](https://github.com/nodejs/node/commit/c1588887a6)] - **doc**: fix napi\_default\_property name (Davidson Francis) [#39104](https://github.com/nodejs/node/pull/39104)
* [[`a440f6c69c`](https://github.com/nodejs/node/commit/a440f6c69c)] - **doc**: fix dead links in packages.md (Michaël Zasso) [#39113](https://github.com/nodejs/node/pull/39113)
* [[`33cad271c5`](https://github.com/nodejs/node/commit/33cad271c5)] - **errors**: remove eager stack generation for node errors (Gus Caplan) [#39182](https://github.com/nodejs/node/pull/39182)
* [[`ac05a0a8a3`](https://github.com/nodejs/node/commit/ac05a0a8a3)] - **errors**: don't throw TypeError on missing export (Benjamin Coe) [#39017](https://github.com/nodejs/node/pull/39017)
* [[`83f3b959f9`](https://github.com/nodejs/node/commit/83f3b959f9)] - **(SEMVER-MINOR)** **fs**: allow empty string for temp directory prefix (Voltrex) [#39028](https://github.com/nodejs/node/pull/39028)
* [[`ac7184d8c7`](https://github.com/nodejs/node/commit/ac7184d8c7)] - **http**: clean up HttpParser correctly (Tobias Koppers) [#39292](https://github.com/nodejs/node/pull/39292)
* [[`35331cbd13`](https://github.com/nodejs/node/commit/35331cbd13)] - **http,https**: align server option of https with http (Qingyu Deng) [#38992](https://github.com/nodejs/node/pull/38992)
* [[`29194d4f88`](https://github.com/nodejs/node/commit/29194d4f88)] - **inspector**: move inspector async hooks to environment (Joyee Cheung) [#39112](https://github.com/nodejs/node/pull/39112)
* [[`ecf627a9af`](https://github.com/nodejs/node/commit/ecf627a9af)] - **lib**: rename TransferedReadableStream etc (Tobias Nießen) [#39352](https://github.com/nodejs/node/pull/39352)
* [[`0e55cb72df`](https://github.com/nodejs/node/commit/0e55cb72df)] - **lib**: make lazyDOMException more common (Khaidi Chu) [#39105](https://github.com/nodejs/node/pull/39105)
* [[`cfd96aa8f9`](https://github.com/nodejs/node/commit/cfd96aa8f9)] - **meta**: fix tls code owners (Robert Nagy) [#39355](https://github.com/nodejs/node/pull/39355)
* [[`e5c2d80560`](https://github.com/nodejs/node/commit/e5c2d80560)] - **meta**: use form schema for bug report template (Michaël Zasso) [#39194](https://github.com/nodejs/node/pull/39194)
* [[`bd472daf0c`](https://github.com/nodejs/node/commit/bd472daf0c)] - **meta**: add @nodejs/actions as CODEOWNERS (Mary Marchini) [#39119](https://github.com/nodejs/node/pull/39119)
* [[`63f87027e3`](https://github.com/nodejs/node/commit/63f87027e3)] - **node-api**: cctest on v8impl::Reference (legendecas) [#38970](https://github.com/nodejs/node/pull/38970)
* [[`7ea98fbccd`](https://github.com/nodejs/node/commit/7ea98fbccd)] - **perf_hooks**: refactor perf\_hooks for snapshot building (Joyee Cheung) [#38971](https://github.com/nodejs/node/pull/38971)
* [[`20cc8ec2af`](https://github.com/nodejs/node/commit/20cc8ec2af)] - **readline**: allow completer to rewrite existing input (Anna Henningsen) [#39178](https://github.com/nodejs/node/pull/39178)
* [[`b168ec2a2a`](https://github.com/nodejs/node/commit/b168ec2a2a)] - **repl**: processTopLevelAwait fallback error handling (ejose19) [#39290](https://github.com/nodejs/node/pull/39290)
* [[`a101fe68ad`](https://github.com/nodejs/node/commit/a101fe68ad)] - **repl**: correctly hoist top level await declarations (ejose19) [#39265](https://github.com/nodejs/node/pull/39265)
* [[`d441d91450`](https://github.com/nodejs/node/commit/d441d91450)] - **repl**: ensure correct syntax err for await parsing (Guy Bedford) [#39154](https://github.com/nodejs/node/pull/39154)
* [[`9184259a54`](https://github.com/nodejs/node/commit/9184259a54)] - **src**: add JSDoc typings for v8 (Voltrex) [#38944](https://github.com/nodejs/node/pull/38944)
* [[`66553feeba`](https://github.com/nodejs/node/commit/66553feeba)] - **src**: compare IPv4 addresses in host byte order (Colin Ihrig) [#39096](https://github.com/nodejs/node/pull/39096)
* [[`ea8d83bf59`](https://github.com/nodejs/node/commit/ea8d83bf59)] - **src,crypto**: fix 0-length output crash in webcrypto (Khaidi Chu) [#38913](https://github.com/nodejs/node/pull/38913)
* [[`683c995001`](https://github.com/nodejs/node/commit/683c995001)] - **src,zlib**: tighten up Z\_\*\_WINDOWBITS macros (Khaidi Chu) [#39115](https://github.com/nodejs/node/pull/39115)
* [[`cb32f69e00`](https://github.com/nodejs/node/commit/cb32f69e00)] - **stream**: cleanup async handling (Robert Nagy) [#39329](https://github.com/nodejs/node/pull/39329)
* [[`1fc6382942`](https://github.com/nodejs/node/commit/1fc6382942)] - **stream**: don't emit prefinish after error or close (Robert Nagy) [#39332](https://github.com/nodejs/node/pull/39332)
* [[`35b6669e13`](https://github.com/nodejs/node/commit/35b6669e13)] - **stream**: use finished for pump (Robert Nagy) [#39203](https://github.com/nodejs/node/pull/39203)
* [[`9af62a1357`](https://github.com/nodejs/node/commit/9af62a1357)] - **(SEMVER-MINOR)** **stream**: implement WHATWG streams (James M Snell) [#39062](https://github.com/nodejs/node/pull/39062)
* [[`0bb980aeaf`](https://github.com/nodejs/node/commit/0bb980aeaf)] - **test**: remove eslint-disable comment from fixture file (Rich Trott) [#39320](https://github.com/nodejs/node/pull/39320)
* [[`21f77031fb`](https://github.com/nodejs/node/commit/21f77031fb)] - **test**: move debugger test case to parallel (Rich Trott) [#39300](https://github.com/nodejs/node/pull/39300)
* [[`0ec93a1fc1`](https://github.com/nodejs/node/commit/0ec93a1fc1)] - **test**: use common.PORT instead of hardcoded port number (Rich Trott) [#39298](https://github.com/nodejs/node/pull/39298)
* [[`11a8b81caf`](https://github.com/nodejs/node/commit/11a8b81caf)] - **test**: remove debugger workaround for AIX (Rich Trott) [#39296](https://github.com/nodejs/node/pull/39296)
* [[`8e77aa23f1`](https://github.com/nodejs/node/commit/8e77aa23f1)] - **test**: add test for debugger restart message issue (Rich Trott) [#39273](https://github.com/nodejs/node/pull/39273)
* [[`13755599e1`](https://github.com/nodejs/node/commit/13755599e1)] - **test**: remove workaround code in debugger test (Rich Trott) [#39238](https://github.com/nodejs/node/pull/39238)
* [[`1f31e3c774`](https://github.com/nodejs/node/commit/1f31e3c774)] - **test**: remove checks for armv6 (Rich Trott) [#39162](https://github.com/nodejs/node/pull/39162)
* [[`d486d0117c`](https://github.com/nodejs/node/commit/d486d0117c)] - **test**: move test-debugger-address to parallel (Rich Trott) [#39236](https://github.com/nodejs/node/pull/39236)
* [[`cdc7a19f48`](https://github.com/nodejs/node/commit/cdc7a19f48)] - **test**: remove common.enoughTestCpu (Rich Trott) [#39161](https://github.com/nodejs/node/pull/39161)
* [[`cc32365f56`](https://github.com/nodejs/node/commit/cc32365f56)] - **(SEMVER-MINOR)** **test**: add WPT streams tests (James M Snell) [#39062](https://github.com/nodejs/node/pull/39062)
* [[`fff21a4afb`](https://github.com/nodejs/node/commit/fff21a4afb)] - **test**: replace "inspector-cli" with "debugger" (Rich Trott) [#39156](https://github.com/nodejs/node/pull/39156)
* [[`df17c62818`](https://github.com/nodejs/node/commit/df17c62818)] - **test**: use localhost test instead of connecting to remote (Adam Majer) [#39011](https://github.com/nodejs/node/pull/39011)
* [[`dfe99d2aac`](https://github.com/nodejs/node/commit/dfe99d2aac)] - **tls**: move legacy code into own file (Robert Nagy) [#39333](https://github.com/nodejs/node/pull/39333)
* [[`f338fddbb0`](https://github.com/nodejs/node/commit/f338fddbb0)] - **tools**: add GitHub Action to run find-inactive-collaborators.mjs (Rich Trott) [#39335](https://github.com/nodejs/node/pull/39335)
* [[`b3a0dd1e4a`](https://github.com/nodejs/node/commit/b3a0dd1e4a)] - **tools**: pass bot token to node-pr-labeler (Michaël Zasso) [#39271](https://github.com/nodejs/node/pull/39271)
* [[`b56a3d9009`](https://github.com/nodejs/node/commit/b56a3d9009)] - **tools**: update gyp-next to v0.9.3 (Jiawen Geng) [#39291](https://github.com/nodejs/node/pull/39291)
* [[`3cd9f5e298`](https://github.com/nodejs/node/commit/3cd9f5e298)] - **tools**: add find-inactive-collaborators.js (Rich Trott) [#39262](https://github.com/nodejs/node/pull/39262)
* [[`0673ede3ad`](https://github.com/nodejs/node/commit/0673ede3ad)] - **tools**: take ownership of deps/v8/tools/node (Michaël Zasso) [#39222](https://github.com/nodejs/node/pull/39222)
* [[`cb8c6ffbce`](https://github.com/nodejs/node/commit/cb8c6ffbce)] - **tools**: update ESLint to 7.30.0 (Colin Ihrig) [#39242](https://github.com/nodejs/node/pull/39242)
* [[`d5113f9e34`](https://github.com/nodejs/node/commit/d5113f9e34)] - **tools**: remove armv6 from test tools (Rich Trott) [#39162](https://github.com/nodejs/node/pull/39162)
* [[`802d9c4488`](https://github.com/nodejs/node/commit/802d9c4488)] - **tools**: update path-parse to 1.0.7 (Rich Trott) [#39232](https://github.com/nodejs/node/pull/39232)
* [[`ab9ccd014c`](https://github.com/nodejs/node/commit/ab9ccd014c)] - **tools**: remove unused `lint-pr-commit-message.sh` (Richard Lau) [#39120](https://github.com/nodejs/node/pull/39120)
* [[`6200f3b35f`](https://github.com/nodejs/node/commit/6200f3b35f)] - **tools**: update @babel/eslint-parser to 7.14.7 (Rich Trott) [#39160](https://github.com/nodejs/node/pull/39160)
* [[`dfe5d1139c`](https://github.com/nodejs/node/commit/dfe5d1139c)] - **tools**: update remark-preset-lint-node to 2.4.1 (Rich Trott) [#39201](https://github.com/nodejs/node/pull/39201)
* [[`4715105581`](https://github.com/nodejs/node/commit/4715105581)] - **tools**: upgrade `highlight.js` to version 11.0.1 (Antoine du Hamel) [#39032](https://github.com/nodejs/node/pull/39032)
* [[`2481ddd08d`](https://github.com/nodejs/node/commit/2481ddd08d)] - **tools,doc**: fix error message for unrecognized type (Antoine du Hamel) [#39221](https://github.com/nodejs/node/pull/39221)
* [[`adb812c042`](https://github.com/nodejs/node/commit/adb812c042)] - **typings**: add a few JSDoc typings for the net lib module (nerdthatnoonelikes) [#38953](https://github.com/nodejs/node/pull/38953)
* [[`29673b8ac8`](https://github.com/nodejs/node/commit/29673b8ac8)] - **typings**: add JSDoc typings for timers (Voltrex) [#38834](https://github.com/nodejs/node/pull/38834)
* [[`fe1c81f247`](https://github.com/nodejs/node/commit/fe1c81f247)] - **wasi**: use missing validator (Voltrex) [#39070](https://github.com/nodejs/node/pull/39070)

<a id="16.4.2"></a>
## 2021-07-05, Version 16.4.2 (Current), @BethGriggs

### Notable Changes

Node.js 16.4.1 introduced a regression in the Windows installer on
non-English locales that is being fixed in this release. There is no
need to download this release if you are not using the Windows
installer.

### Commits

* [[`76e709ec63`](https://github.com/nodejs/node/commit/76e709ec63)] - **win,msi**: use localized "Authenticated Users" name (Richard Lau) [#39241](https://github.com/nodejs/node/pull/39241)

<a id="16.4.1"></a>
## 2021-07-01, Version 16.4.1 (Current), @BethGriggs

This is a security release.

### Notable Changes

Vulnerabilities fixed:

* **CVE-2021-22918**: libuv upgrade - Out of bounds read (Medium)
  * Node.js is vulnerable to out-of-bounds read in libuv's uv__idna_toascii() function which is used to convert strings to ASCII. This is called by Node's dns module's lookup() function and can lead to information disclosures or crashes. You can read more about it in https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-22918
* **CVE-2021-22921**: Windows installer - Node Installer Local Privilege Escalation (Medium)
  * Node.js is vulnerable to local privilege escalation attacks under certain conditions on Windows platforms. More specifically, improper configuration of permissions in the installation directory allows an attacker to perform two different escalation attacks: PATH and DLL hijacking. You can read more about it in https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2021-22921

### Commits

* [[`d33aead28b`](https://github.com/nodejs/node/commit/d33aead28b)] - **deps**: uv: cherry-pick 99c29c9c2c9b (Ben Noordhuis) [nodejs-private/node-private#267](https://github.com/nodejs-private/node-private/pull/267)
* [[`2690907b81`](https://github.com/nodejs/node/commit/2690907b81)] - **win,msi**: set install directory permission (AkshayK) [nodejs-private/node-private#269](https://github.com/nodejs-private/node-private/pull/269)

<a id="16.4.0"></a>
## 2021-06-23, Version 16.4.0 (Current), @danielleadams

### Notable changes

* **async_hooks**:
  * stabilize part of AsyncLocalStorage (Vladimir de Turckheim) [#37675](https://github.com/nodejs/node/pull/37675)
* **deps**:
  * upgrade npm to 7.18.1 (npm team) [#39065](https://github.com/nodejs/node/pull/39065)
  * update V8 to 9.1.269.36 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* **dns**:
  * allow `--dns-result-order` to change default dns verbatim (Ouyang Yadong) [#38099](https://github.com/nodejs/node/pull/38099)

### Commits

* [[`d2b972ee52`](https://github.com/nodejs/node/commit/d2b972ee52)] - **async_hooks**: check for empty contexts before removing (Bryan English) [#39095](https://github.com/nodejs/node/pull/39095)
* [[`03e75fda4c`](https://github.com/nodejs/node/commit/03e75fda4c)] - **async_hooks**: switch between native and context hooks correctly (Stephen Belanger) [#38912](https://github.com/nodejs/node/pull/38912)
* [[`8115e6ee6d`](https://github.com/nodejs/node/commit/8115e6ee6d)] - **(SEMVER-MINOR)** **async_hooks**: stabilize part of AsyncLocalStorage (Vladimir de Turckheim) [#37675](https://github.com/nodejs/node/pull/37675)
* [[`5f51729014`](https://github.com/nodejs/node/commit/5f51729014)] - **bootstrap**: move event loop handle checking into snapshot builder (Joyee Cheung) [#39007](https://github.com/nodejs/node/pull/39007)
* [[`9d100aa269`](https://github.com/nodejs/node/commit/9d100aa269)] - **bootstrap**: split NodeMainInstance::Run() (Joyee Cheung) [#39007](https://github.com/nodejs/node/pull/39007)
* [[`2aaf2f231f`](https://github.com/nodejs/node/commit/2aaf2f231f)] - **build**: reconfigure when gyp files change on Windows (Joyee Cheung) [#39066](https://github.com/nodejs/node/pull/39066)
* [[`7f225a05ee`](https://github.com/nodejs/node/commit/7f225a05ee)] - ***Revert*** "**build**: work around bug in MSBuild v16.10.0" (Michaël Zasso) [#38977](https://github.com/nodejs/node/pull/38977)
* [[`1853127dde`](https://github.com/nodejs/node/commit/1853127dde)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`c0d236f5ea`](https://github.com/nodejs/node/commit/c0d236f5ea)] - **build**: make build-addons errors fail the build (Richard Lau) [#38983](https://github.com/nodejs/node/pull/38983)
* [[`173292bcf8`](https://github.com/nodejs/node/commit/173292bcf8)] - **build**: fix commit-queue default branch (Mary Marchini) [#38998](https://github.com/nodejs/node/pull/38998)
* [[`e939e243bf`](https://github.com/nodejs/node/commit/e939e243bf)] - **build**: don't pass python override to V8 build (Richard Lau) [#38969](https://github.com/nodejs/node/pull/38969)
* [[`651c58b412`](https://github.com/nodejs/node/commit/651c58b412)] - **build**: correct Xcode spelling in .gitignore (bl-ue) [#38895](https://github.com/nodejs/node/pull/38895)
* [[`5203c9ced7`](https://github.com/nodejs/node/commit/5203c9ced7)] - **build**: fast-track npm PRs and dont-land them on LTS (Michaël Zasso) [#38885](https://github.com/nodejs/node/pull/38885)
* [[`7de57d4d33`](https://github.com/nodejs/node/commit/7de57d4d33)] - **build**: dont-land gyp-next PRs on LTS branches (Michaël Zasso) [#38887](https://github.com/nodejs/node/pull/38887)
* [[`e87cd4542b`](https://github.com/nodejs/node/commit/e87cd4542b)] - **child_process**: refactor to use `validateBoolean` (Qingyu Deng) [#38927](https://github.com/nodejs/node/pull/38927)
* [[`69fa9e16e9`](https://github.com/nodejs/node/commit/69fa9e16e9)] - **(SEMVER-MINOR)** **child_process**: allow `options.cwd` receive a URL (Khaidi Chu) [#38862](https://github.com/nodejs/node/pull/38862)
* [[`cf9d686c35`](https://github.com/nodejs/node/commit/cf9d686c35)] - **crypto**: fix aes crash when tag length too small (Khaidi Chu) [#38914](https://github.com/nodejs/node/pull/38914)
* [[`1799ea36f0`](https://github.com/nodejs/node/commit/1799ea36f0)] - **crypto**: use compatible version of EVP\_CIPHER\_name (Shelley Vohr) [#38925](https://github.com/nodejs/node/pull/38925)
* [[`6d5dc63ae4`](https://github.com/nodejs/node/commit/6d5dc63ae4)] - **crypto**: fix label cast in EVP\_PKEY\_CTX\_set0\_rsa\_oaep\_label (Shelley Vohr) [#38926](https://github.com/nodejs/node/pull/38926)
* [[`6e93c17bf5`](https://github.com/nodejs/node/commit/6e93c17bf5)] - **crypto**: use EVP\_get\_cipherbynid directly (Shelley Vohr) [#38901](https://github.com/nodejs/node/pull/38901)
* [[`82c293959e`](https://github.com/nodejs/node/commit/82c293959e)] - **crypto**: add missing rand.h include (Shelley Vohr) [#38864](https://github.com/nodejs/node/pull/38864)
* [[`e4f802de9a`](https://github.com/nodejs/node/commit/e4f802de9a)] - **debugger**: rename internal library for clarity (Rich Trott) [#39080](https://github.com/nodejs/node/pull/39080)
* [[`1e8bdab581`](https://github.com/nodejs/node/commit/1e8bdab581)] - **debugger**: use ERR\_DEBUGGER\_STARTUP\_ERROR in \_inspect.js (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`b43cb69fbb`](https://github.com/nodejs/node/commit/b43cb69fbb)] - **debugger**: use error codes in debugger REPL (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`dc9218136b`](https://github.com/nodejs/node/commit/dc9218136b)] - **debugger**: use ERR\_DEBUGGER\_ERROR in debugger client (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`711916a271`](https://github.com/nodejs/node/commit/711916a271)] - **debugger**: remove unnecessary boilerplate copyright comment (Rich Trott) [#38952](https://github.com/nodejs/node/pull/38952)
* [[`0f65e41442`](https://github.com/nodejs/node/commit/0f65e41442)] - **debugger**: reduce scope of eslint disable comment (Rich Trott) [#38946](https://github.com/nodejs/node/pull/38946)
* [[`1fa724ec5a`](https://github.com/nodejs/node/commit/1fa724ec5a)] - **deps**: upgrade npm to 7.18.1 (npm team) [#39065](https://github.com/nodejs/node/pull/39065)
* [[`c6aa68598d`](https://github.com/nodejs/node/commit/c6aa68598d)] - **deps**: upgrade npm to 7.17.0 (npm team) [#38999](https://github.com/nodejs/node/pull/38999)
* [[`864fe9910b`](https://github.com/nodejs/node/commit/864fe9910b)] - **deps**: make V8 9.1 abi-compatible with 9.0 (Michaël Zasso) [#38991](https://github.com/nodejs/node/pull/38991)
* [[`c93f3573eb`](https://github.com/nodejs/node/commit/c93f3573eb)] - **deps**: V8: cherry-pick fa4cb172cde2 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3c6c28b0a1`](https://github.com/nodejs/node/commit/3c6c28b0a1)] - **deps**: V8: cherry-pick 4c074516397b (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3c37396d5c`](https://github.com/nodejs/node/commit/3c37396d5c)] - **deps**: V8: cherry-pick 5f4413194480 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`3433559a55`](https://github.com/nodejs/node/commit/3433559a55)] - **deps**: V8: cherry-pick 272445f10927 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`f56c78574e`](https://github.com/nodejs/node/commit/f56c78574e)] - **deps**: V8: cherry-pick c0fceaa0669b (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`7197fcec93`](https://github.com/nodejs/node/commit/7197fcec93)] - **deps**: V8: cherry-pick d59db06bf542 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`bf7aa9fef8`](https://github.com/nodejs/node/commit/bf7aa9fef8)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`eac377bc15`](https://github.com/nodejs/node/commit/eac377bc15)] - **deps**: V8: backport aaacffa1e003 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`1a7c8a12c1`](https://github.com/nodejs/node/commit/1a7c8a12c1)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`3c9a75522b`](https://github.com/nodejs/node/commit/3c9a75522b)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`8ed258339a`](https://github.com/nodejs/node/commit/8ed258339a)] - **deps**: V8: forward declaration of `Rtl*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`4ef37c83a9`](https://github.com/nodejs/node/commit/4ef37c83a9)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`7c61c6ee25`](https://github.com/nodejs/node/commit/7c61c6ee25)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`e82ef4148e`](https://github.com/nodejs/node/commit/e82ef4148e)] - **(SEMVER-MINOR)** **deps**: update V8 to 9.1.269.36 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`70af146745`](https://github.com/nodejs/node/commit/70af146745)] - **deps**: upgrade npm to 7.16.0 (npm team) [#38920](https://github.com/nodejs/node/pull/38920)
* [[`a71df7630e`](https://github.com/nodejs/node/commit/a71df7630e)] - **(SEMVER-MINOR)** **dns**: allow `--dns-result-order` to change default dns verbatim (Ouyang Yadong) [#38099](https://github.com/nodejs/node/pull/38099)
* [[`dce256b210`](https://github.com/nodejs/node/commit/dce256b210)] - **doc**: remove references to deleted freenode channels (devsnek) [#39047](https://github.com/nodejs/node/pull/39047)
* [[`1afff98805`](https://github.com/nodejs/node/commit/1afff98805)] - **doc**: fix typos (bl-ue) [#39049](https://github.com/nodejs/node/pull/39049)
* [[`858f66e691`](https://github.com/nodejs/node/commit/858f66e691)] - **doc**: add missing parameter types (Voltrex) [#39013](https://github.com/nodejs/node/pull/39013)
* [[`ed91379186`](https://github.com/nodejs/node/commit/ed91379186)] - **doc**: clearify that http does chunked encoding itself (Mao Wtm) [#28379](https://github.com/nodejs/node/pull/28379)
* [[`51561f390a`](https://github.com/nodejs/node/commit/51561f390a)] - **doc**: add missing changelog links (Antoine du Hamel) [#39016](https://github.com/nodejs/node/pull/39016)
* [[`a19170eb9d`](https://github.com/nodejs/node/commit/a19170eb9d)] - **doc**: clarify that only one Python version is required to build (bl-ue) [#38894](https://github.com/nodejs/node/pull/38894)
* [[`7b219992e0`](https://github.com/nodejs/node/commit/7b219992e0)] - **doc**: fix markup for aesImportParams (Tobias Nießen) [#38898](https://github.com/nodejs/node/pull/38898)
* [[`405b50cdba`](https://github.com/nodejs/node/commit/405b50cdba)] - **doc**: use `await` in filehandle.truncate() snippet (RA80533) [#38939](https://github.com/nodejs/node/pull/38939)
* [[`5218fe86d1`](https://github.com/nodejs/node/commit/5218fe86d1)] - **doc**: fixed typo in process.md (Derevianchenko Maksym) [#38941](https://github.com/nodejs/node/pull/38941)
* [[`f903ad85f2`](https://github.com/nodejs/node/commit/f903ad85f2)] - **doc**: add missing semis after classes (Darshan Sen) [#38931](https://github.com/nodejs/node/pull/38931)
* [[`0bdeeda3b5`](https://github.com/nodejs/node/commit/0bdeeda3b5)] - **doc**: update write callback documentation (Simone Busoli) [#38959](https://github.com/nodejs/node/pull/38959)
* [[`7a7c0588ad`](https://github.com/nodejs/node/commit/7a7c0588ad)] - **doc**: mark util.inherits as legacy (Voltrex) [#38896](https://github.com/nodejs/node/pull/38896)
* [[`f6964dc506`](https://github.com/nodejs/node/commit/f6964dc506)] - **doc**: clarify when `readable._read(...)` is called (Shaun Keys) [#38726](https://github.com/nodejs/node/pull/38726)
* [[`3481b02e77`](https://github.com/nodejs/node/commit/3481b02e77)] - **doc**: mark Node.js v15.x as EOL (Antoine du Hamel) [#38891](https://github.com/nodejs/node/pull/38891)
* [[`17a9846920`](https://github.com/nodejs/node/commit/17a9846920)] - **doc**: fix .mjs syntax in crypto.md (himself65) [#38882](https://github.com/nodejs/node/pull/38882)
* [[`8c7b2bab5f`](https://github.com/nodejs/node/commit/8c7b2bab5f)] - **doc,fs**: remove experimental status for WHATWG URL as path (Antoine du Hamel) [#38870](https://github.com/nodejs/node/pull/38870)
* [[`eddde6c31a`](https://github.com/nodejs/node/commit/eddde6c31a)] - **errors**: don't rekey on primitive type (Benjamin Coe) [#39025](https://github.com/nodejs/node/pull/39025)
* [[`3d7892ef39`](https://github.com/nodejs/node/commit/3d7892ef39)] - **errors**: add ERR\_DEBUGGER\_STARTUP\_ERROR (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`631856ea32`](https://github.com/nodejs/node/commit/631856ea32)] - **errors**: add ERR\_DEBUGGER\_ERROR (Rich Trott) [#39024](https://github.com/nodejs/node/pull/39024)
* [[`336571fbdd`](https://github.com/nodejs/node/commit/336571fbdd)] - ***Revert*** "**http**: make HEAD method to work with keep-alive" (Michaël Zasso) [#38949](https://github.com/nodejs/node/pull/38949)
* [[`c2b4fbba0f`](https://github.com/nodejs/node/commit/c2b4fbba0f)] - **lib**: remove semicolon in preparation for babel/eslint-parser update (Rich Trott) [#39094](https://github.com/nodejs/node/pull/39094)
* [[`f17dde81f3`](https://github.com/nodejs/node/commit/f17dde81f3)] - **lib**: make internal/options lazy (Joyee Cheung) [#38993](https://github.com/nodejs/node/pull/38993)
* [[`551430514b`](https://github.com/nodejs/node/commit/551430514b)] - **lib**: add JSDoc typings for child\_process (Voltrex) [#38222](https://github.com/nodejs/node/pull/38222)
* [[`ded83350a0`](https://github.com/nodejs/node/commit/ded83350a0)] - **lib**: make primordials Promise methods safe (Antoine du Hamel) [#38650](https://github.com/nodejs/node/pull/38650)
* [[`637c1fa83c`](https://github.com/nodejs/node/commit/637c1fa83c)] - **lib**: refactor debuglog init (Antoine du Hamel) [#38838](https://github.com/nodejs/node/pull/38838)
* [[`5b5e07a2cc`](https://github.com/nodejs/node/commit/5b5e07a2cc)] - **meta**: update label-pr-config (Michaël Zasso) [#38950](https://github.com/nodejs/node/pull/38950)
* [[`92ed1c6cce`](https://github.com/nodejs/node/commit/92ed1c6cce)] - **module**: fix legacy `node` specifier resolution to resolve `"main"` field (Antoine du Hamel) [#38979](https://github.com/nodejs/node/pull/38979)
* [[`4174f139b6`](https://github.com/nodejs/node/commit/4174f139b6)] - **net**: use missing validator (Voltrex) [#38984](https://github.com/nodejs/node/pull/38984)
* [[`f7724ab342`](https://github.com/nodejs/node/commit/f7724ab342)] - **node-api**: avoid crashing on passed-in null string (Gabriel Schulhof) [#38923](https://github.com/nodejs/node/pull/38923)
* [[`ec3e5b4c15`](https://github.com/nodejs/node/commit/ec3e5b4c15)] - **node-api**: avoid SecondPassCallback crash (Michael Dawson) [#38899](https://github.com/nodejs/node/pull/38899)
* [[`74f5e30d69`](https://github.com/nodejs/node/commit/74f5e30d69)] - **node-api**: rtn pending excep on napi\_new\_instance (legendecas) [#38798](https://github.com/nodejs/node/pull/38798)
* [[`4c6193fea1`](https://github.com/nodejs/node/commit/4c6193fea1)] - **report**: generates report on threads with no isolates (legendecas) [#38994](https://github.com/nodejs/node/pull/38994)
* [[`3c7a7d9ee4`](https://github.com/nodejs/node/commit/3c7a7d9ee4)] - **(SEMVER-MINOR)** **src**: allow to negate boolean CLI flags (Michaël Zasso) [#39023](https://github.com/nodejs/node/pull/39023)
* [[`284d9c6228`](https://github.com/nodejs/node/commit/284d9c6228)] - **src**: cleanup uv\_fs\_t regardless of success or not (legendecas) [#38996](https://github.com/nodejs/node/pull/38996)
* [[`902bb858d7`](https://github.com/nodejs/node/commit/902bb858d7)] - **src**: refactor to use locale functions (Darshan Sen) [#39014](https://github.com/nodejs/node/pull/39014)
* [[`10370c5e8a`](https://github.com/nodejs/node/commit/10370c5e8a)] - **src**: fix multiple AddLinkedBinding() calls (Anna Henningsen) [#39012](https://github.com/nodejs/node/pull/39012)
* [[`ff8313c3a5`](https://github.com/nodejs/node/commit/ff8313c3a5)] - **src**: throw error in LoadBuiltinModuleSource when reading fails (Joyee Cheung) [#38904](https://github.com/nodejs/node/pull/38904)
* [[`9ba5518f08`](https://github.com/nodejs/node/commit/9ba5518f08)] - **src**: skip test\_fatal/test\_threads for Debug builds (Daniel Bevenius) [#38805](https://github.com/nodejs/node/pull/38805)
* [[`06afb8df65`](https://github.com/nodejs/node/commit/06afb8df65)] - **(SEMVER-MINOR)** **src**: make InitializeOncePerProcess more flexible (Shelley Vohr) [#38888](https://github.com/nodejs/node/pull/38888)
* [[`db4b192113`](https://github.com/nodejs/node/commit/db4b192113)] - **src**: add not-weak DCHECK to PersistentToLocal::Strong (Anna Henningsen) [#38875](https://github.com/nodejs/node/pull/38875)
* [[`08b2a4a138`](https://github.com/nodejs/node/commit/08b2a4a138)] - **src,test**: raise error for --enable-fips when no FIPS (Daniel Bevenius) [#38859](https://github.com/nodejs/node/pull/38859)
* [[`5d92c09bbf`](https://github.com/nodejs/node/commit/5d92c09bbf)] - **src,url**: separate some tables out of node\_url.cc (Khaidi Chu) [#38988](https://github.com/nodejs/node/pull/38988)
* [[`c20e28e1a0`](https://github.com/nodejs/node/commit/c20e28e1a0)] - **stream**: fix pipeline pump (Robert Nagy) [#39006](https://github.com/nodejs/node/pull/39006)
* [[`7b026d8a72`](https://github.com/nodejs/node/commit/7b026d8a72)] - **test**: move inspector-cli tests to sequential (Rich Trott) [#39079](https://github.com/nodejs/node/pull/39079)
* [[`a53911b166`](https://github.com/nodejs/node/commit/a53911b166)] - **test**: improve buffer coverage (Rongjian Zhang) [#38538](https://github.com/nodejs/node/pull/38538)
* [[`5e9175f148`](https://github.com/nodejs/node/commit/5e9175f148)] - **test**: fix name of variable in inspector-cli test (Tobias Nießen) [#38869](https://github.com/nodejs/node/pull/38869)
* [[`bd924610ec`](https://github.com/nodejs/node/commit/bd924610ec)] - **test**: fix typo (Houssem Chebab) [#39045](https://github.com/nodejs/node/pull/39045)
* [[`d50df5dec1`](https://github.com/nodejs/node/commit/d50df5dec1)] - **test**: fix typo in test-http2-invalidheaderfield.js (Ikko Ashimine) [#39021](https://github.com/nodejs/node/pull/39021)
* [[`6111671d45`](https://github.com/nodejs/node/commit/6111671d45)] - **test**: adapt abort tests for new Windows code (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`1816d46cef`](https://github.com/nodejs/node/commit/1816d46cef)] - **test**: adapt test-linux-perf to V8 changes (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`32961c4781`](https://github.com/nodejs/node/commit/32961c4781)] - **test**: fix V8 serdes test for V8 9.1 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`f652284b3b`](https://github.com/nodejs/node/commit/f652284b3b)] - **test**: remove obsolete TLS test (Rich Trott) [#39001](https://github.com/nodejs/node/pull/39001)
* [[`81bbeab3bd`](https://github.com/nodejs/node/commit/81bbeab3bd)] - **test**: improve coverage of lib/events.js (Rongjian Zhang) [#38582](https://github.com/nodejs/node/pull/38582)
* [[`e82111f890`](https://github.com/nodejs/node/commit/e82111f890)] - **test**: http outgoing \_headers setter null (ycjcl868) [#38881](https://github.com/nodejs/node/pull/38881)
* [[`1f10e84939`](https://github.com/nodejs/node/commit/1f10e84939)] - **test**: suppress warning in test\_environment.cc (Daniel Bevenius) [#38868](https://github.com/nodejs/node/pull/38868)
* [[`379b5f79a9`](https://github.com/nodejs/node/commit/379b5f79a9)] - **tls**: tweak clientCertEngine argument parsing (Shelley Vohr) [#38900](https://github.com/nodejs/node/pull/38900)
* [[`78d2e0ed8e`](https://github.com/nodejs/node/commit/78d2e0ed8e)] - **tools**: update babel-eslint-parser to 7.14.5 (Rich Trott) [#39094](https://github.com/nodejs/node/pull/39094)
* [[`fed641127a`](https://github.com/nodejs/node/commit/fed641127a)] - **tools**: update ESLint to 7.29.0 (Rich Trott) [#39083](https://github.com/nodejs/node/pull/39083)
* [[`3ae2a0be48`](https://github.com/nodejs/node/commit/3ae2a0be48)] - **tools**: fix typo (Houssem Chebab) [#39044](https://github.com/nodejs/node/pull/39044)
* [[`a1d0aef60e`](https://github.com/nodejs/node/commit/a1d0aef60e)] - **tools**: update doctool dependencies, migrate to ESM (Michaël Zasso) [#38966](https://github.com/nodejs/node/pull/38966)
* [[`2a292cf574`](https://github.com/nodejs/node/commit/2a292cf574)] - **tools**: update V8 gypfiles for 9.1 (Michaël Zasso) [#38273](https://github.com/nodejs/node/pull/38273)
* [[`0c90fd8454`](https://github.com/nodejs/node/commit/0c90fd8454)] - **tools**: avoid crashing CQ when git push fails (Antoine du Hamel) [#36861](https://github.com/nodejs/node/pull/36861)
* [[`f817c2d3bb`](https://github.com/nodejs/node/commit/f817c2d3bb)] - **tools**: fix typo in commit-queue.sh (bl-ue) [#39000](https://github.com/nodejs/node/pull/39000)
* [[`be5101eb32`](https://github.com/nodejs/node/commit/be5101eb32)] - **tools**: update ESLint to 7.28.0 (Luigi Pinca) [#38955](https://github.com/nodejs/node/pull/38955)
* [[`9bf9ddb490`](https://github.com/nodejs/node/commit/9bf9ddb490)] - **tools**: refactor snapshot builder (Joyee Cheung) [#38902](https://github.com/nodejs/node/pull/38902)
* [[`0706565097`](https://github.com/nodejs/node/commit/0706565097)] - **tools**: bump remark-preset-lint-node to 2.3.0 (Rich Trott) [#38910](https://github.com/nodejs/node/pull/38910)
* [[`7d35fa7938`](https://github.com/nodejs/node/commit/7d35fa7938)] - **tools**: update gyp-next to v0.9.1 (Jiawen Geng) [#38867](https://github.com/nodejs/node/pull/38867)
* [[`00c20e621f`](https://github.com/nodejs/node/commit/00c20e621f)] - **tools,doc**: forbid CJS globals in ESM code snippets (Antoine du Hamel) [#38889](https://github.com/nodejs/node/pull/38889)
* [[`99161b09f6`](https://github.com/nodejs/node/commit/99161b09f6)] - **url,src**: simplify ipv6 logic by using uv\_inet\_pton (Khaidi Chu) [#38842](https://github.com/nodejs/node/pull/38842)
* [[`f40725f2a1`](https://github.com/nodejs/node/commit/f40725f2a1)] - **vm**: use missing validator (Voltrex) [#38935](https://github.com/nodejs/node/pull/38935)
* [[`f959cb3c68`](https://github.com/nodejs/node/commit/f959cb3c68)] - **worker**: do not look up context twice in PostMessage (Anna Henningsen) [#38784](https://github.com/nodejs/node/pull/38784)

<a id="16.3.0"></a>
## 2021-06-02, Version 16.3.0 (Current), @danielleadams

### Notable Changes

* **cli**:
  * add -C alias for --conditions flag (Guy Bedford) [#38755](https://github.com/nodejs/node/pull/38755)
* **deps**:
  * add workspaces support to npm install commands (Ruy Adorno) [#38750](https://github.com/nodejs/node/pull/38750)

### Commits

* [[`4e58ec4aa6`](https://github.com/nodejs/node/commit/4e58ec4aa6)] - **benchmark**: output JSON-compatible numbers (Michaël Zasso) [#38778](https://github.com/nodejs/node/pull/38778)
* [[`7a9d0fd5a9`](https://github.com/nodejs/node/commit/7a9d0fd5a9)] - **benchmark**: fix http elapsed time (Antoine du Hamel) [#38743](https://github.com/nodejs/node/pull/38743)
* [[`a98d631905`](https://github.com/nodejs/node/commit/a98d631905)] - **bootstrap**: include vm and contextify binding into the snapshot (Joyee Cheung) [#38677](https://github.com/nodejs/node/pull/38677)
* [[`f1628960e1`](https://github.com/nodejs/node/commit/f1628960e1)] - **build**: remove outdated dont-land-on-v6.x label (Michaël Zasso) [#38886](https://github.com/nodejs/node/pull/38886)
* [[`6986154b30`](https://github.com/nodejs/node/commit/6986154b30)] - **build**: work around bug in MSBuild v16.10.0 (Michaël Zasso) [#38873](https://github.com/nodejs/node/pull/38873)
* [[`24cca7c5ea`](https://github.com/nodejs/node/commit/24cca7c5ea)] - **build**: add lto build to CI (Jiawen Geng) [#38567](https://github.com/nodejs/node/pull/38567)
* [[`80c32b7a9a`](https://github.com/nodejs/node/commit/80c32b7a9a)] - **build**: allow LTO with Clang 3.9.1+ (Jesse Chan) [#38751](https://github.com/nodejs/node/pull/38751)
* [[`e9be2095cf`](https://github.com/nodejs/node/commit/e9be2095cf)] - **build**: replace non-POSIX test -a|o (Issam E. Maghni) [#38731](https://github.com/nodejs/node/pull/38731)
* [[`717a8b63e1`](https://github.com/nodejs/node/commit/717a8b63e1)] - **child_process**: retain reference to data with advanced serialization (Anna Henningsen) [#38728](https://github.com/nodejs/node/pull/38728)
* [[`bc8400122c`](https://github.com/nodejs/node/commit/bc8400122c)] - **(SEMVER-MINOR)** **cli**: add -C alias for --conditions flag (Guy Bedford) [#38755](https://github.com/nodejs/node/pull/38755)
* [[`eb7c932a6d`](https://github.com/nodejs/node/commit/eb7c932a6d)] - **debugger**: revise async iterator usage to comply with lint rules (Rich Trott) [#38847](https://github.com/nodejs/node/pull/38847)
* [[`f1000e0e52`](https://github.com/nodejs/node/commit/f1000e0e52)] - **debugger**: removed unused function argument (Rich Trott) [#38850](https://github.com/nodejs/node/pull/38850)
* [[`ee1056da60`](https://github.com/nodejs/node/commit/ee1056da60)] - **debugger**: wait for V8 debugger to be enabled (Michaël Zasso) [#38811](https://github.com/nodejs/node/pull/38811)
* [[`47ad448def`](https://github.com/nodejs/node/commit/47ad448def)] - **deps**: upgrade npm to 7.15.1 (npm team) [#38880](https://github.com/nodejs/node/pull/38880)
* [[`e8192b5e89`](https://github.com/nodejs/node/commit/e8192b5e89)] - **deps**: upgrade npm to 7.14.0 (Ruy Adorno) [#38750](https://github.com/nodejs/node/pull/38750)
* [[`15aaf14690`](https://github.com/nodejs/node/commit/15aaf14690)] - **deps**: update llhttp to 6.0.2 (Fedor Indutny) [#38665](https://github.com/nodejs/node/pull/38665)
* [[`108ffdb68f`](https://github.com/nodejs/node/commit/108ffdb68f)] - **doc**: fixed typo in n-api.md (julianjany) [#38822](https://github.com/nodejs/node/pull/38822)
* [[`131a6918dd`](https://github.com/nodejs/node/commit/131a6918dd)] - **doc**: use "Long Term Support" in collaborator guide (Rich Trott) [#38841](https://github.com/nodejs/node/pull/38841)
* [[`4844337cd7`](https://github.com/nodejs/node/commit/4844337cd7)] - **doc**: use "Long Term Support" in technical values doc (Rich Trott) [#38841](https://github.com/nodejs/node/pull/38841)
* [[`f1e823b679`](https://github.com/nodejs/node/commit/f1e823b679)] - **doc**: use "Long Term Support" in README (Philip) [#38839](https://github.com/nodejs/node/pull/38839)
* [[`4e11971a76`](https://github.com/nodejs/node/commit/4e11971a76)] - **doc**: fix grammar in `fs.md` (yotamselementor) [#38818](https://github.com/nodejs/node/pull/38818)
* [[`e2f28c80d1`](https://github.com/nodejs/node/commit/e2f28c80d1)] - **doc**: fixup code sample in http.md (TodorTotev) [#38776](https://github.com/nodejs/node/pull/38776)
* [[`96fa387082`](https://github.com/nodejs/node/commit/96fa387082)] - **doc**: document null target pattern (Guy Bedford) [#38724](https://github.com/nodejs/node/pull/38724)
* [[`5553be3f4e`](https://github.com/nodejs/node/commit/5553be3f4e)] - **doc**: update code examples for `node:url` module (fisker Cheung) [#38645](https://github.com/nodejs/node/pull/38645)
* [[`0c063a1258`](https://github.com/nodejs/node/commit/0c063a1258)] - **doc,url**: clarify domainTo\* when built without ICU (Darshan Sen) [#38789](https://github.com/nodejs/node/pull/38789)
* [[`2054efa02c`](https://github.com/nodejs/node/commit/2054efa02c)] - **events**: refactor to use primordials in lib/events (Akhil Marsonya) [#38117](https://github.com/nodejs/node/pull/38117)
* [[`4884991a12`](https://github.com/nodejs/node/commit/4884991a12)] - **lib**: include url in bootstrap snapshot and remove unnecessary lazy-loads (Joyee Cheung) [#38826](https://github.com/nodejs/node/pull/38826)
* [[`08ad2f6c18`](https://github.com/nodejs/node/commit/08ad2f6c18)] - **lib**: fix typos (bl-ue) [#38846](https://github.com/nodejs/node/pull/38846)
* [[`7d3a8cb854`](https://github.com/nodejs/node/commit/7d3a8cb854)] - **lib**: remove unnecessary lazy loads (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`5d9442a024`](https://github.com/nodejs/node/commit/5d9442a024)] - **lib**: load internal/fs/watchers and internal/fs/read\_file\_context early (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`2268d1cf4c`](https://github.com/nodejs/node/commit/2268d1cf4c)] - **lib**: refactor to reuse validators (Rongjian Zhang) [#38608](https://github.com/nodejs/node/pull/38608)
* [[`496f7eae92`](https://github.com/nodejs/node/commit/496f7eae92)] - **node-api**: fix shutdown crashes (Michael Dawson) [#38492](https://github.com/nodejs/node/pull/38492)
* [[`e1195312b9`](https://github.com/nodejs/node/commit/e1195312b9)] - **(SEMVER-MINOR)** **os**: add os.devNull (Luigi Pinca) [#38569](https://github.com/nodejs/node/pull/38569)
* [[`7ba305552f`](https://github.com/nodejs/node/commit/7ba305552f)] - **src**: set PromiseHooks by Environment (Bryan English) [#38821](https://github.com/nodejs/node/pull/38821)
* [[`74205b3542`](https://github.com/nodejs/node/commit/74205b3542)] - **src**: replace `auto`s in node\_api.cc (Khaidi Chu) [#38852](https://github.com/nodejs/node/pull/38852)
* [[`120849f609`](https://github.com/nodejs/node/commit/120849f609)] - **src**: cache necessary isolate & context in api/\* (Khaidi Chu) [#38366](https://github.com/nodejs/node/pull/38366)
* [[`f25cd4f377`](https://github.com/nodejs/node/commit/f25cd4f377)] - **src**: fix typos (bl-ue) [#38845](https://github.com/nodejs/node/pull/38845)
* [[`a1b0e64187`](https://github.com/nodejs/node/commit/a1b0e64187)] - **src**: support fs\_event\_wrap binding in the snapshot (Joyee Cheung) [#38737](https://github.com/nodejs/node/pull/38737)
* [[`36d4a4331d`](https://github.com/nodejs/node/commit/36d4a4331d)] - **src**: remove redundant v8 namespaces in `env.cc` (Juan José Arboleda) [#38792](https://github.com/nodejs/node/pull/38792)
* [[`3e6b3b22c5`](https://github.com/nodejs/node/commit/3e6b3b22c5)] - **src**: use SPrintF in ProcessEmitWarning (Darshan Sen) [#38758](https://github.com/nodejs/node/pull/38758)
* [[`9ca5c0e29e`](https://github.com/nodejs/node/commit/9ca5c0e29e)] - **src**: fix compiler warnings in node\_buffer.cc (Darshan Sen) [#38722](https://github.com/nodejs/node/pull/38722)
* [[`3741595289`](https://github.com/nodejs/node/commit/3741595289)] - **src**: set CONF\_MFLAGS\_DEFAULT\_SECTION for OpenSSL 3 (Daniel Bevenius) [#38732](https://github.com/nodejs/node/pull/38732)
* [[`4e3353223e`](https://github.com/nodejs/node/commit/4e3353223e)] - **src**: use HandleScope in StreamReq::Done() (Darshan Sen) [#38720](https://github.com/nodejs/node/pull/38720)
* [[`c576311954`](https://github.com/nodejs/node/commit/c576311954)] - **src**: remove commented code in `node_file.cc` (Juan José Arboleda) [#38693](https://github.com/nodejs/node/pull/38693)
* [[`61c95f08b3`](https://github.com/nodejs/node/commit/61c95f08b3)] - **src**: write named pipe info in diagnostic report (legendecas) [#38637](https://github.com/nodejs/node/pull/38637)
* [[`ba96f14233`](https://github.com/nodejs/node/commit/ba96f14233)] - **src**: remove unused `iostream` library (Juan José Arboleda) [#38694](https://github.com/nodejs/node/pull/38694)
* [[`f5dd85bbe6`](https://github.com/nodejs/node/commit/f5dd85bbe6)] - **src**: remove more extra semis from member fns (Shelley Vohr) [#38744](https://github.com/nodejs/node/pull/38744)
* [[`a47fd67154`](https://github.com/nodejs/node/commit/a47fd67154)] - **src**: replace `auto`s in node\_contextify.cc (Khaidi Chu) [#38644](https://github.com/nodejs/node/pull/38644)
* [[`9054d25acc`](https://github.com/nodejs/node/commit/9054d25acc)] - **stream**: add a non-destroying iterator to Readable (Nitzan Uziely) [#38526](https://github.com/nodejs/node/pull/38526)
* [[`4131f94ca8`](https://github.com/nodejs/node/commit/4131f94ca8)] - **stream**: allow empty string as source of pipeline (Qingyu Deng) [#38723](https://github.com/nodejs/node/pull/38723)
* [[`0aa3cb5c0e`](https://github.com/nodejs/node/commit/0aa3cb5c0e)] - **test**: improve coverage of fs internal utils (Rongjian Zhang) [#38746](https://github.com/nodejs/node/pull/38746)
* [[`48ebebd2a8`](https://github.com/nodejs/node/commit/48ebebd2a8)] - **test**: remove unnecessary `--pending-deprecation` flag (Antoine du Hamel) [#38819](https://github.com/nodejs/node/pull/38819)
* [[`3c492baa51`](https://github.com/nodejs/node/commit/3c492baa51)] - **test**: fix writefile with fd (Nitzan Uziely) [#38820](https://github.com/nodejs/node/pull/38820)
* [[`e91d14c57c`](https://github.com/nodejs/node/commit/e91d14c57c)] - **test**: simplify test-path-resolve.js (himself65) [#38671](https://github.com/nodejs/node/pull/38671)
* [[`1f5baaa2e7`](https://github.com/nodejs/node/commit/1f5baaa2e7)] - **test**: improve coverage for `question` in readline (Qingyu Deng) [#38799](https://github.com/nodejs/node/pull/38799)
* [[`6d86f8afd5`](https://github.com/nodejs/node/commit/6d86f8afd5)] - **test**: os, replace custom flatten method with built-in Array.flat (Wael Almattar) [#38770](https://github.com/nodejs/node/pull/38770)
* [[`c7a58578dc`](https://github.com/nodejs/node/commit/c7a58578dc)] - **test**: set locale for datetime-change-notify test (ZiJian Liu) [#38741](https://github.com/nodejs/node/pull/38741)
* [[`695e982a42`](https://github.com/nodejs/node/commit/695e982a42)] - **test**: improve coverage of lib/fs.js (Rongjian Zhang) [#38604](https://github.com/nodejs/node/pull/38604)
* [[`11ac9c6fcc`](https://github.com/nodejs/node/commit/11ac9c6fcc)] - **test**: improve coverage of lib/\_http\_outgoing.js (Rongjian Zhang) [#38734](https://github.com/nodejs/node/pull/38734)
* [[`6da4aa30c6`](https://github.com/nodejs/node/commit/6da4aa30c6)] - **test**: give js-native-api tests consistent names (Gabriel Schulhof) [#38692](https://github.com/nodejs/node/pull/38692)
* [[`929e8df1c0`](https://github.com/nodejs/node/commit/929e8df1c0)] - **test**: improve coverage of stream.Readable (Rongjian Zhang) [#38702](https://github.com/nodejs/node/pull/38702)
* [[`36ffd58105`](https://github.com/nodejs/node/commit/36ffd58105)] - **tools**: refloat 7 Node.js patches to cpplint.py (Rich Trott) [#38851](https://github.com/nodejs/node/pull/38851)
* [[`6b8c712247`](https://github.com/nodejs/node/commit/6b8c712247)] - **tools**: bump cpplint to 1.5.5 (Rich Trott) [#38851](https://github.com/nodejs/node/pull/38851)
* [[`be8d934679`](https://github.com/nodejs/node/commit/be8d934679)] - **tools**: remove exception for Node.js 8 and earlier (Rich Trott) [#38840](https://github.com/nodejs/node/pull/38840)
* [[`c0bde0cd4a`](https://github.com/nodejs/node/commit/c0bde0cd4a)] - **tools**: update setup-node to setup-node@v2 (pengjie) [#38825](https://github.com/nodejs/node/pull/38825)
* [[`21ce3af904`](https://github.com/nodejs/node/commit/21ce3af904)] - **tools**: update ESLint to 7.27.0 (Luigi Pinca) [#38764](https://github.com/nodejs/node/pull/38764)
* [[`ab44106555`](https://github.com/nodejs/node/commit/ab44106555)] - **tools**: use PrintCaughtException in the snapshot builder (Joyee Cheung) [#38745](https://github.com/nodejs/node/pull/38745)
* [[`30c0020885`](https://github.com/nodejs/node/commit/30c0020885)] - **typings**: add JSDoc typings for https (Voltrex) [#38589](https://github.com/nodejs/node/pull/38589)
* [[`7fb809b475`](https://github.com/nodejs/node/commit/7fb809b475)] - **typings**: add JSDoc typings for events (Voltrex) [#38712](https://github.com/nodejs/node/pull/38712)
* [[`7773d58f1a`](https://github.com/nodejs/node/commit/7773d58f1a)] - **url**: exit early when : delimiter is seen in hostname (Timothy Gu) [#38742](https://github.com/nodejs/node/pull/38742)
* [[`a2da9e254c`](https://github.com/nodejs/node/commit/a2da9e254c)] - **worker**: use rwlock for sibling group (Anna Henningsen) [#38783](https://github.com/nodejs/node/pull/38783)
* [[`18f3ba3674`](https://github.com/nodejs/node/commit/18f3ba3674)] - **worker**: leave TODO comments for using std::variant when possible (Anna Henningsen) [#38788](https://github.com/nodejs/node/pull/38788)

<a id="16.2.0"></a>
## 2021-05-19, Version 16.2.0 (Current), @targos

### Notable Changes

* [[`36b948560c`](https://github.com/nodejs/node/commit/36b948560c)] - **(SEMVER-MINOR)** **async_hooks**: use new v8::Context PromiseHook API (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`c0deeeacb2`](https://github.com/nodejs/node/commit/c0deeeacb2)] - **lib**: support setting process.env.TZ on windows (James M Snell) [#38642](https://github.com/nodejs/node/pull/38642)
* [[`4c4902748c`](https://github.com/nodejs/node/commit/4c4902748c)] - **(SEMVER-MINOR)** **module**: add support for `URL` to `import.meta.resolve` (Antoine du Hamel) [#38587](https://github.com/nodejs/node/pull/38587)
* [[`c182198c44`](https://github.com/nodejs/node/commit/c182198c44)] - **(SEMVER-MINOR)** **process**: add `'worker'` event (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`fbf02e3198`](https://github.com/nodejs/node/commit/fbf02e3198)] - **(SEMVER-MINOR)** **util**: add util.types.isKeyObject and util.types.isCryptoKey (Filip Skokan) [#38619](https://github.com/nodejs/node/pull/38619)

### Commits

* [[`36b948560c`](https://github.com/nodejs/node/commit/36b948560c)] - **(SEMVER-MINOR)** **async_hooks**: use new v8::Context PromiseHook API (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`dcae03203e`](https://github.com/nodejs/node/commit/dcae03203e)] - **buffer**: remove TODOs in `atob` / `btoa` (Khaidi Chu) [#38548](https://github.com/nodejs/node/pull/38548)
* [[`48b557e904`](https://github.com/nodejs/node/commit/48b557e904)] - **buffer**: remove unreachable code (Rongjian Zhang) [#38537](https://github.com/nodejs/node/pull/38537)
* [[`b0df28dea5`](https://github.com/nodejs/node/commit/b0df28dea5)] - **build**: add workaround for V8 builds (Richard Lau) [#38632](https://github.com/nodejs/node/pull/38632)
* [[`3bb12db255`](https://github.com/nodejs/node/commit/3bb12db255)] - **build**: remove dependency on `distutils.spawn` (Richard Lau) [#38600](https://github.com/nodejs/node/pull/38600)
* [[`10aaf30da1`](https://github.com/nodejs/node/commit/10aaf30da1)] - **build**: add missing torque output sources (Richard Lau) [#38576](https://github.com/nodejs/node/pull/38576)
* [[`03b4a3a5bf`](https://github.com/nodejs/node/commit/03b4a3a5bf)] - **build**: compile with -std=gnu++14 (Darshan Sen) [#38504](https://github.com/nodejs/node/pull/38504)
* [[`4296591154`](https://github.com/nodejs/node/commit/4296591154)] - **build,src,test,doc**: enable FIPS for OpenSSL 3.0 (Daniel Bevenius) [#38633](https://github.com/nodejs/node/pull/38633)
* [[`36bb8daba5`](https://github.com/nodejs/node/commit/36bb8daba5)] - **crypto**: forbid NODE-ED25519 and NODE-ED448 "raw" key export (Filip Skokan) [#38668](https://github.com/nodejs/node/pull/38668)
* [[`36bb7243ff`](https://github.com/nodejs/node/commit/36bb7243ff)] - **debugger**: refactor `inspect_repl` to use primordials (Antoine du Hamel) [#38551](https://github.com/nodejs/node/pull/38551)
* [[`16a6c8d5a6`](https://github.com/nodejs/node/commit/16a6c8d5a6)] - **debugger**: refactor to use internal modules (Antoine du Hamel) [#38550](https://github.com/nodejs/node/pull/38550)
* [[`11dd9a6838`](https://github.com/nodejs/node/commit/11dd9a6838)] - **debugger**: disable only the lint rules required by current file state (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`e79f540fa0`](https://github.com/nodejs/node/commit/e79f540fa0)] - **debugger**: avoid non-ASCII char in code file (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`d9867b9358`](https://github.com/nodejs/node/commit/d9867b9358)] - **debugger**: wrap lines longer than 80 chars (Rich Trott) [#38529](https://github.com/nodejs/node/pull/38529)
* [[`352a600142`](https://github.com/nodejs/node/commit/352a600142)] - **debugger**: rename inspector-cli test module to debugger (Rich Trott) [#38530](https://github.com/nodejs/node/pull/38530)
* [[`608d0e11f3`](https://github.com/nodejs/node/commit/608d0e11f3)] - **deps**: upgrade npm to 7.13.0 (Ruy Adorno) [#38682](https://github.com/nodejs/node/pull/38682)
* [[`5c71f49d3f`](https://github.com/nodejs/node/commit/5c71f49d3f)] - **deps**: upgrade npm to 7.12.1 (Ruy Adorno) [#38628](https://github.com/nodejs/node/pull/38628)
* [[`ec2dbfb200`](https://github.com/nodejs/node/commit/ec2dbfb200)] - **deps**: patch V8 to 9.0.257.25 (Michaël Zasso) [#38556](https://github.com/nodejs/node/pull/38556)
* [[`ab298723b5`](https://github.com/nodejs/node/commit/ab298723b5)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick fa4cb172cde2 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`a84e9b3e7d`](https://github.com/nodejs/node/commit/a84e9b3e7d)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 4c074516397b (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`043b1aaa3f`](https://github.com/nodejs/node/commit/043b1aaa3f)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 5f4413194480 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`1a104bac74`](https://github.com/nodejs/node/commit/1a104bac74)] - **(SEMVER-MINOR)** **deps**: V8: cherry-pick 272445f10927 (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`827ae05538`](https://github.com/nodejs/node/commit/827ae05538)] - **(SEMVER-MINOR)** **deps**: V8: backport c0fceaa0669b (Stephen Belanger) [#36394](https://github.com/nodejs/node/pull/36394)
* [[`f31a6114a4`](https://github.com/nodejs/node/commit/f31a6114a4)] - **deps**: V8: cherry-pick 530080c44af2 (Milad Fa) [#38489](https://github.com/nodejs/node/pull/38489)
* [[`4001dd28ba`](https://github.com/nodejs/node/commit/4001dd28ba)] - **dgram**: extract cluster lazy loading method to make it testable (Rongjian Zhang) [#38563](https://github.com/nodejs/node/pull/38563)
* [[`a0dc194e31`](https://github.com/nodejs/node/commit/a0dc194e31)] - **doc**: document buffer.kStringMaxLength (Tobias Nießen) [#38688](https://github.com/nodejs/node/pull/38688)
* [[`8590c151cd`](https://github.com/nodejs/node/commit/8590c151cd)] - **doc**: update abort signal in fs promise api example (Moritz Kneilmann) [#38669](https://github.com/nodejs/node/pull/38669)
* [[`0100a3b026`](https://github.com/nodejs/node/commit/0100a3b026)] - **doc**: add documentation for fs.WriteStream.close() (Hitesh Sharma) [#38610](https://github.com/nodejs/node/pull/38610)
* [[`5c38a554ec`](https://github.com/nodejs/node/commit/5c38a554ec)] - **doc**: clarify synchronous blocking of Worker stdio (James M Snell) [#38658](https://github.com/nodejs/node/pull/38658)
* [[`1765e32c45`](https://github.com/nodejs/node/commit/1765e32c45)] - **doc**: update contact info (Gabriel Schulhof) [#38689](https://github.com/nodejs/node/pull/38689)
* [[`c4b161cb89`](https://github.com/nodejs/node/commit/c4b161cb89)] - **doc**: change color of doctag on night mode (Qingyu Deng) [#38652](https://github.com/nodejs/node/pull/38652)
* [[`6620a3182e`](https://github.com/nodejs/node/commit/6620a3182e)] - **doc**: add ESM code examples in url.md (Antoine du Hamel) [#38651](https://github.com/nodejs/node/pull/38651)
* [[`d3de0ef5d4`](https://github.com/nodejs/node/commit/d3de0ef5d4)] - **doc**: fix fs.openSync() signature (Luigi Pinca) [#38591](https://github.com/nodejs/node/pull/38591)
* [[`56bf6c1bcd`](https://github.com/nodejs/node/commit/56bf6c1bcd)] - **doc**: typo stats() should be stat(); clarity (Bryan Field) [#38541](https://github.com/nodejs/node/pull/38541)
* [[`1d9fd49f41`](https://github.com/nodejs/node/commit/1d9fd49f41)] - **doc**: fix code example in ecdh.setPublicKey() (Jordan Baczuk) [#38542](https://github.com/nodejs/node/pull/38542)
* [[`4c70e42928`](https://github.com/nodejs/node/commit/4c70e42928)] - **doc**: use `HEAD` instead of `master` for links (Antoine du Hamel) [#38518](https://github.com/nodejs/node/pull/38518)
* [[`ae9128ec61`](https://github.com/nodejs/node/commit/ae9128ec61)] - **doc**: clarify DiffieHellmanGroup class docs (Nitzan Uziely) [#38363](https://github.com/nodejs/node/pull/38363)
* [[`e59131d97f`](https://github.com/nodejs/node/commit/e59131d97f)] - **doc**: fix broken AHAFS link in fs doc (Rich Trott) [#38534](https://github.com/nodejs/node/pull/38534)
* [[`e9d4c8587a`](https://github.com/nodejs/node/commit/e9d4c8587a)] - **doc**: use AIX instead of Aix in fs.md (Rich Trott) [#38535](https://github.com/nodejs/node/pull/38535)
* [[`e0118f347a`](https://github.com/nodejs/node/commit/e0118f347a)] - **doc**: remove extraneous dash from flag prefix (Rodolfo Carvalho) [#38532](https://github.com/nodejs/node/pull/38532)
* [[`9e10e1a76f`](https://github.com/nodejs/node/commit/9e10e1a76f)] - **doc**: corrected workload name as per the latest VS Installer (MrJithil) [#38500](https://github.com/nodejs/node/pull/38500)
* [[`38644d6f96`](https://github.com/nodejs/node/commit/38644d6f96)] - **doc**: use sentence case in headers in src/crypto/README.md (Rich Trott) [#38524](https://github.com/nodejs/node/pull/38524)
* [[`347b9f2304`](https://github.com/nodejs/node/commit/347b9f2304)] - **errors**: remove input from ERR\_INVALID\_URL message (moander) [#38614](https://github.com/nodejs/node/pull/38614)
* [[`5b40e2f596`](https://github.com/nodejs/node/commit/5b40e2f596)] - **events**: use nullish coalencing operator (Voltrex) [#38328](https://github.com/nodejs/node/pull/38328)
* [[`3a5856cbc3`](https://github.com/nodejs/node/commit/3a5856cbc3)] - **fs**: fix async iterator partial writes (Nitzan Uziely) [#38615](https://github.com/nodejs/node/pull/38615)
* [[`e8761186a5`](https://github.com/nodejs/node/commit/e8761186a5)] - **fs**: fix error when writing buffers \> INT32\_MAX (Zach Bjornson) [#38546](https://github.com/nodejs/node/pull/38546)
* [[`47080bcfc8`](https://github.com/nodejs/node/commit/47080bcfc8)] - **fs**: use `assert` in `fsCall` argument checking (Rongjian Zhang) [#38519](https://github.com/nodejs/node/pull/38519)
* [[`3d8b8e133f`](https://github.com/nodejs/node/commit/3d8b8e133f)] - **http**: refactor to remove redundant argument of \_deferToConnect (Rongjian Zhang) [#38598](https://github.com/nodejs/node/pull/38598)
* [[`c0deeeacb2`](https://github.com/nodejs/node/commit/c0deeeacb2)] - **lib**: support setting process.env.TZ on windows (James M Snell) [#38642](https://github.com/nodejs/node/pull/38642)
* [[`cf4dc80d5f`](https://github.com/nodejs/node/commit/cf4dc80d5f)] - **lib**: make `IterableWeakMap` safe to iterate (Antoine du Hamel) [#38523](https://github.com/nodejs/node/pull/38523)
* [[`90b640efb1`](https://github.com/nodejs/node/commit/90b640efb1)] - **meta**: add v8 team (Jiawen Geng) [#38566](https://github.com/nodejs/node/pull/38566)
* [[`4c4902748c`](https://github.com/nodejs/node/commit/4c4902748c)] - **(SEMVER-MINOR)** **module**: add support for `URL` to `import.meta.resolve` (Antoine du Hamel) [#38587](https://github.com/nodejs/node/pull/38587)
* [[`14a2a00cda`](https://github.com/nodejs/node/commit/14a2a00cda)] - **node-api**: faster threadsafe\_function (Fedor Indutny) [#38506](https://github.com/nodejs/node/pull/38506)
* [[`be4b3a4164`](https://github.com/nodejs/node/commit/be4b3a4164)] - **path**: inline conditions (Voltrex) [#38613](https://github.com/nodejs/node/pull/38613)
* [[`c182198c44`](https://github.com/nodejs/node/commit/c182198c44)] - **(SEMVER-MINOR)** **process**: add `'worker'` event (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`e2b8454582`](https://github.com/nodejs/node/commit/e2b8454582)] - **repl**: fix Ctrl+C on top level await (Antoine du Hamel) [#38656](https://github.com/nodejs/node/pull/38656)
* [[`718ad105e5`](https://github.com/nodejs/node/commit/718ad105e5)] - **src**: fix fatal errors when a current isolate not exist (legendecas) [#38624](https://github.com/nodejs/node/pull/38624)
* [[`524a9d6fcd`](https://github.com/nodejs/node/commit/524a9d6fcd)] - **src**: update cares\_wrap OpenBSD defines (Anna Henningsen) [#38670](https://github.com/nodejs/node/pull/38670)
* [[`6b409cf664`](https://github.com/nodejs/node/commit/6b409cf664)] - **src**: remove extra semi after member fn (Shelley Vohr) [#38686](https://github.com/nodejs/node/pull/38686)
* [[`bfec80fd66`](https://github.com/nodejs/node/commit/bfec80fd66)] - **src**: make workers messaging more resilient (Juan José Arboleda) [#38510](https://github.com/nodejs/node/pull/38510)
* [[`ff1b4322f5`](https://github.com/nodejs/node/commit/ff1b4322f5)] - **test**: refactor `test-readline-interface` to be shorter (Juan José Arboleda) [#38691](https://github.com/nodejs/node/pull/38691)
* [[`8eea317227`](https://github.com/nodejs/node/commit/8eea317227)] - **test**: stream.finished detects a destroyed IncomingMessage (Nitzan Uziely) [#38661](https://github.com/nodejs/node/pull/38661)
* [[`5b25fbe266`](https://github.com/nodejs/node/commit/5b25fbe266)] - **test**: set common.bits to 64 for riscv64 (Andreas Schwab) [#38626](https://github.com/nodejs/node/pull/38626)
* [[`5a0b52120a`](https://github.com/nodejs/node/commit/5a0b52120a)] - **test**: improve coverage of lib/\_http\_client.js (Rongjian Zhang) [#38599](https://github.com/nodejs/node/pull/38599)
* [[`3d0fad3840`](https://github.com/nodejs/node/commit/3d0fad3840)] - **test**: improve coverage of lib/os.js (Rongjian Zhang) [#38653](https://github.com/nodejs/node/pull/38653)
* [[`16b2fb4e0c`](https://github.com/nodejs/node/commit/16b2fb4e0c)] - **test**: increase coverage for repl (ZiJian Liu) [#38559](https://github.com/nodejs/node/pull/38559)
* [[`8f78c6646e`](https://github.com/nodejs/node/commit/8f78c6646e)] - **test**: call functions internally (Voltrex) [#38560](https://github.com/nodejs/node/pull/38560)
* [[`178fe215a4`](https://github.com/nodejs/node/commit/178fe215a4)] - **test**: increase coverage for Histogram (ZiJian Liu) [#38555](https://github.com/nodejs/node/pull/38555)
* [[`95db7d5afc`](https://github.com/nodejs/node/commit/95db7d5afc)] - **test**: improve fs coverage (Rongjian Zhang) [#38517](https://github.com/nodejs/node/pull/38517)
* [[`f2f768f261`](https://github.com/nodejs/node/commit/f2f768f261)] - **test**: complete coverage of querystring (Rongjian Zhang) [#38520](https://github.com/nodejs/node/pull/38520)
* [[`5b44107ae9`](https://github.com/nodejs/node/commit/5b44107ae9)] - **test**: increase coverage for AbortController (ZiJian Liu) [#38514](https://github.com/nodejs/node/pull/38514)
* [[`662265074c`](https://github.com/nodejs/node/commit/662265074c)] - **test**: increase coverage for Blob (ZiJian Liu) [#38515](https://github.com/nodejs/node/pull/38515)
* [[`89e1daccf3`](https://github.com/nodejs/node/commit/89e1daccf3)] - **test**: run message and pseudo-tty tests in parallel (Richard Lau) [#38502](https://github.com/nodejs/node/pull/38502)
* [[`727c2bcc24`](https://github.com/nodejs/node/commit/727c2bcc24)] - **test**: move test-net-connect-econnrefused from pummel to sequential (Rich Trott) [#38462](https://github.com/nodejs/node/pull/38462)
* [[`e64ebac2da`](https://github.com/nodejs/node/commit/e64ebac2da)] - **test**: fix flaky inspector-cli tests when breakpionts are restored (Rich Trott) [#38431](https://github.com/nodejs/node/pull/38431)
* [[`b51b4feece`](https://github.com/nodejs/node/commit/b51b4feece)] - **test**: skip tests for openssl-3.0.0-alpha15 (Daniel Bevenius) [#38451](https://github.com/nodejs/node/pull/38451)
* [[`db5ee23edf`](https://github.com/nodejs/node/commit/db5ee23edf)] - **test**: update OpenSSL 3.0.0-alpha15 error messages (Daniel Bevenius) [#38451](https://github.com/nodejs/node/pull/38451)
* [[`24472d9e0c`](https://github.com/nodejs/node/commit/24472d9e0c)] - **test,repl**: fix tests when inspector is disabled (Antoine du Hamel) [#38564](https://github.com/nodejs/node/pull/38564)
* [[`267a84f5e1`](https://github.com/nodejs/node/commit/267a84f5e1)] - **tools**: remove redundant v8 config (Jiawen Geng) [#38565](https://github.com/nodejs/node/pull/38565)
* [[`a028805f1b`](https://github.com/nodejs/node/commit/a028805f1b)] - **tools**: update ESLint to 7.26.0 (Colin Ihrig) [#38605](https://github.com/nodejs/node/pull/38605)
* [[`ec8ab22ce6`](https://github.com/nodejs/node/commit/ec8ab22ce6)] - **(SEMVER-MINOR)** **tools**: add `Worker` to type-parser (James M Snell) [#38659](https://github.com/nodejs/node/pull/38659)
* [[`151488539b`](https://github.com/nodejs/node/commit/151488539b)] - **tools**: make GH Actions workflows work if default branch is not master (Antoine du Hamel) [#38516](https://github.com/nodejs/node/pull/38516)
* [[`c0f0c9a92d`](https://github.com/nodejs/node/commit/c0f0c9a92d)] - **typings**: add JSDoc typings for readline (Voltrex) [#38253](https://github.com/nodejs/node/pull/38253)
* [[`fbf02e3198`](https://github.com/nodejs/node/commit/fbf02e3198)] - **(SEMVER-MINOR)** **util**: add util.types.isKeyObject and util.types.isCryptoKey (Filip Skokan) [#38619](https://github.com/nodejs/node/pull/38619)
* [[`070ee4bb94`](https://github.com/nodejs/node/commit/070ee4bb94)] - ***Revert*** "**worker**: remove `ERR_CLOSED_MESSAGE_PORT`" (Juan José Arboleda) [#38510](https://github.com/nodejs/node/pull/38510)

<a id="16.1.0"></a>
## 2021-05-04, Version 16.1.0 (Current), @targos

### Notable Changes

* [[`8a90f55a05`](https://github.com/nodejs/node/commit/8a90f55a05)] - **(SEMVER-MINOR)** **fs**: allow no-params fsPromises fileHandle read (Nitzan Uziely) [#38287](https://github.com/nodejs/node/pull/38287)

### Commits

* [[`28e16488cf`](https://github.com/nodejs/node/commit/28e16488cf)] - **async_hooks,doc**: replace process.stdout.fd with 1 (Darshan Sen) [#38382](https://github.com/nodejs/node/pull/38382)
* [[`cbab7ec6e5`](https://github.com/nodejs/node/commit/cbab7ec6e5)] - **benchmark**: avoid using `console.log()` (Antoine du Hamel) [#38370](https://github.com/nodejs/node/pull/38370)
* [[`ba15b20062`](https://github.com/nodejs/node/commit/ba15b20062)] - **benchmark**: use `process.hrtime.bigint()` (Antoine du Hamel) [#38369](https://github.com/nodejs/node/pull/38369)
* [[`bc6e719884`](https://github.com/nodejs/node/commit/bc6e719884)] - **bootstrap**: freeze more intrinsics (Antoine du Hamel) [#38217](https://github.com/nodejs/node/pull/38217)
* [[`29faf0f12e`](https://github.com/nodejs/node/commit/29faf0f12e)] - **build**: fix label-pr workflow (Michaël Zasso) [#38399](https://github.com/nodejs/node/pull/38399)
* [[`b5d669a6ea`](https://github.com/nodejs/node/commit/b5d669a6ea)] - **build**: label PRs with GitHub Action instead of nodejs-github-bot (Phillip Johnsen) [#38301](https://github.com/nodejs/node/pull/38301)
* [[`195f679331`](https://github.com/nodejs/node/commit/195f679331)] - **crypto**: don't crash with some selfsigned certs (Nils Dralle) [#37990](https://github.com/nodejs/node/pull/37990)
* [[`4b073b0beb`](https://github.com/nodejs/node/commit/4b073b0beb)] - **crypto**: fix generateKeyPair type checks (Nitzan Uziely) [#38364](https://github.com/nodejs/node/pull/38364)
* [[`c1d9b5b386`](https://github.com/nodejs/node/commit/c1d9b5b386)] - **crypto**: fix scrypt keylen validation (Antoine du Hamel) [#38385](https://github.com/nodejs/node/pull/38385)
* [[`7354479ad5`](https://github.com/nodejs/node/commit/7354479ad5)] - **crypto**: fix DiffieHellman `generator` validation (eladkeyshawn) [#38311](https://github.com/nodejs/node/pull/38311)
* [[`0e446d6048`](https://github.com/nodejs/node/commit/0e446d6048)] - **debugger**: enable linter on `internal/inspector/inspect_client` (Antoine du Hamel) [#38417](https://github.com/nodejs/node/pull/38417)
* [[`9f0e80aa4d`](https://github.com/nodejs/node/commit/9f0e80aa4d)] - **debugger**: refactor `internal/inspector/_inspect` to use more primordials (Antoine du Hamel) [#38406](https://github.com/nodejs/node/pull/38406)
* [[`a0c566f85a`](https://github.com/nodejs/node/commit/a0c566f85a)] - **debugger**: apply automatic lint fixes for inspect\_repl.js (Rich Trott) [#38411](https://github.com/nodejs/node/pull/38411)
* [[`b884ea739b`](https://github.com/nodejs/node/commit/b884ea739b)] - **debugger**: apply automatic lint fixes for \_inspect.js (Rich Trott) [#38411](https://github.com/nodejs/node/pull/38411)
* [[`f946aa0360`](https://github.com/nodejs/node/commit/f946aa0360)] - **debugger**: remove unused function argument (Rich Trott) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`203a9689a3`](https://github.com/nodejs/node/commit/203a9689a3)] - **debugger**: align message with Node.js standard (Rich Trott) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`ef617dcbb0`](https://github.com/nodejs/node/commit/ef617dcbb0)] - **debugger**: add usage example for `--port` (Rafael Gonzaga) [#38400](https://github.com/nodejs/node/pull/38400)
* [[`37b5ce2d5a`](https://github.com/nodejs/node/commit/37b5ce2d5a)] - **debugger**: fix race condition/deadlock on initialization (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`2a6203d155`](https://github.com/nodejs/node/commit/2a6203d155)] - **debugger**: replace internal use of deprecated API (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`6fff9fff97`](https://github.com/nodejs/node/commit/6fff9fff97)] - **debugger**: allow longer time to connect (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`def85daace`](https://github.com/nodejs/node/commit/def85daace)] - **debugger**: accommodate line chunking in Windows (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`07361e6b77`](https://github.com/nodejs/node/commit/07361e6b77)] - **debugger**: fix inspect restart on Windows (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`d65615e119`](https://github.com/nodejs/node/commit/d65615e119)] - **debugger**: remove unused code (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`62b03bc4f6`](https://github.com/nodejs/node/commit/62b03bc4f6)] - **debugger**: move node-inspect to internal library (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`e3b75cb5aa`](https://github.com/nodejs/node/commit/e3b75cb5aa)] - **deps**: V8: cherry-pick fd75c97d3f56 (Michaël Zasso) [#38455](https://github.com/nodejs/node/pull/38455)
* [[`aabddfbeb5`](https://github.com/nodejs/node/commit/aabddfbeb5)] - **deps**: upgrade npm to 7.11.2 (Ruy Adorno) [#38475](https://github.com/nodejs/node/pull/38475)
* [[`7b9fb92d51`](https://github.com/nodejs/node/commit/7b9fb92d51)] - **deps**: update to cjs-module-lexer@1.2.1 (Guy Bedford) [#38450](https://github.com/nodejs/node/pull/38450)
* [[`47626c52a3`](https://github.com/nodejs/node/commit/47626c52a3)] - **deps**: patch V8 to 9.0.257.24 (Michaël Zasso) [#38423](https://github.com/nodejs/node/pull/38423)
* [[`f455e08621`](https://github.com/nodejs/node/commit/f455e08621)] - **deps**: patch V8 to 9.0.257.21 (Michaël Zasso) [#38333](https://github.com/nodejs/node/pull/38333)
* [[`dd61a26d8c`](https://github.com/nodejs/node/commit/dd61a26d8c)] - **deps**: update llhttp to 6.0.1 (Fedor Indutny) [#38359](https://github.com/nodejs/node/pull/38359)
* [[`05f41cdbcc`](https://github.com/nodejs/node/commit/05f41cdbcc)] - **deps**: patch V8 to 9.0.257.19 (Michaël Zasso) [#38270](https://github.com/nodejs/node/pull/38270)
* [[`224faa0a05`](https://github.com/nodejs/node/commit/224faa0a05)] - ***Revert*** "**doc**: os.uptime() temporary bug notice" (Michaël Zasso) [#38494](https://github.com/nodejs/node/pull/38494)
* [[`3b0480dde8`](https://github.com/nodejs/node/commit/3b0480dde8)] - **doc**: document `'secureConnect'` event limitation (James M Snell) [#38447](https://github.com/nodejs/node/pull/38447)
* [[`92586046ec`](https://github.com/nodejs/node/commit/92586046ec)] - **doc**: fix outdated util inspect documentation and layout example (Ruben Bridgewater) [#37079](https://github.com/nodejs/node/pull/37079)
* [[`13de4cf1ca`](https://github.com/nodejs/node/commit/13de4cf1ca)] - **doc**: mark Node.js 10 as End-of-Life (Richard Lau) [#38482](https://github.com/nodejs/node/pull/38482)
* [[`3cbfde1f25`](https://github.com/nodejs/node/commit/3cbfde1f25)] - **doc**: mark querystring api as legacy (James M Snell) [#38436](https://github.com/nodejs/node/pull/38436)
* [[`a5929c2487`](https://github.com/nodejs/node/commit/a5929c2487)] - **doc**: update node-api support matrix (Michael Dawson) [#38424](https://github.com/nodejs/node/pull/38424)
* [[`f08650cefe`](https://github.com/nodejs/node/commit/f08650cefe)] - **doc**: add arguments for stream event of Http2Server and Http2SecureServer (Qingyu Deng) [#37892](https://github.com/nodejs/node/pull/37892)
* [[`2d59273bed`](https://github.com/nodejs/node/commit/2d59273bed)] - **doc**: indicate that abort tests do not generate core files (Rich Trott) [#38422](https://github.com/nodejs/node/pull/38422)
* [[`f1970127ee`](https://github.com/nodejs/node/commit/f1970127ee)] - **doc**: add try/catch in http2 respondWithFile example (Matteo Collina) [#38410](https://github.com/nodejs/node/pull/38410)
* [[`f6f1317f43`](https://github.com/nodejs/node/commit/f6f1317f43)] - **doc**: note the system requirements for V8 tests (DeeDeeG) [#38319](https://github.com/nodejs/node/pull/38319)
* [[`4b19beaf3c`](https://github.com/nodejs/node/commit/4b19beaf3c)] - **doc**: minor clarification to pathObject (James M Snell) [#38437](https://github.com/nodejs/node/pull/38437)
* [[`1eae4af6f7`](https://github.com/nodejs/node/commit/1eae4af6f7)] - **doc**: clarify that fs.Dir async iterator closes automatically (James M Snell) [#38438](https://github.com/nodejs/node/pull/38438)
* [[`14afb39259`](https://github.com/nodejs/node/commit/14afb39259)] - **doc**: document new TCP\_KEEPCNT and TCP\_KEEPINTVL socket option defaults (Arnold Zokas) [#38313](https://github.com/nodejs/node/pull/38313)
* [[`ed5ef21690`](https://github.com/nodejs/node/commit/ed5ef21690)] - **doc**: do not mention TCP in the allowHalfOpen option description (Luigi Pinca) [#38360](https://github.com/nodejs/node/pull/38360)
* [[`042985c139`](https://github.com/nodejs/node/commit/042985c139)] - **doc**: update message to match actual output (Rich Trott) [#35271](https://github.com/nodejs/node/pull/35271)
* [[`bcc5e2af76`](https://github.com/nodejs/node/commit/bcc5e2af76)] - **doc**: request default snap track be updated for LTS (Rod Vagg) [#37708](https://github.com/nodejs/node/pull/37708)
* [[`dfd4c7ba93`](https://github.com/nodejs/node/commit/dfd4c7ba93)] - **doc**: mark `process.hrtime()` as legacy (Antoine du Hamel) [#38371](https://github.com/nodejs/node/pull/38371)
* [[`67cd88da00`](https://github.com/nodejs/node/commit/67cd88da00)] - **doc**: fix typo in worker\_threads.md (takayama) [#38368](https://github.com/nodejs/node/pull/38368)
* [[`a9314cda7d`](https://github.com/nodejs/node/commit/a9314cda7d)] - **doc**: fix version history for `"exports"` patterns (Antoine du Hamel) [#38355](https://github.com/nodejs/node/pull/38355)
* [[`76885cd578`](https://github.com/nodejs/node/commit/76885cd578)] - **doc**: fix `package.json` `"imports"` field history (Antoine du Hamel) [#38356](https://github.com/nodejs/node/pull/38356)
* [[`0e88ae7ec1`](https://github.com/nodejs/node/commit/0e88ae7ec1)] - **doc**: fix typo in buffer.md (divlo) [#38323](https://github.com/nodejs/node/pull/38323)
* [[`1cccc2da51`](https://github.com/nodejs/node/commit/1cccc2da51)] - **doc**: fix YAML comment opening tags (Jayden Seric) [#38324](https://github.com/nodejs/node/pull/38324)
* [[`25052dc987`](https://github.com/nodejs/node/commit/25052dc987)] - **doc**: add nodejs-sec email template (Daniel Bevenius) [#38290](https://github.com/nodejs/node/pull/38290)
* [[`3858029262`](https://github.com/nodejs/node/commit/3858029262)] - **doc**: update TSC members list with three new members (Rich Trott) [#38352](https://github.com/nodejs/node/pull/38352)
* [[`2eef587674`](https://github.com/nodejs/node/commit/2eef587674)] - **doc**: use `foo.prototype.bar` notation in buffer.md (Voltrex) [#38032](https://github.com/nodejs/node/pull/38032)
* [[`8a90f55a05`](https://github.com/nodejs/node/commit/8a90f55a05)] - **(SEMVER-MINOR)** **fs**: allow no-params fsPromises fileHandle read (Nitzan Uziely) [#38287](https://github.com/nodejs/node/pull/38287)
* [[`a696f1080c`](https://github.com/nodejs/node/commit/a696f1080c)] - **inspector**: remove redundant method for connection check (Yash Ladha) [#37986](https://github.com/nodejs/node/pull/37986)
* [[`fcac2e0363`](https://github.com/nodejs/node/commit/fcac2e0363)] - **lib**: harden lint checks for globals (Antoine du Hamel) [#38419](https://github.com/nodejs/node/pull/38419)
* [[`277122e1fa`](https://github.com/nodejs/node/commit/277122e1fa)] - **lib**: fix and improve os typings (Akhil Marsonya) [#38316](https://github.com/nodejs/node/pull/38316)
* [[`f2c0258b4c`](https://github.com/nodejs/node/commit/f2c0258b4c)] - **lib**: add support for JSTransferable as a mixin (James M Snell) [#38383](https://github.com/nodejs/node/pull/38383)
* [[`96f54d3446`](https://github.com/nodejs/node/commit/96f54d3446)] - **meta**: post comment when pr labeled fast-track (James M Snell) [#38446](https://github.com/nodejs/node/pull/38446)
* [[`4711f57cf2`](https://github.com/nodejs/node/commit/4711f57cf2)] - **perf_hooks**: add toJSON to performance class (Yash Ladha) [#37771](https://github.com/nodejs/node/pull/37771)
* [[`013fa59602`](https://github.com/nodejs/node/commit/013fa59602)] - **perf_hooks**: fix PerformanceObserver 'gc' crash (James M Snell) [#38414](https://github.com/nodejs/node/pull/38414)
* [[`10147f191e`](https://github.com/nodejs/node/commit/10147f191e)] - **readline**: move utilities to internal modules (Antoine du Hamel) [#38466](https://github.com/nodejs/node/pull/38466)
* [[`620ee42ab4`](https://github.com/nodejs/node/commit/620ee42ab4)] - **repl**: document top level await limitation with const/let (James M Snell) [#38449](https://github.com/nodejs/node/pull/38449)
* [[`aa24681dcb`](https://github.com/nodejs/node/commit/aa24681dcb)] - **repl**: display prompt once after error callback (Anna Henningsen) [#38314](https://github.com/nodejs/node/pull/38314)
* [[`9c06103a4f`](https://github.com/nodejs/node/commit/9c06103a4f)] - **src**: fix validation of negative offset to avoid abort (James M Snell) [#38421](https://github.com/nodejs/node/pull/38421)
* [[`7d8cc2abf1`](https://github.com/nodejs/node/commit/7d8cc2abf1)] - **src**: use %progbits instead of @progbits (Stephen Gallagher) [#38312](https://github.com/nodejs/node/pull/38312)
* [[`17856f1f88`](https://github.com/nodejs/node/commit/17856f1f88)] - **src**: print arbitrary javascript exception value in node report (legendecas) [#38009](https://github.com/nodejs/node/pull/38009)
* [[`769a210d55`](https://github.com/nodejs/node/commit/769a210d55)] - **src**: refactor to use THROW\_\* argument based snprintf (Filip Skokan) [#38357](https://github.com/nodejs/node/pull/38357)
* [[`e3538bbcd2`](https://github.com/nodejs/node/commit/e3538bbcd2)] - **src**: fix abort in pbkdf2 (Tobias Nießen) [#38354](https://github.com/nodejs/node/pull/38354)
* [[`09cacd7418`](https://github.com/nodejs/node/commit/09cacd7418)] - **src**: fix setting Converter sub char length (James M Snell) [#38331](https://github.com/nodejs/node/pull/38331)
* [[`3649ec5276`](https://github.com/nodejs/node/commit/3649ec5276)] - **src**: avoid deferred gc/cleanup for Buffer.from (James M Snell) [#38337](https://github.com/nodejs/node/pull/38337)
* [[`f2ffaba78c`](https://github.com/nodejs/node/commit/f2ffaba78c)] - **stream**: the position of \_read() is wrong (helloyou2012) [#38292](https://github.com/nodejs/node/pull/38292)
* [[`7ce39b8608`](https://github.com/nodejs/node/commit/7ce39b8608)] - **test**: fix `common.mustCall` `length` and `name` properties (Antoine du Hamel) [#38464](https://github.com/nodejs/node/pull/38464)
* [[`d1cd1178e7`](https://github.com/nodejs/node/commit/d1cd1178e7)] - **test**: address deprecation warning (Rich Trott) [#38448](https://github.com/nodejs/node/pull/38448)
* [[`67e9e71f75`](https://github.com/nodejs/node/commit/67e9e71f75)] - **test**: crypto KeyObject.from() ERR\_INVALID\_ARG\_TYPE (pezhmanparsaee) [#37890](https://github.com/nodejs/node/pull/37890)
* [[`9ad611c0b2`](https://github.com/nodejs/node/commit/9ad611c0b2)] - **test**: fix flaky test-crypto-timing-safe-dqual-benchmarks (Rich Trott) [#38476](https://github.com/nodejs/node/pull/38476)
* [[`10b6b4e244`](https://github.com/nodejs/node/commit/10b6b4e244)] - **test**: update url Web Platform Tests (Leko) [#38435](https://github.com/nodejs/node/pull/38435)
* [[`4f6c4eb144`](https://github.com/nodejs/node/commit/4f6c4eb144)] - **test**: move abort test from pummel to abort directory (Rich Trott) [#38396](https://github.com/nodejs/node/pull/38396)
* [[`231ef4b0ce`](https://github.com/nodejs/node/commit/231ef4b0ce)] - **test**: move slower tests into pummel and skip on slow devices (Rich Trott) [#38395](https://github.com/nodejs/node/pull/38395)
* [[`45322dfa12`](https://github.com/nodejs/node/commit/45322dfa12)] - **test**: skip some pummel tests on slower machines (Rich Trott) [#38394](https://github.com/nodejs/node/pull/38394)
* [[`1bc47a4c0f`](https://github.com/nodejs/node/commit/1bc47a4c0f)] - **test**: fix test to allow quictls fork of OpenSSL 3 (Richard Lau) [#38372](https://github.com/nodejs/node/pull/38372)
* [[`6ac02755f5`](https://github.com/nodejs/node/commit/6ac02755f5)] - **test**: extend timeout on debugger tests for slower machines (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`93b0c78de0`](https://github.com/nodejs/node/commit/93b0c78de0)] - **test**: fix comment typo (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`6c3e5043b0`](https://github.com/nodejs/node/commit/6c3e5043b0)] - **test**: fix test-inspector-cli-address (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`27d7588ad5`](https://github.com/nodejs/node/commit/27d7588ad5)] - **test**: add ancestor package.json checks for tmpdir (Richard Lau) [#38285](https://github.com/nodejs/node/pull/38285)
* [[`30de03630e`](https://github.com/nodejs/node/commit/30de03630e)] - **test**: replace function with arrow function and remove unused argument (Andres) [#38235](https://github.com/nodejs/node/pull/38235)
* [[`eb8f5ce44f`](https://github.com/nodejs/node/commit/eb8f5ce44f)] - **test**: use .test domain for not found address (Richard Lau) [#38286](https://github.com/nodejs/node/pull/38286)
* [[`a4084d66c6`](https://github.com/nodejs/node/commit/a4084d66c6)] - **test,debugger**: migrate node-inspect tests to core (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`16eb078aa8`](https://github.com/nodejs/node/commit/16eb078aa8)] - **test,readline**: improve tab completion coverage (Antoine du Hamel) [#38465](https://github.com/nodejs/node/pull/38465)
* [[`b3ca1b358e`](https://github.com/nodejs/node/commit/b3ca1b358e)] - **timers**: remove redundant unref calls (Giora Guttsait) [#38320](https://github.com/nodejs/node/pull/38320)
* [[`5b393d9258`](https://github.com/nodejs/node/commit/5b393d9258)] - **tls**: validate ticket keys buffer (Antoine du Hamel) [#38308](https://github.com/nodejs/node/pull/38308)
* [[`f6745e9370`](https://github.com/nodejs/node/commit/f6745e9370)] - **tls**: fix `tlsSocket.setMaxSendFragment` abort (eladkeyshawn) [#38170](https://github.com/nodejs/node/pull/38170)
* [[`499da2d9e3`](https://github.com/nodejs/node/commit/499da2d9e3)] - **tools**: use mktemp to create the workspace directory (Luigi Pinca) [#38432](https://github.com/nodejs/node/pull/38432)
* [[`8a83bfd1bd`](https://github.com/nodejs/node/commit/8a83bfd1bd)] - **tools**: use a shallow clone of the npm/cli repository (Luigi Pinca) [#38463](https://github.com/nodejs/node/pull/38463)
* [[`bec959ef8b`](https://github.com/nodejs/node/commit/bec959ef8b)] - **tools**: disable LTO for "v8\_cppgc\_shared" target (Jesse Chan) [#38346](https://github.com/nodejs/node/pull/38346)
* [[`6350d35b3c`](https://github.com/nodejs/node/commit/6350d35b3c)] - **tools**: remove fixer for non-ascii-character ESLint custom rule (Rich Trott) [#38413](https://github.com/nodejs/node/pull/38413)
* [[`dce8d2968a`](https://github.com/nodejs/node/commit/dce8d2968a)] - **tools**: fix doc generation when version info is not available (Antoine du Hamel) [#38398](https://github.com/nodejs/node/pull/38398)
* [[`1033f6c8cb`](https://github.com/nodejs/node/commit/1033f6c8cb)] - **tools**: add \_depot\_tools to PATH (for V8 tests) (DeeDeeG) [#38299](https://github.com/nodejs/node/pull/38299)
* [[`28f02cb8cf`](https://github.com/nodejs/node/commit/28f02cb8cf)] - **tools**: update ESLint to 7.25.0 (Colin Ihrig) [#38378](https://github.com/nodejs/node/pull/38378)
* [[`f1ea2c8e2b`](https://github.com/nodejs/node/commit/f1ea2c8e2b)] - **tools**: update markdown linter rules (Rich Trott) [#38384](https://github.com/nodejs/node/pull/38384)
* [[`02e875c645`](https://github.com/nodejs/node/commit/02e875c645)] - **tools**: remove node-inspect from license (Rich Trott) [#38161](https://github.com/nodejs/node/pull/38161)
* [[`d3bd4b4771`](https://github.com/nodejs/node/commit/d3bd4b4771)] - **tools**: fix type mismatch in test runner (Richard Lau) [#38289](https://github.com/nodejs/node/pull/38289)
* [[`9a2651352b`](https://github.com/nodejs/node/commit/9a2651352b)] - **typings**: add JSDoc typings for fs (Voltrex) [#38306](https://github.com/nodejs/node/pull/38306)
* [[`e389e86b6b`](https://github.com/nodejs/node/commit/e389e86b6b)] - **typings**: add JSDoc typings for util (Rohit Gohri) [#38213](https://github.com/nodejs/node/pull/38213)
* [[`ec5b06eae3`](https://github.com/nodejs/node/commit/ec5b06eae3)] - **util**: fix infinite recursion during inspection (Ruben Bridgewater) [#37079](https://github.com/nodejs/node/pull/37079)
* [[`67bd0ec15c`](https://github.com/nodejs/node/commit/67bd0ec15c)] - **zlib**: fix brotli flush range (Khaidi Chu) [#38408](https://github.com/nodejs/node/pull/38408)

<a id="16.0.0"></a>
## 2021-04-20, Version 16.0.0 (Current), @BethGriggs

### Notable Changes

#### Deprecations and Removals

* **(SEMVER-MAJOR)** **fs**: remove permissive rmdir recursive (Antoine du Hamel) [#37216](https://github.com/nodejs/node/pull/37216)
* **(SEMVER-MAJOR)** **fs**: runtime deprecate rmdir recursive option (Antoine du Hamel) [#37302](https://github.com/nodejs/node/pull/37302)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('http\_parser') (James M Snell) [#37813](https://github.com/nodejs/node/pull/37813)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('url') (James M Snell) [#37799](https://github.com/nodejs/node/pull/37799)
* **(SEMVER-MAJOR)** **lib**: make process.binding('util') return only type checkers (Anna Henningsen) [#37819](https://github.com/nodejs/node/pull/37819)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('crypto') (James M Snell) [#37790](https://github.com/nodejs/node/pull/37790)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('signal\_wrap') (James M Snell) [#37800](https://github.com/nodejs/node/pull/37800)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('v8') (James M Snell) [#37789](https://github.com/nodejs/node/pull/37789)
* **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('async\_wrap') (James M Snell) [#37576](https://github.com/nodejs/node/pull/37576)
* **(SEMVER-MAJOR)** **module**: remove module.createRequireFromPath (Antoine du Hamel) [#37201](https://github.com/nodejs/node/pull/37201)
* **(SEMVER-MAJOR)** **module**: runtime deprecate subpath folder mappings (Antoine du Hamel) [#37215](https://github.com/nodejs/node/pull/37215)
* **(SEMVER-MAJOR)** **module**: runtime deprecate "main" index and extension lookups (Antoine du Hamel) [#37206](https://github.com/nodejs/node/pull/37206)
* **(SEMVER-MAJOR)** **module**: runtime deprecate invalid package.json main entries (Antoine du Hamel) [#37204](https://github.com/nodejs/node/pull/37204)
* **(SEMVER-MAJOR)** **process**: runtime deprecate changing process.config (James M Snell) [#36902](https://github.com/nodejs/node/pull/36902)

#### Stable Timers Promises API

The Timers Promises API provides an alternative set of timer functions that return Promise objects. Added in Node.js v15.0.0, in this release they graduate from experimental status to stable.

Contributed by James Snell - [#38112](https://github.com/nodejs/node/pull/38112)

#### Toolchain and Compiler Upgrades

Node.js v16.0.0 will be the first release where we ship prebuilt binaries for Apple Silicon. While we’ll be providing separate tarballs for the Intel (`darwin-x64`) and ARM (`darwin-arm64`) architectures the macOS installer (`.pkg`) will be shipped as a ‘fat’ (multi-architecture) binary.

* **(SEMVER-MAJOR)** **build**: remove support for Python 2 (Christian Clauss) [#36691](https://github.com/nodejs/node/pull/36691)
* **(SEMVER-MAJOR)** **build**: default PYTHON to python3 in Makefile (Michaël Zasso) [#37764](https://github.com/nodejs/node/pull/37764)
* **build**: update Makefile to support fat binary (Ash Cripps) [#37861](https://github.com/nodejs/node/pull/37861)
* **(SEMVER-MAJOR)** **build**: enable ASLR (PIE) on OS X (woodfairy) [#35704](https://github.com/nodejs/node/pull/35704)
* **build**: warn for gcc versions earlier than 8.3.0 (Richard Lau) [#37935](https://github.com/nodejs/node/pull/37935)
* **(SEMVER-MAJOR)** **doc**: update minimum supported Xcode to 11 (Michaël Zasso) [#37872](https://github.com/nodejs/node/pull/37872)
* **(SEMVER-MAJOR)** **doc**: update minimum supported GCC to 8.3 (Michaël Zasso) [#37871](https://github.com/nodejs/node/pull/37871)
* **(SEMVER-MAJOR)** **doc**: update AIX to GCC8 for v16.x (Ash Cripps) [#37677](https://github.com/nodejs/node/pull/37677)
* **tools**: set arch in Distribution.xml (Ash Cripps) [#38261](https://github.com/nodejs/node/pull/38261)

#### V8 9.0

The V8 JavaScript engine is updated to V8 9.0, including performance tweaks and improvements.

This update also brings the ECMAScript RegExp Match Indices, which provide the start and end indices of the captured string. The indices array is available via the `.indices` property on match objects when the regular expression has the `/d` flag.

Contributed by Michaël Zasso - [#37587](https://github.com/nodejs/node/pull/37587)

#### Other Notable Changes

* **(SEMVER-MINOR)** **assert**: graduate assert.match and assert.doesNotMatch (James M Snell) [#38111](https://github.com/nodejs/node/pull/38111)
* **(SEMVER-MAJOR)** **buffer**: expose btoa and atob as globals (James M Snell) [#37786](https://github.com/nodejs/node/pull/37786)
* **(SEMVER-MAJOR)** **deps**: bump minimum ICU version to 68 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* **deps**: update ICU to 69.1 (Michaël Zasso) [#38178](https://github.com/nodejs/node/pull/38178)
* **deps**: update llhttp to 6.0.0 (Fedor Indutny) [#38277](https://github.com/nodejs/node/pull/38277)
* **deps**: upgrade npm to 7.10.0 (Ruy Adorno) [#38254](https://github.com/nodejs/node/pull/38254)
* **(SEMVER-MINOR)** **http**: add http.ClientRequest.getRawHeaderNames() (simov) [#37660](https://github.com/nodejs/node/pull/37660)
* **(SEMVER-MAJOR)** **lib,src**: update cluster to use Parent (Michael Dawson) [#36478](https://github.com/nodejs/node/pull/36478)
* **(SEMVER-MINOR)** **module**: add support for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* **(SEMVER-MINOR)** **perf_hooks**: add histogram option to timerify (James M Snell) [#37475](https://github.com/nodejs/node/pull/37475)
* **(SEMVER-MINOR)** **repl**: add auto‑completion for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* **(SEMVER-MINOR)** **util**: add getSystemErrorMap() impl (eladkeyshawn) [#38101](https://github.com/nodejs/node/pull/38101)

### Semver-Major Commits

* [[`324a6c235a`](https://github.com/nodejs/node/commit/324a6c235a)] - **(SEMVER-MAJOR)** **async_hooks**: add thisArg to AsyncResource.bind (James M Snell) [#36782](https://github.com/nodejs/node/pull/36782)
* [[`d1e2184c8e`](https://github.com/nodejs/node/commit/d1e2184c8e)] - **(SEMVER-MAJOR)** **buffer**: expose btoa and atob as globals (James M Snell) [#37786](https://github.com/nodejs/node/pull/37786)
* [[`4268fae04a`](https://github.com/nodejs/node/commit/4268fae04a)] - **(SEMVER-MAJOR)** **build**: remove support for Python 2 (Christian Clauss) [#36691](https://github.com/nodejs/node/pull/36691)
* [[`c3a5e15ebe`](https://github.com/nodejs/node/commit/c3a5e15ebe)] - **(SEMVER-MAJOR)** **build**: default PYTHON to python3 in Makefile (Michaël Zasso) [#37764](https://github.com/nodejs/node/pull/37764)
* [[`1d8c022544`](https://github.com/nodejs/node/commit/1d8c022544)] - **(SEMVER-MAJOR)** **build**: update Makefile to support fat binary (Ash Cripps) [#37861](https://github.com/nodejs/node/pull/37861)
* [[`38f32386c1`](https://github.com/nodejs/node/commit/38f32386c1)] - **(SEMVER-MAJOR)** **build**: include minimal V8 headers in distribution (Michaël Zasso) [#37570](https://github.com/nodejs/node/pull/37570)
* [[`a19af5ee71`](https://github.com/nodejs/node/commit/a19af5ee71)] - **(SEMVER-MAJOR)** **build**: use C++11 ABI with libstdc++ (Anna Henningsen) [#36634](https://github.com/nodejs/node/pull/36634)
* [[`8d6b74d347`](https://github.com/nodejs/node/commit/8d6b74d347)] - **(SEMVER-MAJOR)** **build**: enable ASLR (PIE) on OS X (woodfairy) [#35704](https://github.com/nodejs/node/pull/35704)
* [[`732ad99e47`](https://github.com/nodejs/node/commit/732ad99e47)] - **(SEMVER-MAJOR)** **deps**: update V8 to 9.0.257.11 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`43cc8e4b2e`](https://github.com/nodejs/node/commit/43cc8e4b2e)] - **(SEMVER-MAJOR)** **deps**: bump minimum ICU version to 68 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`c5ff019a4e`](https://github.com/nodejs/node/commit/c5ff019a4e)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.9.255.19 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`c7b3292251`](https://github.com/nodejs/node/commit/c7b3292251)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.8.278.17 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`48db20f6f5`](https://github.com/nodejs/node/commit/48db20f6f5)] - **(SEMVER-MAJOR)** **deps**: update V8 to 8.7.220 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`d85e1f0703`](https://github.com/nodejs/node/commit/d85e1f0703)] - **(SEMVER-MAJOR)** **dns**: use url module instead of punycode for IDNA (Antoine du Hamel) [#35091](https://github.com/nodejs/node/pull/35091)
* [[`290c158018`](https://github.com/nodejs/node/commit/290c158018)] - **(SEMVER-MAJOR)** **doc**: update minimum supported Xcode to 11 (Michaël Zasso) [#37872](https://github.com/nodejs/node/pull/37872)
* [[`1ff2918d80`](https://github.com/nodejs/node/commit/1ff2918d80)] - **(SEMVER-MAJOR)** **doc**: update minimum supported GCC to 8.3 (Michaël Zasso) [#37871](https://github.com/nodejs/node/pull/37871)
* [[`2706e67116`](https://github.com/nodejs/node/commit/2706e67116)] - **(SEMVER-MAJOR)** **doc**: update AIX to GCC8 for v16.x (Ash Cripps) [#37677](https://github.com/nodejs/node/pull/37677)
* [[`5ae5ca90ef`](https://github.com/nodejs/node/commit/5ae5ca90ef)] - **(SEMVER-MAJOR)** **doc**: add http.IncomingMessage#connection (Pranshu Srivastava) [#33768](https://github.com/nodejs/node/pull/33768)
* [[`83d6e63aee`](https://github.com/nodejs/node/commit/83d6e63aee)] - **(SEMVER-MAJOR)** **events**: change EventTarget handler exception behavior (Nitzan Uziely) [#37237](https://github.com/nodejs/node/pull/37237)
* [[`9948036ee0`](https://github.com/nodejs/node/commit/9948036ee0)] - **(SEMVER-MAJOR)** **fs**: remove permissive rmdir recursive (Antoine du Hamel) [#37216](https://github.com/nodejs/node/pull/37216)
* [[`d4693ff430`](https://github.com/nodejs/node/commit/d4693ff430)] - **(SEMVER-MAJOR)** **fs**: add validation for fd and path (Dylan Elliott) [#35187](https://github.com/nodejs/node/pull/35187)
* [[`0ddd75bcd8`](https://github.com/nodejs/node/commit/0ddd75bcd8)] - **(SEMVER-MAJOR)** **fs**: runtime deprecate rmdir recursive option (Antoine du Hamel) [#37302](https://github.com/nodejs/node/pull/37302)
* [[`da217d0773`](https://github.com/nodejs/node/commit/da217d0773)] - **(SEMVER-MAJOR)** **fs**: fix flag and mode validation (James M Snell) [#37480](https://github.com/nodejs/node/pull/37480)
* [[`2ef9a76ece`](https://github.com/nodejs/node/commit/2ef9a76ece)] - **(SEMVER-MAJOR)** **http**: use objects with null prototype in Agent (Michaël Zasso) [#36409](https://github.com/nodejs/node/pull/36409)
* [[`25e30005b8`](https://github.com/nodejs/node/commit/25e30005b8)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('http\_parser') (James M Snell) [#37813](https://github.com/nodejs/node/pull/37813)
* [[`8bb4e048af`](https://github.com/nodejs/node/commit/8bb4e048af)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('url') (James M Snell) [#37799](https://github.com/nodejs/node/pull/37799)
* [[`fe73e4d578`](https://github.com/nodejs/node/commit/fe73e4d578)] - **(SEMVER-MAJOR)** **lib**: make process.binding('util') return only type checkers (Anna Henningsen) [#37819](https://github.com/nodejs/node/pull/37819)
* [[`3bee6d8aad`](https://github.com/nodejs/node/commit/3bee6d8aad)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('crypto') (James M Snell) [#37790](https://github.com/nodejs/node/pull/37790)
* [[`ac00df112e`](https://github.com/nodejs/node/commit/ac00df112e)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('signal\_wrap') (James M Snell) [#37800](https://github.com/nodejs/node/pull/37800)
* [[`ae595d76e3`](https://github.com/nodejs/node/commit/ae595d76e3)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('v8') (James M Snell) [#37789](https://github.com/nodejs/node/pull/37789)
* [[`104dac79cc`](https://github.com/nodejs/node/commit/104dac79cc)] - **(SEMVER-MAJOR)** **lib**: aggregate errors to avoid error swallowing (Antoine du Hamel) [#37460](https://github.com/nodejs/node/pull/37460)
* [[`1468c9ff7c`](https://github.com/nodejs/node/commit/1468c9ff7c)] - **(SEMVER-MAJOR)** **lib**: runtime deprecate access to process.binding('async\_wrap') (James M Snell) [#37576](https://github.com/nodejs/node/pull/37576)
* [[`295e766c27`](https://github.com/nodejs/node/commit/295e766c27)] - **(SEMVER-MAJOR)** **lib**: remove usage of url.parse (raisinten) [#36853](https://github.com/nodejs/node/pull/36853)
* [[`cb3020d824`](https://github.com/nodejs/node/commit/cb3020d824)] - **(SEMVER-MAJOR)** **lib**: add error handling for input stream (rexagod) [#31603](https://github.com/nodejs/node/pull/31603)
* [[`15164cebce`](https://github.com/nodejs/node/commit/15164cebce)] - **(SEMVER-MAJOR)** **lib,src**: update cluster to use Parent (Michael Dawson) [#36478](https://github.com/nodejs/node/pull/36478)
* [[`3cc9aec988`](https://github.com/nodejs/node/commit/3cc9aec988)] - **(SEMVER-MAJOR)** **module**: runtime deprecate subpath folder mappings (Antoine du Hamel) [#37215](https://github.com/nodejs/node/pull/37215)
* [[`9fab73c73b`](https://github.com/nodejs/node/commit/9fab73c73b)] - **(SEMVER-MAJOR)** **module**: runtime deprecate "main" index and extension lookups (Antoine du Hamel) [#37206](https://github.com/nodejs/node/pull/37206)
* [[`76a073b67e`](https://github.com/nodejs/node/commit/76a073b67e)] - **(SEMVER-MAJOR)** **module**: runtime deprecate invalid package.json main entries (Antoine du Hamel) [#37204](https://github.com/nodejs/node/pull/37204)
* [[`674614b3f5`](https://github.com/nodejs/node/commit/674614b3f5)] - **(SEMVER-MAJOR)** **module**: remove module.createRequireFromPath (Antoine du Hamel) [#37201](https://github.com/nodejs/node/pull/37201)
* [[`aecd5ebf49`](https://github.com/nodejs/node/commit/aecd5ebf49)] - **(SEMVER-MAJOR)** **module**: only set cache when finding module succeeds (Yongsheng Zhang) [#36642](https://github.com/nodejs/node/pull/36642)
* [[`f0bf373176`](https://github.com/nodejs/node/commit/f0bf373176)] - **(SEMVER-MAJOR)** **perf_hooks**: make performance a global (James M Snell) [#37970](https://github.com/nodejs/node/pull/37970)
* [[`f3eb224c83`](https://github.com/nodejs/node/commit/f3eb224c83)] - **(SEMVER-MAJOR)** **perf_hooks**: complete overhaul of the implementation (James M Snell) [#37136](https://github.com/nodejs/node/pull/37136)
* [[`f1753d4c76`](https://github.com/nodejs/node/commit/f1753d4c76)] - **(SEMVER-MAJOR)** **process**: disallow adding options to process.allowedNodeEnvironmentFlags (Antoine du Hamel) [#36660](https://github.com/nodejs/node/pull/36660)
* [[`96f3977ded`](https://github.com/nodejs/node/commit/96f3977ded)] - **(SEMVER-MAJOR)** **process**: runtime deprecate changing process.config (James M Snell) [#36902](https://github.com/nodejs/node/pull/36902)
* [[`45dbcbef90`](https://github.com/nodejs/node/commit/45dbcbef90)] - **(SEMVER-MAJOR)** **readline**: cursorTo throw error on NaN (Zijian Liu) [#36379](https://github.com/nodejs/node/pull/36379)
* [[`bf79987433`](https://github.com/nodejs/node/commit/bf79987433)] - **(SEMVER-MAJOR)** **src**: mark internally exported functions as explicitly internal (Tyler Ang-Wanek) [#37000](https://github.com/nodejs/node/pull/37000)
* [[`1fe571aa0c`](https://github.com/nodejs/node/commit/1fe571aa0c)] - **(SEMVER-MAJOR)** **src**: inline AsyncCleanupHookHandle in headers (Tyler Ang-Wanek) [#37000](https://github.com/nodejs/node/pull/37000)
* [[`dfc288e7fd`](https://github.com/nodejs/node/commit/dfc288e7fd)] - **(SEMVER-MAJOR)** **src**: clean up embedder API (Anna Henningsen) [#35897](https://github.com/nodejs/node/pull/35897)
* [[`65e8864fa3`](https://github.com/nodejs/node/commit/65e8864fa3)] - **(SEMVER-MAJOR)** **worker**: send correct error status for worker init (Yash Ladha) [#36242](https://github.com/nodejs/node/pull/36242)

### Semver-Minor Commits

* [[`944a956087`](https://github.com/nodejs/node/commit/944a956087)] - **(SEMVER-MINOR)** **assert**: graduate assert.match and assert.doesNotMatch (James M Snell) [#38111](https://github.com/nodejs/node/pull/38111)
* [[`6a1986d50a`](https://github.com/nodejs/node/commit/6a1986d50a)] - **(SEMVER-MINOR)** **deps**: update llhttp to 5.1.0 (Fedor Indutny) [#38146](https://github.com/nodejs/node/pull/38146)
* [[`069b5df4f6`](https://github.com/nodejs/node/commit/069b5df4f6)] - **(SEMVER-MINOR)** **module**: add support for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* [[`b803bca4fa`](https://github.com/nodejs/node/commit/b803bca4fa)] - **(SEMVER-MINOR)** **perf_hooks**: add histogram option to timerify (James M Snell) [#37475](https://github.com/nodejs/node/pull/37475)
* [[`95391fe689`](https://github.com/nodejs/node/commit/95391fe689)] - **(SEMVER-MINOR)** **repl**: add auto‑completion for `node:`‑prefixed `require(…)` calls (ExE Boss) [#37246](https://github.com/nodejs/node/pull/37246)
* [[`15b8e6b1c4`](https://github.com/nodejs/node/commit/15b8e6b1c4)] - **(SEMVER-MINOR)** **timers**: graduate awaitable timers and improve docs (James M Snell) [#38112](https://github.com/nodejs/node/pull/38112)
* [[`802171057f`](https://github.com/nodejs/node/commit/802171057f)] - **(SEMVER-MINOR)** **util**: add getSystemErrorMap() impl (eladkeyshawn) [#38101](https://github.com/nodejs/node/pull/38101)

### Semver-Patch Commits

* [[`8930eba199`](https://github.com/nodejs/node/commit/8930eba199)] - **assert**: change status of legacy asserts (James M Snell) [#38113](https://github.com/nodejs/node/pull/38113)
* [[`0180fc5b9b`](https://github.com/nodejs/node/commit/0180fc5b9b)] - **benchmark**: improve compare.R output (Brian White) [#38118](https://github.com/nodejs/node/pull/38118)
* [[`8d9d8236b7`](https://github.com/nodejs/node/commit/8d9d8236b7)] - **bootstrap**: mksnapshot should show JS error (Bradley Meck) [#38174](https://github.com/nodejs/node/pull/38174)
* [[`6cb314bbe5`](https://github.com/nodejs/node/commit/6cb314bbe5)] - **bootstrap**: print information for snapshot at environment exit in debug (Joyee Cheung) [#37967](https://github.com/nodejs/node/pull/37967)
* [[`14aed60941`](https://github.com/nodejs/node/commit/14aed60941)] - **buffer,errors**: add missing n literal in range error string (Cactysman) [#37750](https://github.com/nodejs/node/pull/37750)
* [[`049b703a28`](https://github.com/nodejs/node/commit/049b703a28)] - **build**: sync generation of `v8\_build\_config.json` (Richard Lau) [#38263](https://github.com/nodejs/node/pull/38263)
* [[`1d21a8d140`](https://github.com/nodejs/node/commit/1d21a8d140)] - **build**: add riscv64 configure (luyahan) [#37980](https://github.com/nodejs/node/pull/37980)
* [[`f5eea1744d`](https://github.com/nodejs/node/commit/f5eea1744d)] - **build**: don't run test workflow on doc dir on macOS (ycjcl868) [#37999](https://github.com/nodejs/node/pull/37999)
* [[`2853b76e20`](https://github.com/nodejs/node/commit/2853b76e20)] - **build**: add pummel tests to ci runs (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`24426cd8c4`](https://github.com/nodejs/node/commit/24426cd8c4)] - **build**: prepare Windows coverage GitHub Action for pummel tests (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`7df0fc5c5c`](https://github.com/nodejs/node/commit/7df0fc5c5c)] - **build**: move OPENSSL\_API\_COMPAT to else clause (Daniel Bevenius) [#38126](https://github.com/nodejs/node/pull/38126)
* [[`9cfb418e1f`](https://github.com/nodejs/node/commit/9cfb418e1f)] - **build**: package release changelog for releases (Richard Lau) [#38033](https://github.com/nodejs/node/pull/38033)
* [[`558d1e6c22`](https://github.com/nodejs/node/commit/558d1e6c22)] - **build**: warn for gcc versions earlier than 8.3.0 (Richard Lau) [#37935](https://github.com/nodejs/node/pull/37935)
* [[`a572a4e34e`](https://github.com/nodejs/node/commit/a572a4e34e)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`f3c7078245`](https://github.com/nodejs/node/commit/f3c7078245)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`842389839b`](https://github.com/nodejs/node/commit/842389839b)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`98d1ae47cf`](https://github.com/nodejs/node/commit/98d1ae47cf)] - **build**: reset embedder string to "-node.0" (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`993ed19f9c`](https://github.com/nodejs/node/commit/993ed19f9c)] - **crypto**: reduce range of size to int max (Qingyu Deng) [#38096](https://github.com/nodejs/node/pull/38096)
* [[`896dc39951`](https://github.com/nodejs/node/commit/896dc39951)] - **crypto**: fix webcrypto derive(Bits|Key) resolve values and docs (Filip Skokan) [#38148](https://github.com/nodejs/node/pull/38148)
* [[`d2f116c6bb`](https://github.com/nodejs/node/commit/d2f116c6bb)] - **crypto**: fixup randomFill size and offset handling (James M Snell) [#38138](https://github.com/nodejs/node/pull/38138)
* [[`dfe3f952a3`](https://github.com/nodejs/node/commit/dfe3f952a3)] - **crypto**: fix crash in CCM mode without data (Tobias Nießen) [#38102](https://github.com/nodejs/node/pull/38102)
* [[`e8cb6446ef`](https://github.com/nodejs/node/commit/e8cb6446ef)] - **crypto**: reconcile oneshot sign/verify sync and async implementations (Filip Skokan) [#37816](https://github.com/nodejs/node/pull/37816)
* [[`1e4a2bcbee`](https://github.com/nodejs/node/commit/1e4a2bcbee)] - **crypto**: remove check for condition that is always true (Rich Trott) [#38072](https://github.com/nodejs/node/pull/38072)
* [[`64d5be25ab`](https://github.com/nodejs/node/commit/64d5be25ab)] - **deps**: V8: cherry-pick 1648e050cade (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`621b544909`](https://github.com/nodejs/node/commit/621b544909)] - **deps**: silence irrelevant V8 warnings (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`0d78bc3101`](https://github.com/nodejs/node/commit/0d78bc3101)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`5214918856`](https://github.com/nodejs/node/commit/5214918856)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`6b3caf77b2`](https://github.com/nodejs/node/commit/6b3caf77b2)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`d0a032fafb`](https://github.com/nodejs/node/commit/d0a032fafb)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c8b2fa642e`](https://github.com/nodejs/node/commit/c8b2fa642e)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`8eeecc19ae`](https://github.com/nodejs/node/commit/8eeecc19ae)] - **deps**: V8: cherry-pick 8957d4677aa7 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`b186142a0b`](https://github.com/nodejs/node/commit/b186142a0b)] - **deps**: V8: backport a11395433dbd (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`290f2d8d3e`](https://github.com/nodejs/node/commit/290f2d8d3e)] - **deps**: V8: cherry-pick deb0813166f3 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`63ed0b8bfe`](https://github.com/nodejs/node/commit/63ed0b8bfe)] - **deps**: V8: cherry-pick 9a6a22874c81 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`47f1c5257a`](https://github.com/nodejs/node/commit/47f1c5257a)] - **deps**: silence irrelevant V8 warning (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`19d975241f`](https://github.com/nodejs/node/commit/19d975241f)] - **deps**: workaround stod() limitations on SmartOS (Colin Ihrig) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`70f928c6a6`](https://github.com/nodejs/node/commit/70f928c6a6)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`b045e39513`](https://github.com/nodejs/node/commit/b045e39513)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`32725d2224`](https://github.com/nodejs/node/commit/32725d2224)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`fe3cee7b37`](https://github.com/nodejs/node/commit/fe3cee7b37)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`b2d05f7349`](https://github.com/nodejs/node/commit/b2d05f7349)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c7a0ab4e3d`](https://github.com/nodejs/node/commit/c7a0ab4e3d)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`60b623ee90`](https://github.com/nodejs/node/commit/60b623ee90)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`577ff9fee5`](https://github.com/nodejs/node/commit/577ff9fee5)] - **deps**: V8: cherry-pick deb0813166f3 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`00e1c7ea83`](https://github.com/nodejs/node/commit/00e1c7ea83)] - **deps**: V8: cherry-pick 9a6a22874c81 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`ee01d6b7fc`](https://github.com/nodejs/node/commit/ee01d6b7fc)] - **deps**: V8: cherry-pick 2059ee813359 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`2dad8d43cc`](https://github.com/nodejs/node/commit/2dad8d43cc)] - **deps**: V8: cherry-pick bde7ee5473d6 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`3046131ea0`](https://github.com/nodejs/node/commit/3046131ea0)] - **deps**: V8: cherry-pick 9a712984025e (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`d178d0738f`](https://github.com/nodejs/node/commit/d178d0738f)] - **deps**: V8: cherry-pick 0b96e5b0bfb2 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`5c71ea151a`](https://github.com/nodejs/node/commit/5c71ea151a)] - **deps**: V8: cherry-pick fbb28902e049 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`c8e15cd2c6`](https://github.com/nodejs/node/commit/c8e15cd2c6)] - **deps**: V8: cherry-pick 821fb3883a8e (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`b0d67426af`](https://github.com/nodejs/node/commit/b0d67426af)] - **deps**: workaround stod() limitations on SmartOS (Colin Ihrig) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`c8a658ac53`](https://github.com/nodejs/node/commit/c8a658ac53)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`153b8cea36`](https://github.com/nodejs/node/commit/153b8cea36)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`a785984133`](https://github.com/nodejs/node/commit/a785984133)] - **deps**: V8: silence irrelevant warnings (Michaël Zasso) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`246c9b8c31`](https://github.com/nodejs/node/commit/246c9b8c31)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`96a567f9e9`](https://github.com/nodejs/node/commit/96a567f9e9)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`e74383cecb`](https://github.com/nodejs/node/commit/e74383cecb)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`732847f1eb`](https://github.com/nodejs/node/commit/732847f1eb)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`70171d186f`](https://github.com/nodejs/node/commit/70171d186f)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`15c91c6dd5`](https://github.com/nodejs/node/commit/15c91c6dd5)] - **deps**: V8: cherry-pick 821fb3883a8e (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`40b2fa4832`](https://github.com/nodejs/node/commit/40b2fa4832)] - **deps**: V8: cherry-pick 45e49775f5a3 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`cd91ab5865`](https://github.com/nodejs/node/commit/cd91ab5865)] - **deps**: V8: cherry-pick 7b3a27b7ae65 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`f4fc099080`](https://github.com/nodejs/node/commit/f4fc099080)] - **deps**: V8: cherry-pick d76abfed3512 (Michaël Zasso) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`6200176ef0`](https://github.com/nodejs/node/commit/6200176ef0)] - **deps**: fix V8 build issue with inline methods (Jiawen Geng) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`bd5642deb9`](https://github.com/nodejs/node/commit/bd5642deb9)] - **deps**: update V8 postmortem metadata script (Colin Ihrig) [#35415](https://github.com/nodejs/node/pull/35415)
* [[`9ae7159216`](https://github.com/nodejs/node/commit/9ae7159216)] - **deps**: update V8 postmortem metadata script (Colin Ihrig) [#33579](https://github.com/nodejs/node/pull/33579)
* [[`f4b4e21b2f`](https://github.com/nodejs/node/commit/f4b4e21b2f)] - **deps**: patch V8 to run on Xcode 8 (Mary Marchini) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`f6a84540d8`](https://github.com/nodejs/node/commit/f6a84540d8)] - **deps**: V8: silence irrelevant warnings (Michaël Zasso) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`bbc3f46572`](https://github.com/nodejs/node/commit/bbc3f46572)] - **deps**: make v8.h compatible with VS2015 (Joao Reis) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`0c988642dc`](https://github.com/nodejs/node/commit/0c988642dc)] - **deps**: V8: forward declaration of `Rtl\*FunctionTable` (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`703bf933d4`](https://github.com/nodejs/node/commit/703bf933d4)] - **deps**: V8: patch register-arm64.h (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`5451975b18`](https://github.com/nodejs/node/commit/5451975b18)] - **deps**: patch V8 to run on older XCode versions (Ujjwal Sharma) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`c460f7af4d`](https://github.com/nodejs/node/commit/c460f7af4d)] - **deps**: V8: un-cherry-pick bd019bd (Refael Ackermann) [#32116](https://github.com/nodejs/node/pull/32116)
* [[`bfee9daaa5`](https://github.com/nodejs/node/commit/bfee9daaa5)] - **deps**: update llhttp to 6.0.0 (Fedor Indutny) [#38277](https://github.com/nodejs/node/pull/38277)
* [[`94405650ae`](https://github.com/nodejs/node/commit/94405650ae)] - **deps**: upgrade npm to 7.10.0 (Ruy Adorno) [#38254](https://github.com/nodejs/node/pull/38254)
* [[`8e80fc7ff8`](https://github.com/nodejs/node/commit/8e80fc7ff8)] - **deps**: patch V8 to 9.0.257.17 (Michaël Zasso) [#38237](https://github.com/nodejs/node/pull/38237)
* [[`5b358d57e1`](https://github.com/nodejs/node/commit/5b358d57e1)] - **deps**: patch V8 to 9.0.257.16 (Michaël Zasso) [#38218](https://github.com/nodejs/node/pull/38218)
* [[`ee669a0d29`](https://github.com/nodejs/node/commit/ee669a0d29)] - **deps**: update ICU to 69.1 (Michaël Zasso) [#38178](https://github.com/nodejs/node/pull/38178)
* [[`2468e4ed3e`](https://github.com/nodejs/node/commit/2468e4ed3e)] - **deps**: V8: backport d59db06bf542 (Antoine du Hamel) [#38162](https://github.com/nodejs/node/pull/38162)
* [[`c748668704`](https://github.com/nodejs/node/commit/c748668704)] - **deps**: upgrade npm to 7.9.0 (Ruy Adorno) [#38156](https://github.com/nodejs/node/pull/38156)
* [[`ca13f7aaf3`](https://github.com/nodejs/node/commit/ca13f7aaf3)] - **deps**: V8: cherry-pick 501482cbc704 (Colin Ihrig) [#38121](https://github.com/nodejs/node/pull/38121)
* [[`bc531d1860`](https://github.com/nodejs/node/commit/bc531d1860)] - **deps**: upgrade npm to 7.8.0 (Darcy Clarke) [#38030](https://github.com/nodejs/node/pull/38030)
* [[`d639321acd`](https://github.com/nodejs/node/commit/d639321acd)] - **deps**: patch V8 to 9.0.257.13 (Michaël Zasso) [#37830](https://github.com/nodejs/node/pull/37830)
* [[`bc31dc0e0f`](https://github.com/nodejs/node/commit/bc31dc0e0f)] - **dns**: refactor cares\_wrap internals (James M Snell) [#38172](https://github.com/nodejs/node/pull/38172)
* [[`36decec87f`](https://github.com/nodejs/node/commit/36decec87f)] - **doc**: remove superfluous await from fsPromises.readdir example (Michael Rommel) [#38293](https://github.com/nodejs/node/pull/38293)
* [[`ac2c8c530d`](https://github.com/nodejs/node/commit/ac2c8c530d)] - **doc**: fixup http.IncomingMessage deprecation code (Guy Bedford) [#36917](https://github.com/nodejs/node/pull/36917)
* [[`767643fc19`](https://github.com/nodejs/node/commit/767643fc19)] - **doc**: restore minimum Xcode version for macOS (Richard Lau) [#38266](https://github.com/nodejs/node/pull/38266)
* [[`e541032276`](https://github.com/nodejs/node/commit/e541032276)] - **doc**: fix typo in repl.md (Arkerone) [#38244](https://github.com/nodejs/node/pull/38244)
* [[`fb93b71307`](https://github.com/nodejs/node/commit/fb93b71307)] - **doc**: fix typo in buffer.md (Arkerone) [#38243](https://github.com/nodejs/node/pull/38243)
* [[`7d688d4b36`](https://github.com/nodejs/node/commit/7d688d4b36)] - **doc**: fix missing backtick in fs.md (Siddharth) [#38260](https://github.com/nodejs/node/pull/38260)
* [[`6d04cc6849`](https://github.com/nodejs/node/commit/6d04cc6849)] - **doc**: change "oject" to "object" (Arkerone) [#38256](https://github.com/nodejs/node/pull/38256)
* [[`b4363f726c`](https://github.com/nodejs/node/commit/b4363f726c)] - **doc**: revise TLS minVersion/maxVersion text (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`98c2067f13`](https://github.com/nodejs/node/commit/98c2067f13)] - **doc**: update BUILDING.md for Apple Silicon (Ash Cripps) [#38227](https://github.com/nodejs/node/pull/38227)
* [[`4def7c4418`](https://github.com/nodejs/node/commit/4def7c4418)] - **doc**: standardize on pseudorandom (Rich Trott) [#38196](https://github.com/nodejs/node/pull/38196)
* [[`f1027ecf29`](https://github.com/nodejs/node/commit/f1027ecf29)] - **doc**: standardize command flag notes (Ferdi) [#38199](https://github.com/nodejs/node/pull/38199)
* [[`756d2e48d8`](https://github.com/nodejs/node/commit/756d2e48d8)] - **doc**: update `buffer.constants.MAX\_LENGTH` (Qingyu Deng) [#38109](https://github.com/nodejs/node/pull/38109)
* [[`474fbb5f6e`](https://github.com/nodejs/node/commit/474fbb5f6e)] - **doc**: clarify child\_process close event (Nitzan Uziely) [#38181](https://github.com/nodejs/node/pull/38181)
* [[`eee2c331ef`](https://github.com/nodejs/node/commit/eee2c331ef)] - **doc**: add command flag to import.meta.resolve (Ferdi) [#38171](https://github.com/nodejs/node/pull/38171)
* [[`f46d29360c`](https://github.com/nodejs/node/commit/f46d29360c)] - **doc**: advise against using randomFill on floats (Tobias Nießen) [#38150](https://github.com/nodejs/node/pull/38150)
* [[`5823fc79ba`](https://github.com/nodejs/node/commit/5823fc79ba)] - **doc**: update links in ICU guide (Michaël Zasso) [#38177](https://github.com/nodejs/node/pull/38177)
* [[`993a1da47c`](https://github.com/nodejs/node/commit/993a1da47c)] - **doc**: mention cryptographic prng in description of randomUUID (Serkan Özel) [#38074](https://github.com/nodejs/node/pull/38074)
* [[`5ba5cc8619`](https://github.com/nodejs/node/commit/5ba5cc8619)] - **doc**: fix typos in doc/api/cli.md (Arkerone) [#38163](https://github.com/nodejs/node/pull/38163)
* [[`6a2314acd7`](https://github.com/nodejs/node/commit/6a2314acd7)] - **doc**: add link to V8 (Voltrex) [#38144](https://github.com/nodejs/node/pull/38144)
* [[`093b527b25`](https://github.com/nodejs/node/commit/093b527b25)] - **doc**: fix typo in assert.md (Arkerone) [#38152](https://github.com/nodejs/node/pull/38152)
* [[`0fa579ac2a`](https://github.com/nodejs/node/commit/0fa579ac2a)] - **doc**: add missing comma in crypto doc (Tobias Nießen) [#38142](https://github.com/nodejs/node/pull/38142)
* [[`4bc8f7542f`](https://github.com/nodejs/node/commit/4bc8f7542f)] - **doc**: fix typo in crypto (Arkerone) [#38130](https://github.com/nodejs/node/pull/38130)
* [[`005ebafbd1`](https://github.com/nodejs/node/commit/005ebafbd1)] - **doc**: improve security text in collaborators guide (Rich Trott) [#38107](https://github.com/nodejs/node/pull/38107)
* [[`54322b8d8b`](https://github.com/nodejs/node/commit/54322b8d8b)] - **doc**: apply consistent punctuation to header contributing guide (Akhil Marsonya) [#38047](https://github.com/nodejs/node/pull/38047)
* [[`0d34767c4c`](https://github.com/nodejs/node/commit/0d34767c4c)] - **doc**: sending http request to localhost to avoid https redirect (Hassaan Pasha) [#38036](https://github.com/nodejs/node/pull/38036)
* [[`f851efd2e1`](https://github.com/nodejs/node/commit/f851efd2e1)] - **doc**: apply sentence case to backporting-to-release-lines.md headers (marsonya) [#37617](https://github.com/nodejs/node/pull/37617)
* [[`36bc8b905c`](https://github.com/nodejs/node/commit/36bc8b905c)] - **doc**: fix typo in fs.md (Antoine du Hamel) [#38100](https://github.com/nodejs/node/pull/38100)
* [[`f52c92134c`](https://github.com/nodejs/node/commit/f52c92134c)] - **doc**: internal/test/binding for testing (Bradley Meck) [#38026](https://github.com/nodejs/node/pull/38026)
* [[`ab42ef3930`](https://github.com/nodejs/node/commit/ab42ef3930)] - **doc**: add parentheses to function and move reference (Rich Trott) [#38066](https://github.com/nodejs/node/pull/38066)
* [[`2861778ecd`](https://github.com/nodejs/node/commit/2861778ecd)] - **doc**: change wording in doc/api/domain.md comment (Akhil Marsonya) [#38044](https://github.com/nodejs/node/pull/38044)
* [[`361632dab1`](https://github.com/nodejs/node/commit/361632dab1)] - **doc**: fix lint error in modules.md (Rich Trott) [#37811](https://github.com/nodejs/node/pull/37811)
* [[`b3f35e2c70`](https://github.com/nodejs/node/commit/b3f35e2c70)] - **doc,lib**: add missing deprecation code (Colin Ihrig) [#37541](https://github.com/nodejs/node/pull/37541)
* [[`cbe3b27166`](https://github.com/nodejs/node/commit/cbe3b27166)] - **doc,tools**: allow stability table to be updated (Richard Lau) [#38048](https://github.com/nodejs/node/pull/38048)
* [[`8dd06850ae`](https://github.com/nodejs/node/commit/8dd06850ae)] - **esm**: use correct URL for error decoration (Bradley Meck) [#37854](https://github.com/nodejs/node/pull/37854)
* [[`6bbe28552c`](https://github.com/nodejs/node/commit/6bbe28552c)] - **fs**: use byteLength to handle ArrayBuffer views (Michaël Zasso) [#38187](https://github.com/nodejs/node/pull/38187)
* [[`8e76397fab`](https://github.com/nodejs/node/commit/8e76397fab)] - **fs**: validate encoding to binding.writeString() (Colin Ihrig) [#38183](https://github.com/nodejs/node/pull/38183)
* [[`24fd791184`](https://github.com/nodejs/node/commit/24fd791184)] - **fs**: move constants to internal/fs/utils.js (Darshan Sen) [#38061](https://github.com/nodejs/node/pull/38061)
* [[`40ace47396`](https://github.com/nodejs/node/commit/40ace47396)] - **http**: fixup perf regression (James M Snell) [#38110](https://github.com/nodejs/node/pull/38110)
* [[`f4d3d12327`](https://github.com/nodejs/node/commit/f4d3d12327)] - **http**: use CRLF conistently in \_http\_outgoing.js (Daniel Bevenius) [#37851](https://github.com/nodejs/node/pull/37851)
* [[`ee9e2a2eb6`](https://github.com/nodejs/node/commit/ee9e2a2eb6)] - **lib**: revert primordials in a hot path (Antoine du Hamel) [#38248](https://github.com/nodejs/node/pull/38248)
* [[`d756d2b99c`](https://github.com/nodejs/node/commit/d756d2b99c)] - **lib**: enforce using `primordials.globalThis` instead of `global` (Antoine du Hamel) [#38230](https://github.com/nodejs/node/pull/38230)
* [[`09c9e5dea4`](https://github.com/nodejs/node/commit/09c9e5dea4)] - **lib**: avoid mutating `Error.stackTraceLimit` when it is not writable (Antoine du Hamel) [#38215](https://github.com/nodejs/node/pull/38215)
* [[`23d2c54bab`](https://github.com/nodejs/node/commit/23d2c54bab)] - **lib**: add `globalThis` to primordials (Antoine du Hamel) [#38211](https://github.com/nodejs/node/pull/38211)
* [[`78343bbdc5`](https://github.com/nodejs/node/commit/78343bbdc5)] - **lib**: add `WeakRef` and `FinalizationRegistry` to `primordials` (ExE Boss) [#37263](https://github.com/nodejs/node/pull/37263)
* [[`656fb4657a`](https://github.com/nodejs/node/commit/656fb4657a)] - **lib**: add tsconfig for code completions (Bradley Meck) [#38042](https://github.com/nodejs/node/pull/38042)
* [[`d86132488d`](https://github.com/nodejs/node/commit/d86132488d)] - **lib**: properly process JavaScript exceptions on async\_hooks fatal error (legendecas) [#38106](https://github.com/nodejs/node/pull/38106)
* [[`a9332e84bf`](https://github.com/nodejs/node/commit/a9332e84bf)] - **lib**: refactor to use primordials in lib/internal/cli\_table (Akhil Marsonya) [#38046](https://github.com/nodejs/node/pull/38046)
* [[`8d78d9ef27`](https://github.com/nodejs/node/commit/8d78d9ef27)] - **lib**: load v8\_prof\_processor dependencies as ESM (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`7b2bad4005`](https://github.com/nodejs/node/commit/7b2bad4005)] - **module**: clarify CJS global-like variables not defined error message (Antoine du Hamel) [#37852](https://github.com/nodejs/node/pull/37852)
* [[`7869761c2e`](https://github.com/nodejs/node/commit/7869761c2e)] - **net**: fix typo (Luigi Pinca) [#38127](https://github.com/nodejs/node/pull/38127)
* [[`4afcd55274`](https://github.com/nodejs/node/commit/4afcd55274)] - **node-api**: make reference weak parameter an indirect link to references (Chengzhong Wu) [#38000](https://github.com/nodejs/node/pull/38000)
* [[`e38d62a8c9`](https://github.com/nodejs/node/commit/e38d62a8c9)] - **path**: fix POSIX path.resolve() perf regression (Brian White) [#38064](https://github.com/nodejs/node/pull/38064)
* [[`b0d5e036d8`](https://github.com/nodejs/node/commit/b0d5e036d8)] - **path**: fix posix.relative() on Windows (Rich Trott) [#37747](https://github.com/nodejs/node/pull/37747)
* [[`548cbf0625`](https://github.com/nodejs/node/commit/548cbf0625)] - **perf_hooks**: fix loop delay resolution validation (Antoine du Hamel) [#38166](https://github.com/nodejs/node/pull/38166)
* [[`13c931a9dc`](https://github.com/nodejs/node/commit/13c931a9dc)] - **process**: add range validation to debugPort (Colin Ihrig) [#38205](https://github.com/nodejs/node/pull/38205)
* [[`8dd5dd8a4b`](https://github.com/nodejs/node/commit/8dd5dd8a4b)] - **process**: do not lazily load AsyncResource (Michaël Zasso) [#38041](https://github.com/nodejs/node/pull/38041)
* [[`4e833b6059`](https://github.com/nodejs/node/commit/4e833b6059)] - **process,doc**: add missing deprecation code (Colin Ihrig) [#37091](https://github.com/nodejs/node/pull/37091)
* [[`d6669645c0`](https://github.com/nodejs/node/commit/d6669645c0)] - **repl**: fix declaring a variable with the name `util` (eladkeyshawn) [#38141](https://github.com/nodejs/node/pull/38141)
* [[`e7391967c2`](https://github.com/nodejs/node/commit/e7391967c2)] - **repl**: fix error message printing (Anna Henningsen) [#38209](https://github.com/nodejs/node/pull/38209)
* [[`4e9212bb7b`](https://github.com/nodejs/node/commit/4e9212bb7b)] - **src**: cache some context in locals (Khaidi Chu) [#37473](https://github.com/nodejs/node/pull/37473)
* [[`fc20e833ca`](https://github.com/nodejs/node/commit/fc20e833ca)] - **src**: fix finalization crash (James M Snell) [#38250](https://github.com/nodejs/node/pull/38250)
* [[`6c9b19a7af`](https://github.com/nodejs/node/commit/6c9b19a7af)] - **src**: refactor SecureContext Initialization (James M Snell) [#38116](https://github.com/nodejs/node/pull/38116)
* [[`8d63aa828e`](https://github.com/nodejs/node/commit/8d63aa828e)] - **src**: fix typo for initialization (Yash Ladha) [#37974](https://github.com/nodejs/node/pull/37974)
* [[`66c8f76c2c`](https://github.com/nodejs/node/commit/66c8f76c2c)] - **src**: remove KeyObjectData::CreateSecret overload (Tobias Nießen) [#38067](https://github.com/nodejs/node/pull/38067)
* [[`87dc152229`](https://github.com/nodejs/node/commit/87dc152229)] - **src**: fix node version (Richard Lau) [#36460](https://github.com/nodejs/node/pull/36460)
* [[`e929d1f2c8`](https://github.com/nodejs/node/commit/e929d1f2c8)] - **src**: fix node version (Brian White) [#36385](https://github.com/nodejs/node/pull/36385)
* [[`8e8dea36cc`](https://github.com/nodejs/node/commit/8e8dea36cc)] - **src**: use non-deprecated GetCreationContext from V8 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`b1c1c4695c`](https://github.com/nodejs/node/commit/b1c1c4695c)] - **src**: remove V8\_FT\_ADAPTOR for V8 update (Colin Ihrig) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`8f5cce6862`](https://github.com/nodejs/node/commit/8f5cce6862)] - **src**: use non-deprecated V8 module APIs (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`497f6ca5b4`](https://github.com/nodejs/node/commit/497f6ca5b4)] - **src**: update NODE\_MODULE\_VERSION to 93 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`001dc16cf1`](https://github.com/nodejs/node/commit/001dc16cf1)] - **src**: use non-deprecated V8 module and script APIs (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`47a90d9f37`](https://github.com/nodejs/node/commit/47a90d9f37)] - **src**: update NODE\_MODULE\_VERSION to 92 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`5259d17309`](https://github.com/nodejs/node/commit/5259d17309)] - **src**: update NODE\_MODULE\_VERSION to 91 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`6f9cbcf6a6`](https://github.com/nodejs/node/commit/6f9cbcf6a6)] - **src**: fix v8 api deprecation (Jiawen Geng) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`9d4d55bd94`](https://github.com/nodejs/node/commit/9d4d55bd94)] - **src**: update NODE\_MODULE\_VERSION to 90 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`369f239503`](https://github.com/nodejs/node/commit/369f239503)] - **stream**: fix multiple Writable.destroy() calls (Robert Nagy) [#38221](https://github.com/nodejs/node/pull/38221)
* [[`4ad46e2fef`](https://github.com/nodejs/node/commit/4ad46e2fef)] - **stream**: refactor to avoid unsafe array iteration (Antoine du Hamel) [#37126](https://github.com/nodejs/node/pull/37126)
* [[`419686cdfb`](https://github.com/nodejs/node/commit/419686cdfb)] - **stream**: refactor to use more primordials (Antoine du Hamel) [#36346](https://github.com/nodejs/node/pull/36346)
* [[`c704faa0f9`](https://github.com/nodejs/node/commit/c704faa0f9)] - **test**: fix flaky test-dns and test-dns-lookup (Rich Trott) [#38282](https://github.com/nodejs/node/pull/38282)
* [[`5e588c1c7c`](https://github.com/nodejs/node/commit/5e588c1c7c)] - **test**: fixup failing test/internet/test-dns.js (James M Snell) [#38241](https://github.com/nodejs/node/pull/38241)
* [[`18c9913ce1`](https://github.com/nodejs/node/commit/18c9913ce1)] - **test**: add tests for missing https agent options (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`4ad8e83a3d`](https://github.com/nodejs/node/commit/4ad8e83a3d)] - **test**: fix test-https-agent-additional-options.js (Rich Trott) [#38202](https://github.com/nodejs/node/pull/38202)
* [[`05df701e70`](https://github.com/nodejs/node/commit/05df701e70)] - **test**: remove common.disableCrashOnUnhandledRejection (Michaël Zasso) [#38210](https://github.com/nodejs/node/pull/38210)
* [[`8f4850d5c7`](https://github.com/nodejs/node/commit/8f4850d5c7)] - **test**: fix typo in comment in binding.c (Tobias Nießen) [#38220](https://github.com/nodejs/node/pull/38220)
* [[`9498e97015`](https://github.com/nodejs/node/commit/9498e97015)] - **test**: fix typo in gtest-all.cc (Ikko Ashimine) [#38224](https://github.com/nodejs/node/pull/38224)
* [[`c8bbd83ab2`](https://github.com/nodejs/node/commit/c8bbd83ab2)] - **test**: add undefined fatalException exit code test (Nitzan Uziely) [#38119](https://github.com/nodejs/node/pull/38119)
* [[`db9cf52dcf`](https://github.com/nodejs/node/commit/db9cf52dcf)] - **test**: check the different error code on IBM i (Xu Meng) [#38159](https://github.com/nodejs/node/pull/38159)
* [[`95ca351fd8`](https://github.com/nodejs/node/commit/95ca351fd8)] - **test**: skip fs.watch() test on IBMi (Rich Trott) [#38192](https://github.com/nodejs/node/pull/38192)
* [[`8cee28465c`](https://github.com/nodejs/node/commit/8cee28465c)] - **test**: fix test-dh-regr for OpenSSL 3 (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`213ae4f4c6`](https://github.com/nodejs/node/commit/213ae4f4c6)] - **test**: skip test-vm-memleak in ASAN (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`50208915a0`](https://github.com/nodejs/node/commit/50208915a0)] - **test**: skip test-hash-seed on armv6 and armv7 (Rich Trott) [#34289](https://github.com/nodejs/node/pull/34289)
* [[`7216eb67df`](https://github.com/nodejs/node/commit/7216eb67df)] - **test**: update OpenSSL 3.x expected error message (Daniel Bevenius) [#38164](https://github.com/nodejs/node/pull/38164)
* [[`7e516aaac0`](https://github.com/nodejs/node/commit/7e516aaac0)] - **test**: remove unneeded m flag on regular expressions (Rich Trott) [#38124](https://github.com/nodejs/node/pull/38124)
* [[`269f5132cc`](https://github.com/nodejs/node/commit/269f5132cc)] - **test**: skip different params test for OpenSSL 3.x (Daniel Bevenius) [#38165](https://github.com/nodejs/node/pull/38165)
* [[`f96dffb7ae`](https://github.com/nodejs/node/commit/f96dffb7ae)] - **test**: fix flaky test-zlib-unused-weak.js (Ouyang Yadong) [#38149](https://github.com/nodejs/node/pull/38149)
* [[`e96773b94b`](https://github.com/nodejs/node/commit/e96773b94b)] - **test**: add regression test for serdes readDouble() (Colin Ihrig) [#38121](https://github.com/nodejs/node/pull/38121)
* [[`cc4ee6cba8`](https://github.com/nodejs/node/commit/cc4ee6cba8)] - **test**: deflake test-http-many-ended-pipelines (Luigi Pinca) [#38018](https://github.com/nodejs/node/pull/38018)
* [[`098a4d6551`](https://github.com/nodejs/node/commit/098a4d6551)] - **test**: skip test-crypto-dh-keys on armv6 and armv7 (Rich Trott) [#38076](https://github.com/nodejs/node/pull/38076)
* [[`f9b63b8530`](https://github.com/nodejs/node/commit/f9b63b8530)] - **test**: update parallel/test-crypto-keygen for OpenSSL 3 (Richard Lau) [#38136](https://github.com/nodejs/node/pull/38136)
* [[`6a6cdfad03`](https://github.com/nodejs/node/commit/6a6cdfad03)] - **test**: fix skip message for test-macos-app-sandbox (Tobias Nießen) [#38114](https://github.com/nodejs/node/pull/38114)
* [[`e155b1f2f7`](https://github.com/nodejs/node/commit/e155b1f2f7)] - **test**: correct test comment (Evan Lucas) [#38095](https://github.com/nodejs/node/pull/38095)
* [[`d61977f03e`](https://github.com/nodejs/node/commit/d61977f03e)] - **test**: remove dead code (Luigi Pinca) [#38016](https://github.com/nodejs/node/pull/38016)
* [[`8b05e32519`](https://github.com/nodejs/node/commit/8b05e32519)] - **test**: fix flaky test-net-timeout (Rich Trott) [#38060](https://github.com/nodejs/node/pull/38060)
* [[`a0492ba391`](https://github.com/nodejs/node/commit/a0492ba391)] - **test**: fix test-vm-memleak for high baseline platforms (Rich Trott) [#38062](https://github.com/nodejs/node/pull/38062)
* [[`30d7f05fef`](https://github.com/nodejs/node/commit/30d7f05fef)] - **test**: improve code coverage in webcrypto API (Juan José Arboleda) [#38052](https://github.com/nodejs/node/pull/38052)
* [[`d75543d8b5`](https://github.com/nodejs/node/commit/d75543d8b5)] - **test**: fix flaky timeout-delayed-body and headers tests (Nitzan Uziely) [#38045](https://github.com/nodejs/node/pull/38045)
* [[`4f387c25cb`](https://github.com/nodejs/node/commit/4f387c25cb)] - **test**: fix flaky test-vm-memleak (Rich Trott) [#38054](https://github.com/nodejs/node/pull/38054)
* [[`330f25ef82`](https://github.com/nodejs/node/commit/330f25ef82)] - **test**: prepare for consistent comma-dangle lint rule (Rich Trott) [#37930](https://github.com/nodejs/node/pull/37930)
* [[`31fe3b215f`](https://github.com/nodejs/node/commit/31fe3b215f)] - **test**: make sure http pipelining does not emit a warning (Matteo Collina) [#37964](https://github.com/nodejs/node/pull/37964)
* [[`978bbf987c`](https://github.com/nodejs/node/commit/978bbf987c)] - **test**: fix flaky test-http2-pack-end-stream-flag (James M Snell) [#37814](https://github.com/nodejs/node/pull/37814)
* [[`ecc584251e`](https://github.com/nodejs/node/commit/ecc584251e)] - **test**: fixup flaky test-performance-function-async test (James M Snell) [#37493](https://github.com/nodejs/node/pull/37493)
* [[`32482a828b`](https://github.com/nodejs/node/commit/32482a828b)] - **test**: remove FLAKY for test-domain-error-types (Rich Trott) [#37458](https://github.com/nodejs/node/pull/37458)
* [[`501ae0e6e3`](https://github.com/nodejs/node/commit/501ae0e6e3)] - **test**: remove outdated V8 flag (Michaël Zasso) [#37151](https://github.com/nodejs/node/pull/37151)
* [[`fa3997d75a`](https://github.com/nodejs/node/commit/fa3997d75a)] - **test**: mark test-return-on-exit as flaky (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`896ae96a15`](https://github.com/nodejs/node/commit/896ae96a15)] - **test**: mark WASI's test-return-on-exit as flaky (Colin Ihrig) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`0da7a11e54`](https://github.com/nodejs/node/commit/0da7a11e54)] - **test,http**: check that http server is robust from handler abuse (Rich Trott) [#37958](https://github.com/nodejs/node/pull/37958)
* [[`a0261d231c`](https://github.com/nodejs/node/commit/a0261d231c)] - ***Revert*** "**timers**: refactor to use optional chaining" (Matteo Collina) [#38245](https://github.com/nodejs/node/pull/38245)
* [[`3da003cc1c`](https://github.com/nodejs/node/commit/3da003cc1c)] - **tls**: fix session and keylog add listener segfault (Nitzan Uziely) [#38180](https://github.com/nodejs/node/pull/38180)
* [[`eb20447407`](https://github.com/nodejs/node/commit/eb20447407)] - **tls**: extract out SecureContext configuration (James M Snell) [#38116](https://github.com/nodejs/node/pull/38116)
* [[`b16e79e05b`](https://github.com/nodejs/node/commit/b16e79e05b)] - **tls**: fix typo (Arkerone) [#38129](https://github.com/nodejs/node/pull/38129)
* [[`d4f33f109e`](https://github.com/nodejs/node/commit/d4f33f109e)] - **tools**: skip macOS GitHub Actions test on doc-only changes (Rich Trott) [#38296](https://github.com/nodejs/node/pull/38296)
* [[`13d0de5954`](https://github.com/nodejs/node/commit/13d0de5954)] - **tools**: set arch in Distribution.xml (Ash Cripps) [#38261](https://github.com/nodejs/node/pull/38261)
* [[`28bca33f28`](https://github.com/nodejs/node/commit/28bca33f28)] - **tools**: update ESLint to 7.24.0 (Colin Ihrig) [#38179](https://github.com/nodejs/node/pull/38179)
* [[`038608d401`](https://github.com/nodejs/node/commit/038608d401)] - **tools**: relax max-len lint rule for template strings (Rich Trott) [#38097](https://github.com/nodejs/node/pull/38097)
* [[`e67fb569f4`](https://github.com/nodejs/node/commit/e67fb569f4)] - **tools**: apply consistent comma-dangle lint rule (Rich Trott) [#37930](https://github.com/nodejs/node/pull/37930)
* [[`9843361c07`](https://github.com/nodejs/node/commit/9843361c07)] - **tools**: update V8 gypfiles for 9.0 (Michaël Zasso) [#37587](https://github.com/nodejs/node/pull/37587)
* [[`017661768a`](https://github.com/nodejs/node/commit/017661768a)] - **tools**: update V8 gypfiles for 8.9 (Michaël Zasso) [#37330](https://github.com/nodejs/node/pull/37330)
* [[`79da253473`](https://github.com/nodejs/node/commit/79da253473)] - **tools**: update V8 gypfiles for 8.8 (Michaël Zasso) [#36139](https://github.com/nodejs/node/pull/36139)
* [[`770d9e2542`](https://github.com/nodejs/node/commit/770d9e2542)] - **tools**: update V8 gypfiles for 8.7 (Michaël Zasso) [#35700](https://github.com/nodejs/node/pull/35700)
* [[`b87f1be92d`](https://github.com/nodejs/node/commit/b87f1be92d)] - **typings**: add types for "http\_parser" and "options" bindings (Michaël Zasso) [#38239](https://github.com/nodejs/node/pull/38239)
* [[`1c8b2956d1`](https://github.com/nodejs/node/commit/1c8b2956d1)] - **typings**: add types for internalBinding('serdes') (Michaël Zasso) [#38204](https://github.com/nodejs/node/pull/38204)
* [[`d97787fccc`](https://github.com/nodejs/node/commit/d97787fccc)] - **typings**: add JSDoc to os module functions (David Brownman) [#38197](https://github.com/nodejs/node/pull/38197)
* [[`8acfe5c2a4`](https://github.com/nodejs/node/commit/8acfe5c2a4)] - **typings**: add JSDoc Types to lib/querystring (Simon Knott) [#38185](https://github.com/nodejs/node/pull/38185)
* [[`d3162da8dd`](https://github.com/nodejs/node/commit/d3162da8dd)] - **typings**: add JSDoc typings for http (Voltrex) [#38191](https://github.com/nodejs/node/pull/38191)
* [[`82d59882b1`](https://github.com/nodejs/node/commit/82d59882b1)] - **typings**: add JSDoc typings for assert (Voltrex) [#38188](https://github.com/nodejs/node/pull/38188)
* [[`f1a21e5c91`](https://github.com/nodejs/node/commit/f1a21e5c91)] - **typings**: add JSDoc types to lib/path (Simon Knott) [#38186](https://github.com/nodejs/node/pull/38186)
* [[`3377eb9641`](https://github.com/nodejs/node/commit/3377eb9641)] - **typings**: add types for internalBinding('util') (Michaël Zasso) [#38200](https://github.com/nodejs/node/pull/38200)
* [[`cb2bdc632a`](https://github.com/nodejs/node/commit/cb2bdc632a)] - **typings**: add types for internalBinding('fs') (Michaël Zasso) [#38198](https://github.com/nodejs/node/pull/38198)
* [[`26eed3e0ed`](https://github.com/nodejs/node/commit/26eed3e0ed)] - **vm**: add import assertion support (Gus Caplan) [#37176](https://github.com/nodejs/node/pull/37176)
* [[`6986fa07eb`](https://github.com/nodejs/node/commit/6986fa07eb)] - **worker**: fix exit code for error thrown in handler (Nitzan Uziely) [#38012](https://github.com/nodejs/node/pull/38012)
