# Node Foundation CTC Meeting 2016-02-03

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/ctc-meeting-2016-02-03
* **GitHub Issue**: https://github.com/nodejs/node/issues/5058
* **Minutes Google Doc**: <https://docs.google.com/document/d/145ND-9pGdAwZ1eoOMypX1_wtx5FCVoanWtLl8zzyxH8>
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1X3RbJhhLvFNojmQwxmsfUb2qPMyNPcVzcSS2aAoAon0>_

## Present

* James Snell (CTC)
* Trevor Norris (CTC)
* Colin Ihrig (CTC)
* Brian White (CTC)
* Alexis Campailla (CTC)
* Bert Belder (CTC) x
* Chris Dickinson (CTC)
* Shigeki Ohtsu (CTC)
* Steven Loomis (observer)
* Mikeal Rogers (observer)
* Fedor Indutny (CTC)
* Jeremiah Senkpiel (CTC)
* Rod Vagg (CTC)
* Ben Noordhuis (CTC)
* Nikita Skovoroda (observer)
* Evan Lucas (observer)
* Rich Trott (observer)
* Michael Dawson (observer)


## Agenda

Extracted from **ctc-agenda** labelled issues and pull requests from the **nodejs org** prior to the meeting.

## Standup

* James Snell (CTC) — Working on the security fix stuff, buffer stuff, express TLP proposal
* Trevor Norris (CTC) — Commenting, working on making AsyncWrap a public API
* Colin Ihrig (CTC) — Just reviewing PRs and issues
* Brian White (CTC) — Reviewing PRs and issues, submitting various PRs. Working on performance improvements throughout core.
* Alexis Campailla (CTC) — Reviewing issues & PRs, drop XP support PR
* Chris Dickinson (CTC) — Docs WG Roadmap ratified (!), Promises PR
* Shigeki Ohtsu (CTC) — Upgrading OpenSSL and reviewing several PRs.
* Steven R. Loomis (observer) — met w/ TC39/Ecma402 folks to move items forward. worked on full-icu (#3460 - in the agenda) packaging and also locale negotiation https://github.com/nodejs/Intl/issues/10 - recommend docs (?) + small non-core module.
* Mikeal Rogers (observer) — TSC-level stuff, contribution agreement; updates on copyright stuff for core.
* Fedor Indutny (CTC) — reviewing PRs/issues, working on landing c-ares, OpenSSL patches
* Jeremiah Senkpiel (CTC) — Not much notable, TSC things (administrative wrangling)
* Rod Vagg (CTC) — Security issue, administrative wrangling, struggling a little to keep on top of everything
* Ben Noordhuis (CTC) — Wrote some code, reviewed some code, answered questions, replied to bug reports.
* Nikita Skovoroda (observer) — Commenting, nothing significant. Minor work on the npm code search tool.
* Evan Lucas (observer) — Issue and PR review. Looking into some minor stream performance things.
* Rich Trott (observer) — Test improvements; tightening linting rules; finding/closing old/stalled issues/PRs; Testing WG second meeting later this week
* Michael Dawson (observer) — Adding AIX machine, CI jobs, Job for V8 testing in Node tree, PPC BE release machine investigation, Benchmarking infra.

## Review of last meeting

*  Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)
  - (Skip, also in this meeting)
* CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)
  - (Skip, also in this meeting)
* buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682) & Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)
  - (Skip, also in this meeting)
* doc: add Docs working group [#4244](https://github.com/nodejs/node/pull/4244)
  - Ratified
* Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)
  - (Skip, also in this meeting)
* Drop Windows XP (and Vista) support in 6.0 [#3804](https://github.com/nodejs/node/issues/3804)
  - Agreed to drop

## Minutes

### Enable Node.js to run with Microsoft's ChakraCore engine [#4765](https://github.com/nodejs/node/pull/4765)

_(Jeremiah: This should probably be the VM neutral discussion https://github.com/nodejs/roadmap/issues/54)_

Jeremiah: Someone tagged the roadmap issue on this. It might be more useful to talk about the VM neutrality issue rather than the PR.

Ben: Has anyone started reviewing the PR yet?

Alexis: Yes, there was a first review, an update, and a follow-up. I agree that the most interesting discussion is on the roadmap issue.

Rod: How are we going to make progress on this? Should we wait until after the VM summit that James is organizing, or is there another way?

Alexis: We could make a high level evaluation of whether we see value in VM neutrality or not, that could make progress.

Michael: That’s what the issue was intended for in the first place.

Jeremiah: There’s been a suggestion that the PR should be broken up a bit, to make reviewing more reasonable.

Mikeal: I think the question CTC needs to answer sooner rather than later: do we hold up Chakra on a resolution, land it on a branch, etc. What is a “good” solution to work from while we don’t have a “perfect solution” [cd - some paraphrasing here]

Rod: We need the high level questions answered — the ones too hard to answer in github.

Mikeal: We need to give the people that want to work on Chakra specifically a place to work on it, while we figure out what we want.

Alexis: Answering whether we want VM neutrality at all could make progress.

James: Does anyone have objections to being VM neutral, at a high level.

Ben: Not objections as such, but I do question how valuable it is.

Alexis: It’s a matter of value vs. cost then. If it’s free, then of course we would add it.

Ben: Yes.

Michael: Even if we never add another VM, making the VM bindings more stable is a net win.

Rod: We do have to be careful assuming this is something people are actually for.

Michael: Shipping with a different VM might be more controversial than making it _possible_ to ship with a different VM.

Trevor: [CD interpretation: part of the difficulty is the degree to which VM is complected with node c++, perhaps we should focus instead on a low level JS api.]

Michael: Would this let us land V8 updates easier?

Trevor: Once we have a sanctioned API, yes. Buffers are a good example of this.

Mikeal: There are lots of examples of folks that copy over the entire JS API — even they end up writing something of a shim layer to get native modules. This LLJS API would not be the entire story.

[CD: Michael and Trevor discuss subsets of APIs to support.]

Mikeal: We should have this conversation at the summit. Where do we tell folks who want to work on Chakra to work?

Ben: It only works on Windows.

Mikeal: We could say, we’re going to put it on a branch, and you can work with the Build WG to produce builds. There’s a lot of MS folk that want to see this work, and we stand to learn a lot from the process of how this works.

Ben: Are we the first line support?

Alexis: There is a team of engineers dedicated to this.

James: We could stand up a separate repo, with its own issue tracker + PRs.

Rod: It’s also a discussion about the size of the tree. We talking in the build WG about different ways of vendoring to address this. A separate repo sounds interest.

Jeremiah: Would that separate repo be the shim, or a fork of Node.js?

Rod: it would be a fork.

Jeremiah: It’d be nice to have the build process pull in the shim and chakra and build it.

Rod: There’s a discussion in the Build WG repo about this. There’s not an easy way to do this.

Rod: In terms of making progress right now, a fork repo is probably the best way to go — reducing the number of

Jeremiah: I don’t think VM neutral is the way to go, I think our own VM is the way to go. There are concerns in the thread about how we impact userland — it’s unclear how modules will have to support that between different VMs.

Mikeal: Folks using ES6 transpile.

[CD and Jeremiah: not always!]

Rod: The folks who care will do the work — when I publish a module I publish it to work for me — when someone else needs it to work else where they can PR it. The big benefit I see of VM neutrality is that we become part of a competitive landscape of VMs. MS really wants to get into this game, and compete with V8. We see it in the browser ecosystem, where the competition has shifted from perf to features, and it’d be interesting to see that applied to the node ecosystem.

Jeremiah: Time check.

Rod: in terms of progress, does anyone object to making a separate repo for this?

[No objections!]

### CTC Membership Nominations [#4750](https://github.com/nodejs/node/issues/4750)

Rod: We’ll leave this for a couple more weeks. Moving on.

### buffer: add Buffer.from(), Buffer.alloc() and Buffer.allocUnsafe(), soft-deprecate Buffer(num) [#4682](https://github.com/nodejs/node/pull/4682) & Buffer(number) is unsafe [#4660](https://github.com/nodejs/node/issues/4660)

James: Discussion has settled out. No new comments. Updated PR yesterday with a couple changes I discussed with Trevor. Close to being done, just a matter of cleaning up the PR a bit and making sure there are no objections. It is a semver-major. We haven’t decided if we’re going to deprecate the Buffer(n) api.

Rod: Is it worth jumping in with naming issues — e.g., opposing the word “Unsafe” — now?

James: Some folk really don’t like typing “unsafe”, but it is, _technically_, unsafe.

[CD: Perhaps we should call it “allocXtreme”]

Rod: Personally I don’t want “unsafe”, but I’ve been holding off.

James: If you’ve been holding off on it, I don’t really care about the name too much. We can take it back to GH.

### Seek legal advice on LICENSE and copyright blocks in code [#3979](https://github.com/nodejs/node/issues/3979)

Rod: Likely a two line comment at the top of all files.

###  @srl295: [path for full-icu data?](https://github.com/nodejs/node/issues/3460) -  ./node_modules vs ./node/ ? (npm linkage)

Steven: Put together a proof of concept. Core question here is: is full-icu try to use a directory such as node_modules, or is that hijacking it for improper use [cd: unsure if I captured that correctly]

Result from Nov CTC meeting was “No objections to using node_modules”, and so I’m looking for feedback.

Alexis: I thought the no objection was to a separate directory.

Steven: Node module writes into some other known directory.

Steven: The node installer or deb pkg could have a checkbox to install icu data.

Rod: We could ship multiple installers.

Re the package: Perhaps we should use `execPath` to determine installation location?

Steven: Is execPath relative?

Rod: It’s absolute.

Steven: so that would be for global install — local install would use `node_modules/<something>`.

Rod: We could take a page from npm’s `.bin` and use `.lib`. I’m assuming the problem is that Node needs to look for this before it even gets to module resolution.

Steven: Right, this has to happen before ~~V8~~ **your VM** starts up.

Alexis: So I don’t think this belongs in `node_modules/`.

Rod: Possibly `.node-icu`?

Steven: Local is `node_modules/.node-icu`?

Rod: Maybe writing up the details on GH and pulling us in?

Steven: This is some good progress. It seems like it deals with the problem that it doesn’t overload an actual module; I’ll write up a proposal for this. Probably tomorrow.

Rod: Any other comments for that?

## Next Meeting

2016-02-10
